/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;

public class StrategicAgreementValidator
extends AbstractValidator {
    protected void dynamicValidator(ExtendedDataEntity dataEntity, Boolean type, String message, Object ... value) throws KDBizException {
        if (type.booleanValue()) {
            for (int i = 0; i < value.length; ++i) {
                if (value[i] instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)value[i]) == 0) {
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StrategicAgreementValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), message));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StrategicAgreementValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), message));
                }
                if (value[i] instanceof Date && value[i] == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StrategicAgreementValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), message));
                }
                if (value[i] instanceof String && value[i].equals("")) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StrategicAgreementValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), message));
                }
                if (value[i] != null) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StrategicAgreementValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), message));
            }
        }
    }

    public void validate() {
        block5: {
            String operationKey;
            ExtendedDataEntity[] dataEntities;
            block4: {
                dataEntities = this.getDataEntities();
                operationKey = this.getOperateKey();
                if (!("submit".equals(operationKey) | "save".equals(operationKey))) break block4;
                for (int i = 0; i < dataEntities.length; ++i) {
                    ExtendedDataEntity dataEntry = dataEntities[i];
                    Boolean isAgreementAmount = dataEntry.getDataEntity().getBoolean("isagreementamount");
                    BigDecimal agreementAmount = dataEntry.getDataEntity().getBigDecimal("agreementamount");
                    this.dynamicValidator(dataEntry, isAgreementAmount, ResManager.loadKDString((String)"\u534f\u8bae\u603b\u4ef7", (String)"StrategicAgreementValidator_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), agreementAmount);
                    Boolean verifyValid = dataEntry.getDataEntity().getBoolean("verifyvalid");
                    Date contractDate = dataEntry.getDataEntity().getDate("contractdate");
                    Date agreementValidDate = dataEntry.getDataEntity().getDate("agreementvaliddate");
                    Date agreementExpireDate = dataEntry.getDataEntity().getDate("agreementexpiredate");
                    this.dynamicValidator(dataEntry, verifyValid, ResManager.loadKDString((String)"\u7b7e\u7ea6\u65e5\u671f", (String)"StrategicAgreementValidator_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contractDate);
                    this.dynamicValidator(dataEntry, verifyValid, ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u5f00\u59cb\u65e5\u671f", (String)"StrategicAgreementValidator_15", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), agreementValidDate);
                    this.dynamicValidator(dataEntry, verifyValid, ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u7ed3\u675f\u65e5\u671f", (String)"StrategicAgreementValidator_16", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), agreementExpireDate);
                    Boolean reNew = dataEntry.getDataEntity().getBoolean("renew");
                    Date agreementDelayDate = dataEntry.getDataEntity().getDate("agreementdelaydate");
                    String reNewStatement = dataEntry.getDataEntity().getString("renewstatement");
                    this.dynamicValidator(dataEntry, reNew, ResManager.loadKDString((String)"\u7eed\u7ea6\u76f8\u5173", (String)"StrategicAgreementValidator_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), agreementDelayDate, reNewStatement);
                    Date agreementOriDate = dataEntry.getDataEntity().getDate("agreementoridate");
                    if (agreementOriDate != null && agreementDelayDate != null && agreementOriDate.compareTo(agreementDelayDate) >= 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u534f\u8bae\u5ef6\u8fdf\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u539f\u534f\u8bae\u7ed3\u675f\u65e5\u671f\u3002", (String)"StrategicAgreementValidator_18", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                    Boolean reNewOrgScope = dataEntry.getDataEntity().getBoolean("reneworgscope");
                    String reSetAdaptScope = dataEntry.getDataEntity().getString("resetadaptescope");
                    String orgChangedStatement = dataEntry.getDataEntity().getString("orgchangedstatement");
                    this.dynamicValidator(dataEntry, reNewOrgScope, ResManager.loadKDString((String)"\u53d8\u66f4\u9002\u7528\u7ec4\u7ec7\u76f8\u5173", (String)"StrategicAgreementValidator_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), reSetAdaptScope, orgChangedStatement);
                    Boolean reNewPartBScope = dataEntry.getDataEntity().getBoolean("renewpartbscope");
                    String Resetpartbscope = dataEntry.getDataEntity().getString("resetpartbscope");
                    this.dynamicValidator(dataEntry, reNewPartBScope, ResManager.loadKDString((String)"\u53d8\u66f4\u4e59\u65b9\u8303\u56f4\u76f8\u5173", (String)"StrategicAgreementValidator_6", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), Resetpartbscope);
                    Boolean reNewPriceScope = dataEntry.getDataEntity().getBoolean("renewpricescope");
                    String detailPriceStatement = dataEntry.getDataEntity().getString("detailpricestatement");
                    this.dynamicValidator(dataEntry, reNewPriceScope, ResManager.loadKDString((String)"\u53d8\u66f4\u4ef7\u683c\u76f8\u5173", (String)"StrategicAgreementValidator_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), detailPriceStatement);
                    String adaptScope = dataEntry.getDataEntity().getString("adaptescope");
                    String resetAdapteScope = dataEntry.getDataEntity().getString("resetadaptescope");
                    DynamicObjectCollection orgScopeEntry = dataEntry.getDataEntity().getDynamicObjectCollection("orgscopeentry");
                    if ("B".equals(adaptScope) || "B".equals(resetAdapteScope)) {
                        boolean anyMatch = orgScopeEntry.stream().limit(orgScopeEntry.size()).anyMatch(org -> {
                            DynamicObject orgDynamicObject = org.getDynamicObject("scopeorg");
                            return null == orgDynamicObject;
                        });
                        this.dynamicValidator(dataEntry, anyMatch, ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u7279\u5b9a\u8303\u56f4\u8bbe\u7f6e\uff0c\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StrategicAgreementValidator_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), BigDecimal.ZERO);
                    }
                    String partBScope = dataEntry.getDataEntity().getString("partbscope");
                    String resetPartBScope = dataEntry.getDataEntity().getString("resetpartbscope");
                    DynamicObjectCollection partBScopeEntry = dataEntry.getDataEntity().getDynamicObjectCollection("partbscopeentry");
                    if (!"B".equals(partBScope) && !"B".equals(resetPartBScope)) continue;
                    boolean anyMatch = partBScopeEntry.stream().limit(partBScopeEntry.size()).anyMatch(supplier -> {
                        DynamicObject supplierDynamicObject = supplier.getDynamicObject("supplier");
                        return supplierDynamicObject == null;
                    });
                    this.dynamicValidator(dataEntry, anyMatch, ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u7279\u5b9a\u8303\u56f4\u8bbe\u7f6e\uff0c\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StrategicAgreementValidator_8", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), BigDecimal.ZERO);
                }
                break block5;
            }
            if (!"unaudit".equals(operationKey)) break block5;
            Object[] idPkObject = Arrays.stream(dataEntities).map(o -> o.getDataEntity().getPkValue()).toArray();
            ArrayList<String> ignoreEntityIds = new ArrayList<String>(1);
            ignoreEntityIds.add("pmct_contdocbill");
            Map map = BaseDataRefrenceHelper.checkRefrenced((String)"pmct_strategicagreementf7", (Object[])idPkObject, ignoreEntityIds, null, null);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject strategicAgreement = dataEntity.getDataEntity();
                Object pkValue = strategicAgreement.getPkValue();
                if (map.isEmpty() || !map.containsKey(pkValue)) continue;
                BaseDataCheckRefrenceResult referResult = (BaseDataCheckRefrenceResult)map.get(pkValue);
                String refFormId = referResult.getRefenceKey().getRefEntityKey();
                MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refFormId);
                String billName = refMainType.getDisplayName().toString();
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6218\u7565\u534f\u8bae\u5df2\u88ab\u5355\u636e\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"StrategicAgreementValidator_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), billName.replace(ResManager.loadKDString((String)"\u6a21\u677f", (String)"StrategicAgreementValidator_13", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), "")));
            }
        }
    }
}

