/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.budget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;
import kd.pmgt.pmct.common.model.BudgetRegValue;
import kd.pmgt.pmct.common.model.CommonBudgetUpdateParam;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractBudgetUpdateSupport {
    protected CommonBudgetUpdateParam commonBudgetUpdateParam;
    protected List<BudgetRegValue> budgetRegValues;
    protected BudgetRegValue budgetRegValue;
    protected DynamicObject project;
    protected DynamicObject contract;
    protected Map<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
    protected Map<String, BigDecimal> controlAmountMap = new HashMap<String, BigDecimal>();

    public BudgetValidateInfo validateBudget() {
        HashMap resultMap;
        ArrayList<BudgetValidateInfo> outOfControlValidates = new ArrayList<BudgetValidateInfo>(16);
        ArrayList<BudgetValidateInfo> outOfRemindValidates = new ArrayList<BudgetValidateInfo>(16);
        BudgetValidateInfo budgetValidateInfo = new BudgetValidateInfo(false, false, null);
        for (BudgetRegValue budgetReg : this.budgetRegValues) {
            boolean projectCostControl;
            DynamicObject project = budgetReg.getProjectValue();
            boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
            if (isNew) continue;
            QFilter projectFilter = new QFilter("pro", "=", project.getPkValue());
            DynamicObject approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{projectFilter});
            if (approval != null && !(projectCostControl = approval.getBoolean("projectcostcontrol"))) continue;
            budgetValidateInfo = this.doValidateBudget();
            if (budgetValidateInfo.isOutOfControl()) {
                outOfControlValidates.add(budgetValidateInfo);
                continue;
            }
            if (!budgetValidateInfo.isOutOfRemind()) continue;
            outOfRemindValidates.add(budgetValidateInfo);
        }
        if (!CollectionUtils.isEmpty(outOfRemindValidates)) {
            resultMap = new HashMap(16);
            for (BudgetValidateInfo outOfRemindValidate : outOfRemindValidates) {
                resultMap.putAll(outOfRemindValidate.getResultMap());
            }
            budgetValidateInfo = new BudgetValidateInfo(false, true, resultMap);
        }
        if (!CollectionUtils.isEmpty(outOfControlValidates)) {
            resultMap = new HashMap(16);
            for (BudgetValidateInfo outOfControlValidate : outOfControlValidates) {
                resultMap.putAll(outOfControlValidate.getResultMap());
            }
            budgetValidateInfo = new BudgetValidateInfo(true, false, resultMap);
        }
        return budgetValidateInfo;
    }

    abstract boolean updateBudget();

    protected BudgetValidateInfo doValidateBudget() {
        return null;
    }

    protected void initSingleBudgetReg(BudgetRegValue budgetReg) {
        this.budgetRegValue = budgetReg;
        this.project = this.budgetRegValue.getProjectValue();
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> singleBudgetAmountMap = new HashMap<String, BigDecimal>();
        singleBudgetAmountMap.put(this.budgetRegValue.getBudgetValue().getPkValue().toString(), this.budgetRegValue.getAmountValue().multiply(exchangeRate));
        if (!this.budgetAmountMap.containsKey(this.budgetRegValue.getBudgetValue().getPkValue().toString())) {
            this.budgetAmountMap.putAll(singleBudgetAmountMap);
        }
        if (!this.controlAmountMap.containsKey(this.budgetRegValue.getBudgetValue().getPkValue().toString())) {
            this.controlAmountMap.put(this.budgetRegValue.getBudgetValue().getPkValue().toString(), this.budgetRegValue.getAmountValue().multiply(BigDecimal.ONE));
        }
        return singleBudgetAmountMap;
    }

    protected String operationToBizRule() {
        String entityNumber = this.commonBudgetUpdateParam.getEntityNumber();
        String operation = this.commonBudgetUpdateParam.getOperation();
        if ("requestProjectBudget".equalsIgnoreCase(operation) || "returnProjectBudget".equalsIgnoreCase(operation) || "execProjectBudget".equalsIgnoreCase(operation) || "clearProjectBudget".equalsIgnoreCase(operation) || "returnAndClearProjectBudget".equalsIgnoreCase(operation)) {
            return operation;
        }
        QFilter objectTypeFilter = new QFilter("objecttype", "=", (Object)entityNumber);
        QFilter operationFilter = new QFilter("entryentity.operationkey", "=", (Object)operation);
        QFilter opBizRuleFilter = new QFilter("opbizrule", "in", Arrays.asList("requestProjectBudget", "execProjectBudget", "returnProjectBudget", "clearProjectBudget", "returnAndClearProjectBudget"));
        DynamicObject opBizRuleSet = BusinessDataServiceHelper.loadSingle((String)"bos_opbizruleset", (String)"opbizrule", (QFilter[])new QFilter[]{objectTypeFilter, operationFilter, opBizRuleFilter});
        if (opBizRuleSet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u9884\u7b97\u6263\u51cf\u64cd\u4f5c\u3002", (String)"AbstractBudgetUpdateSupport_1", (String)"pmgt-pmct-business", (Object[])new Object[0]));
        }
        return opBizRuleSet.getString("opbizrule");
    }
}

