/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.budget;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.business.budget.AbstractBudgetUpdateSupport;
import kd.pmgt.pmct.business.budget.BudgetCurrencySupport;
import kd.pmgt.pmct.common.model.BudgetRegValue;
import kd.pmgt.pmct.common.model.CommonBudgetUpdateParam;

public class ContractBudgetUpdateSupport
extends AbstractBudgetUpdateSupport {
    public ContractBudgetUpdateSupport(CommonBudgetUpdateParam commonBudgetUpdateParam, List<BudgetRegValue> budgetRegValues) {
        this.commonBudgetUpdateParam = commonBudgetUpdateParam;
        this.budgetRegValues = budgetRegValues;
    }

    @Override
    public boolean updateBudget() {
        boolean updated = false;
        boolean isOpenedContract = this.contract.getBoolean("openedcontract");
        boolean multiPartSettlement = this.contract.getBoolean("multipartsettlement");
        if (this.project != null && !isOpenedContract && !multiPartSettlement) {
            boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)this.project.getPkValue()));
            if (isNew) {
                return true;
            }
            Map projectAmountMap = this.budgetAmountMap;
            Map contractAmountMap = this.controlAmountMap;
            switch (this.commonBudgetUpdateParam.getOperation()) {
                case "submit": {
                    PerformBillInfo billInfo = new PerformBillInfoBuilder().formBillId(this.commonBudgetUpdateParam.getEntityNumber()).id(this.commonBudgetUpdateParam.getBillId().longValue()).billNo(this.commonBudgetUpdateParam.getBillNo()).billName(this.commonBudgetUpdateParam.getBillName()).creator(this.commonBudgetUpdateParam.getCreator()).createDate(this.commonBudgetUpdateParam.getCreateTime()).contractId(this.contract.getString("id")).contractCurrency(this.contract.getDynamicObject("currency")).amountType(PerformAmountTypeEnum.CONTRACT).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnSubmit((Map)projectAmountMap, (Map)contractAmountMap, (PerformBillInfo)billInfo);
                    break;
                }
                case "unsubmit": {
                    PerformBillInfo billInfo = new PerformBillInfoBuilder().formBillId(this.commonBudgetUpdateParam.getEntityNumber()).id(this.commonBudgetUpdateParam.getBillId().longValue()).contractId(this.contract.getString("id")).amountType(PerformAmountTypeEnum.CONTRACT).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit((Map)projectAmountMap, (Map)contractAmountMap, (PerformBillInfo)billInfo);
                    break;
                }
                case "audit": {
                    PerformBillInfo billInfo = new PerformBillInfoBuilder().formBillId(this.commonBudgetUpdateParam.getEntityNumber()).id(this.commonBudgetUpdateParam.getBillId().longValue()).billNo(this.commonBudgetUpdateParam.getBillNo()).billName(this.commonBudgetUpdateParam.getBillName()).creator(this.commonBudgetUpdateParam.getCreator()).createDate(this.commonBudgetUpdateParam.getCreateTime()).auditor(this.commonBudgetUpdateParam.getAuditor()).auditDate(this.commonBudgetUpdateParam.getAuditTime()).contractId(this.contract.getString("id")).amountType(PerformAmountTypeEnum.CONTRACT).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnAudit((Map)projectAmountMap, (Map)contractAmountMap, (PerformBillInfo)billInfo);
                    break;
                }
                case "unaudit": {
                    BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit((Map)projectAmountMap, (Map)contractAmountMap, (String)this.commonBudgetUpdateParam.getEntityNumber(), (long)this.commonBudgetUpdateParam.getBillId(), (String)this.contract.getString("id"), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
                    break;
                }
            }
            updated = true;
        }
        return updated;
    }

    @Override
    protected BudgetValidateInfo doValidateBudget() {
        BudgetValidateInfo validateInfo = null;
        Map<String, BigDecimal> proBudgetAmountMap = this.buildBudgetAmountMap(new BudgetCurrencySupport().getExchangeRate(this.contract, this.project));
        switch (this.commonBudgetUpdateParam.getOperation()) {
            case "submit": {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(proBudgetAmountMap, (String)this.contract.getString("id"), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
                break;
            }
            case "unsubmit": {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnUnSubmit(proBudgetAmountMap, (String)String.valueOf(this.commonBudgetUpdateParam.getBillId()), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
                break;
            }
            case "audit": {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(proBudgetAmountMap, (String)String.valueOf(this.commonBudgetUpdateParam.getBillId()), (long)this.commonBudgetUpdateParam.getBillId(), (String)this.commonBudgetUpdateParam.getEntityNumber(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)false);
                break;
            }
            case "unaudit": {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(proBudgetAmountMap, (String)String.valueOf(this.commonBudgetUpdateParam.getBillId()), (long)this.commonBudgetUpdateParam.getBillId(), (String)this.commonBudgetUpdateParam.getEntityNumber(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT, (boolean)true);
                break;
            }
        }
        return validateInfo;
    }
}

