/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.utils.ContractTypeUtils;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;

public class ContractEditHelper {
    public static final String PLAN_ENTRY = "planEntry";
    public static final String PERCENT_MODEL = "percentModel";
    public static final String PAY_PERCENT = "payPercent";
    public static final String PAY_AMOUNT = "payAmount";
    public static final String ORIGINAL_OF_TAX_AMOUNT = "Originaloftaxamount";
    public static final String DIRECTION = "direction";
    public static final String CACHE_ADJUSTAMOUNT = "cache_adjustamount";
    private static final Log logger = LogFactory.getLog(ContractEditHelper.class);

    public static void adjustPayPlan(IFormView formView, Map<String, String> paramMap) {
        BigDecimal originalOfTaxAmount;
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity(paramMap.get(PLAN_ENTRY));
        EntryGrid entryGrid = (EntryGrid)formView.getControl(paramMap.get(PLAN_ENTRY));
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8ba1\u5212\u884c\u3002", (String)"ContractEditHelper_0", (String)"pmgt-pmct-business", (Object[])new Object[0]));
            return;
        }
        int rowIndex = selectRows[0];
        ArrayList<BigDecimal> payPercentList = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> payAmountList = new ArrayList<BigDecimal>();
        for (DynamicObject entity : entryEntity) {
            BigDecimal payPercent = (BigDecimal)entity.get(paramMap.get(PAY_PERCENT));
            BigDecimal payAmount = (BigDecimal)entity.get(paramMap.get(PAY_AMOUNT));
            payPercentList.add(payPercent);
            payAmountList.add(payAmount);
        }
        boolean percentModel = (Boolean)formView.getModel().getValue(paramMap.get(PERCENT_MODEL));
        if (percentModel) {
            BigDecimal percentSum = payPercentList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            if (percentSum.compareTo(BigDecimal.valueOf(100L)) != 0) {
                if (PayDirectionEnum.OUT.getValue().equals(paramMap.get(DIRECTION))) {
                    formView.showErrorNotification(ResManager.loadKDStringExt((String)"\u8ba1\u5212\u9762\u677f\u4e2d\u7684\u201c\u4ed8\u6b3e\u6bd4\u4f8b\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e100%\u3002", (String)"ContractEditHelper_1", (String)"pmgt-pmct-business", (Object[])new Object[0]));
                } else {
                    formView.showErrorNotification(ResManager.loadKDStringExt((String)"\u8ba1\u5212\u9762\u677f\u4e2d\u7684\u201c\u6536\u6b3e\u6bd4\u4f8b\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e100%\u3002", (String)"ContractEditHelper_2", (String)"pmgt-pmct-business", (Object[])new Object[0]));
                }
                return;
            }
            originalOfTaxAmount = (BigDecimal)formView.getModel().getValue(paramMap.get(ORIGINAL_OF_TAX_AMOUNT));
            BigDecimal otherAmount = new BigDecimal(BigInteger.ZERO);
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (i == rowIndex) continue;
                otherAmount = otherAmount.add(((DynamicObject)entryEntity.get(i)).getBigDecimal(paramMap.get(PAY_AMOUNT)));
            }
            formView.getModel().beginInit();
            formView.getModel().setValue(paramMap.get(PAY_AMOUNT), (Object)originalOfTaxAmount.subtract(otherAmount), rowIndex);
            formView.updateView(paramMap.get(PAY_AMOUNT), rowIndex);
            formView.getModel().endInit();
        } else {
            BigDecimal amountSum = payAmountList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            originalOfTaxAmount = (BigDecimal)formView.getModel().getValue(paramMap.get(ORIGINAL_OF_TAX_AMOUNT));
            if (originalOfTaxAmount.compareTo(amountSum) != 0) {
                formView.showErrorNotification(ResManager.loadKDStringExt((String)"\u8ba1\u5212\u9762\u677f\u4e2d\u7684\u201c\u542b\u7a0e\u91d1\u989d\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"ContractEditHelper_3", (String)"pmgt-pmct-business", (Object[])new Object[0]));
                return;
            }
            BigDecimal otherPercent = new BigDecimal(BigInteger.ZERO);
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (i == rowIndex) continue;
                otherPercent = otherPercent.add(((DynamicObject)entryEntity.get(i)).getBigDecimal(paramMap.get(PAY_PERCENT)));
            }
            formView.getModel().beginInit();
            formView.getModel().setValue(paramMap.get(PAY_PERCENT), (Object)BigDecimal.valueOf(100L).subtract(otherPercent), rowIndex);
            formView.updateView(paramMap.get(PAY_PERCENT), rowIndex);
            formView.getModel().endInit();
        }
    }

    public static void recountPayPlan(IFormView formView, Map<String, String> paramMap) {
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity(paramMap.get(PLAN_ENTRY));
        boolean percentModel = (Boolean)formView.getModel().getValue(paramMap.get(PERCENT_MODEL));
        BigDecimal originalOfTaxAmount = (BigDecimal)formView.getModel().getValue(paramMap.get(ORIGINAL_OF_TAX_AMOUNT));
        if (percentModel) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryEntity.get(i);
                BigDecimal payPercent = entity.getBigDecimal(paramMap.get(PAY_PERCENT));
                payPercent = payPercent.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP);
                formView.getModel().beginInit();
                if (BigDecimal.ZERO.compareTo(payPercent) != 0) {
                    formView.getModel().setValue(paramMap.get(PAY_AMOUNT), (Object)originalOfTaxAmount.multiply(payPercent), i);
                    formView.updateView(paramMap.get(PAY_AMOUNT), i);
                }
                formView.getModel().endInit();
            }
        } else {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryEntity.get(i);
                BigDecimal payAmount = entity.getBigDecimal(paramMap.get(PAY_AMOUNT));
                formView.getModel().beginInit();
                if (BigDecimal.ZERO.compareTo(payAmount) != 0 && BigDecimal.ZERO.compareTo(originalOfTaxAmount) != 0) {
                    formView.getModel().setValue(paramMap.get(PAY_PERCENT), (Object)payAmount.divide(originalOfTaxAmount, 10, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)), i);
                    formView.updateView(paramMap.get(PAY_PERCENT), i);
                }
                formView.getModel().endInit();
            }
        }
    }

    public static void setCheckParameter(BeforeDoOperationEventArgs args, String formId, String itemId) {
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        for (ControlAp item : formMeta.getItems()) {
            String key = item.getKey();
            String visible = item.getVisible();
            if (!StringUtils.equals((CharSequence)itemId, (CharSequence)key)) continue;
            boolean a = !StringUtils.isBlank((CharSequence)visible);
            ((FormOperate)args.getSource()).getOption().setVariableValue("visible", Boolean.toString(a));
        }
    }

    public static boolean amountRollback(IFormView view, DynamicObject subEntry, Object newValue, Object oldValue, String key, int rowIndex) {
        BigDecimal newAmount = BigDecimal.ZERO;
        BigDecimal oldAmount = BigDecimal.ZERO;
        if (newValue != null) {
            newAmount = new BigDecimal(String.valueOf(newValue));
        }
        if (oldValue != null) {
            oldAmount = new BigDecimal(String.valueOf(oldValue));
        }
        if (newAmount.subtract(oldAmount).abs().compareTo(BigDecimal.ONE) > 0) {
            subEntry.set(key, (Object)oldAmount);
            view.updateView(subEntry.getDataEntityType().getName());
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6e05\u5355\u5206\u5f55\u7b2c%s\u884c\uff0c\u8c03\u6574\u91d1\u989d\u8d85\u51fa\u5fae\u8c03\u5bb9\u5dee\u8303\u56f4[-1\uff0c1]\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u3002", (String)"ContractEditHelper_4", (String)"pmgt-pmct-business", (Object[])new Object[0]), rowIndex + 1));
            return true;
        }
        return false;
    }

    public static void resetEntryAmountField(DynamicObjectCollection entryEntities, boolean isEnterAmount, boolean isOfTaxContract, DynamicObject currency, String qtyField, String oftaxField, String amountField, String taxRateField, String priceOfTaxField, String priceField, String taxField) {
        int pricePrecision = CurrencyHelper.getPriceAccuracy((DynamicObject)currency);
        int amtPrecision = CurrencyHelper.getAmountAccuracy((DynamicObject)currency);
        for (DynamicObject row : entryEntities) {
            BigDecimal qty = row.getBigDecimal(qtyField);
            BigDecimal ofTax = row.getBigDecimal(oftaxField);
            BigDecimal amount = row.getBigDecimal(amountField);
            BigDecimal taxrate1 = row.getBigDecimal(taxRateField);
            BigDecimal priceOfTax = row.getBigDecimal(priceOfTaxField);
            BigDecimal price = row.getBigDecimal(priceField);
            BigDecimal subTaxRate = taxrate1.divide(BigDecimal.valueOf(100L), 10, 4);
            if (isEnterAmount) {
                if (isOfTaxContract) {
                    amount = ofTax.divide(BigDecimal.ONE.add(subTaxRate), amtPrecision, RoundingMode.HALF_UP);
                    if (qty.compareTo(BigDecimal.ZERO) != 0) {
                        priceOfTax = NumberHelper.divide((Object)ofTax, (Object)qty, (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
                        price = NumberHelper.divide((Object)amount, (Object)qty, (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
                    }
                } else {
                    ofTax = amount.multiply(BigDecimal.ONE.add(subTaxRate));
                    if (qty.compareTo(BigDecimal.ZERO) != 0) {
                        priceOfTax = NumberHelper.divide((Object)ofTax, (Object)qty, (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
                        price = NumberHelper.divide((Object)amount, (Object)qty, (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
                    }
                }
            } else {
                ofTax = priceOfTax.multiply(qty);
                amount = price.multiply(qty);
            }
            row.set(oftaxField, (Object)ofTax);
            row.set(amountField, (Object)amount);
            row.set(priceOfTaxField, (Object)priceOfTax);
            row.set(priceField, (Object)price);
            row.set(taxField, (Object)NumberHelper.subtract((Object)ofTax, (Object)amount));
        }
    }

    public static void setNewListModel(Object contractId, DynamicObjectCollection listModelEntry) {
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_contracttpl");
        QFilter contFilter = new QFilter("contractid", "=", (Object)String.valueOf(contractId));
        DynamicObjectCollection listEntries = QueryServiceHelper.query((String)"pmct_contractlist", (String)"listingmodel", (QFilter[])new QFilter[]{contFilter});
        Set listModelIds = listEntries.stream().map(obj -> obj.getLong("listingmodel")).collect(Collectors.toSet());
        DynamicObjectCollection newListModelEntry = ContractTypeUtils.getListConfigs((DynamicObject)contract.getDynamicObject("contracttype"));
        if (newListModelEntry == null) {
            return;
        }
        listModelEntry.clear();
        for (DynamicObject listConfig : newListModelEntry) {
            if (!listModelIds.contains(listConfig.getPkValue())) continue;
            String tabname = listConfig.getString("tabname");
            String cmpRule = listConfig.getString("computerule");
            DynamicObject entry = new DynamicObject(listModelEntry.getDynamicObjectType());
            entry.set("listmodelid", listConfig.getPkValue());
            entry.set("modelname", (Object)tabname);
            if ("00".equals(cmpRule)) {
                entry.set("cmptype", (Object)"(+)");
            } else if ("01".equals(cmpRule)) {
                entry.set("cmptype", (Object)"(-)");
            } else if ("02".equals(cmpRule)) {
                entry.set("cmptype", (Object)"(0)");
            }
            listModelEntry.add((Object)entry);
        }
    }
}

