/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.helper;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmct.business.model.ContractValidateResult;

public class ContractValidateHelper {
    public static ContractValidateResult checkUsedAmt(Object contractPk, DynamicObjectCollection outContractPayPlanEntries) {
        QFilter contractPkFilter = new QFilter("contract", "=", contractPk);
        QFilter autoGeneratedFilter = new QFilter("autogenerated", "=", (Object)Boolean.TRUE);
        DynamicObject[] contractPayItemIds = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{contractPkFilter, autoGeneratedFilter});
        if (contractPayItemIds.length == 1 && !outContractPayPlanEntries.isEmpty()) {
            DynamicObject contractPayItem = BusinessDataServiceHelper.loadSingle((Object)contractPayItemIds[0].getPkValue(), (String)"pmbs_contractpayitem");
            BigDecimal reimbursedComAmt = contractPayItem.getBigDecimal("reimbursedcomamt");
            if (reimbursedComAmt.compareTo(BigDecimal.ZERO) > 0) {
                String msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8be5\u5408\u540c\u5df2\u7ecf\u57fa\u4e8e\u6574\u5355\u8fdb\u884c\u62a5\u9500\uff0c\u4e0d\u80fd\u6dfb\u52a0\u4ed8\u6b3e\u8ba1\u5212\u3002", (String)"ContractValidateHelper_0", (String)"pmgt-pmct-business", (Object[])new Object[0]);
                return new ContractValidateResult(true, msg);
            }
            BigDecimal paidComAmt = contractPayItem.getBigDecimal("paidcomamt");
            if (paidComAmt.compareTo(BigDecimal.ZERO) > 0) {
                String msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8be5\u5408\u540c\u5df2\u7ecf\u57fa\u4e8e\u6574\u5355\u8fdb\u884c\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u6dfb\u52a0\u4ed8\u6b3e\u8ba1\u5212\u3002", (String)"ContractValidateHelper_1", (String)"pmgt-pmct-business", (Object[])new Object[0]);
                return new ContractValidateResult(true, msg);
            }
        }
        return new ContractValidateResult(false, "");
    }

    public static ContractValidateResult checkOriginalOfTaxAmount(BigDecimal originalOfTaxAmount, DynamicObjectCollection outContractPayPlanEntries) {
        BigDecimal totalPayAmount = outContractPayPlanEntries.stream().map(entry -> entry.getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!outContractPayPlanEntries.isEmpty() && totalPayAmount.compareTo(originalOfTaxAmount) != 0) {
            String msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4ed8\u6b3e\u8ba1\u5212\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractValidateHelper_2", (String)"pmgt-pmct-business", (Object[])new Object[0]);
            return new ContractValidateResult(true, msg);
        }
        return new ContractValidateResult(false, "");
    }

    public static ContractValidateResult checkIncomePlanOriginalOfTaxAmount(BigDecimal originalOfTaxAmount, DynamicObjectCollection contractIncomePlanEntries) {
        if (!contractIncomePlanEntries.isEmpty()) {
            BigDecimal totalPayAmount = contractIncomePlanEntries.stream().map(entry -> entry.getBigDecimal("incomeamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (!contractIncomePlanEntries.isEmpty() && totalPayAmount.compareTo(originalOfTaxAmount) != 0) {
                String msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u6536\u6b3e\u8ba1\u5212\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractValidateHelper_3", (String)"pmgt-pmct-business", (Object[])new Object[0]);
                return new ContractValidateResult(true, msg);
            }
        }
        return new ContractValidateResult(false, "");
    }

    @Deprecated
    public static ContractValidateResult chargeByPlanNeedPlanEntry(DynamicObjectCollection outContractPayPlanEntries) {
        Object appParameter = Optional.ofNullable(SystemParamHelper.getAppParameter((String)"chargebyplan", (String)"pmct")).orElse("false");
        boolean chargeByPlan = Boolean.parseBoolean(appParameter.toString());
        if (chargeByPlan && outContractPayPlanEntries.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u8ba1\u5212\u3002", (String)"ContractValidateHelper_4", (String)"pmgt-pmct-business", (Object[])new Object[0]);
            return new ContractValidateResult(true, msg);
        }
        return new ContractValidateResult(false, "");
    }

    public static ContractValidateResult chargeByPlanNeedPlanEntry(DynamicObject bill, String entryFormId) {
        boolean chargeByPlan;
        DynamicObjectCollection contractCollectPlanEntries = bill.getDynamicObjectCollection(entryFormId);
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl");
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        boolean bl = chargeByPlan = (contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype")).getBoolean("enable") && contractType.getBoolean("chargebyplan");
        if (chargeByPlan && contractCollectPlanEntries.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u8ba1\u5212\u3002", (String)"ContractValidateHelper_4", (String)"pmgt-pmct-business", (Object[])new Object[0]);
            return new ContractValidateResult(true, msg);
        }
        return new ContractValidateResult(false, "");
    }

    @Deprecated
    public static ContractValidateResult chargeByPlanNeedIncomeEntry(DynamicObjectCollection contractCollectPlanEntries) {
        Object chargedByPlan = SystemParamHelper.getAppParameter((String)"chargebyplan", (String)"pmct");
        boolean chargeByPlan = Optional.ofNullable(chargedByPlan).map(it -> Boolean.valueOf(it.toString())).orElse(false);
        if (chargeByPlan && contractCollectPlanEntries.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u8ba1\u5212\u3002", (String)"ContractValidateHelper_5", (String)"pmgt-pmct-business", (Object[])new Object[0]);
            return new ContractValidateResult(true, msg);
        }
        return new ContractValidateResult(false, "");
    }

    public static ContractValidateResult chargeByPlanNeedIncomeEntry(DynamicObject bill, String entryFormId) {
        boolean chargeByPlan;
        DynamicObjectCollection contractCollectPlanEntries = bill.getDynamicObjectCollection(entryFormId);
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl");
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        boolean bl = chargeByPlan = (contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype")).getBoolean("enable") && contractType.getBoolean("chargebyplan");
        if (chargeByPlan && contractCollectPlanEntries.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u8ba1\u5212\u3002", (String)"ContractValidateHelper_5", (String)"pmgt-pmct-business", (Object[])new Object[0]);
            return new ContractValidateResult(true, msg);
        }
        return new ContractValidateResult(false, "");
    }

    public static ContractValidateResult checkPayAmount(DynamicObjectCollection outContractPayPlanEntries) {
        boolean error = false;
        StringBuilder msgBuilder = new StringBuilder();
        for (int i = 0; i < outContractPayPlanEntries.size(); ++i) {
            BigDecimal appliedComAmt;
            BigDecimal maxAmount;
            String fieldName;
            BigDecimal paidComAmt;
            DynamicObject outContractPayPlanEntry = (DynamicObject)outContractPayPlanEntries.get(i);
            long conPayItemId = outContractPayPlanEntry.getLong("conpayitemid");
            BigDecimal payAmount = outContractPayPlanEntry.getBigDecimal("payamount");
            if (conPayItemId == 0L) continue;
            DynamicObject contractPayItem = BusinessDataServiceHelper.loadSingle((Object)conPayItemId, (String)"pmbs_contractpayitem");
            BigDecimal reimbursedComAmt = contractPayItem.getBigDecimal("reimbursedcomamt");
            if (reimbursedComAmt.compareTo(paidComAmt = contractPayItem.getBigDecimal("paidcomamt")) > 0) {
                MetadataServiceHelper.getDataEntityType((String)"pmbs_contractpayitem");
                fieldName = ResManager.loadKDString((String)"\u5df2\u62a5\u9500\u91d1\u989d", (String)"ContractValidateHelper_6", (String)"pmgt-pmct-business", (Object[])new Object[0]);
                maxAmount = reimbursedComAmt;
            } else {
                fieldName = ResManager.loadKDString((String)"\u5df2\u4ed8\u6b3e\u91d1\u989d", (String)"ContractValidateHelper_7", (String)"pmgt-pmct-business", (Object[])new Object[0]);
                maxAmount = paidComAmt;
            }
            if (payAmount.compareTo(maxAmount) < 0) {
                if (StringUtils.isNotBlank((CharSequence)msgBuilder.toString())) {
                    msgBuilder.append('\n');
                }
                error = true;
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%1$s\u9879\uff0c\u542b\u7a0e\u91d1\u989d\u5c0f\u4e8e\u8be5\u9879%2$s\u3002", (String)"ContractValidateHelper_12", (String)"pmgt-pmct-business", (Object[])new Object[0]), i + 1, fieldName));
                msgBuilder.append('\r');
            }
            if (NumberHelper.compareValue((Object)payAmount, (Object)(appliedComAmt = contractPayItem.getBigDecimal("appliedcomamt"))) >= 0) continue;
            if (StringUtils.isNotBlank((CharSequence)msgBuilder.toString())) {
                msgBuilder.append('\n');
            }
            error = true;
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u542b\u7a0e\u91d1\u989d\u5c0f\u4e8e\u8be5\u9879\u5df2\u7533\u8bf7\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u3002", (String)"ContractValidateHelper_13", (String)"pmgt-pmct-business", (Object[])new Object[0]), i + 1));
        }
        return new ContractValidateResult(error, msgBuilder.toString());
    }

    public static ContractValidateResult checkIncomeAmount(DynamicObjectCollection contractIncomePlanEntries) {
        boolean error = false;
        StringBuilder msgBuilder = new StringBuilder();
        for (int i = 0; i < contractIncomePlanEntries.size(); ++i) {
            BigDecimal appliedComAmt;
            DynamicObject contractCollectPlanEntry = (DynamicObject)contractIncomePlanEntries.get(i);
            long conIncomeItemId = contractCollectPlanEntry.getLong("conincomeitemid");
            BigDecimal incomeAmount = contractCollectPlanEntry.getBigDecimal("incomeamount");
            if (conIncomeItemId == 0L) continue;
            DynamicObject contractPayItem = BusinessDataServiceHelper.loadSingle((Object)conIncomeItemId, (String)"pmbs_contractcollectitem");
            BigDecimal collectedComAmt = contractPayItem.getBigDecimal("collectedcomamt");
            if (incomeAmount.compareTo(collectedComAmt) < 0) {
                error = true;
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u542b\u7a0e\u91d1\u989d\u5c0f\u4e8e\u8be5\u9879\u5df2\u6536\u6b3e\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"ContractValidateHelper_9", (String)"pmgt-pmct-business", (Object[])new Object[0]), i + 1));
                msgBuilder.append('\r');
                msgBuilder.append('\n');
            }
            if (NumberHelper.compareValue((Object)incomeAmount, (Object)(appliedComAmt = contractPayItem.getBigDecimal("appliedcomamt"))) >= 0) continue;
            msgBuilder.append('\n');
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u542b\u7a0e\u91d1\u989d\u5c0f\u4e8e\u8be5\u9879\u5df2\u8bf7\u6b3e\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u3002", (String)"ContractValidateHelper_14", (String)"pmgt-pmct-business", (Object[])new Object[0]), i + 1));
        }
        return new ContractValidateResult(error, msgBuilder.toString());
    }
}

