/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;

public class IncomePlanChangeHelper {
    private static final Log logger = LogFactory.getLog(IncomePlanChangeHelper.class);
    private static final int BUILDTYPE_UPDATE = 1;
    private static final int BUILDTYPE_NEW = 2;
    private static final int BUILDTYPE_DELETE = 3;
    private String srcFormId;

    public DynamicObject buildFundPlanChangeEntry(Object sourcePk, Object contractPk, String changeType, DynamicObject[] customEntries, String srcFormId, boolean needBillHead) {
        this.srcFormId = srcFormId;
        DynamicObject fundPlanChangeObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incomeplanchange"));
        DynamicObjectCollection changeEntries = fundPlanChangeObj.getDynamicObjectCollection("changeentity");
        if (needBillHead) {
            this.buildEntryHead(sourcePk, changeType, fundPlanChangeObj);
        }
        QFilter sourceBillIdFilter = new QFilter("sourcebillid", "=", sourcePk);
        DynamicObject[] fundPlanChangeBills = BusinessDataServiceHelper.load((String)"pmct_incomeplanchange", (String)"id", (QFilter[])new QFilter[]{sourceBillIdFilter});
        if (fundPlanChangeBills.length == 0) {
            QFilter contractFilter = new QFilter("contract", "=", contractPk);
            QFilter autoGeneFilter = new QFilter("autogenerated", "=", (Object)DefaultEnum.NO.getValue());
            QFilter sourceFilter = new QFilter("sourcebilltype", "!=", (Object)PayPlanSourceEnum.PERFORM.getValue());
            DynamicObject[] contractCollectItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"id", (QFilter[])new QFilter[]{contractFilter, autoGeneFilter, sourceFilter}, (String)"createtime asc");
            contractCollectItems = Arrays.stream(contractCollectItems).map(item -> BusinessDataServiceHelper.loadSingle((Object)item.getPkValue(), (String)"pmbs_contractcollectitem")).collect(Collectors.toList()).toArray(new DynamicObject[0]);
            this.fillFundPlanChangeEntry(customEntries, changeEntries, contractCollectItems);
        } else {
            fundPlanChangeObj = BusinessDataServiceHelper.loadSingle((Object)fundPlanChangeBills[0].getPkValue(), (String)"pmct_incomeplanchange");
        }
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_contracttpl");
        fundPlanChangeObj.set("currency", contract.get("currency"));
        return fundPlanChangeObj;
    }

    private void buildEntryHead(Object sourceId, String changeType, DynamicObject fundPlanChangeObj) {
        DynamicObject sourceBill = null;
        if (StringUtils.equals((CharSequence)PayPlanSourceEnum.ADDITION.getValue(), (CharSequence)changeType)) {
            sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmct_addagreementtpl");
        } else if (StringUtils.equals((CharSequence)PayPlanSourceEnum.MODIFY.getValue(), (CharSequence)changeType)) {
            sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmct_revisiontpl");
        } else if (StringUtils.equals((CharSequence)PayPlanSourceEnum.CLAIM.getValue(), (CharSequence)changeType)) {
            sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmct_inclaimbill");
        }
        if (sourceBill != null) {
            Object contractPk = sourceBill.getDynamicObject("contract").getPkValue();
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_contracttpl");
            fundPlanChangeObj.set("currency", contract.get("currency"));
            fundPlanChangeObj.set("sourcebilltype", (Object)changeType);
        }
    }

    protected void fillFundPlanChangeEntry(DynamicObject[] customEntries, DynamicObjectCollection changeEntries, DynamicObject[] contractCollectItems) {
        long contractCollectItemPk;
        long pk;
        int n;
        DynamicObject customEntry = null;
        DynamicObject contractCollectItem = null;
        boolean contains = false;
        String conPlanItemId = "";
        switch (this.srcFormId) {
            case "pmct_inaddagreement": {
                conPlanItemId = "conplanitemid";
                break;
            }
            case "pmct_incontractrevision": {
                conPlanItemId = "conplanitemid";
                break;
            }
            case "pmct_inclaimbill": {
                conPlanItemId = "conplanitemid";
                break;
            }
            case "pmct_contractrevision": {
                conPlanItemId = "conincomeitemid";
                break;
            }
        }
        DynamicObject[] dynamicObjectArray = contractCollectItems;
        int n2 = dynamicObjectArray.length;
        for (n = 0; n < n2; ++n) {
            DynamicObject item;
            contractCollectItem = item = dynamicObjectArray[n];
            for (DynamicObject entry : customEntries) {
                pk = entry.getLong(conPlanItemId);
                contractCollectItemPk = Long.parseLong(String.valueOf(item.getPkValue()));
                if (contractCollectItemPk == pk) {
                    customEntry = entry;
                    contains = true;
                    this.buildItem(changeEntries, customEntry, contractCollectItem, 1);
                    break;
                }
                customEntry = null;
                contains = false;
            }
            if (contains) continue;
            this.buildItem(changeEntries, customEntry, contractCollectItem, 3);
        }
        dynamicObjectArray = customEntries;
        n2 = dynamicObjectArray.length;
        for (n = 0; n < n2; ++n) {
            DynamicObject entry;
            customEntry = entry = dynamicObjectArray[n];
            for (DynamicObject item : contractCollectItems) {
                pk = entry.getLong(conPlanItemId);
                contractCollectItemPk = Long.parseLong(String.valueOf(item.getPkValue()));
                if (contractCollectItemPk == pk) {
                    contains = true;
                    break;
                }
                contractCollectItem = null;
                contains = false;
            }
            if (contains) continue;
            this.buildItem(changeEntries, customEntry, contractCollectItem, 2);
        }
    }

    private void buildItem(DynamicObjectCollection changeEntries, DynamicObject customEntry, DynamicObject contractCollectItem, Integer buildType) {
        DynamicObject changeEntry = changeEntries.addNew();
        changeEntry.set("id", (Object)DB.genLongId((String)"t_pmct_fundplanchange"));
        if (contractCollectItem != null) {
            changeEntry.set("customer", contractCollectItem.get("customer"));
            changeEntry.set("oldcollecttype", contractCollectItem.get("collecttype"));
            changeEntry.set("oldcollectfeq", contractCollectItem.get("collectfeq"));
            changeEntry.set("oldcollectway", contractCollectItem.get("collectway"));
            changeEntry.set("oldcollectpercent", contractCollectItem.get("collectpercent"));
            changeEntry.set("oldcollectamount", contractCollectItem.get("collectamount"));
            changeEntry.set("oldplancollecttime", contractCollectItem.get("plancollecttime"));
            changeEntry.set("oldsourcebillid", contractCollectItem.get("sourcebill"));
            Object nodeSetting = contractCollectItem.get("nodesetting");
            changeEntry.set("oldnodesetting", nodeSetting);
            changeEntry.set("oldctrlstrategy", contractCollectItem.get("ctrlstrategy"));
            if (nodeSetting != null) {
                changeEntry.set("oldnodesettingsource", contractCollectItem.get("nodesettingsource"));
            }
        }
        if (customEntry != null) {
            switch (this.srcFormId) {
                case "pmct_inaddagreement": {
                    changeEntry.set("customer", customEntry.get("customer"));
                    changeEntry.set("newcollecttype", customEntry.get("incometype"));
                    changeEntry.set("newcollectfeq", customEntry.get("incomefeq"));
                    changeEntry.set("newcollectway", customEntry.get("incomeway"));
                    changeEntry.set("newcollectpercent", customEntry.get("incomepercent"));
                    changeEntry.set("newcollectamount", customEntry.get("incomeamountoftax"));
                    changeEntry.set("newplancollecttime", customEntry.get("planincometime"));
                    Object nodeSetting = customEntry.get("nodesetting");
                    changeEntry.set("newnodesetting", nodeSetting);
                    changeEntry.set("newctrlstrategy", customEntry.get("ctrlstrategy"));
                    if (nodeSetting == null) break;
                    changeEntry.set("newnodesettingsource", customEntry.get("nodesettingsource"));
                    break;
                }
                case "pmct_incontractrevision": {
                    changeEntry.set("customer", customEntry.get("customer"));
                    changeEntry.set("newcollecttype", customEntry.get("incometype"));
                    changeEntry.set("newcollectfeq", customEntry.get("incomefeq"));
                    changeEntry.set("newcollectway", customEntry.get("incomeway"));
                    changeEntry.set("newcollectpercent", customEntry.get("incomepercent"));
                    changeEntry.set("newcollectamount", customEntry.get("incomeamountoftax"));
                    changeEntry.set("newplancollecttime", customEntry.get("planincometime"));
                    Object nodeSetting = customEntry.get("nodesetting");
                    changeEntry.set("newnodesetting", nodeSetting);
                    changeEntry.set("newctrlstrategy", customEntry.get("ctrlstrategy"));
                    if (nodeSetting == null) break;
                    changeEntry.set("newnodesettingsource", customEntry.get("nodesettingsource"));
                    break;
                }
                case "pmct_contractrevision": {
                    changeEntry.set("customer", customEntry.get("customer"));
                    changeEntry.set("newcollecttype", customEntry.get("incometype"));
                    changeEntry.set("newcollectfeq", customEntry.get("incomemethod"));
                    changeEntry.set("newcollectway", customEntry.get("incomeway"));
                    changeEntry.set("newcollectpercent", customEntry.get("incomepercent"));
                    changeEntry.set("newcollectamount", customEntry.get("incomeamount"));
                    changeEntry.set("newplancollecttime", customEntry.get("planincometime"));
                    Object nodeSetting = customEntry.get("incomenodesetting");
                    changeEntry.set("newnodesetting", nodeSetting);
                    changeEntry.set("newctrlstrategy", customEntry.get("incomectrlstrategy"));
                    if (nodeSetting == null) break;
                    changeEntry.set("newnodesettingsource", customEntry.get("incomesource"));
                    break;
                }
                case "pmct_inclaimbill": {
                    changeEntry.set("customer", customEntry.get("customer"));
                    changeEntry.set("newcollecttype", customEntry.get("incometype"));
                    changeEntry.set("newcollectfeq", customEntry.get("incomefeq"));
                    changeEntry.set("newcollectway", customEntry.get("incomeway"));
                    changeEntry.set("newcollectpercent", customEntry.get("incomepercent"));
                    changeEntry.set("newcollectamount", customEntry.get("incomeamountoftax"));
                    changeEntry.set("newplancollecttime", customEntry.get("planincometime"));
                    Object nodeSetting = customEntry.get("nodesetting");
                    changeEntry.set("newnodesetting", nodeSetting);
                    changeEntry.set("newctrlstrategy", customEntry.get("ctrlstrategy"));
                    if (nodeSetting == null) break;
                    changeEntry.set("newnodesettingsource", customEntry.get("nodesettingsource"));
                    break;
                }
            }
            changeEntry.set("newsourcebillid", customEntry.getPkValue());
            changeEntry.set("seq", customEntry.get("seq"));
        }
        if (contractCollectItem != null && customEntry != null && buildType == 1) {
            BigDecimal collectedComAmt = (BigDecimal)contractCollectItem.get("collectedcomamt");
            BigDecimal incomeAmountOfTax = BigDecimal.ZERO;
            switch (this.srcFormId) {
                case "pmct_inaddagreement": {
                    incomeAmountOfTax = (BigDecimal)customEntry.get("incomeamountoftax");
                    break;
                }
                case "pmct_incontractrevision": {
                    incomeAmountOfTax = (BigDecimal)customEntry.get("incomeamountoftax");
                    break;
                }
                case "pmct_inclaimbill": {
                    incomeAmountOfTax = (BigDecimal)customEntry.get("incomeamountoftax");
                    break;
                }
                case "pmct_contractrevision": {
                    String entryName = customEntry.getDynamicObjectType().getName();
                    if (StringUtils.equals((CharSequence)"incontpayplanentry", (CharSequence)entryName)) {
                        incomeAmountOfTax = (BigDecimal)customEntry.get("incomeamount");
                        break;
                    }
                    incomeAmountOfTax = (BigDecimal)customEntry.get("payamount");
                    break;
                }
            }
            changeEntry.set("uncollectedamt", (Object)incomeAmountOfTax.subtract(collectedComAmt));
            changeEntry.set("collectedamt", contractCollectItem.get("collectedamt"));
            changeEntry.set("collectedcomamt", (Object)collectedComAmt);
            changeEntry.set("appliedamt", contractCollectItem.get("appliedamt"));
            changeEntry.set("appliedcomamt", contractCollectItem.get("appliedcomamt"));
            changeEntry.set("appliableamt", contractCollectItem.get("appliableamt"));
        } else if (buildType == 2) {
            Object newCollectAmountOfTax = changeEntry.get("newcollectamount");
            changeEntry.set("uncollectedamt", newCollectAmountOfTax);
            changeEntry.set("appliableamt", newCollectAmountOfTax);
        } else if (buildType == 3) {
            changeEntry.set("uncollectedamt", (Object)0);
            changeEntry.set("appliableamt", (Object)0);
        }
        BigDecimal newPayAmount = Optional.ofNullable(changeEntry.getBigDecimal("newcollectamount")).orElse(BigDecimal.ZERO);
        BigDecimal oldPayAmount = Optional.ofNullable(changeEntry.getBigDecimal("oldcollectamount")).orElse(BigDecimal.ZERO);
        changeEntry.set("changecollectamount", (Object)newPayAmount.subtract(oldPayAmount));
    }
}

