/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class ContractSelectSupport {
    public void selectContract(String formId, String operateKey, PayDirectionEnum payDirection, List<Long> orgPks, DynamicObject project, ListShowParameter parameter) {
        QFilter contractFilter = this.getContractFilter(formId, operateKey, payDirection, orgPks, project);
        parameter.getListFilterParameter().getQFilters().add(contractFilter);
    }

    public QFilter getContractFilter(String formId, String operateKey, PayDirectionEnum payDirection, List<Long> orgPks, DynamicObject project) {
        QFilter contractFilter;
        Long projectPk = project == null ? null : Long.valueOf(Long.parseLong(project.getPkValue().toString()));
        List<Long> proPks = projectPk == null ? null : Collections.singletonList(projectPk);
        Set shareContractIdPks = Arrays.stream(ContractHelper.getContractByMultiPartSettle(proPks, orgPks)).map(contract -> Long.parseLong(contract.getPkValue().toString())).collect(Collectors.toSet());
        QFilter shareContractIdsFilter = null;
        if (!shareContractIdPks.isEmpty()) {
            shareContractIdsFilter = new QFilter("id", "in", shareContractIdPks);
        }
        QFilter nonMultiSettlementFilter = new QFilter("multipartsettlement", "=", (Object)false);
        if (project != null) {
            contractFilter = new QFilter("project", "=", project.getPkValue());
            QFilter orgsFilter = new QFilter("org", "in", orgPks);
            contractFilter.and(orgsFilter);
            contractFilter = shareContractIdsFilter != null ? shareContractIdsFilter.or(contractFilter.and(nonMultiSettlementFilter)) : contractFilter.and(nonMultiSettlementFilter);
        } else {
            QFilter permContractIdFilter = ProjectPermissionHelper.getPermContractFilter(orgPks, (boolean)false, null, (String)formId, (String)operateKey);
            contractFilter = shareContractIdsFilter != null ? shareContractIdsFilter.or(permContractIdFilter.and(nonMultiSettlementFilter)) : permContractIdFilter.and(nonMultiSettlementFilter);
        }
        QFilter contractStatusFilter = ContractHelper.getContractByStatus((String)formId, (String)payDirection.getValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        contractFilter.and(contractStatusFilter).and(statusFilter);
        return contractFilter;
    }

    public QFilter getContractFilterForAllOrgPerm(String formId, PayDirectionEnum payDirection) {
        QFilter contractStatusFilter = ContractHelper.getContractByStatus((String)formId, (String)payDirection.getValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        contractStatusFilter.and(statusFilter);
        return contractStatusFilter;
    }
}

