/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.pmct.ContractMultiTypeEnum;
import kd.pmgt.pmct.business.manage.IContractFillBackService;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.common.utils.AmountCurrencyUtils;

public class InContractFillBackService
implements IContractFillBackService {
    @Override
    public DynamicObjectCollection fillBillEntryByContractF7(IFormView view, IDataModel dataModel, ListSelectedRowCollection selectedRows) {
        int rowIndex;
        DynamicObjectCollection inContractPlanEntries = dataModel.getEntryEntity("incontractplanentity");
        for (rowIndex = 0; rowIndex < selectedRows.size(); ++rowIndex) {
            ListSelectedRow selectedRow = selectedRows.get(rowIndex);
            DynamicObject entry = inContractPlanEntries.addNew();
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"pmct_incontract");
            this.fillCurrentEntry(dataModel, contract, entry);
        }
        for (rowIndex = 0; rowIndex < inContractPlanEntries.size(); ++rowIndex) {
            DynamicObject contract = ((DynamicObject)inContractPlanEntries.get(rowIndex)).getDynamicObject("incontract");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            String multiPayType = contract.getString("multipaytype");
            if (!multiPartSettlement || !StringUtils.equals((CharSequence)multiPayType, (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue())) continue;
            AbstractGrid grid = (AbstractGrid)view.getControl("incontractplanentity");
            this.setCellColor(grid, "inoriginaloftaxamt", rowIndex);
            this.setCellColor(grid, "intotalinvoiceoftaxamt", rowIndex);
            this.setCellColor(grid, "ininvoicednonpay", rowIndex);
        }
        return inContractPlanEntries;
    }

    @Override
    public DynamicObjectCollection fillFundPlanData2BillEntry(IFormView view, IDataModel dataModel, String returnData) {
        DynamicObjectCollection inContractPlanEntries = dataModel.getEntryEntity("incontractplanentity");
        inContractPlanEntries.clear();
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_monthlyfundplan")).getDynamicObjectCollection("incontractplanentity").getDynamicObjectType();
        Object[] customObjectEntries = DynamicObjectSerializeUtil.deserialize((String)returnData, (DynamicObjectType)dt);
        List contracts = Arrays.stream(customObjectEntries).map(item -> (DynamicObject)item).collect(Collectors.toList());
        for (int i = 0; i < contracts.size(); ++i) {
            DynamicObject contract = (DynamicObject)contracts.get(i);
            DynamicObject entry = inContractPlanEntries.addNew();
            this.doFillFundPlanData2BillEntry(view, i, entry, contract);
        }
        return inContractPlanEntries;
    }

    @Override
    public DynamicObjectCollection fillImportData2BillEntry(IFormView view, IDataModel dataModel, String returnData) {
        DynamicObject period = (DynamicObject)dataModel.getValue("period");
        DynamicObjectCollection inContractPlanEntries = dataModel.getEntryEntity("incontractplanentity");
        inContractPlanEntries.clear();
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_monthlyfundplan")).getDynamicObjectCollection("incontractplanentity").getDynamicObjectType();
        Object[] customObjectEntries = DynamicObjectSerializeUtil.deserialize((String)returnData, (DynamicObjectType)dt);
        List importEntities = Arrays.stream(customObjectEntries).map(item -> (DynamicObject)item).collect(Collectors.toList());
        for (int i = 0; i < importEntities.size(); ++i) {
            DynamicObject importData = (DynamicObject)importEntities.get(i);
            DynamicObject entry = inContractPlanEntries.addNew();
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)importData.getDynamicObject("incontract").getPkValue(), (String)"pmct_incontractf7");
            this.fillCurrentEntry(dataModel, contract, entry);
            if (period == null) continue;
            entry.set("inperiodplanamt", (Object)importData.getBigDecimal("inperiodplanamt"));
            BigDecimal inPeriodPlanAmtStd = AmountCurrencyUtils.amount2StdAmount((BigDecimal)entry.getBigDecimal("inperiodplanamt"), (BigDecimal)entry.getBigDecimal("inexchangerate"), (DynamicObject)((DynamicObject)dataModel.getValue("currency")));
            entry.set("inperiodplanamtstd", (Object)inPeriodPlanAmtStd);
            entry.set("incontractdescription", (Object)importData.getString("incontractdescription"));
        }
        return inContractPlanEntries;
    }

    private void doFillFundPlanData2BillEntry(IFormView view, int rowIndex, DynamicObject currentEntry, DynamicObject fundPlanContract) {
        currentEntry.set("incontract", fundPlanContract.get("incontract"));
        currentEntry.set("incurrency", fundPlanContract.get("incurrency"));
        currentEntry.set("inexchangerate", (Object)fundPlanContract.getBigDecimal("inexchangerate"));
        currentEntry.set("inoriginaloftaxamt", fundPlanContract.get("inoriginaloftaxamt"));
        currentEntry.set("intotalsettleoftaxamt", fundPlanContract.get("intotalsettleoftaxamt"));
        currentEntry.set("intotalinvoiceoftaxamt", fundPlanContract.get("intotalinvoiceoftaxamt"));
        currentEntry.set("intotalrealoftaxamt", fundPlanContract.get("intotalrealoftaxamt"));
        currentEntry.set("ininvoicednonpay", fundPlanContract.get("ininvoicednonpay"));
        currentEntry.set("insettlednonpay", fundPlanContract.get("insettlednonpay"));
        currentEntry.set("inperiodplanamt", fundPlanContract.get("inperiodplanamt"));
        currentEntry.set("inperiodplanamtstd", fundPlanContract.get("inperiodplanamtstd"));
        currentEntry.set("incontractbillno", fundPlanContract.get("incontractbillno"));
        currentEntry.set("parta", fundPlanContract.get("parta"));
        currentEntry.set("incontractstatus", fundPlanContract.get("incontractstatus"));
        currentEntry.set("incontracttype", fundPlanContract.get("incontracttype"));
        currentEntry.set("inproject", fundPlanContract.get("inproject"));
        currentEntry.set("inorg", fundPlanContract.get("inorg"));
        currentEntry.set("incontractdescription", fundPlanContract.get("incontractdescription"));
        fundPlanContract = BusinessDataServiceHelper.loadSingle((Object)fundPlanContract.getDynamicObject("incontract").getPkValue(), (String)"pmct_outcontract");
        boolean multiPartSettlement = fundPlanContract.getBoolean("multipartsettlement");
        String multiPayType = fundPlanContract.getString("multipaytype");
        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue())) {
            AbstractGrid grid = (AbstractGrid)view.getControl("incontractplanentity");
            this.setCellColor(grid, "inoriginaloftaxamt", rowIndex);
            this.setCellColor(grid, "intotalinvoiceoftaxamt", rowIndex);
            this.setCellColor(grid, "ininvoicednonpay", rowIndex);
        }
    }

    private void fillCurrentEntry(IDataModel dataModel, DynamicObject contract, DynamicObject currentEntry) {
        BigDecimal totalRealOfTaxAmount;
        BigDecimal totalSettleOfTaxAmount;
        DynamicObject project = (DynamicObject)dataModel.getValue("project");
        DynamicObject org = (DynamicObject)dataModel.getValue("org");
        currentEntry.set("incontract", (Object)contract);
        currentEntry.set("incurrency", contract.get("currency"));
        BigDecimal exchangeRate = contract.getBigDecimal("exchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        currentEntry.set("inexchangerate", (Object)exchangeRate);
        currentEntry.set("inoriginaloftaxamt", contract.get("totaloftaxamount"));
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        String multiPayType = contract.getString("multipaytype");
        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue())) {
            MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
            totalSettleOfTaxAmount = multiSettleAmtService.getMultiTotalSettleOfTaxAmt(org, project, contract);
            totalRealOfTaxAmount = multiSettleAmtService.getTotalRealOfTaxAmount(org, project, contract);
        } else {
            totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
            totalRealOfTaxAmount = contract.getBigDecimal("totalrealoftaxamount");
        }
        currentEntry.set("intotalsettleoftaxamt", (Object)totalSettleOfTaxAmount);
        currentEntry.set("intotalinvoiceoftaxamt", contract.get("totalinvoiceoftaxamount"));
        currentEntry.set("intotalrealoftaxamt", (Object)totalRealOfTaxAmount);
        currentEntry.set("ininvoicednonpay", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalRealOfTaxAmount));
        currentEntry.set("insettlednonpay", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
        currentEntry.set("incontractbillno", contract.get("billno"));
        if (StringUtils.equals((CharSequence)contract.getString("paydirection"), (CharSequence)PayDirectionEnum.OUT.getValue())) {
            currentEntry.set("parta", contract.get("partb"));
        } else {
            currentEntry.set("parta", contract.get("parta"));
        }
        currentEntry.set("incontractstatus", contract.get("contractstatus"));
        currentEntry.set("incontracttype", contract.get("contracttype"));
        currentEntry.set("inproject", contract.get("project"));
        currentEntry.set("inorg", contract.get("org"));
        currentEntry.set("incontractdescription", contract.get("description"));
    }

    @Override
    public void updateView(IFormView formView) {
        formView.updateView("incontractplanentity");
    }
}

