/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmct.business.manage.INonContractFundPlanningService;
import kd.pmgt.pmct.common.utils.AmountCurrencyUtils;

public class InNonContractFundPlanningService
implements INonContractFundPlanningService {
    @Override
    public BigDecimal calculateNonPeriodPlanAmtStd(IDataModel dataModel) {
        int curIndex = dataModel.getEntryCurrentRowIndex("innoncontractplanentity");
        DynamicObject rowEntity = dataModel.getEntryRowEntity("innoncontractplanentity", curIndex);
        DynamicObject currency = rowEntity.getDynamicObject("innoncurrency");
        DynamicObject stdCurrency = (DynamicObject)dataModel.getValue("currency");
        DynamicObject exRateTable = rowEntity.getDynamicObject("noninexratetable");
        Date exchangeDate = (Date)rowEntity.get("noninexchangedate");
        BigDecimal exchangeRate = CurrencyHelper.getExChangeRate((Long)currency.getLong("id"), (Long)stdCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)exchangeDate);
        return AmountCurrencyUtils.amount2StdAmount((BigDecimal)((BigDecimal)dataModel.getValue("noninperiodplanamt")), (BigDecimal)exchangeRate, (DynamicObject)stdCurrency);
    }

    @Override
    public void setDefaultExchangeFields(IDataModel dataModel) {
        int currentRowIndex = dataModel.getEntryCurrentRowIndex("innoncontractplanentity");
        DynamicObject org = (DynamicObject)dataModel.getValue("org");
        DynamicObject currency = CurrencyHelper.getCurrency((Long)((Long)org.getPkValue()));
        DynamicObject exRateTable = CurrencyHelper.getExRateTable((Long)((Long)org.getPkValue()));
        dataModel.setValue("innoncurrency", (Object)currency, currentRowIndex);
        dataModel.setValue("noninexratetable", exRateTable.getPkValue(), currentRowIndex);
        dataModel.setValue("noninexchangedate", (Object)new Date(), currentRowIndex);
    }

    @Override
    public DynamicObjectCollection setImportData(IDataModel dataModel, String returnData) {
        DynamicObjectCollection inContractPlanEntries = dataModel.getEntryEntity("innoncontractplanentity");
        inContractPlanEntries.clear();
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_monthlyfundplan")).getDynamicObjectCollection("innoncontractplanentity").getDynamicObjectType();
        Object[] customObjectEntries = DynamicObjectSerializeUtil.deserialize((String)returnData, (DynamicObjectType)dt);
        List<DynamicObject> importEntities = Arrays.stream(customObjectEntries).map(item -> (DynamicObject)item).collect(Collectors.toList());
        importEntities.forEach(importData -> {
            DynamicObject entry = inContractPlanEntries.addNew();
            entry.set("nonincomeitem", (Object)importData.getString("nonincomeitem"));
            entry.set("noninperiodplanamt", (Object)importData.getBigDecimal("noninperiodplanamt"));
            entry.set("nonincompanyname", (Object)importData.getString("nonincompanyname"));
            DynamicObject currency = importData.getDynamicObject("innoncurrency");
            entry.set("innoncurrency", (Object)currency);
            DynamicObject exRateTable = importData.getDynamicObject("noninexratetable");
            entry.set("noninexratetable", (Object)exRateTable);
            Date exchangeDate = importData.getDate("noninexchangedate");
            entry.set("noninexchangedate", (Object)exchangeDate);
            DynamicObject stdCurrency = (DynamicObject)dataModel.getValue("currency");
            BigDecimal exchangeRate = CurrencyHelper.getExChangeRate((Long)currency.getLong("id"), (Long)stdCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)exchangeDate);
            BigDecimal inPeriodPlanAmtStd = AmountCurrencyUtils.amount2StdAmount((BigDecimal)entry.getBigDecimal("noninperiodplanamt"), (BigDecimal)exchangeRate, (DynamicObject)stdCurrency);
            entry.set("noninperiodplanamtstd", (Object)inPeriodPlanAmtStd);
            entry.set("nondescription", (Object)importData.getString("nondescription"));
        });
        return inContractPlanEntries;
    }
}

