/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.pmgt.pmbs.common.excel.CommonImportAndExport;
import org.apache.commons.collections.CollectionUtils;

public class MonthlyFundPlanExcelSupport
extends CommonImportAndExport {
    public Map<String, List<String>> templateColumnMap = new HashMap<String, List<String>>();
    public Map<String, List<String>> exportExcludeDataColumnMap = new HashMap<String, List<String>>();

    public void initExcelColumn() {
        this.templateColumnMap.put("incontractplanentity", Arrays.asList("incontract", "inperiodplanamt", "incontractdescription"));
        this.templateColumnMap.put("outcontractplanentity", Arrays.asList("outcontract", "outperiodplanamt", "outcontractdescription"));
        this.templateColumnMap.put("innoncontractplanentity", Arrays.asList("nonincomeitem", "innoncurrency", "noninexratetable", "noninexchangedate", "noninperiodplanamt", "nonincompanyname", "nondescription"));
        this.templateColumnMap.put("outnoncontractplanentity", Arrays.asList("nonoutcomeitem", "outnoncurrency", "nonoutexratetable", "nonoutexchangedate", "nonoutperiodplanamt", "nonoutcompanyname", "nonoutdescription"));
        this.exportExcludeDataColumnMap.put("incontractplanentity", Arrays.asList("incontractperiod", "incurrency", "inexchangerate"));
        this.exportExcludeDataColumnMap.put("outcontractplanentity", Arrays.asList("outcontractperiod", "outcurrency", "outexchangerate"));
    }

    public ExportWriterFormat loadExportFormat() {
        boolean exportData;
        this.initExcelColumn();
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(this.getEntityNumber(), 0L, null, null);
        List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        ExportWriterFormat format = (ExportWriterFormat)formats.get(0);
        ExportWriterFormat entryFormat = null;
        for (ExportWriterFormat format1 : format.next) {
            if (!format1.name.equals(this.getEntryKey())) continue;
            if (StringUtils.equals((CharSequence)this.getEntryKey(), (CharSequence)"incontractplanentity")) {
                format1.next.clear();
            }
            entryFormat = format1;
            break;
        }
        boolean bl = exportData = this.params.get("isExportData") != null && (Boolean)this.params.get("isExportData") != false;
        if (entryFormat != null) {
            if (exportData) {
                List<String> excludeCol = this.exportExcludeDataColumnMap.get(entryFormat.name);
                if (!CollectionUtils.isEmpty(excludeCol)) {
                    for (String column : excludeCol) {
                        entryFormat.fields.remove(column);
                    }
                }
            } else {
                List<String> columns = this.templateColumnMap.get(entryFormat.name);
                entryFormat.fields.retainAll(columns);
            }
        }
        return entryFormat;
    }

    public String genDataExportFileName(LocalDate now) {
        boolean exportData = this.params.get("isExportData") != null && (Boolean)this.params.get("isExportData") != false;
        String fileName = exportData ? ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_", (String)"MonthlyFundPlanExcelSupport_0", (String)"pmgt-pmct-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"MonthlyFundPlanExcelSupport_1", (String)"pmgt-pmct-business", (Object[])new Object[0]);
        fileName = fileName + this.formator.displayName;
        fileName = fileName + String.format("_%02d%02d", now.getMonthValue(), now.getDayOfMonth());
        return fileName.replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "").replaceAll(" ", "_");
    }
}

