/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class MultiSettleAmtService {
    public BigDecimal getMultiTotalSettleOfTaxAmt(DynamicObject org, DynamicObject project, DynamicObject contract) {
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        orgFilter.and(billStatusFilter).and(contractFilter);
        if (project != null) {
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            orgFilter.and(projectFilter);
        }
        DynamicObject[] contractSettleBills = BusinessDataServiceHelper.load((String)"pmct_outcontract_settle", (String)String.join((CharSequence)",", "id", "settleoftaxamount"), (QFilter[])new QFilter[]{orgFilter});
        return Arrays.stream(contractSettleBills).map(bill -> bill.getBigDecimal("settleoftaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getMultiTotalApplyOfTaxAmount(DynamicObject org, DynamicObject project, DynamicObject contract) {
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        orgFilter.and(billStatusFilter).and(contractFilter);
        if (project != null) {
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            orgFilter.and(projectFilter);
        }
        DynamicObject[] applyPaymentBills = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)String.join((CharSequence)",", "id", "curpaytotal"), (QFilter[])new QFilter[]{orgFilter});
        BigDecimal applyPayTotal = Arrays.stream(applyPaymentBills).map(bill -> bill.getBigDecimal("curpaytotal")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        orgFilter = new QFilter("org", "=", org.getPkValue());
        contractFilter = new QFilter("entryentity.entrycontract", "=", contract.getPkValue());
        billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        orgFilter.and(billStatusFilter).and(contractFilter);
        if (project != null) {
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            orgFilter.and(projectFilter);
        }
        DynamicObject[] paymentApplyBills = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)String.join((CharSequence)",", "id", "entryentity.entrycontract", "entryentity.applyoftaxamount"), (QFilter[])new QFilter[]{orgFilter});
        BigDecimal applymentApplyPayTotal = Arrays.stream(paymentApplyBills).map(bill -> bill.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).filter(entity -> StringUtils.equals((CharSequence)contract.getPkValue().toString(), (CharSequence)entity.getDynamicObject("entrycontract").getPkValue().toString())).map(entity -> entity.getBigDecimal("applyoftaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        return applyPayTotal.add(applymentApplyPayTotal);
    }

    public BigDecimal getMultiTotalPayOfTaxAmt(DynamicObject org, DynamicObject project, DynamicObject contract) {
        DynamicObject[] outcomeRegisters;
        BigDecimal totalRealOfTaxAmount = BigDecimal.ZERO;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("entryentity.entrycontract.id", "=", contract.getPkValue()));
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        filterList.add(new QFilter("org", "=", org.getPkValue()));
        if (project != null) {
            filterList.add(new QFilter("project", "=", project.getPkValue()));
        }
        QFilter[] qFilters = new QFilter[filterList.size()];
        DynamicObject contPartB = contract.getDynamicObject("partb");
        if (contract.getBoolean("ismulticontract")) {
            filterList.add(new QFilter("entryentity.contpartb", "=", contPartB != null ? contPartB.getPkValue() : null));
        }
        for (DynamicObject incomeRegister : outcomeRegisters = BusinessDataServiceHelper.load((String)"pmct_paymentregister", (String)"thispaymentoftaxamount,entryentity.entrycontract,entryentity.contpartb", (QFilter[])filterList.toArray(qFilters))) {
            DynamicObjectCollection incomeEntries = incomeRegister.getDynamicObjectCollection("entryentity");
            for (DynamicObject incomeEntry : incomeEntries) {
                DynamicObject entryContract = incomeEntry.getDynamicObject("entrycontract");
                DynamicObject entryContPartB = incomeEntry.getDynamicObject("contpartb");
                BigDecimal settleBigDecimal = BigDecimal.ZERO;
                if (contract.getPkValue().equals(entryContract.getPkValue())) {
                    if (!contract.getBoolean("ismulticontract")) {
                        settleBigDecimal = incomeEntry.getBigDecimal("thispaymentoftaxamount");
                    } else if (contPartB != null && entryContPartB != null && contPartB.getPkValue().equals(entryContPartB.getPkValue())) {
                        settleBigDecimal = incomeEntry.getBigDecimal("thispaymentoftaxamount");
                    }
                }
                totalRealOfTaxAmount = totalRealOfTaxAmount.add(settleBigDecimal);
            }
        }
        return totalRealOfTaxAmount;
    }

    public BigDecimal getTotalRealOfTaxAmount(DynamicObject org, DynamicObject project, DynamicObject contract) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilters.add(new QFilter("org", "=", org.getPkValue()));
        if (null != project) {
            qFilters.add(new QFilter("project", "=", project.getPkValue()));
        }
        qFilters.add(new QFilter("entryentity.entrycontract", "=", contract.getPkValue()));
        DynamicObject[] incomeRegisters = BusinessDataServiceHelper.load((String)"pmct_incomeregister", (String)"entryentity, entryentity.entrycontract, entryentity.receiptoftaxamount", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal totalRealOfTaxAmt = BigDecimal.ZERO;
        for (DynamicObject incomeRegister : incomeRegisters) {
            DynamicObjectCollection entryColl = incomeRegister.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryColl) {
                if (entry.getDynamicObject("entrycontract").getLong("id") != contract.getLong("id")) continue;
                totalRealOfTaxAmt = totalRealOfTaxAmt.add(entry.getBigDecimal("receiptoftaxamount"));
            }
        }
        return totalRealOfTaxAmt;
    }

    public BigDecimal getIncomeApplyTaxAmtSum(DynamicObject org, DynamicObject project, DynamicObject period, DynamicObject contract) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilters.add(new QFilter("period", "=", period.getPkValue()));
        qFilters.add(new QFilter("entryentity.entrycontract", "=", contract.getPkValue()));
        if (null != org) {
            qFilters.add(new QFilter("org", "=", org.getPkValue()));
        }
        if (null != project) {
            qFilters.add(new QFilter("project", "=", project.getPkValue()));
        }
        DynamicObject[] incomeApplys = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)"entryentity, entryentity.entrycontract, entryentity.applyoftaxamount", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal applyTaxAmtSum = BigDecimal.ZERO;
        for (DynamicObject incomeApply : incomeApplys) {
            DynamicObjectCollection incomeApplyEntryColl = incomeApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject incomeApplyEntry : incomeApplyEntryColl) {
                if (contract == null || incomeApplyEntry.getDynamicObject("entrycontract").getLong("id") != contract.getLong("id")) continue;
                applyTaxAmtSum = applyTaxAmtSum.add(incomeApplyEntry.getBigDecimal("applyoftaxamount"));
            }
        }
        return applyTaxAmtSum;
    }

    public BigDecimal getMultiSettleAmount(DynamicObject org, DynamicObject project, DynamicObject contract, DynamicObject period, DynamicObject supplier) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter("org", "=", org.getPkValue()));
        filterList.add(new QFilter("contract", "=", contract.getPkValue()));
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        filterList.add(new QFilter("period.enddate", "<=", (Object)period.getDate("enddate")));
        if (contract.getBoolean("ismulticontract") && supplier != null) {
            filterList.add(new QFilter("contpartb", "=", supplier.getPkValue()));
        }
        if (project != null) {
            filterList.add(new QFilter("project", "=", project.getPkValue()));
        }
        DynamicObject[] contractSettleBills = BusinessDataServiceHelper.load((String)"pmct_outcontract_settle", (String)String.join((CharSequence)",", "id", "settleoftaxamount"), (QFilter[])filterList.toArray(new QFilter[filterList.size()]));
        return Arrays.stream(contractSettleBills).map(bill -> bill.getBigDecimal("settleoftaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getMultiPayAmount(DynamicObject org, DynamicObject project, DynamicObject contract, DynamicObject period, DynamicObject supplier) {
        DynamicObject[] outcomeRegisters;
        BigDecimal amount = BigDecimal.ZERO;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter("entryentity.entrycontract.id", "=", contract.getPkValue()));
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        filterList.add(new QFilter("org", "=", org.getPkValue()));
        filterList.add(new QFilter("period.enddate", "<=", (Object)period.getDate("enddate")));
        if (contract.getBoolean("ismulticontract") && supplier != null) {
            filterList.add(new QFilter("entryentity.contpartb", "=", supplier.getPkValue()));
        }
        if (project != null) {
            filterList.add(new QFilter("entryentity.contpro", "=", project.getPkValue()));
        }
        for (DynamicObject outcomeRegister : outcomeRegisters = BusinessDataServiceHelper.load((String)"pmct_paymentregister", (String)"thispaymentoftaxamount,entryentity.entrycontract,entryentity.contpartb,entryentity.contpro", (QFilter[])filterList.toArray(new QFilter[filterList.size()]))) {
            DynamicObjectCollection outcomeEntries = outcomeRegister.getDynamicObjectCollection("entryentity");
            for (DynamicObject outcomeEntry : outcomeEntries) {
                DynamicObject entryContract = outcomeEntry.getDynamicObject("entrycontract");
                DynamicObject entryContPro = outcomeEntry.getDynamicObject("contpro");
                DynamicObject entryContPartB = outcomeEntry.getDynamicObject("contpartb");
                BigDecimal entryAmount = BigDecimal.ZERO;
                if (contract != null && entryContract != null && contract.getPkValue().equals(entryContract.getPkValue()) && (project == null && entryContPro == null || project != null && entryContPro != null && project.getPkValue().equals(entryContPro.getPkValue()))) {
                    if (!contract.getBoolean("ismulticontract")) {
                        entryAmount = outcomeEntry.getBigDecimal("thispaymentoftaxamount");
                    } else if (supplier != null && entryContPartB != null && supplier.getPkValue().equals(entryContPartB.getPkValue())) {
                        entryAmount = outcomeEntry.getBigDecimal("thispaymentoftaxamount");
                    }
                }
                amount = amount.add(entryAmount);
            }
        }
        return amount;
    }

    public BigDecimal getMultiPayApplyAmount(DynamicObject org, DynamicObject project, DynamicObject contract, DynamicObject period, DynamicObject supplier) {
        DynamicObject[] payApplySingles;
        DynamicObject[] payApplys;
        BigDecimal amount = BigDecimal.ZERO;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter("entryentity.entrycontract.id", "=", contract.getPkValue()));
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        filterList.add(new QFilter("org", "=", org.getPkValue()));
        filterList.add(new QFilter("period", "=", period.getPkValue()));
        if (contract.getBoolean("ismulticontract") && supplier != null) {
            filterList.add(new QFilter("entryentity.contpartb", "=", supplier.getPkValue()));
        }
        if (project != null) {
            filterList.add(new QFilter("entryentity.contpro.id", "=", project.getPkValue()));
        }
        QFilter[] qFilters = new QFilter[filterList.size()];
        for (DynamicObject payApply : payApplys = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"applyoftaxamount,entryentity.entrycontract,entryentity.contpartb,entryentity.contpro", (QFilter[])filterList.toArray(qFilters))) {
            DynamicObjectCollection entries = payApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject entryContract = entry.getDynamicObject("entrycontract");
                DynamicObject entryContPro = entry.getDynamicObject("contpro");
                DynamicObject entryContPartB = entry.getDynamicObject("contpartb");
                BigDecimal entryAmount = BigDecimal.ZERO;
                if (contract != null && entryContract != null && contract.getPkValue().equals(entryContract.getPkValue()) && (project == null && entryContPro == null || project != null && entryContPro != null && project.getPkValue().equals(entryContPro.getPkValue()))) {
                    if (!contract.getBoolean("ismulticontract")) {
                        entryAmount = entry.getBigDecimal("applyoftaxamount");
                    } else if (supplier != null && entryContPartB != null && supplier.getPkValue().equals(entryContPartB.getPkValue())) {
                        entryAmount = entry.getBigDecimal("applyoftaxamount");
                    }
                }
                amount = amount.add(entryAmount);
            }
        }
        filterList.clear();
        filterList.add(new QFilter("contract", "=", contract.getPkValue()));
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        filterList.add(new QFilter("org", "=", org.getPkValue()));
        filterList.add(new QFilter("period", "=", period.getPkValue()));
        if (project != null) {
            filterList.add(new QFilter("project", "=", project.getPkValue()));
        }
        if (contract.getBoolean("ismulticontract") && supplier != null) {
            filterList.add(new QFilter("supplier", "=", supplier.getPkValue()));
        }
        qFilters = new QFilter[filterList.size()];
        for (DynamicObject payApplySingle : payApplySingles = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"contract,supplier,paydetailentry,curpayamtoftax", (QFilter[])filterList.toArray(qFilters))) {
            DynamicObjectCollection entries = payApplySingle.getDynamicObjectCollection("paydetailentry");
            for (DynamicObject entry : entries) {
                BigDecimal entryAmount = entry.getBigDecimal("curpayamtoftax");
                amount = amount.add(entryAmount);
            }
        }
        return amount;
    }

    public BigDecimal getMultiIncomeAmount(DynamicObject org, DynamicObject project, DynamicObject contract, DynamicObject period) {
        DynamicObject[] incomeRegisters;
        BigDecimal amount = BigDecimal.ZERO;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("entryentity.entrycontract.id", "=", contract.getPkValue()));
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        filterList.add(new QFilter("org", "=", org.getPkValue()));
        filterList.add(new QFilter("period.enddate", "<=", (Object)period.getDate("enddate")));
        if (null != project) {
            filterList.add(new QFilter("project", "=", project.getPkValue()));
        }
        for (DynamicObject incomeRegister : incomeRegisters = BusinessDataServiceHelper.load((String)"pmct_incomeregister", (String)"entryentity, entryentity.entrycontract, entryentity.receiptoftaxamount,entryentity.contpro", (QFilter[])filterList.toArray(new QFilter[0]))) {
            DynamicObjectCollection entryColl = incomeRegister.getDynamicObjectCollection("entryentity");
            for (DynamicObject inComeEntry : entryColl) {
                DynamicObject entryContract = inComeEntry.getDynamicObject("entrycontract");
                DynamicObject entryContPro = inComeEntry.getDynamicObject("contpro");
                if (contract == null || entryContract == null || !contract.getPkValue().equals(entryContract.getPkValue()) || (project != null || entryContPro != null) && (project == null || entryContPro == null || !project.getPkValue().equals(entryContPro.getPkValue()))) continue;
                amount = amount.add(inComeEntry.getBigDecimal("receiptoftaxamount"));
            }
        }
        return amount;
    }

    public BigDecimal getMultiIncomeApplyAmount(DynamicObject org, DynamicObject project, DynamicObject contract, DynamicObject period) {
        DynamicObject[] incomeApplys;
        BigDecimal amount = BigDecimal.ZERO;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter("entryentity.entrycontract", "=", contract.getPkValue()));
        filterList.add(new QFilter("billstatus", "=", (Object)"C"));
        filterList.add(new QFilter("org", "=", org.getPkValue()));
        filterList.add(new QFilter("period", "=", period.getPkValue()));
        if (null != project) {
            filterList.add(new QFilter("entryentity.contpro", "=", project.getPkValue()));
        }
        for (DynamicObject incomeApply : incomeApplys = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)"entryentity, entryentity.entrycontract,entryentity.contpro, entryentity.applyoftaxamount", (QFilter[])filterList.toArray(new QFilter[0]))) {
            DynamicObjectCollection incomeApplyEntryColl = incomeApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject incomeApplyEntry : incomeApplyEntryColl) {
                DynamicObject entryContract = incomeApplyEntry.getDynamicObject("entrycontract");
                DynamicObject entryContPro = incomeApplyEntry.getDynamicObject("contpro");
                if (contract == null || entryContract == null || !contract.getPkValue().equals(entryContract.getPkValue()) || (project != null || entryContPro != null) && (project == null || entryContPro == null || !project.getPkValue().equals(entryContPro.getPkValue()))) continue;
                amount = amount.add(incomeApplyEntry.getBigDecimal("applyoftaxamount"));
            }
        }
        return amount;
    }
}

