/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmct.business.manage.AbstractFundPlanningService;
import kd.pmgt.pmct.business.manage.ContractSelectSupport;
import kd.pmgt.pmct.business.manage.FundPlanPayItemService;
import kd.pmgt.pmct.business.manage.IContractFundPlanningService;
import kd.pmgt.pmct.common.enums.FundPlanningStatisticsEnum;
import kd.pmgt.pmct.common.utils.AmountCurrencyUtils;

public class OutContractFundPlanningService
extends AbstractFundPlanningService
implements IContractFundPlanningService {
    private static final Log logger = LogFactory.getLog(OutContractFundPlanningService.class);
    private FundPlanPayItemService fundPlanPayItemService = new FundPlanPayItemService();
    private ContractSelectSupport contractSelectSupport = new ContractSelectSupport();

    @Override
    public List<ComboItem> initStaticDimensions() {
        List<FundPlanningStatisticsEnum> dimensionEnums = Arrays.asList(FundPlanningStatisticsEnum.PARTB, FundPlanningStatisticsEnum.ORG, FundPlanningStatisticsEnum.PROJECT, FundPlanningStatisticsEnum.CONTRACTTYPE);
        return dimensionEnums.stream().map(dimensionEnum -> new ComboItem(new LocaleString(dimensionEnum.getName()), dimensionEnum.getValue())).collect(Collectors.toList());
    }

    @Override
    public List<ItemValue> getChartData(IDataModel dataModel, String entryProp) {
        String dimension = this.getDimension(dataModel);
        List<Object> itemValues = new ArrayList<ItemValue>();
        String targetPlanAmtStd = "outperiodplanamtstd";
        DynamicObjectCollection contracts = dataModel.getEntryEntity("outcontractplanentity");
        if (contracts.isEmpty()) {
            itemValues.add(new ItemValue("", (Number)0));
            return itemValues;
        }
        Map<Long, List<DynamicObject>> chartDataMap = contracts.stream().filter(contract -> contract.getDynamicObject(entryProp) != null).collect(Collectors.groupingBy(contract -> Long.parseLong(contract.getDynamicObject(entryProp).getPkValue().toString())));
        itemValues = chartDataMap.values().stream().map(dynamicObjects -> {
            String itemName = ((DynamicObject)dynamicObjects.get(0)).getDynamicObject(entryProp).getString(this.getDimensionNameFormId(dimension));
            BigDecimal totalPeriodAmt = dynamicObjects.stream().map(it -> it.getBigDecimal(targetPlanAmtStd)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            return new ItemValue(itemName, (Number)totalPeriodAmt);
        }).sorted(Comparator.comparing(o -> (BigDecimal)o.getValue())).collect(Collectors.toList());
        Collections.reverse(itemValues);
        return itemValues;
    }

    @Override
    public String dimension2EntryProp(IDataModel dataModel) {
        String entryProp = null;
        String dimension = this.getDimension(dataModel);
        DynamicObjectCollection contractEntity = dataModel.getEntryEntity("outcontractplanentity");
        FundPlanningStatisticsEnum statisticsEnum = FundPlanningStatisticsEnum.getEnumByValue((String)dimension);
        switch (statisticsEnum) {
            case PARTB: {
                entryProp = "partb";
                break;
            }
            case ORG: {
                entryProp = "outorg";
                break;
            }
            case PROJECT: {
                boolean noProject = contractEntity.stream().map(it -> it.getDynamicObject("outproject")).anyMatch(Objects::isNull);
                if (noProject) break;
                entryProp = "outproject";
                break;
            }
            case CONTRACTTYPE: {
                entryProp = "outcontracttype";
                break;
            }
        }
        return entryProp;
    }

    private String getDimension(IDataModel dataModel) {
        Object dimension = dataModel.getValue("dimension");
        if (dimension == null) {
            dataModel.setValue("dimension", (Object)FundPlanningStatisticsEnum.PARTB.getValue());
        }
        return dataModel.getValue("dimension").toString();
    }

    @Override
    public ListShowParameter showContractListView(IFormView formView, IDataModel dataModel, CloseCallBack closeCallBack) {
        QFilter contractFilter;
        Set<Long> excludeContractPks = this.getSelectedContractPks(dataModel);
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmct_outcontractf7", (boolean)true);
        listShowParameter.setCloseCallBack(closeCallBack);
        QFilter excludePkFilter = new QFilter("id", "not in", excludeContractPks);
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)dataModel.getDataEntityType().getAppId());
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)"pmct_monthlyfundplan", (String)"47150e89000000ac");
        if (hasPermOrgs.hasAllOrgPerm() && CollectionUtils.isEmpty((Collection)hasPermOrgs.getHasPermOrgs())) {
            contractFilter = this.contractSelectSupport.getContractFilterForAllOrgPerm(formView.getEntityId(), PayDirectionEnum.OUT);
        } else {
            List orgPks = hasPermOrgs.getHasPermOrgs();
            logger.info("userId:{}, OutContractFundPlanningService#hasPermPrgList:{}", (Object)userId, (Object)orgPks);
            contractFilter = this.contractSelectSupport.getContractFilter(formView.getEntityId(), "outselectcontract", PayDirectionEnum.OUT, orgPks, (DynamicObject)dataModel.getValue("project"));
        }
        contractFilter.and(excludePkFilter);
        logger.info("userId:{}, OutContractFundPlanningService#showContractListView contractFilter:{}", (Object)userId, (Object)contractFilter);
        listShowParameter.getListFilterParameter().getQFilters().add(contractFilter);
        return listShowParameter;
    }

    @Override
    public Set<Long> getSelectedContractPks(IDataModel dataModel) {
        return dataModel.getEntryEntity("outcontractplanentity").stream().map(entry -> entry.getDynamicObject("outcontract")).map(DataEntityBase::getPkValue).map(pk -> Long.parseLong(pk.toString())).collect(Collectors.toSet());
    }

    @Override
    public String getReturnData(IDataModel dataModel) {
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_monthlyfundplan")).getDynamicObjectCollection("outcontractplanentity").getDynamicObjectType();
        DynamicObjectCollection entryContract = dataModel.getEntryEntity("outcontractplanentity");
        return DynamicObjectSerializeUtil.serialize((Object[])entryContract.toArray(), (DynamicObjectType)dt);
    }

    private String switchPlanningType(String planningType) {
        switch (planningType) {
            case "invoice": {
                planningType = "outinvoicednonpay";
                break;
            }
            case "settle": {
                planningType = "outsettlednonpay";
                break;
            }
        }
        return planningType;
    }

    @Override
    public void doFundPlanning(BigDecimal distributedAmt, int[] selectRows, IDataModel dataModel) {
        String planningType = this.switchPlanningType(dataModel.getValue("radiogroupfield").toString());
        for (int selectRow : selectRows) {
            BigDecimal periodPlanAmtStd;
            BigDecimal periodPlanEntryAmt;
            DynamicObjectCollection payItemEntities;
            DynamicObject rowEntity = dataModel.getEntryRowEntity("outcontractplanentity", selectRow);
            BigDecimal needPlanAmt = this.getNeedPlanAmt(planningType, rowEntity, payItemEntities = dataModel.getEntryEntity("payitementry"));
            BigDecimal restAmt = distributedAmt.subtract(needPlanAmt);
            if (restAmt.compareTo(BigDecimal.ZERO) >= 0) {
                periodPlanEntryAmt = needPlanAmt;
                periodPlanAmtStd = AmountCurrencyUtils.amount2StdAmount((BigDecimal)periodPlanEntryAmt, (BigDecimal)rowEntity.getBigDecimal("outexchangerate"), (DynamicObject)((DynamicObject)dataModel.getValue("stdcurrency")));
                rowEntity.set("outperiodplanamt", (Object)periodPlanEntryAmt);
                rowEntity.set("outperiodplanamtstd", (Object)periodPlanAmtStd);
                distributedAmt = restAmt;
                continue;
            }
            periodPlanEntryAmt = distributedAmt;
            periodPlanAmtStd = AmountCurrencyUtils.amount2StdAmount((BigDecimal)periodPlanEntryAmt, (BigDecimal)rowEntity.getBigDecimal("outexchangerate"), (DynamicObject)((DynamicObject)dataModel.getValue("outcurrency")));
            rowEntity.set("outperiodplanamt", (Object)periodPlanEntryAmt);
            rowEntity.set("outperiodplanamtstd", (Object)periodPlanAmtStd);
            distributedAmt = BigDecimal.ZERO;
        }
    }

    private BigDecimal getNeedPlanAmt(String planningType, DynamicObject rowEntity, DynamicObjectCollection payItemEntities) {
        BigDecimal needPlanAmt = BigDecimal.ZERO;
        switch (planningType) {
            case "outinvoicednonpay": 
            case "outsettlednonpay": {
                needPlanAmt = rowEntity.getBigDecimal(planningType);
                break;
            }
            case "payitem": {
                DynamicObject outContract = rowEntity.getDynamicObject("outcontract");
                this.fundPlanPayItemService.loadPayItemEntry(outContract, payItemEntities);
                needPlanAmt = payItemEntities.stream().filter(payItem -> {
                    Date planPayTime = payItem.getDate("planpaytime");
                    SimpleDateFormat yearAndMonthFormat = new SimpleDateFormat("yyyy-MM");
                    return planPayTime == null || yearAndMonthFormat.format(planPayTime).compareTo(yearAndMonthFormat.format(new Date())) <= 0;
                }).map(payItem -> payItem.getBigDecimal("unpaidamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                break;
            }
        }
        return needPlanAmt;
    }

    @Override
    public BigDecimal calculatePeriodPlanAmt(IDataModel dataModel) {
        return dataModel.getEntryEntity("outcontractplanentity").stream().map(it -> it.getBigDecimal("outperiodplanamtstd")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    @Override
    public BigDecimal calculateNonContractPeriodPlanAmt(IDataModel dataModel) {
        return dataModel.getEntryEntity("outnoncontractplanentity").stream().map(it -> it.getBigDecimal("nonoutperiodplanamtstd")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    @Override
    public void loadPayItemEntry(IFormView formView, int clickRowIndex) {
        IDataModel dataModel = formView.getModel();
        DynamicObject clickContract = dataModel.getEntryRowEntity("outcontractplanentity", clickRowIndex);
        Object contractPk = clickContract.getDynamicObject("outcontract").getPkValue();
        QFilter contractFilter = new QFilter("contract", "=", contractPk);
        DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"paytype,payfeq,payway,paypercent,payamount,planpaytime,remarks,reimbursedamt,paidamt,currency,reimbursedcomamt,reimbursableamt,paidcomamt,unpaidamt,source,remarks,nodesettingsource,nodesetting,ctrlstrategy,appliedamt,appliedcomamt,appliableamt", (QFilter[])new QFilter[]{contractFilter});
        DynamicObjectCollection payItemEntryEntity = dataModel.getEntryEntity("payitementry");
        DynamicObjectType payItemEntryDT = payItemEntryEntity.getDynamicObjectType();
        Map payItemsCompleteStateMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])payItems);
        Map completeStateMap = (Map)payItemsCompleteStateMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject payItem : payItems) {
            DynamicObject payItemEntry = new DynamicObject(payItemEntryDT);
            payItemEntry.set("payitem", (Object)payItem);
            payItemEntry.set("out_appliedamt", (Object)payItem.getBigDecimal("appliedamt"));
            payItemEntry.set("out_appliedcomamt", (Object)payItem.getBigDecimal("appliedcomamt"));
            payItemEntry.set("out_appliableamt", (Object)payItem.getBigDecimal("appliableamt"));
            if (null != completeStateMap && null != payItem.get("nodesetting")) {
                Object taskId = payItem.getDynamicObject("nodesetting").getPkValue();
                payItemEntry.set("out_taskcompletestatus", completeStateMap.get(taskId));
            }
            payItemEntry.set("outconplanentry", contractPk);
            payItemEntry.set("paytype", (Object)payItem.getString("paytype"));
            payItemEntry.set("itemcurrency", (Object)payItem.getDynamicObject("currency"));
            payItemEntry.set("payfeq", (Object)payItem.getString("payfeq"));
            payItemEntry.set("payway", payItem.get("payway"));
            payItemEntry.set("paypercent", payItem.get("paypercent"));
            payItemEntry.set("payamountoftax", payItem.get("payamount"));
            payItemEntry.set("planpaytime", payItem.get("planpaytime"));
            payItemEntry.set("reimbursedamt", payItem.get("reimbursedamt"));
            payItemEntry.set("reimbursedcomamt", payItem.get("reimbursedcomamt"));
            payItemEntry.set("reimbursableamt", payItem.get("reimbursableamt"));
            payItemEntry.set("paidamt", payItem.get("paidamt"));
            payItemEntry.set("paidcomamt", payItem.get("paidcomamt"));
            payItemEntry.set("unpaidamt", payItem.get("unpaidamt"));
            payItemEntry.set("source", payItem.get("source"));
            payItemEntry.set("remarks", payItem.get("remarks"));
            payItemEntryEntity.add((Object)payItemEntry);
        }
        dataModel.updateEntryCache(payItemEntryEntity);
        formView.updateView("payitementry");
    }
}

