/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.pmct.ContractMultiTypeEnum;

public class PrePayService {
    public BigDecimal getPrePayAmount(DynamicObject contract, Object projectId, Object orgId) {
        DynamicObject[] paymentApplies;
        boolean separatePay;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(5);
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        filterList.add(new QFilter("entryentity.entrycontract", "=", contract.getPkValue()));
        filterList.add(new QFilter("entryentity.paymenttype", "=", (Object)ContractPayTypeEnum.PREPAYMENT.getValue()));
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        boolean bl = separatePay = multiPartSettlement && StringUtils.equals((CharSequence)contract.getString("multipaytype"), (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue());
        if (separatePay) {
            if (projectId != null) {
                filterList.add(new QFilter("entryentity.contpro", "=", projectId));
            }
            filterList.add(new QFilter("org", "=", orgId));
        }
        BigDecimal prePayAmount = BigDecimal.ZERO;
        for (DynamicObject paymentApply : paymentApplies = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"entryentity.entrycontract,entryentity.contpro,entryentity.paymenttype,entryentity.entrypaidamount", (QFilter[])filterList.toArray(new QFilter[filterList.size()]))) {
            DynamicObjectCollection entries = paymentApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject contPro = entry.getDynamicObject("contpro");
                if (!entry.getDynamicObject("entrycontract").getPkValue().equals(contract.getPkValue()) || !StringUtils.equals((CharSequence)entry.getString("paymenttype"), (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue()) || separatePay && projectId != null && (contPro == null || !contPro.getPkValue().equals(projectId))) continue;
                prePayAmount = prePayAmount.add(entry.getBigDecimal("entrypaidamount"));
            }
        }
        return prePayAmount;
    }

    public BigDecimal getPrePayDeductionAmount(DynamicObject contract, Object projectId, Object orgId, Boolean includeSubmit) {
        DynamicObject[] paymentApplies;
        boolean separatePay;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(5);
        if (includeSubmit.booleanValue()) {
            filterList.add(new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()}));
        } else {
            filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        }
        filterList.add(new QFilter("entryentity.entrycontract", "=", contract.getPkValue()));
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        boolean bl = separatePay = multiPartSettlement && StringUtils.equals((CharSequence)contract.getString("multipaytype"), (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue());
        if (separatePay) {
            if (projectId != null) {
                filterList.add(new QFilter("entryentity.contpro", "=", projectId));
            }
            filterList.add(new QFilter("org", "=", orgId));
        }
        BigDecimal thisPrePayDeductionAmount = BigDecimal.ZERO;
        for (DynamicObject paymentApply : paymentApplies = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"entryentity.entrycontract,entryentity.contpro,entryentity.thisprepaydeduction", (QFilter[])filterList.toArray(new QFilter[filterList.size()]))) {
            DynamicObjectCollection entries = paymentApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject contPro = entry.getDynamicObject("contpro");
                if (!entry.getDynamicObject("entrycontract").getPkValue().equals(contract.getPkValue()) || separatePay && projectId != null && (contPro == null || !contPro.getPkValue().equals(projectId))) continue;
                thisPrePayDeductionAmount = thisPrePayDeductionAmount.add(entry.getBigDecimal("thisprepaydeduction"));
            }
        }
        return thisPrePayDeductionAmount;
    }

    public List<Map<String, Object>> getDeductionDetailDataList(DynamicObject contract, Object projectId, Object orgId) {
        boolean separatePay;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(5);
        filterList.add(new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()}));
        filterList.add(new QFilter("entryentity.entrycontract", "=", contract.getPkValue()));
        filterList.add(new QFilter("entryentity.thisprepaydeduction", "!=", (Object)BigDecimal.ZERO));
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        boolean bl = separatePay = multiPartSettlement && StringUtils.equals((CharSequence)contract.getString("multipaytype"), (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue());
        if (separatePay) {
            if (projectId != null) {
                filterList.add(new QFilter("entryentity.contpro", "=", projectId));
            }
            filterList.add(new QFilter("org", "=", orgId));
        }
        DynamicObject[] paymentApplies = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"billno,period,billstatus,entryentity.entrycontract,entryentity.contpro,entryentity.paymenttype,entryentity.applyoftaxamount,entryentity.thisprepaydeduction,entryentity.thispayableamount,entryentity.thispaymentoftaxamount", (QFilter[])filterList.toArray(new QFilter[0]));
        ArrayList<Map<String, Object>> deductionDetailDataList = new ArrayList<Map<String, Object>>(paymentApplies.length);
        for (DynamicObject paymentApply : paymentApplies) {
            DynamicObjectCollection entries = paymentApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject contPro = entry.getDynamicObject("contpro");
                if (!entry.getDynamicObject("entrycontract").getPkValue().equals(contract.getPkValue()) || entry.getBigDecimal("thisprepaydeduction").compareTo(BigDecimal.ZERO) == 0 || separatePay && projectId != null && (contPro == null || !contPro.getPkValue().equals(projectId))) continue;
                HashMap<String, Object> deductionDetailData = new HashMap<String, Object>(16);
                deductionDetailData.put("paymenttype", entry.getString("paymenttype"));
                deductionDetailData.put("period", paymentApply.getDynamicObject("period"));
                deductionDetailData.put("applyamount", entry.getBigDecimal("applyoftaxamount"));
                deductionDetailData.put("deductionamount", entry.getBigDecimal("thisprepaydeduction"));
                deductionDetailData.put("payableamount", entry.getBigDecimal("thispayableamount"));
                deductionDetailData.put("billno", paymentApply.getString("billno"));
                deductionDetailData.put("billstatus", paymentApply.getString("billstatus"));
                deductionDetailDataList.add(deductionDetailData);
            }
        }
        return deductionDetailDataList;
    }

    public BigDecimal getPayAbleAmount(DynamicObject contract) {
        DynamicObject[] paymentApplies;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        filterList.add(new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()}));
        filterList.add(new QFilter("entryentity.entrycontract", "=", contract.getPkValue()));
        BigDecimal payAbleAmount = BigDecimal.ZERO;
        for (DynamicObject paymentApply : paymentApplies = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"entryentity.entrycontract,entryentity.contpro,entryentity.thispayableamount", (QFilter[])filterList.toArray(new QFilter[filterList.size()]))) {
            DynamicObjectCollection entries = paymentApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                if (!entry.getDynamicObject("entrycontract").getPkValue().equals(contract.getPkValue())) continue;
                payAbleAmount = payAbleAmount.add(entry.getBigDecimal("thispayableamount"));
            }
        }
        QFilter qFilter = new QFilter("contract", "=", (Object)Long.parseLong(contract.getPkValue().toString()));
        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        paymentApplies = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"curpaytotal", (QFilter[])new QFilter[]{qFilter});
        if (paymentApplies.length > 0) {
            for (DynamicObject paymentApply : paymentApplies) {
                payAbleAmount = payAbleAmount.add(paymentApply.getBigDecimal("curpaytotal"));
            }
        }
        return payAbleAmount;
    }

    public BigDecimal getThisDeductionAmountByContract(DynamicObject contract, Object projectId, DynamicObjectCollection contractEntries) {
        BigDecimal deductionAmountByContract = BigDecimal.ZERO;
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        boolean separatePay = multiPartSettlement && StringUtils.equals((CharSequence)contract.getString("multipaytype"), (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue());
        for (DynamicObject contractEntry : contractEntries) {
            Object entryContId = contractEntry.getDynamicObject("entrycontract").getPkValue();
            DynamicObject entryContPro = contractEntry.getDynamicObject("contpro");
            if (!contract.getPkValue().equals(entryContId) || separatePay && projectId != null && (entryContPro == null || !entryContPro.getPkValue().equals(projectId))) continue;
            deductionAmountByContract = deductionAmountByContract.add(contractEntry.getBigDecimal("thisprepaydeduction"));
        }
        return deductionAmountByContract;
    }

    public BigDecimal getDeductibleAmountByContract(DynamicObject contract, Object projectId, Object orgId) {
        BigDecimal prePayAmount = this.getPrePayAmount(contract, projectId, orgId);
        BigDecimal prePayDeductionAmount = this.getPrePayDeductionAmount(contract, projectId, orgId, Boolean.TRUE);
        return prePayAmount.subtract(prePayDeductionAmount);
    }

    public Map<Object, Map<String, Object>> getThisPrePaySplitBudgetData(DynamicObject contract, Object projectId, DynamicObjectCollection contractEntries) {
        HashMap<Object, Map<String, Object>> prePaySplitBudgetData = new HashMap<Object, Map<String, Object>>(16);
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        boolean separatePay = multiPartSettlement && StringUtils.equals((CharSequence)contract.getString("multipaytype"), (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue());
        for (DynamicObject contractEntry : contractEntries) {
            Object entryContId = contractEntry.getDynamicObject("entrycontract").getPkValue();
            DynamicObject entryContPro = contractEntry.getDynamicObject("contpro");
            if (!contract.getPkValue().equals(entryContId) || separatePay && projectId != null && (entryContPro == null || !entryContPro.getPkValue().equals(projectId))) continue;
            for (DynamicObject split : contractEntry.getDynamicObjectCollection("payapplysplitentry")) {
                Object budgetItemId;
                boolean prePaySplit = split.getBoolean("prepaysplit");
                DynamicObject budgetItem = split.getDynamicObject("bugdetitem");
                Object object = budgetItemId = budgetItem == null ? Long.valueOf(0L) : budgetItem.getPkValue();
                if (!prePaySplit) continue;
                HashMap<String, Object> budgetData = (HashMap<String, Object>)prePaySplitBudgetData.get(budgetItemId);
                if (budgetData == null) {
                    budgetData = new HashMap<String, Object>(16);
                    if (budgetItem != null) {
                        budgetData.put("name", budgetItem.getString("name"));
                        budgetData.put("budgetitem", budgetItem.getDynamicObject("budgetitem"));
                        budgetData.put("project", budgetItem.getDynamicObject("project"));
                    }
                }
                BigDecimal prePayDeduction = budgetData.get("prepaydeduction") == null ? BigDecimal.ZERO : (BigDecimal)budgetData.get("prepaydeduction");
                budgetData.put("prepaydeduction", prePayDeduction.add(split.getBigDecimal("cursplitamt")));
                prePaySplitBudgetData.put(budgetItemId, budgetData);
            }
        }
        return prePaySplitBudgetData;
    }

    public BigDecimal getPayAbleAmountBySupplier(DynamicObject contract, DynamicObject supplier, List<DynamicObject> payApplyBills) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        filterList.add(new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()}));
        filterList.add(new QFilter("entryentity.entrycontract", "=", contract.getPkValue()));
        filterList.add(new QFilter("entryentity.contpartb", "=", supplier.getPkValue()));
        BigDecimal payAbleAmount = BigDecimal.ZERO;
        DynamicObjectCollection paymentApplies = QueryServiceHelper.query((String)"pmct_paymentapply", (String)"entryentity.entrycontract,entryentity.contpartb,entryentity.thispayableamount", (QFilter[])filterList.toArray(new QFilter[0]));
        for (DynamicObject paymentApply : paymentApplies) {
            if (!paymentApply.get("entryentity.entrycontract").equals(contract.getPkValue()) || !paymentApply.get("entryentity.contpartb").equals(supplier.getPkValue())) continue;
            payAbleAmount = payAbleAmount.add(paymentApply.getBigDecimal("entryentity.thispayableamount"));
        }
        QFilter qFilter = new QFilter("contract", "=", contract.getPkValue()).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()).and("supplier", "=", supplier.getPkValue());
        DynamicObjectCollection paymentApplySingles = QueryServiceHelper.query((String)"pmct_applymentpay", (String)"curpaytotal,supplier", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject paymentApply : paymentApplySingles) {
            if (!paymentApply.get("supplier").equals(supplier.getPkValue())) continue;
            payAbleAmount = payAbleAmount.add(paymentApply.getBigDecimal("curpaytotal"));
        }
        for (DynamicObject payApplyBill : payApplyBills) {
            DynamicObjectCollection contractPayEntries = payApplyBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject contractEntry : contractPayEntries) {
                if (!contractEntry.getDynamicObject("entrycontract").getPkValue().equals(contract.getPkValue()) || !contractEntry.getDynamicObject("contpartb").getPkValue().equals(supplier.getPkValue()) || StringUtils.equals((CharSequence)contractEntry.getString("paymenttype"), (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue())) continue;
                payAbleAmount = payAbleAmount.add(contractEntry.getBigDecimal("thispayableamount"));
            }
        }
        return payAbleAmount;
    }
}

