/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmct.common.utils.BaseDocAdaptor;
import kd.pmgt.pmct.common.utils.ContractOfficeUtil;

public class ContractDocAdaptor
extends BaseDocAdaptor {
    public String[][] initDataTable(String propName, DynamicObject billObj, DynamicObjectCollection collection, MainEntityType dataEntityType) {
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"treelistentry")) {
            propName = "sublistentry";
        }
        EntryProp property = (EntryProp)dataEntityType.findProperty(propName);
        EntryType entryType = (EntryType)property.getDynamicCollectionItemPropertyType();
        Map fieldMap = entryType.getFields();
        LinkedHashMap<String, IDataEntityProperty> restructFieldMap = new LinkedHashMap<String, IDataEntityProperty>(fieldMap.size());
        for (Map.Entry fieldEntry : fieldMap.entrySet()) {
            String key = (String)fieldEntry.getKey();
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)fieldEntry.getValue();
            if (this.isExcludeField(propName, key, billObj)) continue;
            restructFieldMap.put(key, iDataEntityProperty);
            this.addField(propName, restructFieldMap, key, iDataEntityProperty);
        }
        String[][] dataTable = new String[collection.size() + 1][restructFieldMap.size()];
        int k = 0;
        for (Map.Entry entry : restructFieldMap.entrySet()) {
            String key = (String)entry.getKey();
            String fieldName = this.getFieldName(key);
            if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
                dataTable[0][k++] = fieldName;
                continue;
            }
            IDataEntityProperty entryProperty = (IDataEntityProperty)entry.getValue();
            LocaleString xLocaleString = entryProperty.getDisplayName();
            dataTable[0][k++] = xLocaleString == null ? "" : xLocaleString.getLocaleValue();
        }
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            int j = 0;
            for (Map.Entry fieldEntry : restructFieldMap.entrySet()) {
                dataTable[i + 1][j++] = ContractOfficeUtil.getPropValueToString((String)fieldEntry.getKey(), dataEntityType, dynamicObject);
            }
        }
        return dataTable;
    }

    @Override
    public DynamicObjectCollection getEntryCollection(DynamicObject billObj, String propName) {
        DynamicObjectCollection collection;
        block5: {
            block7: {
                block6: {
                    block4: {
                        collection = new DynamicObjectCollection();
                        if (!"treelistentry".equals(propName)) break block4;
                        DynamicObjectCollection listmodelentry = billObj.getDynamicObjectCollection("listmodelentry");
                        for (DynamicObject dynamicObject : listmodelentry) {
                            DynamicObjectCollection sublistentry = dynamicObject.getDynamicObjectCollection("sublistentry");
                            collection.addAll((Collection)sublistentry);
                        }
                        break block5;
                    }
                    if (!"sublistentry".equals(propName)) break block6;
                    DynamicObjectCollection listmodelentry = billObj.getDynamicObjectCollection("listmodelentry");
                    for (DynamicObject dynamicObject : listmodelentry) {
                        DynamicObjectCollection sublistentry = dynamicObject.getDynamicObjectCollection("sublistentry");
                        collection.addAll((Collection)sublistentry);
                    }
                    break block5;
                }
                collection = billObj.getDynamicObjectCollection(propName);
                if (!StringUtils.equals((CharSequence)propName, (CharSequence)"outcontpayplanentry")) break block7;
                Map srcObjCompleteMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])((DynamicObject[])collection.toArray((Object[])new DynamicObject[collection.size()])));
                for (DynamicObject payItem : collection) {
                    DynamicObject nodeSetting = payItem.getDynamicObject("nodesetting");
                    String nodeSettingSource = payItem.getString("nodesettingsource");
                    if (nodeSetting == null) continue;
                    Map nodeObjCompMap = (Map)srcObjCompleteMap.get(nodeSettingSource);
                    payItem.set("taskcompletestate", nodeObjCompMap != null ? nodeObjCompMap.get(nodeSetting.getPkValue()) : "");
                }
                break block5;
            }
            if (!StringUtils.equals((CharSequence)propName, (CharSequence)"incontpayplanentry")) break block5;
            Map srcObjCompleteMap = ContractCollectItemHelper.getSrcObjCompleteMap((DynamicObject[])((DynamicObject[])collection.toArray((Object[])new DynamicObject[collection.size()])));
            for (DynamicObject incomeItem : collection) {
                DynamicObject nodeSetting = incomeItem.getDynamicObject("nodesetting");
                String nodeSettingSource = incomeItem.getString("nodesettingsource");
                if (nodeSetting == null) continue;
                Map nodeObjCompMap = (Map)srcObjCompleteMap.get(nodeSettingSource);
                incomeItem.set("taskcompletestate", nodeObjCompMap != null ? nodeObjCompMap.get(nodeSetting.getPkValue()) : "");
            }
        }
        return collection;
    }

    @Override
    public String convertPropertyName(String propName) {
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"treelistentry")) {
            propName = "sublistentry";
        }
        return propName;
    }

    @Override
    public String getFieldName(String key) {
        String fieldName = null;
        if (StringUtils.equals((CharSequence)key, (CharSequence)"multisettleorg.name")) {
            fieldName = ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"ContractDocAdaptor_0", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"multisettlepro.name")) {
            fieldName = ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0", (String)"ContractDocAdaptor_1", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"material.name")) {
            fieldName = ResManager.loadKDString((String)"\u7269\u6599.\u540d\u79f0", (String)"ContractDocAdaptor_2", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"material.modelnum")) {
            fieldName = ResManager.loadKDString((String)"\u7269\u6599.\u89c4\u683c\u578b\u53f7", (String)"ContractDocAdaptor_3", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        }
        return fieldName;
    }

    @Override
    public void addField(String propName, Map<String, IDataEntityProperty> restructFieldMap, String key, IDataEntityProperty value) {
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"contorgscope")) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)"multisettleorg")) {
                restructFieldMap.put("multisettleorg.name", value);
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"contproscope")) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)"multisettlepro")) {
                restructFieldMap.put("multisettlepro.name", value);
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"sublistentry") && StringUtils.equals((CharSequence)key, (CharSequence)"material")) {
            restructFieldMap.put("material.name", value);
            restructFieldMap.put("material.modelnum", value);
        }
    }

    @Override
    public boolean isExcludeField(String propName, String key, DynamicObject billObj) {
        List<String> planplanFieldList;
        boolean isExcludeField = false;
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"listmodelentry")) {
            if (StringUtils.equals((CharSequence)"listmodelid", (CharSequence)key)) {
                isExcludeField = true;
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"sublistentry")) {
            ArrayList<String> excludelistingFieldList = new ArrayList<String>(10);
            Collections.addAll(excludelistingFieldList, "contlistnumber", "contlistname", "longnumber", "isleaf", "level", "parent", "listparentid", "sublistmodelid", "listcurrency", "listexratetable", "listexchangedate", "listexchangerate", "signoftax", "signtax", "signamt", "enable", "status");
            DynamicObject project = billObj.getDynamicObject("project");
            if (project == null) {
                excludelistingFieldList.add("listingbudgetitem");
            }
            if (excludelistingFieldList.contains(key)) {
                isExcludeField = true;
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"outcontpayplanentry")) {
            List<String> planplanFieldList2 = Arrays.asList("supplier", "nodesettingsource", "conplanitemid", "payitemname");
            if (planplanFieldList2.contains(key)) {
                isExcludeField = true;
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"incontpayplanentry") && (planplanFieldList = Arrays.asList("customer", "nodesettingsource", "conplanitemid", "incomeitemname")).contains(key)) {
            isExcludeField = true;
        }
        return isExcludeField;
    }
}

