/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import kd.pmgt.pmct.common.utils.ContractListingPOIHelper;

public class ContractListingImportAndExportUtils {
    private static JSONArray getHeader() {
        JSONArray header = new JSONArray();
        JSONObject sysnumber = new JSONObject();
        sysnumber.put("columnKey", (Object)"sysnumber");
        sysnumber.put("columnName", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u7f16\u7801", (String)"ContractListingImportAndExportUtils_0", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        sysnumber.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)sysnumber);
        JSONObject listnumber = new JSONObject();
        listnumber.put("columnKey", (Object)"listnumber");
        listnumber.put("columnName", (Object)ResManager.loadKDString((String)"\u6e05\u5355\u7f16\u7801", (String)"ContractListingImportAndExportUtils_1", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        listnumber.put("mustFill", (Object)Boolean.TRUE);
        header.add((Object)listnumber);
        JSONObject listname = new JSONObject();
        listname.put("columnKey", (Object)"listname");
        listname.put("columnName", (Object)ResManager.loadKDString((String)"\u6e05\u5355\u540d\u79f0", (String)"ContractListingImportAndExportUtils_2", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        listname.put("mustFill", (Object)Boolean.TRUE);
        header.add((Object)listname);
        JSONObject material = new JSONObject();
        material.put("columnKey", (Object)"material");
        material.put("columnName", (Object)ResManager.loadKDString((String)"\u7269\u6599.\u7f16\u7801", (String)"ContractListingImportAndExportUtils_22", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        material.put("mustFill", (Object)Boolean.TRUE);
        header.add((Object)material);
        JSONObject materialname = new JSONObject();
        materialname.put("columnKey", (Object)"material.name");
        materialname.put("columnName", (Object)ResManager.loadKDString((String)"\u7269\u6599.\u540d\u79f0", (String)"ContractListingImportAndExportUtils_23", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        materialname.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)materialname);
        JSONObject materialmodel = new JSONObject();
        materialmodel.put("columnKey", (Object)"material.modelnum");
        materialmodel.put("columnName", (Object)ResManager.loadKDString((String)"\u7269\u6599.\u89c4\u683c\u578b\u53f7", (String)"ContractListingImportAndExportUtils_24", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        materialmodel.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)materialmodel);
        JSONObject measureunit = new JSONObject();
        measureunit.put("columnKey", (Object)"measureunit");
        measureunit.put("columnName", (Object)ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ContractListingImportAndExportUtils_6", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        measureunit.put("mustFill", (Object)Boolean.TRUE);
        header.add((Object)measureunit);
        JSONObject qty = new JSONObject();
        qty.put("columnKey", (Object)"qty");
        qty.put("columnName", (Object)ResManager.loadKDString((String)"\u6570\u91cf", (String)"ContractListingImportAndExportUtils_7", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        qty.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)qty);
        JSONObject taxPrice = new JSONObject();
        taxPrice.put("columnKey", (Object)"taxprice");
        taxPrice.put("columnName", (Object)ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"ContractListingImportAndExportUtils_11", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        taxPrice.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)taxPrice);
        JSONObject taxrate = new JSONObject();
        taxrate.put("columnKey", (Object)"rate");
        taxrate.put("columnName", (Object)ResManager.loadKDString((String)"\u7a0e\u7387\uff08%\uff09", (String)"ContractListingImportAndExportUtils_9", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        taxrate.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)taxrate);
        JSONObject ofTax = new JSONObject();
        ofTax.put("columnKey", (Object)"oftax");
        ofTax.put("columnName", (Object)ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"ContractListingImportAndExportUtils_12", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        ofTax.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)ofTax);
        JSONObject tax = new JSONObject();
        tax.put("columnKey", (Object)"tax");
        tax.put("columnName", (Object)ResManager.loadKDString((String)"\u7a0e\u989d", (String)"ContractListingImportAndExportUtils_25", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        tax.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)tax);
        JSONObject price = new JSONObject();
        price.put("columnKey", (Object)"price");
        price.put("columnName", (Object)ResManager.loadKDString((String)"\u5355\u4ef7", (String)"ContractListingImportAndExportUtils_8", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        price.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)price);
        JSONObject amount = new JSONObject();
        amount.put("columnKey", (Object)"amount");
        amount.put("columnName", (Object)ResManager.loadKDString((String)"\u91d1\u989d", (String)"ContractListingImportAndExportUtils_10", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        amount.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)amount);
        JSONObject desc = new JSONObject();
        desc.put("columnKey", (Object)"desc");
        desc.put("columnName", (Object)ResManager.loadKDString((String)"\u5907\u6ce8", (String)"ContractListingImportAndExportUtils_13", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        desc.put("mustFill", (Object)Boolean.FALSE);
        header.add((Object)desc);
        return header;
    }

    public static String exportTemplate() {
        String fileName = ResManager.loadKDString((String)"\u5408\u540c\u6e05\u5355\u6a21\u677f", (String)"ContractListingImportAndExportUtils_21", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        String sheetName = ResManager.loadKDString((String)"\u5408\u540c\u6e05\u5355\u5217\u8868", (String)"ContractListingImportAndExportUtils_15", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        JSONArray header = ContractListingImportAndExportUtils.getHeader();
        String url = ContractListingPOIHelper.exportExcel(fileName, sheetName, header, new JSONArray());
        return url;
    }

    public static void exportModel(IFormView view) {
        String fileName = ResManager.loadKDString((String)"\u5408\u540c\u6e05\u5355", (String)"ContractListingImportAndExportUtils_14", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        String sheetName = ResManager.loadKDString((String)"\u5408\u540c\u6e05\u5355\u5217\u8868", (String)"ContractListingImportAndExportUtils_15", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        EntryGrid grid = (EntryGrid)view.getControl("listmodelentry");
        int[] selrows = grid.getSelectRows();
        if (selrows.length <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e05\u5355\u6a21\u677f\u5361\u7247\u3002", (String)"ContractListingImportAndExportUtils_16", (String)"pmgt-pmct-common", (Object[])new Object[0]));
            return;
        }
        int subRowCount = view.getModel().getEntryRowCount("sublistentry");
        JSONArray datas = new JSONArray();
        JSONArray header = ContractListingImportAndExportUtils.getHeader();
        List columnKeys = POIHelper.getColumnKeys((JSONArray)header);
        for (int i = 0; i < subRowCount; ++i) {
            DynamicObject entry = view.getModel().getEntryRowEntity("sublistentry", i);
            if (entry == null) continue;
            JSONObject jsonObject = ContractListingImportAndExportUtils.entryListToJsonObject(entry, columnKeys);
            datas.add((Object)jsonObject);
        }
        String url = ContractListingPOIHelper.exportExcel(fileName, sheetName, header, datas);
        view.download(url);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ContractListingImportAndExportUtils_26", (String)"pmgt-pmct-common", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    public static JSONObject entryListToJsonObject(DynamicObject subRowObj, List<String> columnKeys) {
        JSONObject jsonObject = new JSONObject();
        for (String propNum : columnKeys) {
            if (propNum.indexOf(46) != -1) continue;
            if ("listname".equals(propNum)) {
                OrmLocaleValue val = (OrmLocaleValue)subRowObj.get("listname");
                jsonObject.put("listname", (Object)val.getLocaleValue());
                continue;
            }
            if ("material".equals(propNum)) {
                DynamicObject material;
                if (subRowObj.getDynamicObject("material") == null || (material = subRowObj.getDynamicObject("material")) == null) continue;
                jsonObject.put(propNum, (Object)material.getString("number"));
                jsonObject.put("material.name", (Object)material.getString("name"));
                jsonObject.put("material.modelnum", (Object)material.getString("modelnum"));
                continue;
            }
            if ("rate".equals(propNum)) {
                if (BigDecimal.ZERO.compareTo(subRowObj.getBigDecimal("rate")) == 0) continue;
                jsonObject.put("rate", subRowObj.get("rate"));
                continue;
            }
            if ("measureunit".equals(propNum)) {
                if (subRowObj.getDynamicObject("measureunit") == null) continue;
                jsonObject.put("measureunit", (Object)subRowObj.getDynamicObject("measureunit").getString("name"));
                continue;
            }
            if ("qty".equals(propNum) || "taxprice".equals(propNum) || "amount".equals(propNum) || "price".equals(propNum) || "oftax".equals(propNum)) {
                if (BigDecimal.ZERO.compareTo(subRowObj.getBigDecimal(propNum)) == 0) {
                    jsonObject.put(propNum, (Object)String.valueOf(subRowObj.getBigDecimal(propNum).intValue()));
                    continue;
                }
                jsonObject.put(propNum, subRowObj.get(propNum));
                continue;
            }
            if (subRowObj.get(propNum) == null) continue;
            jsonObject.put(propNum, subRowObj.get(propNum));
        }
        return jsonObject;
    }

    public static void importListing(IFormView view, String url, int curModelIndex) {
        JSONArray jsonArray = ContractListingPOIHelper.inputExcel(url, String.valueOf(POIHelper.getColumnKeys((JSONArray)ContractListingImportAndExportUtils.getHeader()).toString().hashCode()));
        if (jsonArray.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u4e2d\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"ContractListingImportAndExportUtils_18", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection modelEntity = view.getModel().getEntryEntity("listmodelentry");
        DynamicObject modelEntry = (DynamicObject)modelEntity.get(curModelIndex);
        String listmodelid = modelEntry.getString("listmodelid");
        DynamicObjectCollection listingEntry = modelEntry.getDynamicObjectCollection("sublistentry");
        listingEntry.clear();
        boolean isSingleRate = (Boolean)model.getValue("ismultirate") == false;
        BigDecimal singleTaxRate = BigDecimal.ZERO;
        if (isSingleRate) {
            DynamicObject taxRateObj = (DynamicObject)model.getValue("taxrate");
            singleTaxRate = taxRateObj.getBigDecimal("taxrate");
        }
        HashSet<Object> materialKeySet = new HashSet<Object>(16);
        HashSet<Object> measureunitKeySet = new HashSet<Object>(16);
        HashSet<Object> taxrateKeySet = new HashSet<Object>(16);
        for (Object row : jsonArray) {
            JSONArray rowData = JSON.parseArray((String)row.toString());
            for (Object rowDatum : rowData) {
                String objval;
                JSONObject jObject = JSON.parseObject((String)rowDatum.toString());
                String columnKey = jObject.getString("columnKey");
                if ("material".equals(columnKey)) {
                    objval = jObject.getString("cellValue");
                    materialKeySet.add(objval);
                }
                if ("measureunit".equals(columnKey)) {
                    objval = jObject.getString("cellValue");
                    measureunitKeySet.add(objval);
                }
                if (!"rate".equals(columnKey) || StringUtils.isBlank((String)(objval = jObject.getString("cellValue")))) continue;
                taxrateKeySet.add(new BigDecimal(objval));
            }
        }
        Map<Object, DynamicObject> materialMap = ContractListingImportAndExportUtils.queryBusinessDataMap(materialKeySet, "material", "number");
        Map<Object, DynamicObject> measureunitMap = ContractListingImportAndExportUtils.queryBusinessDataMap(measureunitKeySet, "measureunit", "name");
        Map<Object, DynamicObject> taxrateMap = ContractListingImportAndExportUtils.queryBusinessDataMap(taxrateKeySet, "rate", "taxrate");
        HashMap<String, DynamicObject> sysNumMap = new HashMap<String, DynamicObject>(16);
        int index = 1;
        for (Object row : jsonArray) {
            JSONArray rowData = JSONArray.parseArray((String)row.toString());
            DynamicObject listingEntryRow = ContractListingImportAndExportUtils.createEntryData(view, rowData, sysNumMap, materialMap, measureunitMap, taxrateMap);
            if (listingEntryRow == null) continue;
            listingEntryRow.set("sublistmodelid", (Object)listmodelid);
            ContractListingImportAndExportUtils.setListEntry(model, listingEntryRow);
            listingEntryRow.set("enable", (Object)EnableEnum.ENABLE.getValue());
            listingEntryRow.set("seq", (Object)index++);
            listingEntry.add((Object)listingEntryRow);
        }
        if (isSingleRate) {
            for (DynamicObject listingEntryRow : listingEntry) {
                String sysNumber = listingEntryRow.getString("sysnumber");
                boolean isLeaf = listingEntryRow.getBoolean("isleaf");
                if (!isLeaf) continue;
                BigDecimal taxrate = listingEntryRow.getBigDecimal("rate");
                if (taxrate == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5355\u7a0e\u7387\u60c5\u51b5\u4e0b\u7cfb\u7edf\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6e05\u5355\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractListingImportAndExportUtils_19", (String)"pmgt-pmct-common", (Object[])new Object[0]), sysNumber));
                }
                if (taxrate.compareTo(singleTaxRate) == 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u7cfb\u7edf\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u6e05\u5355\u7684\u7a0e\u7387\u201c%2$s%%\u201d\u4e0e\u5355\u636e\u5934\u7684\u7a0e\u7387\u201c%3$s%%\u201d\u4e0d\u76f8\u7b49\u3002", (String)"ContractListingImportAndExportUtils_20", (String)"pmgt-pmct-common", (Object[])new Object[0]), sysNumber, taxrate, singleTaxRate));
            }
        }
        ContractListingImportAndExportUtils.sumToParent(listingEntry);
        view.getModel().updateEntryCache(modelEntity);
    }

    protected static void setListEntry(IDataModel model, DynamicObject listingEntryRow) {
        boolean isEnterAmount = (Boolean)model.getValue("isenteramount");
        boolean isOftaxcontract = (Boolean)model.getValue("isoftaxcontract");
        boolean isAdjustAmount = (Boolean)model.getValue("isadjustamount");
        BigDecimal qty = listingEntryRow.getBigDecimal("qty");
        BigDecimal taxRate = listingEntryRow.getBigDecimal("rate");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        BigDecimal ofTax = listingEntryRow.getBigDecimal("oftax");
        BigDecimal amount = listingEntryRow.getBigDecimal("amount");
        BigDecimal taxPrice = listingEntryRow.getBigDecimal("taxprice");
        BigDecimal price = listingEntryRow.getBigDecimal("price");
        BigDecimal oneAddRate = BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)));
        int pricePrecision = CurrencyHelper.getPriceAccuracy((DynamicObject)currency);
        if (isEnterAmount && isAdjustAmount) {
            int amtPrecision = CurrencyHelper.getAmountAccuracy((DynamicObject)currency);
            if (isOftaxcontract) {
                amount = ofTax.divide(oneAddRate, amtPrecision, 4);
            } else {
                ofTax = amount.multiply(oneAddRate);
            }
            if (qty != null && qty.compareTo(BigDecimal.ZERO) > 0) {
                taxPrice = ofTax.divide(qty, pricePrecision, 4);
                price = amount.divide(qty, pricePrecision, 4);
            }
        } else {
            if (isOftaxcontract) {
                price = taxPrice.divide(oneAddRate, pricePrecision, 4);
            } else {
                taxPrice = price.multiply(oneAddRate);
            }
            amount = qty.multiply(price);
            ofTax = qty.multiply(taxPrice);
        }
        listingEntryRow.set("price", (Object)price);
        listingEntryRow.set("taxprice", (Object)taxPrice);
        listingEntryRow.set("amount", (Object)amount);
        listingEntryRow.set("oftax", (Object)ofTax);
        listingEntryRow.set("tax", (Object)ofTax.subtract(amount));
    }

    private static void sumToParent(DynamicObjectCollection subListingCol) {
        HashMap levelListMap = new HashMap(16);
        int maxLevel = 0;
        List<DynamicObject> levelList = null;
        for (DynamicObject listing : subListingCol) {
            Integer level = listing.getInt("level");
            if (level > maxLevel) {
                maxLevel = level;
            }
            if (levelListMap.get(level) == null) {
                levelList = new ArrayList<DynamicObject>();
                levelList.add(listing);
                levelListMap.put(level, levelList);
                continue;
            }
            levelList = (List)levelListMap.get(level);
            levelList.add(listing);
        }
        while (maxLevel > 0) {
            List levelList_0 = (List)levelListMap.get(maxLevel);
            for (DynamicObject listing : levelList_0) {
                if (listing.getDynamicObject("parent") == null) continue;
                BigDecimal amount = listing.getBigDecimal("amount");
                BigDecimal tax = listing.getBigDecimal("tax");
                BigDecimal oftax = listing.getBigDecimal("oftax");
                DynamicObject parentListing = listing.getDynamicObject("parent");
                parentListing.set("amount", (Object)amount.add(parentListing.getBigDecimal("amount")));
                parentListing.set("tax", (Object)tax.add(parentListing.getBigDecimal("tax")));
                parentListing.set("oftax", (Object)oftax.add(parentListing.getBigDecimal("oftax")));
            }
            --maxLevel;
        }
    }

    private static DynamicObject createEntryData(IFormView view, JSONArray jArray, Map<String, DynamicObject> sysNumMap, Map<Object, DynamicObject> materialMap, Map<Object, DynamicObject> measureunitMap, Map<Object, DynamicObject> taxrateMap) {
        DynamicObject modelEntryObj = view.getModel().getEntryRowEntity("listmodelentry", 0);
        DynamicObjectCollection subListingCol = modelEntryObj.getDynamicObjectCollection("sublistentry");
        DynamicObject listing = new DynamicObject(subListingCol.getDynamicObjectType());
        listing.set("isleaf", (Object)Boolean.TRUE);
        listing.set("level", (Object)1);
        ORM orm = ORM.create();
        long listingId = orm.genLongId("pmct_contractlist");
        listing.set("id", (Object)listingId);
        block30: for (Object object : jArray) {
            JSONObject jObject = JSONObject.parseObject((String)object.toString());
            String columnKey = jObject.getString("columnKey");
            String objval = jObject.getString("cellValue");
            switch (columnKey) {
                case "sysnumber": {
                    if (objval == null || "".equals(objval)) break;
                    listing.set("sysnumber", (Object)objval);
                    sysNumMap.put(objval, listing);
                    int index = objval.lastIndexOf(46);
                    if (index <= 0) break;
                    String parentSysNum = objval.substring(0, index);
                    if (sysNumMap.get(parentSysNum) == null) continue block30;
                    DynamicObject dynamicObject = sysNumMap.get(parentSysNum);
                    int parentLevel = dynamicObject.getInt("level");
                    listing.set("level", (Object)(parentLevel + 1));
                    listing.set("parent", (Object)dynamicObject);
                    listing.set("listparentid", (Object)dynamicObject.getString("id"));
                    dynamicObject.set("isleaf", (Object)Boolean.FALSE);
                    dynamicObject.set("material", null);
                    dynamicObject.set("measureunit", null);
                    dynamicObject.set("qty", null);
                    dynamicObject.set("price", null);
                    dynamicObject.set("amount", null);
                    dynamicObject.set("tax", null);
                    dynamicObject.set("taxprice", null);
                    dynamicObject.set("oftax", null);
                    dynamicObject.set("rateobj", null);
                    dynamicObject.set("rate", null);
                    break;
                }
                case "listnumber": {
                    if (objval == null || "".equals(objval)) {
                        return null;
                    }
                    listing.set("listnumber", (Object)objval);
                    break;
                }
                case "listname": {
                    listing.set("listname", (Object)objval);
                    break;
                }
                case "material": {
                    if (objval == null || "".equals(objval)) break;
                    DynamicObject material = materialMap.get(objval);
                    listing.set("material", (Object)material);
                    break;
                }
                case "measureunit": {
                    if (objval == null || "".equals(objval)) break;
                    for (Map.Entry entry : measureunitMap.entrySet()) {
                        OrmLocaleValue localeValue = (OrmLocaleValue)entry.getKey();
                        if (!localeValue.values().contains(objval)) continue;
                        listing.set("measureunit", entry.getValue());
                    }
                    continue block30;
                }
                case "qty": {
                    if (objval == null || objval.isEmpty()) break;
                    listing.set("qty", (Object)objval);
                    break;
                }
                case "taxprice": {
                    if (objval == null || objval.isEmpty()) break;
                    listing.set("taxprice", (Object)objval);
                    break;
                }
                case "rate": {
                    if (objval == null || objval.isEmpty()) break;
                    DynamicObject taxRateObj = taxrateMap.get(new BigDecimal(objval));
                    listing.set("rateobj", (Object)taxRateObj);
                    listing.set("rate", taxRateObj.get("taxrate"));
                    break;
                }
                case "oftax": {
                    if (objval == null || objval.isEmpty()) break;
                    listing.set("oftax", (Object)new BigDecimal(objval));
                    break;
                }
                case "tax": {
                    if (objval == null || objval.isEmpty()) break;
                    listing.set("tax", (Object)new BigDecimal(objval));
                    break;
                }
                case "price": {
                    if (objval == null || objval.isEmpty()) break;
                    listing.set("price", (Object)new BigDecimal(objval));
                    break;
                }
                case "amount": {
                    if (objval == null || objval.isEmpty()) break;
                    listing.set("amount", (Object)new BigDecimal(objval));
                    break;
                }
                case "desc": {
                    listing.set("desc", (Object)objval);
                    break;
                }
            }
        }
        return listing;
    }

    private static Map<Object, DynamicObject> queryBusinessDataMap(Set<Object> keySet, String type, String mapKey) {
        DynamicObject[] dynamicObjects = new DynamicObject[]{};
        HashMap<Object, DynamicObject> resultMap = new HashMap<Object, DynamicObject>(16);
        switch (type) {
            case "material": {
                QFilter matNumFilter = new QFilter("number", "in", (Object)keySet.toArray());
                dynamicObjects = BusinessDataServiceHelper.load((String)"bd_material", (String)"number,name,modelnum", (QFilter[])new QFilter[]{matNumFilter});
                break;
            }
            case "measureunit": {
                QFilter unitNameFilter = new QFilter("name", "in", (Object)keySet.toArray());
                dynamicObjects = BusinessDataServiceHelper.load((String)"bd_measureunits", (String)"number,name,conversiontype", (QFilter[])new QFilter[]{unitNameFilter});
                break;
            }
            case "rate": {
                QFilter taxrateFiler = new QFilter("taxrate", "in", (Object)keySet.toArray());
                dynamicObjects = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"number,name,taxrate", (QFilter[])new QFilter[]{taxrateFiler});
                break;
            }
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            resultMap.put(dynamicObject.get(mapKey), dynamicObject);
        }
        return resultMap;
    }
}

