/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.AttachmentCountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CityProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IconProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PeriodProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TreeEntryProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.property.UserProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.pmgt.pmct.common.enums.ContTemplateTypeEnum;
import kd.pmgt.pmct.common.enums.FieldTypeEnum;
import kd.pmgt.pmct.common.utils.BaseDocAdaptor;
import kd.pmgt.pmct.common.utils.ContAdditionDocAdaptor;
import kd.pmgt.pmct.common.utils.ContractDocAdaptor;
import kd.pmgt.pmct.common.utils.CurrencyFormatUtil;
import kd.pmgt.pmct.common.utils.StrategeDocAdaptor;

public class ContractOfficeUtil {
    private static final String BILLDOC = "pmgt_contbilldoc";
    private static final String TPLDOC = "pmgt_conttempweboffice";

    public static void addBookMarkForSelection(IFormView formView, WebOffice webOffice) {
        IDataModel model = formView.getModel();
        StringBuilder bookMarkString = new StringBuilder("otherbookmark_");
        bookMarkString.append(System.currentTimeMillis());
        webOffice.addBookmarkForSelection(bookMarkString.toString());
        int row = model.insertEntryRow("bookmarkentry", 0);
        model.setValue("bookmarkvalue", (Object)ResManager.loadKDString((String)"\u624b\u52a8\u8bbe\u7f6e\u7684\u4e66\u7b7e", (String)"ContractOfficeUtil_0", (String)"pmgt-pmct-common", (Object[])new Object[0]), row);
        model.setValue("bookmarkprop", (Object)"", row);
        model.setValue("bookmarktype", (Object)FieldTypeEnum.MANUAL.getValue(), row);
        model.setValue("bookmarkkey", (Object)bookMarkString, row);
    }

    public static void delectField(IFormView formView, WebOffice webOffice) {
        IDataModel model = formView.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("bookmarkentry");
        String bookMarkKey = (String)model.getValue("bookmarkkey", rowIndex);
        String bookMarkType = (String)model.getValue("bookmarktype", rowIndex);
        if (!"100".equals(bookMarkType)) {
            webOffice.deleteMarks(Arrays.asList(bookMarkKey));
        }
        model.deleteEntryRow("bookmarkentry", rowIndex);
    }

    public static void selectField(IFormView formView, WebOffice webOffice) {
        IDataModel model = formView.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("selectfieldentry");
        String name = (String)model.getValue("fieldname", rowIndex);
        String key = (String)model.getValue("fieldkey", rowIndex);
        String bookMarkType = (String)model.getValue("fieldtype", rowIndex);
        String markKey = "bm_" + key + "_" + System.currentTimeMillis();
        String markValue = "\u3010" + name + "\u3011";
        int row = model.insertEntryRow("bookmarkentry", 0);
        model.setValue("bookmarkvalue", (Object)markValue, row);
        model.setValue("bookmarkprop", (Object)key, row);
        model.setValue("bookmarktype", (Object)bookMarkType, row);
        model.setValue("bookmarkkey", (Object)markKey, row);
        webOffice.addMarks(new WebOfficeMark(markKey, markValue));
    }

    public static void loadTempBookMarkEntry(IFormView formView, DynamicObject contTemp) {
        DynamicObjectCollection tempBookMarkEntryCol = contTemp.getDynamicObjectCollection("bookmarkentry");
        IDataModel model = formView.getModel();
        DynamicObjectCollection designBoolMarkEntryCol = model.getEntryEntity("bookmarkentry");
        DynamicObjectType designBookMarkDt = designBoolMarkEntryCol.getDynamicObjectType();
        designBoolMarkEntryCol.clear();
        for (DynamicObject bookMarkEntry : tempBookMarkEntryCol) {
            DynamicObject designBookMarkObj = new DynamicObject(designBookMarkDt);
            designBookMarkObj.set("bookmarkkey", bookMarkEntry.get("bookmarkkey"));
            designBookMarkObj.set("bookmarktype", bookMarkEntry.get("bookmarktype"));
            designBookMarkObj.set("bookmarkprop", bookMarkEntry.get("bookmarkprop"));
            designBookMarkObj.set("bookmarkvalue", bookMarkEntry.get("bookmarkvalue"));
            designBookMarkObj.set("canedit", bookMarkEntry.get("canedit"));
            designBoolMarkEntryCol.add((Object)designBookMarkObj);
        }
    }

    public static void syncBookMark(IFormView formView, WebOfficeBookmarkEvent bookmarkEvent) {
        List bookmarks = bookmarkEvent.getBookmarks();
        DynamicObjectCollection bookMarkEntryCol = formView.getModel().getEntryEntity("bookmarkentry");
        List collect = bookMarkEntryCol.stream().filter(a -> bookmarks.contains(a.getString("bookmarkkey"))).collect(Collectors.toList());
        bookMarkEntryCol.clear();
        bookMarkEntryCol.addAll(collect);
        formView.getModel().updateEntryCache(bookMarkEntryCol);
        formView.updateView("bookmarkentry");
    }

    public static void generateField(IFormView formView, String billFormNumber) {
        IDataModel model = formView.getModel();
        DynamicObjectCollection fieldEntryCol = model.getEntryEntity("selectfieldentry");
        fieldEntryCol.clear();
        DynamicObjectType fieldEntryType = fieldEntryCol.getDynamicObjectType();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormNumber);
        DataEntityPropertyCollection propertyCollection = entityType.getProperties();
        for (IDataEntityProperty iDataEntityProperty : propertyCollection) {
            if (iDataEntityProperty.getDisplayName() == null) continue;
            if (iDataEntityProperty.getName().equals("entryentity")) {
                iDataEntityProperty.getDisplayName();
            }
            ContractOfficeUtil.matchProperty(fieldEntryCol, fieldEntryType, iDataEntityProperty);
        }
        Collections.sort(fieldEntryCol, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o1.getString("fieldtype").compareTo(o2.getString("fieldtype"));
            }
        });
    }

    private static void matchProperty(DynamicObjectCollection fieldEntryCol, DynamicObjectType fieldEntryType, IDataEntityProperty iDataEntityProperty) {
        DynamicObject fieldEntryObj = new DynamicObject(fieldEntryType);
        if (iDataEntityProperty instanceof AssistantProp) {
            AssistantProp assistantProp = (AssistantProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)assistantProp, FieldTypeEnum.ASSISTANT.getValue());
        } else if (iDataEntityProperty instanceof CreaterProp) {
            CreaterProp createrProp = (CreaterProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)createrProp, FieldTypeEnum.CREATOR.getValue());
        } else if (iDataEntityProperty instanceof ModifierProp) {
            ModifierProp modifierProp = (ModifierProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)modifierProp, FieldTypeEnum.MODIFIER.getValue());
        } else if (iDataEntityProperty instanceof CreateDateProp) {
            CreateDateProp createDateProp = (CreateDateProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)createDateProp, FieldTypeEnum.CREATEDATE.getValue());
        } else if (iDataEntityProperty instanceof ModifyDateProp) {
            ModifyDateProp modifyDateProp = (ModifyDateProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)modifyDateProp, FieldTypeEnum.MODIFYDATE.getValue());
        } else if (iDataEntityProperty instanceof AttachmentCountProp) {
            AttachmentCountProp attachmentCountProp = (AttachmentCountProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)attachmentCountProp, FieldTypeEnum.ATTACHMENTCOUNT.getValue());
        } else if (iDataEntityProperty instanceof UserProp) {
            UserProp userProp = (UserProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)userProp, FieldTypeEnum.USER.getValue());
        } else if (iDataEntityProperty instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)orgProp, FieldTypeEnum.ORG.getValue());
        } else if (iDataEntityProperty instanceof CityProp) {
            CityProp cityProp = (CityProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)cityProp, FieldTypeEnum.CITY.getValue());
        } else if (iDataEntityProperty instanceof MaterielProp) {
            MaterielProp materielProp = (MaterielProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)materielProp, FieldTypeEnum.MATERIEL.getValue());
        } else if (iDataEntityProperty instanceof UnitProp) {
            UnitProp unitProp = (UnitProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)unitProp, FieldTypeEnum.UNIT.getValue());
        } else if (iDataEntityProperty instanceof QtyProp) {
            QtyProp qtyProp = (QtyProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)qtyProp, FieldTypeEnum.QTY.getValue());
        } else if (iDataEntityProperty instanceof CurrencyProp) {
            CurrencyProp currencyProp = (CurrencyProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)currencyProp, FieldTypeEnum.CURRENCY.getValue());
        } else if (iDataEntityProperty instanceof PriceProp) {
            PriceProp priceProp = (PriceProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)priceProp, FieldTypeEnum.PRICE.getValue());
        } else if (iDataEntityProperty instanceof PeriodProp) {
            PeriodProp periodProp = (PeriodProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)periodProp, FieldTypeEnum.PERIOD.getValue());
        } else if (iDataEntityProperty instanceof FlexProp) {
            FlexProp flexProp = (FlexProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)flexProp, FieldTypeEnum.FLEX.getValue());
        } else if (iDataEntityProperty instanceof ItemClassProp) {
            ItemClassProp itemClassProp = (ItemClassProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)itemClassProp, FieldTypeEnum.ITEMCLASS.getValue());
        } else if (iDataEntityProperty instanceof ItemClassTypeProp) {
            ItemClassTypeProp itemClassTypeProp = (ItemClassTypeProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)itemClassTypeProp, FieldTypeEnum.ITEMCLASS.getValue());
        } else if (iDataEntityProperty instanceof BillTypeProp) {
            BillTypeProp billTypeProp = (BillTypeProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)billTypeProp, FieldTypeEnum.BILLTYPE.getValue());
        } else if (iDataEntityProperty instanceof BillStatusProp) {
            BillStatusProp billStatusProp = (BillStatusProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)billStatusProp, FieldTypeEnum.BILLSTATUS.getValue());
        } else if (iDataEntityProperty instanceof BasedataProp) {
            BasedataProp prop = (BasedataProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)prop, FieldTypeEnum.BASEDATA.getValue());
        } else if (iDataEntityProperty instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)mulBasedataProp, FieldTypeEnum.MULBASEDATA.getValue());
        } else if (iDataEntityProperty instanceof TreeEntryProp) {
            TreeEntryProp treeEntryProp = (TreeEntryProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)treeEntryProp, FieldTypeEnum.TREEENTRY.getValue());
        } else if (iDataEntityProperty instanceof SubEntryProp) {
            SubEntryProp subEntryProp = (SubEntryProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)subEntryProp, FieldTypeEnum.SUBENTYR.getValue());
        } else if (iDataEntityProperty instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)entryProp, FieldTypeEnum.ENTRY.getValue());
        } else if (iDataEntityProperty instanceof MulComboProp) {
            MulComboProp mulComboProp = (MulComboProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)mulComboProp, FieldTypeEnum.MULCOMBO.getValue());
        } else if (iDataEntityProperty instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)comboProp, FieldTypeEnum.COMBO.getValue());
        } else if (iDataEntityProperty instanceof DateProp) {
            DateProp dateProp = (DateProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)dateProp, FieldTypeEnum.DATE.getValue());
        } else if (iDataEntityProperty instanceof DateTimeProp) {
            DateTimeProp dateProp = (DateTimeProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)dateProp, FieldTypeEnum.DATETIME.getValue());
        } else if (iDataEntityProperty instanceof BigIntProp) {
            BigIntProp bigIntProp = (BigIntProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)bigIntProp, FieldTypeEnum.BIGINT.getValue());
        } else if (iDataEntityProperty instanceof IntegerProp) {
            IntegerProp integerProp = (IntegerProp)iDataEntityProperty;
            if (!StringUtils.equals((CharSequence)"feq", (CharSequence)integerProp.getName())) {
                ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)integerProp, FieldTypeEnum.INTEGER.getValue());
            }
        } else if (iDataEntityProperty instanceof LongProp) {
            LongProp longProp = (LongProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)longProp, FieldTypeEnum.LONG.getValue());
        } else if (iDataEntityProperty instanceof AmountProp) {
            AmountProp amountProp = (AmountProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)amountProp, FieldTypeEnum.AMOUNT.getValue());
        } else if (iDataEntityProperty instanceof MuliLangTextProp) {
            MuliLangTextProp muliLangTextProp = (MuliLangTextProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)muliLangTextProp, FieldTypeEnum.MULLANGTEXT.getValue());
        } else if (iDataEntityProperty instanceof TextAreaProp) {
            TextAreaProp textAreaProp = (TextAreaProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)textAreaProp, FieldTypeEnum.TEXTAREA.getValue());
        } else if (iDataEntityProperty instanceof LargeTextProp) {
            LargeTextProp largeTextProp = (LargeTextProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)largeTextProp, FieldTypeEnum.LARGETEXT.getValue());
        } else if (iDataEntityProperty instanceof TextProp) {
            TextProp textProp = (TextProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)textProp, FieldTypeEnum.TEXT.getValue());
        } else if (iDataEntityProperty instanceof DecimalProp) {
            DecimalProp decimalProp = (DecimalProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)decimalProp, FieldTypeEnum.DECIMAL.getValue());
        } else if (iDataEntityProperty instanceof BooleanProp) {
            BooleanProp booleanProp = (BooleanProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)booleanProp, FieldTypeEnum.BOOLEAN.getValue());
        } else if (iDataEntityProperty instanceof AdminDivisionProp) {
            AdminDivisionProp adminDivisionProp = (AdminDivisionProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)adminDivisionProp, FieldTypeEnum.ADMINDIVISION.getValue());
        } else if (iDataEntityProperty instanceof PictureProp) {
            PictureProp pictureProp = (PictureProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)pictureProp, FieldTypeEnum.PICTURE.getValue());
        } else if (iDataEntityProperty instanceof IconProp) {
            IconProp iconProp = (IconProp)iDataEntityProperty;
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)iconProp, FieldTypeEnum.ICON.getValue());
        } else {
            ContractOfficeUtil.setFieldValue(fieldEntryObj, (DynamicProperty)iDataEntityProperty, FieldTypeEnum.OTHER.getValue());
        }
        fieldEntryCol.add((Object)fieldEntryObj);
    }

    private static void setFieldValue(DynamicObject fieldEntryObj, DynamicProperty prop, String text) {
        fieldEntryObj.set("fieldkey", (Object)prop.getName());
        fieldEntryObj.set("fieldname", (Object)prop.getDisplayName());
        fieldEntryObj.set("fieldtype", (Object)text);
    }

    public static String getPropValueToString(String propName, MainEntityType dataEntityType, DynamicObject obj) {
        Object value = obj.get(propName);
        IDataEntityProperty property = dataEntityType.findProperty(propName);
        if (null == value) {
            return "";
        }
        if (property instanceof BooleanProp) {
            return (Boolean)value != false ? ResManager.loadKDString((String)"\u662f", (String)"ContractOfficeUtil_1", (String)"pmgt-pmct-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ContractOfficeUtil_2", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        }
        if (property instanceof AmountProp) {
            AmountProp amountProp = (AmountProp)property;
            String currencyName = amountProp.getControlPropName();
            IDataEntityType parentType = dataEntityType.findProperty(currencyName).getParent();
            if (parentType instanceof BillEntityType && obj.getDataEntityType() instanceof EntryType) {
                DynamicObject parentObj = (DynamicObject)obj.getParent();
                if (parentObj.getDataEntityType() instanceof EntryType) {
                    parentObj = (DynamicObject)parentObj.getParent();
                }
                DynamicObject currency = parentObj.getDynamicObject(currencyName);
                return CurrencyFormatUtil.getAfterFormatString(currency, value);
            }
            DynamicObject currency = obj.getDynamicObject(currencyName);
            return CurrencyFormatUtil.getAfterFormatString(currency, value);
        }
        if (property instanceof DecimalProp) {
            DecimalProp decimalProp = (DecimalProp)property;
            int scale = decimalProp.getScale();
            BigDecimal decimalValue = new BigDecimal(value.toString());
            return decimalValue.compareTo(BigDecimal.ZERO) == 0 ? "0" : decimalValue.setScale(scale, RoundingMode.HALF_UP).toString();
        }
        if (property instanceof ComboProp) {
            return ((ComboProp)property).getItemByName(value.toString());
        }
        if (property instanceof DateProp) {
            DateProp dateProp = (DateProp)property;
            DateFormat dateFormat = dateProp.getDateFormat();
            return dateFormat.format((Date)value);
        }
        if (property instanceof DateTimeProp) {
            DateTimeProp dateTimeProp = (DateTimeProp)property;
            DateFormat dateFormat = dateTimeProp.getDateFormat();
            return dateFormat.format((Date)value);
        }
        if (property instanceof BasedataProp) {
            String s = ((BasedataProp)property).getDisplayValue(value);
            return s == null ? "" : s;
        }
        if (property instanceof MulBasedataProp) {
            DynamicObjectCollection valueCol = (DynamicObjectCollection)value;
            StringBuilder colNameStr = new StringBuilder();
            for (DynamicObject dynamicObject : valueCol) {
                DynamicObject baseData = dynamicObject.getDynamicObject("fbasedataid");
                String nameField = ((BasedataEntityType)baseData.getDataEntityType()).getNameProperty();
                colNameStr.append(baseData.getString(nameField)).append('\u3001');
            }
            if (valueCol.size() > 0) {
                colNameStr.deleteCharAt(colNameStr.length() - 1);
            }
            return colNameStr.toString();
        }
        if (property instanceof MuliLangTextProp) {
            OrmLocaleValue localeValue = (OrmLocaleValue)value;
            if (localeValue.isEmpty()) {
                return "";
            }
            return localeValue.getLocaleValue() == null ? "" : localeValue.getLocaleValue();
        }
        if (value instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)value).getLocaleValue();
        }
        return value.toString();
    }

    public static String getContListPropValueToString(String propName, MainEntityType dataEntityType, DynamicObject obj, DynamicObject currency, DynamicObject unit) {
        Object value = obj.get(propName);
        IDataEntityProperty property = dataEntityType.findProperty(propName);
        if (null == value) {
            return "";
        }
        if (property instanceof BooleanProp) {
            return (Boolean)value != false ? ResManager.loadKDString((String)"\u662f", (String)"ContractOfficeUtil_1", (String)"pmgt-pmct-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ContractOfficeUtil_2", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        }
        if (property instanceof AmountProp) {
            BigDecimal specValueAmt = BigDecimal.valueOf(Double.parseDouble(value.toString()));
            return CurrencyFormatUtil.getAfterFormatString(currency, specValueAmt);
        }
        if (property instanceof QtyProp) {
            QtyProp qtyProp = (QtyProp)property;
            int precision = qtyProp.getScale();
            if (unit != null) {
                precision = unit.getInt("precision");
            }
            BigDecimal decimalValue = new BigDecimal(value.toString());
            return decimalValue.setScale(precision, RoundingMode.HALF_UP).toString();
        }
        if (property instanceof DecimalProp) {
            DecimalProp decimalProp = (DecimalProp)property;
            int scale = decimalProp.getScale();
            BigDecimal decimalValue = new BigDecimal(value.toString());
            return decimalValue.setScale(scale, RoundingMode.HALF_UP).toString();
        }
        if (property instanceof ComboProp) {
            return ((ComboProp)property).getItemByName(value.toString());
        }
        if (property instanceof DateProp) {
            DateProp dateProp = (DateProp)property;
            DateFormat dateFormat = dateProp.getDateFormat();
            return dateFormat.format((Date)value);
        }
        if (property instanceof DateTimeProp) {
            DateTimeProp dateTimeProp = (DateTimeProp)property;
            DateFormat dateFormat = dateTimeProp.getDateFormat();
            return dateFormat.format((Date)value);
        }
        if (property instanceof BasedataProp) {
            String s = ((DynamicObject)value).get(((BasedataProp)property).getDisplayProp()).toString();
            return s == null ? "" : s;
        }
        if (property instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
            EntityMetadataCache.getDataEntityType((String)mulBasedataProp.getBaseEntityId());
            DynamicObjectCollection valueCol = (DynamicObjectCollection)value;
            StringBuilder colNameStr = new StringBuilder();
            for (DynamicObject dynamicObject : valueCol) {
                DynamicObject baseData = dynamicObject.getDynamicObject("fbasedataid");
                String nameField = ((BasedataEntityType)baseData.getDataEntityType()).getNameProperty();
                colNameStr.append(baseData.getString(nameField)).append('\u3001');
            }
            colNameStr.deleteCharAt(colNameStr.length() - 1);
            return colNameStr.toString();
        }
        if (property instanceof MuliLangTextProp) {
            OrmLocaleValue localeValue = (OrmLocaleValue)value;
            if (localeValue.isEmpty()) {
                return "";
            }
            return localeValue.getLocaleValue() == null ? "" : localeValue.getLocaleValue();
        }
        return value.toString();
    }

    public static String getSpecPropValueToString(String propName, MainEntityType dataEntityType, Object specValue, DynamicObject currency) {
        IDataEntityProperty property = dataEntityType.findProperty(propName);
        if (null == specValue) {
            return "";
        }
        if (property instanceof BooleanProp) {
            return (Boolean)specValue != false ? ResManager.loadKDString((String)"\u662f", (String)"ContractOfficeUtil_1", (String)"pmgt-pmct-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ContractOfficeUtil_2", (String)"pmgt-pmct-common", (Object[])new Object[0]);
        }
        if (property instanceof AmountProp) {
            BigDecimal specValueAmt = BigDecimal.valueOf(Double.parseDouble(specValue.toString()));
            return CurrencyFormatUtil.getAfterFormatString(currency, specValueAmt);
        }
        if (property instanceof ComboProp) {
            return ((ComboProp)property).getItemByName(specValue.toString());
        }
        if (property instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)property;
            String baseEntityId = basedataProp.getBaseEntityId();
            String displayProp = basedataProp.getDisplayProp();
            DynamicObject specObj = BusinessDataServiceHelper.loadSingle((String)baseEntityId, (String)("name," + displayProp), (QFilter[])new QFilter[]{new QFilter("number", "=", specValue)});
            if (specObj != null) {
                return specObj.getString(displayProp);
            }
            return "";
        }
        return specValue.toString();
    }

    public static void renderBillEntry(DynamicObject billObj, BaseDocAdaptor docAdaptor, String propName, WebOffice webOffice, String bookmarkkey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billObj.getDynamicObjectType().getName());
        DynamicObjectCollection collection = docAdaptor.getEntryCollection(billObj, propName);
        propName = docAdaptor.convertPropertyName(propName);
        EntryProp property = (EntryProp)dataEntityType.findProperty(propName);
        EntryType entryType = (EntryType)property.getDynamicCollectionItemPropertyType();
        Map fieldMap = entryType.getFields();
        LinkedHashMap<String, IDataEntityProperty> restructFieldMap = new LinkedHashMap<String, IDataEntityProperty>(fieldMap.size());
        for (Map.Entry fieldEntry : fieldMap.entrySet()) {
            String key = (String)fieldEntry.getKey();
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)fieldEntry.getValue();
            if (docAdaptor.isExcludeField(propName, key, billObj)) continue;
            restructFieldMap.put(key, iDataEntityProperty);
            docAdaptor.addField(propName, restructFieldMap, key, iDataEntityProperty);
        }
        String[][] dataTable = new String[collection.size() + 1][restructFieldMap.size()];
        int k = 0;
        for (Map.Entry entry : restructFieldMap.entrySet()) {
            String key = (String)entry.getKey();
            String fieldName = docAdaptor.getFieldName(key);
            if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
                dataTable[0][k++] = fieldName;
                continue;
            }
            IDataEntityProperty entryProperty = (IDataEntityProperty)entry.getValue();
            LocaleString xLocaleString = entryProperty.getDisplayName();
            dataTable[0][k++] = xLocaleString == null ? "" : xLocaleString.getLocaleValue();
        }
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            int j = 0;
            for (Map.Entry fieldEntry : restructFieldMap.entrySet()) {
                dataTable[i + 1][j++] = ContractOfficeUtil.getPropValueToString((String)fieldEntry.getKey(), dataEntityType, dynamicObject);
            }
        }
        webOffice.addTable(bookmarkkey, dataTable);
    }

    public static void renderContEntry(DynamicObject billObj, MainEntityType dataEntityType, String propName, WebOffice webOffice, String bookmarkkey) {
        DynamicObjectCollection listmodelentry;
        DynamicObjectCollection collection = new DynamicObjectCollection();
        String formId = billObj.getDynamicObjectType().getName();
        if (StringUtils.equals((CharSequence)"pmct_inaddagreement", (CharSequence)formId) || StringUtils.equals((CharSequence)"pmct_outaddagreement", (CharSequence)formId)) {
            if ("entryentity".equals(propName)) {
                listmodelentry = billObj.getDynamicObjectCollection("cardentry");
                for (DynamicObject listModelEntryObj : listmodelentry) {
                    DynamicObjectCollection listEntry = listModelEntryObj.getDynamicObjectCollection("entryentity");
                    for (DynamicObject listEntryObj : listEntry) {
                        collection.add((Object)listEntryObj);
                    }
                }
            } else {
                collection = billObj.getDynamicObjectCollection(propName);
            }
        } else if (StringUtils.equals((CharSequence)"pmct_strategicagreement", (CharSequence)formId)) {
            collection = billObj.getDynamicObjectCollection(propName);
        } else if (StringUtils.equals((CharSequence)"pmct_outcontract", (CharSequence)formId) || StringUtils.equals((CharSequence)"pmct_strategicagreement", (CharSequence)formId)) {
            if ("treelistentry".equals(propName)) {
                listmodelentry = billObj.getDynamicObjectCollection("listmodelentry");
                for (DynamicObject dynamicObject : listmodelentry) {
                    DynamicObjectCollection sublistentry = dynamicObject.getDynamicObjectCollection("sublistentry");
                    for (DynamicObject sub : sublistentry) {
                        collection.add((Object)sub);
                    }
                }
                propName = "sublistentry";
            } else {
                collection = billObj.getDynamicObjectCollection(propName);
            }
        }
        EntryProp property = (EntryProp)dataEntityType.findProperty(propName);
        EntryType entryType = (EntryType)property.getDynamicCollectionItemPropertyType();
        Map fields = entryType.getFields();
        String[][] dataTable = StringUtils.equals((CharSequence)propName, (CharSequence)"sublistentry") ? new String[collection.size() + 1][fields.size() - 1] : (StringUtils.equals((CharSequence)propName, (CharSequence)"pricedetailentry") ? new String[collection.size() + 1][fields.size() - 2] : new String[collection.size() + 1][fields.size()]);
        int k = 0;
        for (Map.Entry entry : fields.entrySet()) {
            if (ContractOfficeUtil.hideField((String)entry.getKey())) continue;
            IDataEntityProperty entryProperty = (IDataEntityProperty)entry.getValue();
            LocaleString xLocaleString = entryProperty.getDisplayName();
            dataTable[0][k++] = xLocaleString == null ? "" : xLocaleString.getLocaleValue();
        }
        for (int i = 0; i < collection.size(); ++i) {
            boolean bl = false;
            for (Map.Entry fieldEntry : fields.entrySet()) {
                if (ContractOfficeUtil.hideField((String)fieldEntry.getKey())) continue;
                dataTable[i + 1][++var13_17] = ContractOfficeUtil.getPropValueToString((String)fieldEntry.getKey(), dataEntityType, (DynamicObject)collection.get(i));
            }
        }
        webOffice.addTable(bookmarkkey, dataTable);
    }

    private static boolean hideField(String proName) {
        if ("level".equals(proName)) {
            return true;
        }
        return "isGroupNode".equals(proName);
    }

    public static void renderContract(IFormView view, WebOffice webOffice, DynamicObject contTemp, DynamicObject billObj) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billObj.getDynamicObjectType().getName());
        String formId = billObj.getDynamicObjectType().getName();
        BaseDocAdaptor docAdaptor = new ContractDocAdaptor();
        if (StringUtils.equals((CharSequence)"pmct_inaddagreement", (CharSequence)formId) || StringUtils.equals((CharSequence)"pmct_outaddagreement", (CharSequence)formId)) {
            docAdaptor = new ContAdditionDocAdaptor();
        } else if (StringUtils.equals((CharSequence)"pmct_strategicagreement", (CharSequence)formId)) {
            docAdaptor = new StrategeDocAdaptor();
        }
        docAdaptor.setBillFieldValue(billObj);
        DynamicObjectCollection bookMarkEntryCol = contTemp.getDynamicObjectCollection("bookmarkentry");
        ArrayList<WebOfficeMark> marks = new ArrayList<WebOfficeMark>();
        for (DynamicObject bookMark : bookMarkEntryCol) {
            String propName = bookMark.getString("bookmarkprop");
            String bookmarkkey = bookMark.getString("bookmarkkey");
            String bookMarkType = bookMark.getString("bookmarktype");
            String value = "";
            if (StringUtils.equals((CharSequence)FieldTypeEnum.MANUAL.getValue(), (CharSequence)bookMarkType)) continue;
            if (StringUtils.equals((CharSequence)FieldTypeEnum.ENTRY.getValue(), (CharSequence)bookMarkType) || StringUtils.equals((CharSequence)FieldTypeEnum.TREEENTRY.getValue(), (CharSequence)bookMarkType) || StringUtils.equals((CharSequence)FieldTypeEnum.SUBENTYR.getValue(), (CharSequence)bookMarkType)) {
                ContractOfficeUtil.renderBillEntry(billObj, docAdaptor, propName, webOffice, bookmarkkey);
                continue;
            }
            value = ContractOfficeUtil.getPropValueToString(propName, dataEntityType, billObj);
            marks.add(new WebOfficeMark(bookmarkkey, value));
        }
        if (!marks.isEmpty()) {
            webOffice.modifyMarks(marks);
        }
    }

    public static String generateAttPath(String fileDir) {
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)"ecwebfffice", (String)fileDir) + "/";
    }

    public static String generateTplPath(String fileName) {
        return ContractOfficeUtil.generateAttPath(TPLDOC) + System.currentTimeMillis() + '/' + fileName;
    }

    public static String generateBillDocPath(String fileName) {
        return ContractOfficeUtil.generateAttPath(BILLDOC) + System.currentTimeMillis() + '/' + fileName;
    }

    public static <T extends AbstractFormPlugin> void openSelectbodytpl(T formPlugin) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", "pmct_selectbodytpl");
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack(formPlugin, "pmct_selectbodytpl"));
        IFormView view = formPlugin.getView();
        String formId = view.getFormShowParameter().getFormId();
        IDataModel model = view.getModel();
        Object contTypeId = null;
        String contTemplateType = null;
        if (StringUtils.equals((CharSequence)"pmct_outcontract", (CharSequence)formId)) {
            contTypeId = ((DynamicObject)model.getValue("contracttype")).getPkValue();
            contTemplateType = ContTemplateTypeEnum.OUT.getValue();
        } else if (StringUtils.equals((CharSequence)"pmct_incontract", (CharSequence)formId)) {
            contTypeId = ((DynamicObject)model.getValue("contracttype")).getPkValue();
            contTemplateType = ContTemplateTypeEnum.IN.getValue();
        } else if (StringUtils.equals((CharSequence)"pmct_strategicagreement", (CharSequence)formId)) {
            contTypeId = ((DynamicObject)model.getValue("agreementtype")).getPkValue();
            contTemplateType = ContTemplateTypeEnum.STRATEGICAGREEMENT.getValue();
        } else if (StringUtils.equals((CharSequence)"pmct_outaddagreement", (CharSequence)formId)) {
            contTypeId = ((DynamicObject)model.getValue("contract")).getDynamicObject("contracttype").getPkValue();
            contTemplateType = ContTemplateTypeEnum.OUTADDAGREEMENT.getValue();
        } else if (StringUtils.equals((CharSequence)"pmct_inaddagreement", (CharSequence)formId)) {
            contTypeId = ((DynamicObject)model.getValue("contract")).getDynamicObject("contracttype").getPkValue();
            contTemplateType = ContTemplateTypeEnum.INADDAGREEMENT.getValue();
        } else if (StringUtils.equals((CharSequence)"pmct_contbilldesign", (CharSequence)formId)) {
            Long contdocBillid = (Long)model.getValue("conttempid");
            DynamicObject contTemplate = BusinessDataServiceHelper.loadSingle((Object)contdocBillid, (String)"pmct_conttemplate", (String)"conttemplatetype");
            contTemplateType = contTemplate.getString("conttemplatetype");
            Long billId = (Long)model.getValue("contractid");
            String billForm = ContractOfficeUtil.getBillFormByTplType(contTemplateType);
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billForm);
            contTypeId = contTemplateType.equals(ContTemplateTypeEnum.IN.getValue()) || contTemplateType.equalsIgnoreCase(ContTemplateTypeEnum.OUT.getValue()) ? bill.getDynamicObject("contracttype").getPkValue() : (contTemplateType.equals(ContTemplateTypeEnum.STRATEGICAGREEMENT.getValue()) ? bill.getDynamicObject("agreementtype").getPkValue() : bill.getDynamicObject("contract").getDynamicObject("contracttype").getPkValue());
            Object contTempId = formPlugin.getView().getModel().getValue("conttempid");
            parameter.setCustomParam("conttempid", contTempId);
        }
        parameter.setCustomParam("contracttype", contTypeId);
        parameter.setCustomParam("conttemplatetype", (Object)contTemplateType);
        formPlugin.getView().showForm(parameter);
    }

    private static String getBillFormByTplType(String conttemplatetype) {
        String billFormId = "pmct_incontract";
        if (StringUtils.equals((CharSequence)ContTemplateTypeEnum.OUT.getValue(), (CharSequence)conttemplatetype)) {
            billFormId = "pmct_outcontract";
        } else if (StringUtils.equals((CharSequence)ContTemplateTypeEnum.OUTADDAGREEMENT.getValue(), (CharSequence)conttemplatetype)) {
            billFormId = "pmct_outaddagreement";
        } else if (StringUtils.equals((CharSequence)ContTemplateTypeEnum.INADDAGREEMENT.getValue(), (CharSequence)conttemplatetype)) {
            billFormId = "pmct_inaddagreement";
        } else if (StringUtils.equals((CharSequence)ContTemplateTypeEnum.STRATEGICAGREEMENT.getValue(), (CharSequence)conttemplatetype)) {
            billFormId = "pmct_strategicagreement";
        }
        return billFormId;
    }
}

