/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.utils;

import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;

public class HttpClientUtils {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static SSLConnectionSocketFactory sslsf = null;
    private static PoolingHttpClientConnectionManager cm = null;
    private static final Log log = LogFactory.getLog(HttpClientUtils.class);
    private static SSLContextBuilder builder = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String HttpPostWithJson(String url, String json) {
        String returnValue = "";
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity requestEntity = new StringEntity(json, "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity((HttpEntity)requestEntity);
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            log.info("info", (Object)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.info("info", (Object)e);
            }
        }
        return returnValue;
    }

    public static CloseableHttpClient getHttpClient() {
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)cm).setConnectionManagerShared(true).build();
        return httpClient;
    }

    static {
        try {
            builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(x509Certificates, s) -> true));
            sslsf = new SSLConnectionSocketFactory(builder.build(), new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registry = RegistryBuilder.create().register(HTTP, (Object)new PlainConnectionSocketFactory()).register(HTTPS, (Object)sslsf).build();
            cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(200);
        }
        catch (Exception e) {
            log.info("info", (Object)e);
        }
    }
}

