/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ShowBankUtils {
    public static boolean hasDefaultBankInfo(DynamicObject customer) {
        if (customer == null) {
            return false;
        }
        String entity = customer.getDataEntityType().getName();
        customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)entity);
        DynamicObjectCollection bankCollection = customer.getDynamicObjectCollection("entry_bank");
        DynamicObject defaultBankAccountInfo = null;
        boolean existDefaultBankAccount = false;
        if (!bankCollection.isEmpty()) {
            for (DynamicObject dynamicObject : bankCollection) {
                if (!dynamicObject.getBoolean("isdefault_bank")) continue;
                defaultBankAccountInfo = dynamicObject;
                existDefaultBankAccount = true;
                break;
            }
            if (!existDefaultBankAccount) {
                defaultBankAccountInfo = (DynamicObject)bankCollection.get(0);
            }
            return defaultBankAccountInfo != null;
        }
        return false;
    }

    public static ListShowParameter getBankInfoShowParameter(Object pk, String formId) {
        DynamicObjectCollection entryBank;
        Set<Object> entryIds = new HashSet(16);
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)pk, (String)formId);
        if (supplier != null && !(entryBank = supplier.getDynamicObjectCollection("entry_bank")).isEmpty()) {
            entryIds = entryBank.stream().map(it -> Long.parseLong(it.getPkValue().toString())).collect(Collectors.toSet());
        }
        ArrayList<String> showFields = new ArrayList<String>();
        showFields.add("name");
        showFields.add("bank.name");
        showFields.add("bankaccount");
        showFields.add("accountname");
        showFields.add("currency.name");
        showFields.add("isdefault_bank");
        ListShowParameter lsp = ShowBankUtils.createDynamicListShowParameter(formId, "entry_bank", showFields);
        ListFilterParameter lfp = new ListFilterParameter();
        if (!entryIds.isEmpty()) {
            lfp.setFilter(new QFilter("entry_bank.id", "in", entryIds));
        } else {
            lfp.setFilter(new QFilter("entry_bank.id", "=", (Object)0L));
        }
        lsp.setListFilterParameter(lfp);
        if ("bd_customer".equals(formId)) {
            lsp.setCaption(ResManager.loadKDString((String)"\u5ba2\u6237-\u94f6\u884c\u4fe1\u606f", (String)"ShowBankUtils_0", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        } else {
            lsp.setCaption(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546-\u94f6\u884c\u4fe1\u606f", (String)"ShowBankUtils_1", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        }
        return lsp;
    }

    public static ListShowParameter createDynamicListShowParameter(String entity, String entry, List<String> showFields) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entity, (boolean)false, (int)2);
        lsp.setCustomParam("entity", (Object)entity);
        lsp.setCustomParam("entry", (Object)entry);
        lsp.setCustomParam("isEntryMain", (Object)Boolean.TRUE);
        lsp.setCustomParam("showFields", showFields);
        ShowBankUtils.clearPlugins(lsp);
        ShowBankUtils.registerScript("kingdee.pmgt.pmct.mainpage.pmctdynamiclistscriptplugin", lsp);
        ShowBankUtils.setMergeRow(false, lsp);
        lsp.setAppId("pmct");
        return lsp;
    }

    private static void clearPlugins(ListShowParameter lsp) {
        List plugins = ShowBankUtils.getOrCreateFormConfig(lsp).getPlugins();
        plugins.clear();
    }

    private static FormConfig getOrCreateFormConfig(ListShowParameter lsp) {
        FormConfig formConfig = lsp.getFormConfig();
        if (formConfig == null) {
            formConfig = FormMetadataCache.getFormConfig((String)lsp.getFormId());
            lsp.setFormConfig(formConfig);
        }
        return formConfig;
    }

    private static void registerScript(String script, ListShowParameter lsp) {
        List plugins = ShowBankUtils.getOrCreateFormConfig(lsp).getPlugins();
        Plugin p = new Plugin();
        p.setClassName(script);
        p.setType(1);
        plugins.add(p);
    }

    private static void setMergeRow(boolean mergeRow, ListShowParameter lsp) {
        Map listUserOptions = ParameterHelper.getListOptions((long)RequestContext.get().getCurrUserId(), (String)lsp.getBillFormId(), (String)ShowBankUtils.getOrCreateFormConfig(lsp).getListUserOption(), null);
        ListUserOption listUserOption = new ListUserOption(listUserOptions);
        listUserOption.setMergeRow(mergeRow);
        lsp.setListUserOption(listUserOption);
    }

    public static DynamicObject loadBankInfo(Long entryPk, String formId) {
        DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingle((String)formId, (String)"entry_bank.bankaccount, entry_bank.accountname, entry_bank.bank, entry_bank.isdefault_bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", (Object)entryPk)});
        if (customerOrSupplier != null) {
            DynamicObjectCollection entryBanks = customerOrSupplier.getDynamicObjectCollection("entry_bank");
            for (DynamicObject row : entryBanks) {
                if (!row.getPkValue().equals(entryPk)) continue;
                return row;
            }
        }
        return null;
    }
}

