/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class StrategicExcelUtils {
    public static JSONArray newInputExcel(String url, String coulmnHashCode, Log logger) {
        JSONArray jsonArray = new JSONArray();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            try {
                Workbook wb = WorkbookFactory.create((InputStream)in);
                Sheet sheet = wb.getSheetAt(0);
                int rowNum = sheet.getLastRowNum();
                if (rowNum <= 2) {
                    return jsonArray;
                }
                Row columnKeyRow = sheet.getRow(1);
                Row headerRow = sheet.getRow(2);
                Row columnKeyHashRow = sheet.getRow(0);
                columnKeyHashRow.getCell(0).setCellType(CellType.STRING);
                String columnKeyHashCellValue = columnKeyHashRow.getCell(0).getStringCellValue();
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)columnKeyHashCellValue, (CharSequence)coulmnHashCode)) {
                    return jsonArray;
                }
                int columnNum = columnKeyRow.getLastCellNum();
                for (int j = 3; j <= rowNum; ++j) {
                    JSONArray jsonRow = new JSONArray();
                    Row iRow = sheet.getRow(j);
                    if (iRow == null) continue;
                    for (int i = 0; i < columnNum; ++i) {
                        JSONObject jsonObject = new JSONObject();
                        Cell columnKeyRowCell = columnKeyRow.getCell(i);
                        Cell headRowCell = headerRow.getCell(i);
                        columnKeyRowCell.setCellType(CellType.STRING);
                        headRowCell.setCellType(CellType.STRING);
                        jsonObject.put("columnKey", (Object)columnKeyRowCell.getStringCellValue());
                        jsonObject.put("columnName", (Object)headRowCell.getStringCellValue());
                        Cell cell = iRow.getCell(i);
                        if (cell != null) {
                            if (cell.getCellType() == CellType.NUMERIC) {
                                cell.setCellType(CellType.NUMERIC);
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    jsonObject.put("cellValue", (Object)cell.getDateCellValue());
                                } else {
                                    jsonObject.put("cellValue", (Object)cell.getNumericCellValue());
                                }
                            } else {
                                cell.setCellType(CellType.STRING);
                                jsonObject.put("cellValue", (Object)cell.getStringCellValue());
                            }
                        } else {
                            jsonObject.put("cellValue", null);
                        }
                        jsonRow.add((Object)jsonObject);
                    }
                    jsonArray.add((Object)jsonRow);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return jsonArray;
    }

    public static String[] getExcelColumnKey() {
        return new String[]{"listnumber", "listname", "materiel", "measureunit", "qty", "pricewithtax", "pricewithouttax", "tax", "amountwithtax", "amountwithouttax", "taxamount", "note", "parentlistnumber"};
    }

    public static void importFromExcel(ClosedCallBackEvent closedCallBackEvent, Log logger, IFormView view, IDataModel model) {
        String url = (String)closedCallBackEvent.getReturnData();
        if (url == null || "".equals(url.trim())) {
            return;
        }
        String columnKeyHash = POIHelper.stringArrayToHash((String[])StrategicExcelUtils.getExcelColumnKey());
        JSONArray jsonArray = StrategicExcelUtils.newInputExcel(url, columnKeyHash, logger);
        if (jsonArray == null || jsonArray.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u5339\u914d\u6216\u5bfc\u5165\u6570\u636e\u662f\u5426\u4e3a\u7a7a\u3002", (String)"StrategicExcelUtils_0", (String)"pmgt-pmct-common", (Object[])new Object[0]));
            return;
        }
        QFilter nameFilter = null;
        HashMap<Long, String> parentMap = new HashMap<Long, String>(16);
        HashMap<String, Long> nameMap = new HashMap<String, Long>(16);
        HashSet<String> parentNameSet = new HashSet<String>(16);
        HashMap<String, DynamicObject> parentEntryMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection entries = model.getEntryEntity("pricedetailentry");
        DynamicObjectType entryDt = entries.getDynamicObjectType();
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
        for (Object json : jsonArray) {
            JSONArray jArray = JSONArray.parseArray((String)json.toString());
            DynamicObject entry = new DynamicObject(entryDt);
            ORM orm = ORM.create();
            Long entryId = orm.genLongId((IDataEntityType)entryDt);
            entry.set("id", (Object)entryId);
            entry.set("isleaf", (Object)"1");
            Iterator iterator = jArray.iterator();
            block15: while (iterator.hasNext()) {
                Object jsonObject = iterator.next();
                JSONObject jObject = JSONObject.parseObject((String)jsonObject.toString());
                String columnKey = jObject.getString("columnKey");
                String value = jObject.get((Object)"cellValue") != null ? jObject.get((Object)"cellValue").toString() : "";
                nameFilter = new QFilter("name", "=", (Object)value);
                switch (columnKey) {
                    case "listnumber": {
                        entry.set("listnumber", (Object)value);
                        nameMap.put(value, entryId);
                        parentEntryMap.put(value, entry);
                        continue block15;
                    }
                    case "materiel": {
                        QFilter numberFilter = new QFilter("number", "=", (Object)value);
                        DynamicObject materiel = BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"id,number,name", (QFilter[])new QFilter[]{numberFilter});
                        entry.set("materiel", (Object)materiel);
                        continue block15;
                    }
                    case "measureunit": {
                        DynamicObject measureunit = BusinessDataServiceHelper.loadSingle((String)"bd_measureunits", (String)"id,number,name", (QFilter[])new QFilter[]{nameFilter});
                        entry.set("measureunit", (Object)measureunit);
                        continue block15;
                    }
                    case "tax": {
                        QFilter taxrateFilter = new QFilter("taxrate", "=", (Object)new BigDecimal(jObject.getString("cellValue")));
                        DynamicObject taxRate = BusinessDataServiceHelper.loadSingle((String)"bd_taxrate", (String)"id,number,name,taxrate", (QFilter[])new QFilter[]{taxrateFilter});
                        entry.set("tax", (Object)taxRate);
                        continue block15;
                    }
                    case "parentlistnumber": {
                        parentMap.put(entryId, value);
                        if (StringUtils.equals((CharSequence)"", (CharSequence)value)) continue block15;
                        parentNameSet.add(value);
                        continue block15;
                    }
                }
                entry.set(columnKey, jObject.get((Object)"cellValue"));
            }
            entryList.add(entry);
        }
        DynamicObject currency = model.getDataEntity().getDynamicObject("currency");
        int pricePrecision = 10;
        if (currency != null) {
            pricePrecision = currency.getInt("priceprecision");
        }
        for (DynamicObject entry : entryList) {
            DynamicObject parent;
            Long parentId;
            String parentName;
            String listNumber = entry.getString("listnumber");
            if (parentNameSet.contains(listNumber)) {
                entry.set("isleaf", (Object)Boolean.FALSE);
            }
            if (!StringUtils.equals((CharSequence)"", (CharSequence)(parentName = (String)parentMap.get(entry.getLong("id")))) && (parentId = (Long)nameMap.get(parentName)) != null) {
                entry.set("pid", (Object)parentId);
            }
            entry.set("level", (Object)((parent = (DynamicObject)parentEntryMap.get(parentName)) == null ? 1 : parent.getInt("level") + 1));
            BigDecimal priceWithTax = entry.getBigDecimal("pricewithtax");
            BigDecimal qty = entry.getBigDecimal("qty");
            entry.set("amountwithtax", (Object)priceWithTax.multiply(qty).setScale(pricePrecision, RoundingMode.HALF_UP));
            DynamicObject tax = entry.getDynamicObject("tax");
            BigDecimal taxValue = tax.getBigDecimal("taxrate").divide(BigDecimal.valueOf(100L)).add(BigDecimal.ONE);
            entry.set("pricewithouttax", (Object)priceWithTax.divide(taxValue, pricePrecision, RoundingMode.HALF_UP));
        }
        entries = model.getEntryEntity("pricedetailentry");
        entries.addAll(entryList);
        model.updateEntryCache(entries);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)view.getControl("pricedetailentry");
        treeEntryGrid.setCollapse(false);
        view.updateView("pricedetailentry");
    }
}

