/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.report.form;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.common.enums.CtrlStrategyEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class OutContractReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private String[] payPlanTitle = new String[]{ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"OutContractReportFormPlugin_5", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"OutContractReportFormPlugin_6", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u652f\u51fa\u7c7b\u578b", (String)"OutContractReportFormPlugin_7", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u652f\u4ed8\u9891\u6b21", (String)"OutContractReportFormPlugin_8", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u65b9\u5f0f", (String)"OutContractReportFormPlugin_9", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u6bd4\u4f8b\uff08%\uff09", (String)"OutContractReportFormPlugin_10", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d", (String)"OutContractReportFormPlugin_11", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u4ed8\u6b3e\u65e5\u671f", (String)"OutContractReportFormPlugin_12", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u8282\u70b9\u8bbe\u7f6e", (String)"OutContractReportFormPlugin_64", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565", (String)"OutContractReportFormPlugin_65", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210\u72b6\u6001", (String)"OutContractReportFormPlugin_66", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0", (String)"OutContractReportFormPlugin_67", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u7533\u8bf7\u91d1\u989d", (String)"OutContractReportFormPlugin_68", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u7533\u8bf7\u91d1\u989d\uff08\u542b\u5728\u9014\uff09", (String)"OutContractReportFormPlugin_69", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53ef\u7533\u8bf7\u91d1\u989d", (String)"OutContractReportFormPlugin_70", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u62a5\u9500\u91d1\u989d", (String)"OutContractReportFormPlugin_13", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u62a5\u9500\u91d1\u989d(\u542b\u5728\u9014)", (String)"OutContractReportFormPlugin_60", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53ef\u62a5\u9500\u91d1\u989d", (String)"OutContractReportFormPlugin_61", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u652f\u4ed8\u91d1\u989d", (String)"OutContractReportFormPlugin_14", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u652f\u4ed8\u91d1\u989d(\u542b\u5728\u9014)", (String)"OutContractReportFormPlugin_62", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672a\u652f\u4ed8\u91d1\u989d", (String)"OutContractReportFormPlugin_63", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf4\u660e", (String)"OutContractReportFormPlugin_16", (String)"pmgt-pmct-report", (Object[])new Object[0])};

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject dyn : rowData) {
            BigDecimal totalRevisionOfTaxAmount = dyn.getBigDecimal("totalrevisionoftaxamount");
            BigDecimal totalClaimOfTaxAmount = dyn.getBigDecimal("totalclaimoftaxamount");
            BigDecimal totalAdditionOfTaxAmt = dyn.getBigDecimal("totaladditionoftaxamt");
            dyn.set("allchangeamount", (Object)totalRevisionOfTaxAmount.add(totalClaimOfTaxAmount).add(totalAdditionOfTaxAmt));
            BigDecimal totalOfTaxAmount = dyn.getBigDecimal("totaloftaxamount");
            BigDecimal totalSettleOfTaxAmount = dyn.getBigDecimal("totalsettleoftaxamount");
            dyn.set("totalunsettleamount", (Object)totalOfTaxAmount.subtract(totalSettleOfTaxAmount));
            BigDecimal totalRealOfTaxAmount = dyn.getBigDecimal("totalrealoftaxamount");
            dyn.set("totalunrealoftaxamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
            BigDecimal totalInvoiceOftaxAmount = dyn.getBigDecimal("totalinvoiceoftaxamount");
            dyn.set("uninvoiceamt", (Object)totalSettleOfTaxAmount.subtract(totalInvoiceOftaxAmount));
            dyn.set("sumuninvoiceamt", (Object)totalOfTaxAmount.subtract(totalInvoiceOftaxAmount));
        }
        this.handleApplyAmount(rowData);
    }

    protected void handleApplyAmount(DynamicObjectCollection rowData) {
        HashMap<Object, BigDecimal> amountMap = new HashMap<Object, BigDecimal>(16);
        List contractIds = rowData.stream().map(o -> o.getDynamicObject("contract").getPkValue()).collect(Collectors.toList());
        if (contractIds.size() > 0) {
            DynamicObject[] payments;
            QFilter qFilter = new QFilter("contract", "in", contractIds);
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatus.C));
            for (DynamicObject payment : payments = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"contract,curpaytotal", (QFilter[])new QFilter[]{qFilter})) {
                Object contractId = payment.getDynamicObject("contract").getPkValue();
                BigDecimal curPayTotal = payment.getBigDecimal("curpaytotal");
                if (amountMap.containsKey(contractId)) {
                    amountMap.put(contractId, ((BigDecimal)amountMap.get(contractId)).add(curPayTotal));
                    continue;
                }
                amountMap.put(contractId, curPayTotal);
            }
        }
        for (DynamicObject dyn : rowData) {
            DynamicObject contract = dyn.getDynamicObject("contract");
            BigDecimal applymentPay = (BigDecimal)amountMap.get(contract.getPkValue());
            if (applymentPay == null) continue;
            dyn.set("totalapplyoftaxamount", (Object)dyn.getBigDecimal("totalapplyoftaxamount").add(applymentPay));
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData("payitementryentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        list.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit paynodeSetting = (BasedataEdit)this.getControl("paynodesetting");
        paynodeSetting.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            int rowKey = beforeF7ViewDetailEvent.getRowKey();
            DynamicObject payItemEntryRow = this.getModel().getEntryRowEntity("payitementryentity", rowKey);
            String nodeSettingSource = payItemEntryRow.getString("nodesettingsource");
            if (NodeSettingSourceEnum.PMBS_TASK.getValue().equals(nodeSettingSource)) {
                DynamicObject task = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("id", "in", beforeF7ViewDetailEvent.getPkId())});
                if (task != null) {
                    boolean islatest = task.getBoolean("islatest");
                    if (islatest) {
                        this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (Object)task.getPkValue()));
                    } else {
                        task = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("sourcetask", "in", task.get("sourcetask.id")), new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue())});
                        if (task != null) {
                            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (Object)task.getPkValue()));
                        }
                    }
                }
            } else if ("pmbs_wbs".equals(nodeSettingSource)) {
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmbs_wbs", (Object)beforeF7ViewDetailEvent.getPkId()));
            } else {
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmbs_workexecution", (Object)beforeF7ViewDetailEvent.getPkId()));
            }
        });
    }

    public void entryRowClick(RowClickEvent evt) {
        int clickRowIndex = evt.getRow();
        if (clickRowIndex < 0) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("payitementryentity");
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData("payitementryentity");
        ReportList list = (ReportList)this.getControl("reportlistap");
        DynamicObject contract = (DynamicObject)list.getReportModel().getValue(clickRowIndex, "contract");
        this.loadRefContractEntry(contract);
        this.loadPayItemEntry(contract);
    }

    @NotNull
    public void loadRefContractEntry(DynamicObject contract) {
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        if (null != contract.getDynamicObject("contract")) {
            filter.or(new QFilter("id", "=", contract.getDynamicObject("contract").getPkValue()));
        }
        String selector = Stream.of("project", "billstatus", "createorg", "currency", "contracttype", "originaloftaxamount", "totaloftaxamount", "totalsettleoftaxamount", "totalapplyoftaxamount", "totalrealoftaxamount", "totalinvoiceoftaxamount", "totalclaimoftaxamount", "totalrevisionoftaxamount", "paydirection", "totaladditionoftaxamt").collect(Collectors.joining(","));
        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"pmct_contractf7", (String)selector, (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection outContractCol = this.getModel().getEntryEntity("entryentity");
        DynamicObjectType outContEntryDT = outContractCol.getDynamicObjectType();
        for (DynamicObject cont : contracts) {
            DynamicObject outContEntry = new DynamicObject(outContEntryDT);
            outContEntry.set("refpaydirection", (Object)(PayDirectionEnum.OUT.getValue().equals(cont.getString("paydirection")) ? ResManager.loadKDString((String)"\u652f\u51fa\u5408\u540c", (String)"OutContractReportFormPlugin_0", (String)"pmgt-pmct-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c", (String)"OutContractReportFormPlugin_1", (String)"pmgt-pmct-report", (Object[])new Object[0])));
            outContEntry.set("refcontract", (Object)cont);
            BigDecimal totalAmt = cont.getBigDecimal("totaloftaxamount");
            BigDecimal totalClaimAmt = cont.getBigDecimal("totalclaimoftaxamount");
            BigDecimal totalAdditionOfTaxAmt = cont.getBigDecimal("totaladditionoftaxamt");
            BigDecimal totalRevisionAmt = cont.getBigDecimal("totalrevisionoftaxamount");
            BigDecimal totalSettleAmt = cont.getBigDecimal("totalsettleoftaxamount");
            BigDecimal totalRealAmt = cont.getBigDecimal("totalrealoftaxamount");
            BigDecimal totalInvoiceAmt = cont.getBigDecimal("totalinvoiceoftaxamount");
            outContEntry.set("refcurrency", (Object)cont.getDynamicObject("currency"));
            outContEntry.set("refproject", (Object)cont.getDynamicObject("project"));
            outContEntry.set("ref_originaloftaxamount", cont.get("originaloftaxamount"));
            outContEntry.set("ref_changeamount", (Object)totalClaimAmt.add(totalRevisionAmt).add(totalAdditionOfTaxAmt));
            outContEntry.set("ref_totaloftaxamount", (Object)totalAmt);
            outContEntry.set("reftotalsettleoftaxamount", (Object)totalSettleAmt);
            outContEntry.set("ref_totalunsettleamount", (Object)totalAmt.subtract(totalSettleAmt));
            outContEntry.set("ref_totalapplyoftaxamount", (Object)cont.getBigDecimal("totalapplyoftaxamount"));
            outContEntry.set("ref_totalrealoftaxamount", (Object)totalRealAmt);
            outContEntry.set("reftotalunrealoftaxamount", (Object)totalSettleAmt.subtract(totalRealAmt));
            outContEntry.set("ref_totalinvoiceoftaxamt", (Object)totalInvoiceAmt);
            outContEntry.set("ref_uninvoiceamt", (Object)totalSettleAmt.subtract(totalInvoiceAmt));
            outContractCol.add((Object)outContEntry);
        }
        this.getModel().updateEntryCache(outContractCol);
        this.getView().updateView("entryentity");
    }

    public void loadPayItemEntry(DynamicObject contract) {
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"paytype,payfeq,payway,paypercent,payamount,planpaytime,remarks,reimbursedamt,paidamt,currency,reimbursedcomamt,reimbursableamt,paidcomamt,unpaidamt,nodesetting,nodesettingsource,taskcompletestatus,name,appliedamt,appliedcomamt,appliableamt", (QFilter[])new QFilter[]{contractFilter, statusFilter});
        DynamicObjectCollection payItemEntryEntity = this.getModel().getEntryEntity("payitementryentity");
        DynamicObjectType payItemEntryDT = payItemEntryEntity.getDynamicObjectType();
        Map srcObjCompleteMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])payItems);
        for (DynamicObject payItem : payItems) {
            DynamicObject payItemEntry = new DynamicObject(payItemEntryDT);
            payItemEntry.set("payitem", (Object)payItem);
            payItemEntry.set("itemcurrency", (Object)payItem.getDynamicObject("currency"));
            payItemEntry.set("paytype", (Object)payItem.getString("paytype"));
            payItemEntry.set("payfeq", (Object)payItem.getString("payfeq"));
            payItemEntry.set("paypercent", (Object)payItem.getString("paypercent"));
            payItemEntry.set("payamountoftax", payItem.get("payamount"));
            DynamicObject nodeSetting = payItem.getDynamicObject("nodesetting");
            payItemEntry.set("paynodesetting", (Object)nodeSetting);
            String nodeSettingSource = payItem.getString("nodesettingsource");
            payItemEntry.set("nodesettingsource", (Object)nodeSettingSource);
            if (nodeSetting != null) {
                Map nodeObjCompMap = (Map)srcObjCompleteMap.get(nodeSettingSource);
                payItemEntry.set("taskcompletestatus", nodeObjCompMap != null ? nodeObjCompMap.get(nodeSetting.getPkValue()) : "");
            }
            payItemEntry.set("appliedamt", payItem.get("appliedamt"));
            payItemEntry.set("appliedcomamt", payItem.get("appliedcomamt"));
            payItemEntry.set("appliableamt", payItem.get("appliableamt"));
            payItemEntry.set("reimbursedamt", payItem.get("reimbursedamt"));
            payItemEntry.set("reimbursedcomamt", payItem.get("reimbursedcomamt"));
            payItemEntry.set("reimbursableamt", payItem.get("reimbursableamt"));
            payItemEntry.set("paidamt", payItem.get("paidamt"));
            payItemEntry.set("paidcomamt", payItem.get("paidcomamt"));
            payItemEntry.set("unpaidamt", payItem.get("unpaidamt"));
            payItemEntryEntity.add((Object)payItemEntry);
        }
        this.getModel().updateEntryCache(payItemEntryEntity);
        this.getView().updateView("payitementryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        int rowIndex = event.getRowIndex();
        ReportList list = (ReportList)this.getControl("reportlistap");
        if (fieldName.equals("contract")) {
            long projectId;
            Map permMap;
            DynamicObject contract = (DynamicObject)list.getReportModel().getValue(rowIndex, fieldName);
            DynamicObject project = contract.getDynamicObject("project");
            boolean teamPermSysParam = ProjectPermFilterHelper.getTeamPermSysParam();
            if (project != null && teamPermSysParam && (permMap = ProjectTeamPermissionHelper.judgeIsHasProOpPerm((Long)(projectId = Long.parseLong(project.getPkValue().toString())), (String)"pmct_outcontractrpt", (String)"reportquery", (Long)RequestContext.get().getCurrUserId())).containsKey("noHasPerm")) {
                this.getView().showTipNotification((String)permMap.get("noHasPerm"));
                return;
            }
            long id = contract.getLong("id");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "pmct_outcontract");
            map.put("pkId", String.valueOf(id));
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(parameter);
        } else if (fieldName.equals("refcontract")) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue(fieldName, rowIndex);
            long id = contract.getLong("id");
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("formId", ResManager.loadKDString((String)"\u652f\u51fa\u5408\u540c", (String)"OutContractReportFormPlugin_0", (String)"pmgt-pmct-report", (Object[])new Object[0]).equals(this.getModel().getValue("refpaydirection")) ? "pmct_outcontract" : "pmct_incontract");
            map.put("pkId", Long.toString(id));
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        } else if (fieldName.equals("project") || fieldName.equals("refproject")) {
            Map permMap;
            DynamicObject project = StringUtils.equals((CharSequence)"project", (CharSequence)fieldName) ? (DynamicObject)list.getReportModel().getValue(rowIndex, fieldName) : (DynamicObject)this.getModel().getValue(fieldName, rowIndex);
            if (project == null) {
                return;
            }
            Long projectId = project.getLong("id");
            boolean teamPermSysParam = ProjectPermFilterHelper.getTeamPermSysParam();
            if (teamPermSysParam && (permMap = ProjectTeamPermissionHelper.judgeIsHasProOpPerm((Long)projectId, (String)"pmct_outcontractrpt", (String)"reportquery", (Long)RequestContext.get().getCurrUserId())).containsKey("noHasPerm")) {
                this.getView().showTipNotification((String)permMap.get("noHasPerm"));
                return;
            }
            DynamicObject proApproval = QueryServiceHelper.queryOne((String)"pmas_pro_approval", (String)"id,pro", (QFilter[])new QFilter[]{new QFilter("pro", "=", (Object)projectId)});
            if (proApproval != null) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                HashMap<String, String> custormMap = new HashMap<String, String>(16);
                custormMap.put("proAppId", proApproval.getString("id"));
                map.put("formId", "pmba_projectkanban");
                map.put("customParams", custormMap);
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("formId", "bd_project");
                map.put("pkId", projectId.toString());
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm(parameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) throws KDBizException {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"refresh")) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("payitementryentity");
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"exportexcel")) {
            this.exportExcel();
        }
    }

    private void exportExcel() {
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        MainEntityType ecDataAnalys = EntityMetadataCache.getDataEntityType((String)"pmct_outcontractrpt");
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        int rowCount = reportList.getReportModel().getRowCount();
        if (rowCount > 0) {
            XSSFSheet contractReportSheet = xssfWorkbook.createSheet(ResManager.loadKDString((String)"\u652f\u51fa\u5408\u540c\u4e00\u89c8\u8868", (String)"OutContractReportFormPlugin_2", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            XSSFSheet payPlanSheet = xssfWorkbook.createSheet(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u76ee", (String)"OutContractReportFormPlugin_50", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            XSSFSheet contractSheet = xssfWorkbook.createSheet(ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c", (String)"OutContractReportFormPlugin_17", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            XSSFFont font = xssfWorkbook.createFont();
            font.setFontHeightInPoints((short)16);
            font.setBold(Boolean.TRUE.booleanValue());
            XSSFCellStyle parentStyle = xssfWorkbook.createCellStyle();
            parentStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            parentStyle.setAlignment(HorizontalAlignment.CENTER);
            parentStyle.setFont((Font)font);
            XSSFFont subfont = xssfWorkbook.createFont();
            subfont.setFontName(ResManager.loadKDString((String)"\u5fae\u8f6f\u96c5\u9ed1", (String)"OutContractReportFormPlugin_3", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            subfont.setFontHeightInPoints((short)12);
            XSSFCellStyle dataStyle = xssfWorkbook.createCellStyle();
            dataStyle.setAlignment(HorizontalAlignment.LEFT);
            dataStyle.setFont((Font)subfont);
            List<String> excludeColumnList = Arrays.asList("currency", "totalrevisionoftaxamount", "totalclaimoftaxamount", "totaladditionoftaxamt");
            List columns = reportList.getColumns();
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                ReportColumn field = (ReportColumn)iterator.next();
                String fieldKey = field.getFieldKey();
                if (!excludeColumnList.contains(fieldKey)) continue;
                iterator.remove();
            }
            int size = columns.size();
            String[] title = new String[size];
            String[] numbers = new String[size];
            int index = 0;
            for (AbstractReportColumn column : columns) {
                title[index] = column.getCaption().getLocaleValue();
                numbers[index] = ((ReportColumn)column).getFieldKey();
                ++index;
            }
            XSSFRow row = contractReportSheet.createRow(0);
            CellRangeAddress callRangeAddress = new CellRangeAddress(0, 0, 0, size - 1);
            XSSFCell outCell = row.createCell(0);
            outCell.setCellStyle((CellStyle)parentStyle);
            outCell.setCellValue(ResManager.loadKDString((String)"\u652f\u51fa\u5408\u540c\u4e00\u89c8\u8868", (String)"OutContractReportFormPlugin_2", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            OutContractReportFormPlugin.setMergedRegion(callRangeAddress, contractReportSheet);
            row.setHeightInPoints(35.0f);
            XSSFRow headRow = contractReportSheet.createRow(1);
            headRow.setHeightInPoints(15.0f);
            for (int i = 0; i < size; ++i) {
                XSSFCell cell = headRow.createCell(i);
                cell.setCellValue(title[i]);
                cell.setCellStyle((CellStyle)dataStyle);
                contractReportSheet.setColumnWidth(i, 5320);
            }
            EntryGrid contractEntry = (EntryGrid)this.getControl("entryentity");
            String[] contractNumbers = this.setRelationContractSheet(contractSheet, parentStyle, dataStyle, contractEntry);
            EntryGrid payItemEntry = (EntryGrid)this.getControl("payitementryentity");
            String[] payPlanNumbers = this.setPayPlanSheet(payPlanSheet, parentStyle, dataStyle, payItemEntry);
            int startRow = 2;
            int startCell = 0;
            int contractStartRow = 2;
            int payPlanStartRow = 2;
            QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
            for (int i = 1; i <= rowCount; ++i) {
                DynamicObject rowData = reportList.getReportModel().getRowData(i);
                this.writeData(ecDataAnalys, columns, numbers, contractReportSheet, dataStyle, startRow, startCell, rowData);
                ++startRow;
                DynamicObject contract = rowData.getDynamicObject("contract");
                contractStartRow = this.setRelationContractData(ecDataAnalys, contractSheet, dataStyle, contractNumbers, contractStartRow, contract);
                QFilter contractFilter = new QFilter("contract.id", "=", contract.getPkValue());
                String selector = Stream.of("paytype", "payfeq", "payway", "paypercent", "payamount", "planpaytime", "reimbursedamt", "paidamt", "source", "remarks", "contract", "currency", "reimbursedcomamt", "reimbursableamt", "paidcomamt", "unpaidamt", "nodesetting", "nodesettingsource", "taskcompletestatus", "name", "ctrlstrategy", "appliedamt", "appliedcomamt", "appliableamt").collect(Collectors.joining(","));
                DynamicObject[] payPlans = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)selector, (QFilter[])new QFilter[]{contractFilter, statusFilter});
                if (payPlans == null || payPlans.length <= 0) continue;
                startCell = 0;
                for (DynamicObject payPlan : payPlans) {
                    this.writePayPlanData(ecDataAnalys, payPlanNumbers, payPlanSheet, dataStyle, payPlanStartRow, startCell, payPlan);
                    ++payPlanStartRow;
                }
            }
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String fileName = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u5408\u540c\u4e00\u89c8\u8868-%s.xlsx", (String)"OutContractReportFormPlugin_34", (String)"pmgt-pmct-report", (Object[])new Object[0]), dateFormat.format(date));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                xssfWorkbook.write((OutputStream)outputStream);
            }
            catch (IOException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5199\u5165\u6570\u636e\u5f02\u5e38", (String)"OutContractReportFormPlugin_51", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            FileService service = FileServiceFactory.getAttachmentFileService();
            RequestContext ctx = RequestContext.getOrCreate();
            String filePath = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)"pmct", (String)("pmct_outcontractrpt_" + UUID.randomUUID().toString()), (String)fileName);
            FileItem fileItem = new FileItem(fileName, filePath, (InputStream)inputStream);
            String url = service.upload(fileItem);
            String fullUrl = UrlService.getAttachmentFullUrl((String)url);
            this.getView().download(fullUrl);
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38", (String)"OutContractReportFormPlugin_52", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u6210\u529f\u3002", (String)"OutContractReportFormPlugin_71", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"OutContractReportFormPlugin_72", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        }
    }

    public int setRelationContractData(MainEntityType ecDataAnalys, XSSFSheet contractSheet, XSSFCellStyle dataStyle, String[] contractNumbers, int contractStartRow, DynamicObject contract) {
        String selector;
        DynamicObject[] contracts;
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        if (null != contract.getDynamicObject("contract")) {
            filter.or(new QFilter("id", "=", contract.getDynamicObject("contract").getPkValue()));
        }
        if ((contracts = BusinessDataServiceHelper.load((String)"pmct_contractf7", (String)(selector = Stream.of("project", "billstatus", "createorg", "currency", "contracttype", "originaloftaxamount", "totaloftaxamount", "totalsettleoftaxamount", "totalapplyoftaxamount", "totalrealoftaxamount", "totalinvoiceoftaxamount", "totalclaimoftaxamount", "totalrevisionoftaxamount", "paydirection", "totaladditionoftaxamt", "org", "contractstatus", "billno", "billname").collect(Collectors.joining(","))), (QFilter[])new QFilter[]{filter})) != null && contracts.length > 0) {
            int contractStartCell = 0;
            for (DynamicObject relationContract : contracts) {
                this.writeContractData(ecDataAnalys, contractNumbers, contractSheet, dataStyle, contractStartRow, contractStartCell, relationContract, contract);
                ++contractStartRow;
            }
        }
        return contractStartRow;
    }

    @NotNull
    public String[] setPayPlanSheet(XSSFSheet payPlanSheet, XSSFCellStyle parentStyle, XSSFCellStyle dataStyle, EntryGrid payItemEntry) {
        List payItems = payItemEntry.getItems();
        List<String> excludeColumnList = Arrays.asList("payitem", "itemcurrency", "nodesettingsource", "source");
        Iterator iterator = payItems.iterator();
        while (iterator.hasNext()) {
            Control field = (Control)iterator.next();
            String fieldKey = field.getKey();
            if (!excludeColumnList.contains(fieldKey)) continue;
            iterator.remove();
        }
        int payPlanSize = payItems.size() + 2;
        XSSFRow payPlanRow = payPlanSheet.createRow(0);
        XSSFCell payPlanCell1 = payPlanRow.createCell(0);
        XSSFCell payPlanCell2 = payPlanRow.createCell(2);
        payPlanCell1.setCellStyle((CellStyle)parentStyle);
        payPlanCell1.setCellValue(ResManager.loadKDString((String)"\u652f\u51fa\u5408\u540c", (String)"OutContractReportFormPlugin_0", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        payPlanCell2.setCellStyle((CellStyle)parentStyle);
        CellRangeAddress payPlanFirstCallRangeAddress = new CellRangeAddress(0, 0, 0, 1);
        OutContractReportFormPlugin.setMergedRegion(payPlanFirstCallRangeAddress, payPlanSheet);
        payPlanCell2.setCellValue(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u76ee", (String)"OutContractReportFormPlugin_50", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        CellRangeAddress payPlanSecondCallRangeAddress = new CellRangeAddress(0, 0, 2, payPlanSize - 1);
        OutContractReportFormPlugin.setMergedRegion(payPlanSecondCallRangeAddress, payPlanSheet);
        payPlanRow.setHeightInPoints(35.0f);
        XSSFRow payPlanHeadRow = payPlanSheet.createRow(1);
        payPlanHeadRow.setHeightInPoints(15.0f);
        String[] payPlanNumbers = new String[payPlanSize];
        payPlanNumbers[0] = "billno";
        payPlanNumbers[1] = "billname";
        int index = 2;
        for (Control item : payItems) {
            FieldEdit column = (FieldEdit)item;
            payPlanNumbers[index] = column.getKey();
            ++index;
        }
        for (int i = 0; i < payPlanSize; ++i) {
            XSSFCell payPlanCell = payPlanHeadRow.createCell(i);
            payPlanCell.setCellValue(this.payPlanTitle[i]);
            payPlanCell.setCellStyle((CellStyle)dataStyle);
            payPlanSheet.setColumnWidth(i, 5320);
        }
        return payPlanNumbers;
    }

    @NotNull
    public String[] setRelationContractSheet(XSSFSheet contractSheet, XSSFCellStyle parentStyle, XSSFCellStyle dataStyle, EntryGrid contractEntry) {
        List contractItems = contractEntry.getItems();
        contractItems.remove(0);
        int contractSize = contractItems.size() + 2;
        XSSFRow contractRow = contractSheet.createRow(0);
        CellRangeAddress firstCallRangeAddress = new CellRangeAddress(0, 0, 0, 1);
        OutContractReportFormPlugin.setMergedRegion(firstCallRangeAddress, contractSheet);
        XSSFCell cell1 = contractRow.createCell(0);
        XSSFCell cell2 = contractRow.createCell(2);
        cell1.setCellStyle((CellStyle)parentStyle);
        cell1.setCellValue(ResManager.loadKDString((String)"\u652f\u51fa\u5408\u540c", (String)"OutContractReportFormPlugin_0", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        cell2.setCellStyle((CellStyle)parentStyle);
        cell2.setCellValue(ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c", (String)"OutContractReportFormPlugin_17", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        CellRangeAddress secondCallRangeAddress = new CellRangeAddress(0, 0, 2, contractSize - 1);
        OutContractReportFormPlugin.setMergedRegion(secondCallRangeAddress, contractSheet);
        contractRow.setHeightInPoints(35.0f);
        XSSFRow contractHeadRow = contractSheet.createRow(1);
        contractHeadRow.setHeightInPoints(15.0f);
        String[] contractTitle = new String[contractSize];
        String[] contractNumbers = new String[contractSize];
        contractTitle[0] = ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"OutContractReportFormPlugin_5", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[1] = ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"OutContractReportFormPlugin_6", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[2] = ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u6536\u652f\u6027\u8d28", (String)"OutContractReportFormPlugin_18", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[3] = ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u7f16\u7801", (String)"OutContractReportFormPlugin_53", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[4] = ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u540d\u79f0", (String)"OutContractReportFormPlugin_54", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[5] = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"OutContractReportFormPlugin_19", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[6] = ResManager.loadKDString((String)"\u9879\u76ee", (String)"OutContractReportFormPlugin_20", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[7] = ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001", (String)"OutContractReportFormPlugin_21", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[8] = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"OutContractReportFormPlugin_22", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[9] = ResManager.loadKDString((String)"\u521b\u5efa\u90e8\u95e8", (String)"OutContractReportFormPlugin_35", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[10] = ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b", (String)"OutContractReportFormPlugin_23", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[11] = ResManager.loadKDString((String)"\u5408\u540c\u521d\u59cb\u91d1\u989d\u2460", (String)"OutContractReportFormPlugin_24", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[12] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u53d8\u52a8\u91d1\u989d\u2461", (String)"OutContractReportFormPlugin_25", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[13] = ResManager.loadKDString((String)"\u5408\u540c\u603b\u91d1\u989d\u2462", (String)"OutContractReportFormPlugin_26", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[14] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u2463", (String)"OutContractReportFormPlugin_27", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[15] = ResManager.loadKDString((String)"\u5408\u540c\u5269\u4f59\u91d1\u989d\u2462-\u2463", (String)"OutContractReportFormPlugin_28", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[16] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u2465", (String)"OutContractReportFormPlugin_29", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[17] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b9e\u4ed8\u91d1\u989d\u2466", (String)"OutContractReportFormPlugin_30", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[18] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u2463-\u2466", (String)"OutContractReportFormPlugin_31", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[19] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u6536\u7968\u91d1\u989d\u2468", (String)"OutContractReportFormPlugin_32", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[20] = ResManager.loadKDString((String)"\u5269\u4f59\u672a\u6536\u7968\u91d1\u989d\u2469", (String)"OutContractReportFormPlugin_33", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractNumbers[0] = "billno";
        contractNumbers[1] = "billname";
        contractNumbers[2] = "refpaydirection";
        contractNumbers[3] = "refcontract";
        contractNumbers[4] = "refcontractname";
        contractNumbers[5] = "refcontractorg";
        contractNumbers[6] = "refproject";
        contractNumbers[7] = "refrelatecontstatus";
        contractNumbers[8] = "refbillstatus";
        contractNumbers[9] = "refcreateorg";
        contractNumbers[10] = "refconttype";
        contractNumbers[11] = "ref_originaloftaxamount";
        contractNumbers[12] = "ref_changeamount";
        contractNumbers[13] = "ref_totaloftaxamount";
        contractNumbers[14] = "reftotalsettleoftaxamount";
        contractNumbers[15] = "ref_totalunsettleamount";
        contractNumbers[16] = "ref_totalapplyoftaxamount";
        contractNumbers[17] = "ref_totalrealoftaxamount";
        contractNumbers[18] = "reftotalunrealoftaxamount";
        contractNumbers[19] = "ref_totalinvoiceoftaxamt";
        contractNumbers[20] = "ref_uninvoiceamt";
        for (int i = 0; i < contractSize; ++i) {
            XSSFCell contractCell = contractHeadRow.createCell(i);
            contractCell.setCellValue(contractTitle[i]);
            contractCell.setCellStyle((CellStyle)dataStyle);
            contractSheet.setColumnWidth(i, 5320);
        }
        return contractNumbers;
    }

    public static void setMergedRegion(CellRangeAddress cellAddresses, XSSFSheet sheet) {
        sheet.addMergedRegion(cellAddresses);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)cellAddresses, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)cellAddresses, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)cellAddresses, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)cellAddresses, (Sheet)sheet);
    }

    private void writeData(MainEntityType ecDataAnalys, List<AbstractReportColumn> columns, String[] numbers, XSSFSheet sheet, XSSFCellStyle dataStyle, int startRow, int startCell, DynamicObject data) {
        XSSFRow cur = sheet.getRow(startRow);
        if (cur == null) {
            cur = sheet.createRow(startRow);
        }
        for (int i = startCell; i < columns.size(); ++i) {
            XSSFCell dataCell = cur.createCell(i);
            Object value = null;
            value = "contract".equals(numbers[i]) ? data.getDynamicObject("contract").get("billno") : ("project".equals(numbers[i]) && data.getDynamicObject("project") != null ? data.getDynamicObject("contract").get("project.name") : ("billname".equals(numbers[i]) ? data.getDynamicObject("contract").get("billname") : ("contractorg".equals(numbers[i]) ? data.getDynamicObject("contract").get("org.name") : ("contractstatus".equals(numbers[i]) ? data.getDynamicObject("contract").get("contractstatus.name") : ("billstatus".equals(numbers[i]) ? (data.getDynamicObject("contract").get("billstatus").equals("A") ? ResManager.loadKDString((String)"\u6682\u5b58", (String)"OutContractReportFormPlugin_55", (String)"pmgt-pmct-report", (Object[])new Object[0]) : (data.getDynamicObject("contract").get("billstatus").equals("B") ? ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"OutContractReportFormPlugin_56", (String)"pmgt-pmct-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"OutContractReportFormPlugin_57", (String)"pmgt-pmct-report", (Object[])new Object[0]))) : ("conttype".equals(numbers[i]) ? data.getDynamicObject("contract").get("contracttype.name") : ("createorg".equals(numbers[i]) ? data.getDynamicObject("contract").get("createorg.name") : data.get(numbers[i]))))))));
            String cellValue = null;
            IDataEntityProperty property = ecDataAnalys.findProperty(numbers[i]);
            DynamicObject currency = data.getDynamicObject("currency");
            int amtprecision = currency.getInt("amtprecision");
            String currencySign = currency.getString("sign");
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                cellValue = comboProp.getItemByName(value.toString());
            } else if (value instanceof BigDecimal) {
                cellValue = ((BigDecimal)value).setScale(amtprecision, RoundingMode.HALF_UP).toPlainString();
                if ("0E-10".equals(cellValue)) {
                    cellValue = BigDecimal.ZERO.setScale(amtprecision).toString();
                }
                cellValue = currencySign + cellValue;
                dataCell.setCellStyle((CellStyle)dataStyle);
            } else {
                cellValue = value != null ? value.toString() : null;
            }
            dataCell.setCellValue(cellValue);
        }
    }

    private void writePayPlanData(MainEntityType ecDataAnalys, String[] numbers, XSSFSheet sheet, XSSFCellStyle dataStyle, int startRow, int startCell, DynamicObject data) {
        XSSFRow curRow = sheet.getRow(startRow);
        if (curRow == null) {
            curRow = sheet.createRow(startRow);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = startCell; i < numbers.length; ++i) {
            String cellValue;
            CtrlStrategyEnum ctrlStrategyEnum;
            String nodeSettingSource;
            Map srcObjCompleteMap;
            Map nodeObjCompMap;
            DynamicObject nodeSetting;
            XSSFCell dataCell = curRow.createCell(i);
            Object value = "billno".equals(numbers[i]) ? data.getDynamicObject("contract").get("billno") : ("billname".equals(numbers[i]) ? data.getDynamicObject("contract").getString("billname") : ("payway".equals(numbers[i]) && data.getDynamicObject("payway") != null ? data.getDynamicObject("payway").getLocaleString("name") : ("payamountoftax".equals(numbers[i]) ? data.get("payamount") : ("planpaytime".equals(numbers[i]) && data.getDate("planpaytime") != null ? df.format(data.getDate("planpaytime")) : ("paynodesetting".equals(numbers[i]) ? this.getNodeSettingName(data) : ("taskcompletestatus".equals(numbers[i]) ? ((nodeSetting = data.getDynamicObject("nodesetting")) != null ? ((nodeObjCompMap = (Map)(srcObjCompleteMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])new DynamicObject[]{data})).get(nodeSettingSource = data.getString("nodesettingsource"))) != null ? nodeObjCompMap.get(nodeSetting.getPkValue()) : "") : "") : ("itemname".equals(numbers[i]) ? data.getLocaleString("name") : ("ctrlstrategy".equals(numbers[i]) ? ((ctrlStrategyEnum = CtrlStrategyEnum.getEnumByValue((String)data.getString("ctrlstrategy"))) != null ? ctrlStrategyEnum.getName() : "") : ("paypercent".equals(numbers[i]) ? data.getBigDecimal(numbers[i]).setScale(4, RoundingMode.HALF_UP) : data.get(numbers[i]))))))))));
            IDataEntityProperty property = ecDataAnalys.findProperty(numbers[i]);
            DynamicObject currency = data.getDynamicObject("currency");
            if (currency == null) continue;
            int amtprecision = currency.getInt("amtprecision");
            String currencySign = currency.getString("sign");
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                cellValue = value != null ? comboProp.getItemByName(value.toString()) : "";
            } else if (property instanceof AmountProp) {
                if (value != null) {
                    cellValue = ((BigDecimal)value).setScale(amtprecision, RoundingMode.HALF_UP).toPlainString();
                    if ("0E-10".equals(cellValue)) {
                        cellValue = BigDecimal.ZERO.setScale(amtprecision).toString();
                    }
                    cellValue = currencySign + cellValue;
                    dataCell.setCellStyle((CellStyle)dataStyle);
                } else {
                    cellValue = BigDecimal.ZERO.setScale(amtprecision).toString();
                }
            } else {
                cellValue = value != null ? value.toString() : null;
            }
            dataCell.setCellValue(cellValue);
        }
    }

    private ILocaleString getNodeSettingName(DynamicObject data) {
        DynamicObject nodesetting = data.getDynamicObject("nodesetting");
        if (nodesetting == null) {
            return null;
        }
        String name = nodesetting.getDynamicObjectType().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)NodeSettingSourceEnum.PMBS_TASK.getValue())) {
            return nodesetting.getLocaleString("name");
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"pmbs_wbs")) {
            return nodesetting.getLocaleString("name");
        }
        return nodesetting.getLocaleString("workitem");
    }

    private void writeContractData(MainEntityType ecDataAnalys, String[] numbers, XSSFSheet sheet, XSSFCellStyle dataStyle, int startRow, int startCell, DynamicObject data, DynamicObject contractData) {
        XSSFRow curRow = sheet.getRow(startRow);
        if (curRow == null) {
            curRow = sheet.createRow(startRow);
        }
        BigDecimal totalAmt = data.getBigDecimal("totaloftaxamount");
        BigDecimal totalClaimAmt = data.getBigDecimal("totalclaimoftaxamount");
        BigDecimal totalAdditionOfTaxAmt = data.getBigDecimal("totaladditionoftaxamt");
        BigDecimal totalRevisionAmt = data.getBigDecimal("totalrevisionoftaxamount");
        BigDecimal totalSettleAmt = data.getBigDecimal("totalsettleoftaxamount");
        BigDecimal totalRealAmt = data.getBigDecimal("totalrealoftaxamount");
        BigDecimal totalInvoiceAmt = data.getBigDecimal("totalinvoiceoftaxamount");
        for (int i = startCell; i < numbers.length; ++i) {
            XSSFCell dataCell = curRow.createCell(i);
            Object value = null;
            if ("billno".equals(numbers[i])) {
                value = contractData.get("billno");
            } else if ("billname".equals(numbers[i])) {
                value = contractData.get("billname");
            } else if ("refcontract".equals(numbers[i])) {
                value = data.get("billno");
            } else if ("refcontractname".equals(numbers[i])) {
                value = data.get("billname");
            } else if ("refpaydirection".equals(numbers[i]) && !data.getString("paydirection").isEmpty()) {
                value = "out".equals(data.getString("paydirection")) ? PayDirectionEnum.OUT.getName() : PayDirectionEnum.IN.getName();
            } else if ("refcontractorg".equals(numbers[i])) {
                value = data.getDynamicObject("org").get("name");
            } else if ("refcreateorg".equals(numbers[i])) {
                value = data.getDynamicObject("createorg").get("name");
            } else if ("refproject".equals(numbers[i]) && data.getDynamicObject("project") != null) {
                value = data.getDynamicObject("project").get("name");
            } else if ("refrelatecontstatus".equals(numbers[i])) {
                value = data.getDynamicObject("contractstatus").get("name");
            } else if ("refbillstatus".equals(numbers[i])) {
                value = "A".equals(data.get("billstatus")) ? StatusEnum.TEMPSAVE.getName() : ("B".equals(data.get("billstatus")) ? StatusEnum.UNCHECKED.getName() : StatusEnum.CHECKED.getName());
            } else if ("refconttype".equals(numbers[i]) && data.getDynamicObject("contracttype") != null) {
                value = data.getDynamicObject("contracttype").get("name");
            } else if ("ref_originaloftaxamount".equals(numbers[i])) {
                value = data.get("originaloftaxamount");
            } else if ("ref_changeamount".equals(numbers[i])) {
                value = totalClaimAmt.add(totalRevisionAmt).add(totalAdditionOfTaxAmt);
            } else if ("ref_totaloftaxamount".equals(numbers[i])) {
                value = totalAmt;
            } else if ("reftotalsettleoftaxamount".equals(numbers[i])) {
                value = totalSettleAmt;
            } else if ("ref_totalunsettleamount".equals(numbers[i])) {
                value = totalAmt.subtract(totalSettleAmt);
            } else if ("ref_totalapplyoftaxamount".equals(numbers[i])) {
                value = data.get("totalapplyoftaxamount");
            } else if ("ref_totalrealoftaxamount".equals(numbers[i])) {
                value = totalRealAmt;
            } else if ("reftotalunrealoftaxamount".equals(numbers[i])) {
                value = totalSettleAmt.subtract(totalRealAmt);
            } else if ("ref_totalinvoiceoftaxamt".equals(numbers[i])) {
                value = totalInvoiceAmt;
            } else if ("ref_uninvoiceamt".equals(numbers[i])) {
                value = totalSettleAmt.subtract(totalInvoiceAmt);
            }
            String cellValue = null;
            IDataEntityProperty property = ecDataAnalys.findProperty(numbers[i]);
            DynamicObject currency = data.getDynamicObject("currency");
            int amtprecision = currency.getInt("amtprecision");
            String currencySign = currency.getString("sign");
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                if (value != null) {
                    cellValue = comboProp.getItemByName(value.toString());
                }
            } else if (value instanceof BigDecimal) {
                cellValue = ((BigDecimal)value).setScale(amtprecision, RoundingMode.HALF_UP).toPlainString();
                if ("0E-10".equals(cellValue)) {
                    cellValue = BigDecimal.ZERO.setScale(amtprecision).toString();
                }
                cellValue = currencySign + cellValue;
                dataCell.setCellStyle((CellStyle)dataStyle);
            } else {
                cellValue = value != null ? value.toString() : null;
            }
            dataCell.setCellValue(cellValue);
        }
    }
}

