/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.report.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.BuildCommonFilterList;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import org.apache.commons.lang3.StringUtils;

public class StrategicAgreementReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    protected void filterContainerInit(FilterContainerInitEvent filter, ReportQueryParam param) {
        super.filterContainerInit(filter, param);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(0);
            CommonFilterColumn partAFilterColumn = (CommonFilterColumn)filterGridView.getItems().get(0);
            String partACache = this.getPageCache().get("partACache");
            if (StringUtils.isNotBlank((CharSequence)partACache)) {
                List partAComboItems = SerializationUtils.fromJsonStringToList((String)partACache, ComboItem.class);
                partAFilterColumn.setComboItems(partAComboItems);
                partAFilterColumn.setMustInput(false);
                this.buildPartBComboItem(filterGridView);
                return;
            }
            long currUserId = RequestContext.get().getCurrUserId();
            List permOrg = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(currUserId), (String)"pmct", (String)"pmct_agreementrpt", (String)"47150e89000000ac");
            if (permOrg.size() > 0) {
                List partAComboItems = BuildCommonFilterList.buildComboItem((String)"bos_org", (QFilter)new QFilter("id", "in", (Object)permOrg));
                partAFilterColumn.setComboItems(partAComboItems);
                partAFilterColumn.setMustInput(false);
                partACache = SerializationUtils.toJsonString((Object)partAComboItems);
                this.getPageCache().put("partACache", partACache);
                this.buildPartBComboItem(filterGridView);
            } else {
                partAFilterColumn.setComboItems(new ArrayList(16));
                CommonFilterColumn projectFilterColumn = (CommonFilterColumn)filterGridView.getItems().get(1);
                projectFilterColumn.setComboItems(new ArrayList(16));
            }
        }
    }

    private void buildPartBComboItem(FilterGridView filterGridView) {
        CommonFilterColumn projectFilterColumn = (CommonFilterColumn)filterGridView.getItems().get(1);
        String partBCache = this.getPageCache().get("partBCache");
        if (StringUtils.isNotBlank((CharSequence)partBCache)) {
            List partBComboItems = SerializationUtils.fromJsonStringToList((String)partBCache, ComboItem.class);
            projectFilterColumn.setComboItems(partBComboItems);
            projectFilterColumn.setMustInput(false);
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        List permOrg = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(currUserId), (String)"pmct", (String)"pmct_agreementrpt", (String)"47150e89000000ac");
        if (permOrg.size() > 0) {
            QFilter orgFilter = new QFilter("org", "in", (Object)permOrg);
            DynamicObjectCollection entryEntity = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{orgFilter});
            Set suppliers = entryEntity.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", suppliers);
            List partBComboItems = BuildCommonFilterList.buildComboItem((String)"bd_supplier", (QFilter)qFilter);
            projectFilterColumn.setComboItems(partBComboItems);
            projectFilterColumn.setMustInput(false);
            partBCache = SerializationUtils.toJsonString((Object)partBComboItems);
            this.getPageCache().put("partBCache", partBCache);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String partBCache;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("parta.id".equals(fieldName) || "parta.name".equals(fieldName)) {
            String partACache = this.getPageCache().get("partACache");
            if (StringUtils.isNotBlank((CharSequence)partACache)) {
                List partAComboItems = SerializationUtils.fromJsonStringToList((String)partACache, ComboItem.class);
                List partAIds = partAComboItems.stream().map(o -> Long.parseLong(o.getValue())).collect(Collectors.toList());
                args.getQfilters().add(new QFilter("id", "in", partAIds));
            }
        } else if (("partb.id".equals(fieldName) || "partb.name".equals(fieldName)) && StringUtils.isNotBlank((CharSequence)(partBCache = this.getPageCache().get("partBCache")))) {
            List partBComboItems = SerializationUtils.fromJsonStringToList((String)partBCache, ComboItem.class);
            List partBIds = partBComboItems.stream().map(o -> Long.parseLong(o.getValue())).collect(Collectors.toList());
            args.getQfilters().add(new QFilter("id", "in", partBIds));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        AbstractGrid entryEntity = (AbstractGrid)this.getControl("entryentity");
        entryEntity.addHyperClickListener((HyperLinkClickListener)this);
        ReportList entryGrid = (ReportList)this.getView().getControl("reportlistap");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        List<Object> agreements = new ArrayList(16);
        Object[] ids = rowData.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList()).toArray();
        if (ids.length > 0) {
            MainEntityType agreementDt = EntityMetadataCache.getDataEntityType((String)"pmct_strategicagreement");
            DynamicObject[] agreementBills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)agreementDt);
            agreements = Arrays.stream(agreementBills).collect(Collectors.toList());
        }
        for (DynamicObject dyn2 : rowData) {
            DynamicObject currency;
            Optional<DynamicObject> first;
            long strategciAgreementId = dyn2.getLong("id");
            DynamicObject agreement = null;
            if (agreements.size() > 0 && (first = agreements.stream().filter(o -> strategciAgreementId == Long.parseLong(o.getPkValue().toString())).findFirst()).isPresent()) {
                agreement = first.get();
            }
            long orgId = dyn2.getDynamicObject("org") == null ? 0L : dyn2.getDynamicObject("org").getLong("id");
            DynamicObject[] contracts = this.getValidOutContract(agreement, orgId);
            dyn2.set("contractcount", (Object)contracts.length);
            BigDecimal originalOfTaxAmount = BigDecimal.ZERO;
            BigDecimal totalSettleAmount = BigDecimal.ZERO;
            BigDecimal totalApplyAmount = BigDecimal.ZERO;
            BigDecimal totalRealAmount = BigDecimal.ZERO;
            for (DynamicObject row : contracts) {
                originalOfTaxAmount = originalOfTaxAmount.add(row.getBigDecimal("originaloftaxamount"));
                totalSettleAmount = totalSettleAmount.add(row.getBigDecimal("totalsettleoftaxamount"));
                totalApplyAmount = totalApplyAmount.add(ContractHelper.getPaymentApplyThisPayableAmount((Object)row.getPkValue(), null));
                totalRealAmount = totalRealAmount.add(row.getBigDecimal("totalrealoftaxamount"));
            }
            dyn2.set("originaloftaxamount", (Object)originalOfTaxAmount);
            dyn2.set("totalsettleamount", (Object)totalSettleAmount);
            dyn2.set("totalapplyamount", (Object)totalApplyAmount);
            dyn2.set("totalrealamount", (Object)totalRealAmount);
            dyn2.set("newtotalrealamount", (Object)totalRealAmount);
            if (agreement == null || (currency = agreement.getDynamicObject("currency")) == null) continue;
            dyn2.set("currency", (Object)currency);
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getModel().deleteEntryData("entryentity");
        this.getView().updateView("entryentity");
    }

    private DynamicObject[] getValidOutContract(DynamicObject agreement, Long org) {
        DynamicObjectCollection list = new DynamicObjectCollection();
        if (agreement != null) {
            DynamicObject sourceBill = agreement.getDynamicObject("sourcebill");
            if (sourceBill != null) {
                QFilter filter = new QFilter("id", "=", sourceBill.getPkValue()).or("sourcebill", "=", sourceBill.getPkValue());
                DynamicObject[] agreements = BusinessDataServiceHelper.load((String)"pmct_strategicagreement", (String)"", (QFilter[])new QFilter[]{filter});
                Collections.addAll(list, agreements);
            } else {
                list.add((Object)agreement);
            }
        }
        Set collect = list.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter agreementFilter = new QFilter("strategicagreement", "in", collect).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        DynamicObject[] outContractsId = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"", (QFilter[])new QFilter[]{agreementFilter, orgFilter});
        HashSet<Object> outContractsIdSet = new HashSet<Object>();
        if (0 != outContractsId.length) {
            for (DynamicObject row : outContractsId) {
                outContractsIdSet.add(row.getPkValue());
            }
        }
        DynamicObject[] contracts = new DynamicObject[]{};
        MainEntityType contractDt = EntityMetadataCache.getDataEntityType((String)"pmct_outcontract");
        if (outContractsIdSet.size() > 0) {
            contracts = BusinessDataServiceHelper.load((Object[])outContractsIdSet.toArray(), (DynamicObjectType)contractDt);
        }
        return contracts;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject org;
        Long strategicAgreementId;
        IReportListModel listModel;
        String fieldName = hyperLinkClickEvent.getFieldName();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        AbstractGrid entryEntity = (AbstractGrid)this.getControl("entryentity");
        int clickRowIndex = hyperLinkClickEvent.getRowIndex();
        if ("contractcount".equals(fieldName)) {
            listModel = reportList.getReportModel();
            strategicAgreementId = (Long)listModel.getValue(clickRowIndex, "id");
            org = (DynamicObject)listModel.getValue(clickRowIndex, "org");
            Long orgId = org == null ? 0L : org.getLong("id");
            this.getModel().deleteEntryData("entryentity");
            DynamicObjectCollection outContractCol = this.getModel().getEntryEntity("entryentity");
            DynamicObjectType outContEntryDT = outContractCol.getDynamicObjectType();
            if (strategicAgreementId != 0L) {
                DynamicObject[] contracts;
                DynamicObject strategicAgreement = BusinessDataServiceHelper.loadSingle((Object)strategicAgreementId, (String)"pmct_strategicagreement");
                for (DynamicObject cont : contracts = this.getValidOutContract(strategicAgreement, orgId)) {
                    DynamicObject outContEntry = new DynamicObject(outContEntryDT);
                    outContEntry.set("outcontract", (Object)cont);
                    BigDecimal totalAmt = cont.getBigDecimal("totaloftaxamount");
                    BigDecimal totalClaimAmt = cont.getBigDecimal("totalclaimoftaxamount");
                    BigDecimal totalRevisionAmt = cont.getBigDecimal("totalrevisionoftaxamount");
                    BigDecimal totalAdditionAmt = cont.getBigDecimal("totaladditionoftaxamt");
                    BigDecimal totalSettleAmt = cont.getBigDecimal("totalsettleoftaxamount");
                    BigDecimal totalRealAmt = cont.getBigDecimal("totalrealoftaxamount");
                    outContEntry.set("outcurrency", (Object)cont.getDynamicObject("currency"));
                    outContEntry.set("outproject", (Object)cont.getDynamicObject("project"));
                    outContEntry.set("out_originaloftaxamount", cont.get("originaloftaxamount"));
                    outContEntry.set("out_changeamount", (Object)totalClaimAmt.add(totalRevisionAmt).add(totalAdditionAmt));
                    outContEntry.set("out_totaloftaxamount", (Object)totalAmt);
                    outContEntry.set("outtotalsettleoftaxamount", (Object)totalSettleAmt);
                    outContEntry.set("out_totalapplyoftaxamount", (Object)ContractHelper.getPaymentApplyThisPayableAmount((Object)cont.getPkValue(), null));
                    outContEntry.set("out_totalrealoftaxamount", (Object)totalRealAmt);
                    outContractCol.add((Object)outContEntry);
                }
                this.getModel().updateEntryCache(outContractCol);
                this.getView().updateView("entryentity");
            }
        }
        if ("outcontract".equals(fieldName)) {
            DynamicObject contract;
            List orgList = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)"pmct_outcontract", (String)"view");
            if (orgList.contains((org = (contract = (DynamicObject)entryEntity.getModel().getValue(fieldName, clickRowIndex)).getDynamicObject("org")).getPkValue())) {
                long id = contract.getLong("id");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("formId", "pmct_outcontract");
                map.put("pkId", Long.toString(id));
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm(parameter);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u652f\u51fa\u5408\u540c\u201d\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"StrategicAgreementReportFormPlugin_0", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            }
        } else if ("billno".equals(fieldName)) {
            listModel = reportList.getReportModel();
            strategicAgreementId = (Long)listModel.getValue(clickRowIndex, "id");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "pmct_strategicagreement");
            map.put("pkId", strategicAgreementId.toString());
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        int clickRowIndex = evt.getRow();
        if (StringUtils.equals((CharSequence)"reportlistap", (CharSequence)source.getKey())) {
            IReportListModel listModel = reportList.getReportModel();
            Long strategicAgreementId = (Long)listModel.getValue(clickRowIndex, "id");
            DynamicObject org = (DynamicObject)listModel.getValue(clickRowIndex, "org");
            Long orgId = org == null ? 0L : org.getLong("id");
            this.getModel().deleteEntryData("entryentity");
            DynamicObjectCollection outContractCol = this.getModel().getEntryEntity("entryentity");
            DynamicObjectType outContEntryDT = outContractCol.getDynamicObjectType();
            if (strategicAgreementId != null && strategicAgreementId != 0L) {
                DynamicObject[] contracts;
                DynamicObject strategicAgreement = BusinessDataServiceHelper.loadSingle((Object)strategicAgreementId, (String)"pmct_strategicagreement");
                for (DynamicObject cont : contracts = this.getValidOutContract(strategicAgreement, orgId)) {
                    DynamicObject outContEntry = new DynamicObject(outContEntryDT);
                    outContEntry.set("outcontract", (Object)cont);
                    BigDecimal totalAmt = cont.getBigDecimal("totaloftaxamount");
                    BigDecimal totalClaimAmt = cont.getBigDecimal("totalclaimoftaxamount");
                    BigDecimal totalRevisionAmt = cont.getBigDecimal("totalrevisionoftaxamount");
                    BigDecimal totalAdditionAmt = cont.getBigDecimal("totaladditionoftaxamt");
                    BigDecimal totalSettleAmt = cont.getBigDecimal("totalsettleoftaxamount");
                    BigDecimal totalRealAmt = cont.getBigDecimal("totalrealoftaxamount");
                    outContEntry.set("outcurrency", (Object)cont.getDynamicObject("currency"));
                    outContEntry.set("outproject", (Object)cont.getDynamicObject("project"));
                    outContEntry.set("out_originaloftaxamount", cont.get("originaloftaxamount"));
                    outContEntry.set("out_changeamount", (Object)totalClaimAmt.add(totalRevisionAmt).add(totalAdditionAmt));
                    outContEntry.set("out_totaloftaxamount", (Object)totalAmt);
                    outContEntry.set("outtotalsettleoftaxamount", (Object)totalSettleAmt);
                    outContEntry.set("out_totalapplyoftaxamount", (Object)ContractHelper.getPaymentApplyThisPayableAmount((Object)cont.getPkValue(), null));
                    outContEntry.set("out_totalrealoftaxamount", (Object)totalRealAmt);
                    outContractCol.add((Object)outContEntry);
                }
                this.getModel().updateEntryCache(outContractCol);
                this.getView().updateView("entryentity");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"refresh")) {
            DynamicObjectCollection outContractCol = this.getModel().getEntryEntity("entryentity");
            outContractCol.clear();
            this.getModel().updateEntryCache(outContractCol);
            this.getView().updateView("entryentity");
        }
    }
}

