/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.ContractSettleHelper;
import kd.pmgt.pmct.common.enums.DirectionEnum;
import kd.pmgt.pmct.common.utils.SettleUpdateAmtUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public abstract class AbstractContractSettleEditUI
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    public static final String OPERATE_ADDENTRY = "addentry";
    public static final String OPERATE_DELETE = "deleteitementry";
    public static final String LISTENTRY_ADDNEW = "newlistentry";
    protected static final String LISTENTRY_DELETE = "deletelistentry";
    protected static final String RELATE_LIST_PAY_ITEM_INDEX = "relateListPayItemIndex";
    protected static final String BUDGET_ITEM_ROW = "budgetItemRow";
    protected static final String OLD_BUDGET_ITEM_ID = "oldBudgetItemId";
    private static final String RELATE_LIST_CONFIRM_CALL_BACK = "relateListConfirmCallBack";
    private static final String CHANGE_LIST_BUDGET_CONFIRM_CALL_BACK = "changeListConfirmBudgetCallBack";
    private static final String CHANGE_DETAIL_BUDGET_CONFIRM_CALL_BACK = "changeDetailConfirmBudgetCallBack";
    protected static final Long SETTLE_PAY_ITEM_ID = 850444247600913408L;
    protected static final Long CLAIM_PAY_ITEM_ID = 849909148731577344L;
    private static boolean isChangePeriod = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contract = (BasedataEdit)this.getControl("contract");
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("listmodelentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        EntryGrid itemEntry = (EntryGrid)this.getControl("itementry");
        itemEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        Object newValue = args.getChangeSet()[0].getNewValue();
        Object oldValue = args.getChangeSet()[0].getOldValue();
        if (propertyName.equals("contract")) {
            this.onChangeContract();
        } else if (propertyName.equals("period")) {
            isChangePeriod = true;
            this.onPeriodChange();
        } else if (propertyName.equals("oftaxamount")) {
            this.onChangeOfTaxAmount(args);
            ContractSettleHelper.setEnableItementry((IFormView)this.getView());
        } else if (propertyName.equals("amount")) {
            this.onChangeAmount(args);
            ContractSettleHelper.setEnableItementry((IFormView)this.getView());
        } else if (propertyName.equals("itemrate")) {
            this.onChangeRate(args);
            ContractSettleHelper.setEnableItementry((IFormView)this.getView());
        } else if (propertyName.equals("taxamt")) {
            this.onChangeTaxAmt(args);
            ContractSettleHelper.setEnableItementry((IFormView)this.getView());
        } else if (propertyName.equals("begindate") || propertyName.equals("enddate")) {
            if (isChangePeriod) {
                isChangePeriod = false;
            } else {
                Date beginDate = (Date)this.getModel().getValue("begindate");
                Date endDate = (Date)this.getModel().getValue("enddate");
                if (null != endDate && null != beginDate && beginDate.compareTo(endDate) > 0) {
                    this.getModel().setValue("enddate", null);
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"AbstractContractSettleEditUI_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (propertyName.equals("project")) {
            Boolean isMultiContract = (Boolean)this.getModel().getValue("ismulticontract");
            if (isMultiContract.booleanValue()) {
                this.getModel().setValue("contract", null);
            }
        } else if (propertyName.equals("outbudget")) {
            Boolean multiContract = (Boolean)this.getModel().getValue("ismulticontract");
            DynamicObject listing = (DynamicObject)this.getModel().getValue("listing", rowIndex);
            if (!multiContract.booleanValue() && newValue != null && listing != null && listing.getDynamicObject("listingbudgetitem") != null && !listing.getDynamicObject("listingbudgetitem").getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                this.getPageCache().put(BUDGET_ITEM_ROW, String.valueOf(rowIndex));
                this.getPageCache().put(OLD_BUDGET_ITEM_ID, oldValue == null ? null : String.valueOf(((DynamicObject)oldValue).getPkValue()));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u9884\u7b97\u9879\u4e0e\u5408\u540c\u5355\u636e\u7684\u9884\u7b97\u9879\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"AbstractContractSettleEditUI_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_LIST_BUDGET_CONFIRM_CALL_BACK, (IFormPlugin)this));
            } else {
                this.changePayItemByListBudgetChange(newValue, rowIndex);
            }
        } else if (propertyName.equals("detailbudgetitem")) {
            Boolean multiContract = (Boolean)this.getModel().getValue("ismulticontract");
            Long referBillId = (Long)this.getModel().getValue("referbillid", rowIndex);
            Long referEntryId = (Long)this.getModel().getValue("referentryid", rowIndex);
            DynamicObject detailPayItem = (DynamicObject)this.getModel().getValue("detailpayitem", rowIndex);
            if (CLAIM_PAY_ITEM_ID.equals(detailPayItem.getPkValue())) {
                DynamicObject claim = BusinessDataServiceHelper.loadSingle((Object)referBillId, (String)"pmct_outclaimbill");
                if (!multiContract.booleanValue() && newValue != null && claim != null && claim.getDynamicObject("budgetitem") != null && !claim.getDynamicObject("budgetitem").getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                    this.getPageCache().put(BUDGET_ITEM_ROW, String.valueOf(rowIndex));
                    this.getPageCache().put(OLD_BUDGET_ITEM_ID, oldValue == null ? null : String.valueOf(((DynamicObject)oldValue).getPkValue()));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u9884\u7b97\u9879\u4e0e\u5408\u540c\u5355\u636e\u7684\u9884\u7b97\u9879\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"AbstractContractSettleEditUI_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_DETAIL_BUDGET_CONFIRM_CALL_BACK, (IFormPlugin)this));
                } else {
                    this.changePayItemByDetailBudgetChange(newValue, rowIndex);
                }
            } else {
                DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)referBillId, (String)"pmct_outperformrecords");
                boolean flag = false;
                if (record != null) {
                    for (DynamicObject entry : record.getDynamicObjectCollection("entryentity")) {
                        if (multiContract.booleanValue() || newValue == null || !entry.getPkValue().equals(referEntryId) || entry.getDynamicObject("budgetitem").getPkValue().equals(((DynamicObject)newValue).getPkValue())) continue;
                        this.getPageCache().put(BUDGET_ITEM_ROW, String.valueOf(rowIndex));
                        this.getPageCache().put(OLD_BUDGET_ITEM_ID, oldValue == null ? null : String.valueOf(((DynamicObject)oldValue).getPkValue()));
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u9884\u7b97\u9879\u4e0e\u5408\u540c\u5355\u636e\u7684\u9884\u7b97\u9879\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"AbstractContractSettleEditUI_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_DETAIL_BUDGET_CONFIRM_CALL_BACK, (IFormPlugin)this));
                        flag = true;
                        break;
                    }
                }
                if (!flag) {
                    this.changePayItemByDetailBudgetChange(newValue, rowIndex);
                }
            }
        }
    }

    protected void changePayItemByListBudgetChange(Object listBudget, int listRowIndex) {
        Long payItemEntryId = (Long)this.getModel().getValue("payitemid", listRowIndex);
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        DynamicObjectCollection modelEntry = this.getModel().getEntryEntity("listmodelentry");
        int oldRelatePayItemRow = -1;
        int newRelatePayItemRow = -1;
        for (int index = 0; index < itemEntry.size(); ++index) {
            if (((DynamicObject)itemEntry.get(index)).getPkValue().equals(payItemEntryId)) {
                oldRelatePayItemRow = index;
            }
            DynamicObject payItem = ((DynamicObject)itemEntry.get(index)).getDynamicObject("payitem");
            DynamicObject payBudget = ((DynamicObject)itemEntry.get(index)).getDynamicObject("paybudgetitem");
            Boolean isRelateList = false;
            block1: for (DynamicObject model : modelEntry) {
                DynamicObjectCollection listEntry = model.getDynamicObjectCollection("listentry");
                for (DynamicObject list : listEntry) {
                    if (!((DynamicObject)itemEntry.get(index)).getPkValue().equals(list.get("payitemid"))) continue;
                    isRelateList = true;
                    break block1;
                }
            }
            if (!payItem.getPkValue().equals(SETTLE_PAY_ITEM_ID) || !isRelateList.booleanValue()) continue;
            if (listBudget == null && payBudget == null) {
                newRelatePayItemRow = index;
                continue;
            }
            if (listBudget == null || payBudget == null || !((DynamicObject)listBudget).getPkValue().equals(payBudget.getPkValue())) continue;
            newRelatePayItemRow = index;
        }
        if (newRelatePayItemRow < 0) {
            ORM orm = ORM.create();
            Long newPayItemId = orm.genLongId((IDataEntityType)itemEntry.getRootEntityType());
            int itemRow = this.getModel().createNewEntryRow("itementry");
            this.getModel().setValue("itementry.id", (Object)newPayItemId, itemRow);
            DynamicObject settlePayItem = BusinessDataServiceHelper.loadSingle((Object)SETTLE_PAY_ITEM_ID, (String)"pmct_payitem");
            this.getModel().setValue("payitem", (Object)settlePayItem, itemRow);
            this.getModel().setValue("paybudgetitem", listBudget, itemRow);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean isMultiRate = contract.getBoolean("ismultirate");
            this.getModel().setValue("payitemid", (Object)newPayItemId, listRowIndex);
        } else {
            DynamicObject newRelatePayItem = this.getModel().getEntryRowEntity("itementry", newRelatePayItemRow);
            this.getModel().setValue("payitemid", newRelatePayItem.getPkValue(), listRowIndex);
        }
        int relateCount = 0;
        DynamicObject oldRelatePayItem = this.getModel().getEntryRowEntity("itementry", oldRelatePayItemRow);
        for (DynamicObject model : modelEntry) {
            DynamicObjectCollection listEntry = model.getDynamicObjectCollection("listentry");
            for (DynamicObject list : listEntry) {
                if (!oldRelatePayItem.getPkValue().equals(list.get("payitemid"))) continue;
                ++relateCount;
            }
        }
        if (relateCount == 0) {
            this.getModel().deleteEntryRow("itementry", oldRelatePayItemRow);
        }
        this.sumHeadAmount();
        ContractSettleHelper.setEnableItementry((IFormView)this.getView());
    }

    protected void changePayItemByDetailBudgetChange(Object detailBudget, int detailRowIndex) {
        Long payItemEntryId = (Long)this.getModel().getValue("itemid", detailRowIndex);
        DynamicObject itemDetail = this.getModel().getEntryRowEntity("payitemdetailentry", detailRowIndex);
        DynamicObject detailPayItem = itemDetail.getDynamicObject("detailpayitem");
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        DynamicObjectCollection detailEntry = this.getModel().getEntryEntity("payitemdetailentry");
        int oldRelatePayItemRow = -1;
        int newRelatePayItemRow = -1;
        for (int index = 0; index < itemEntry.size(); ++index) {
            if (((DynamicObject)itemEntry.get(index)).getPkValue().equals(payItemEntryId)) {
                oldRelatePayItemRow = index;
            }
            DynamicObject payItem = ((DynamicObject)itemEntry.get(index)).getDynamicObject("payitem");
            DynamicObject payBudget = ((DynamicObject)itemEntry.get(index)).getDynamicObject("paybudgetitem");
            Boolean isRelateList = false;
            for (DynamicObject detail : detailEntry) {
                if (!((DynamicObject)itemEntry.get(index)).getPkValue().equals(detail.get("itemid"))) continue;
                isRelateList = true;
                break;
            }
            if (!payItem.getPkValue().equals(detailPayItem.getPkValue()) || !isRelateList.booleanValue()) continue;
            if (detailBudget == null && payBudget == null) {
                newRelatePayItemRow = index;
                continue;
            }
            if (detailBudget == null || payBudget == null || !((DynamicObject)detailBudget).getPkValue().equals(payBudget.getPkValue())) continue;
            newRelatePayItemRow = index;
        }
        BigDecimal detailOfTaxAmt = itemDetail.getBigDecimal("detailoftaxamt");
        BigDecimal detailAmt = itemDetail.getBigDecimal("detailamt");
        BigDecimal detailTaxAmt = itemDetail.getBigDecimal("detailtaxamt");
        this.getModel().beginInit();
        if (newRelatePayItemRow < 0) {
            ORM orm = ORM.create();
            Long newPayItemId = orm.genLongId((IDataEntityType)itemEntry.getRootEntityType());
            int itemRow = this.getModel().createNewEntryRow("itementry");
            this.getModel().setValue("itementry.id", (Object)newPayItemId, itemRow);
            this.getModel().setValue("payitem", (Object)detailPayItem, itemRow);
            this.getModel().setValue("paybudgetitem", detailBudget, itemRow);
            this.getModel().setValue("oftaxamount", (Object)detailOfTaxAmt, itemRow);
            this.getModel().setValue("amount", (Object)detailAmt, itemRow);
            this.getModel().setValue("taxamt", (Object)detailTaxAmt, itemRow);
            BigDecimal rate = detailAmt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : detailTaxAmt.multiply(new BigDecimal(100)).divide(detailAmt, 2, 4);
            this.getModel().setValue("itemid", (Object)newPayItemId, detailRowIndex);
        } else {
            DynamicObject newRelatePayItem = this.getModel().getEntryRowEntity("itementry", newRelatePayItemRow);
            BigDecimal ofTaxAmount = (BigDecimal)this.getModel().getValue("oftaxamount", newRelatePayItemRow);
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", newRelatePayItemRow);
            BigDecimal taxAmt = (BigDecimal)this.getModel().getValue("taxamt", newRelatePayItemRow);
            this.getModel().setValue("oftaxamount", (Object)ofTaxAmount.add(detailOfTaxAmt), newRelatePayItemRow);
            this.getModel().setValue("amount", (Object)amount.add(detailAmt), newRelatePayItemRow);
            this.getModel().setValue("taxamt", (Object)taxAmt.add(detailTaxAmt), newRelatePayItemRow);
            BigDecimal rate = amount.add(detailAmt).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : taxAmt.add(detailTaxAmt).multiply(new BigDecimal(100)).divide(detailAmt, 2, 4);
            this.getModel().setValue("itemid", newRelatePayItem.getPkValue(), detailRowIndex);
        }
        this.getModel().beginInit();
        int relateCount = 0;
        DynamicObject oldRelatePayItem = this.getModel().getEntryRowEntity("itementry", oldRelatePayItemRow);
        for (DynamicObject detail : detailEntry) {
            if (!oldRelatePayItem.getPkValue().equals(detail.get("itemid"))) continue;
            ++relateCount;
        }
        if (relateCount == 0) {
            this.getModel().deleteEntryRow("itementry", oldRelatePayItemRow);
        } else {
            this.getModel().beginInit();
            BigDecimal ofTaxAmount = (BigDecimal)this.getModel().getValue("oftaxamount", oldRelatePayItemRow);
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", oldRelatePayItemRow);
            BigDecimal taxAmt = (BigDecimal)this.getModel().getValue("taxamt", oldRelatePayItemRow);
            this.getModel().setValue("oftaxamount", (Object)ofTaxAmount.subtract(detailOfTaxAmt), oldRelatePayItemRow);
            this.getModel().setValue("amount", (Object)amount.subtract(detailAmt), oldRelatePayItemRow);
            this.getModel().setValue("taxamt", (Object)taxAmt.subtract(detailTaxAmt), oldRelatePayItemRow);
            BigDecimal rate = amount.add(detailAmt).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : taxAmt.add(detailTaxAmt).multiply(new BigDecimal(100)).divide(detailAmt, 2, 4);
            this.getModel().endInit();
        }
        this.getView().updateView("itementry");
        ContractSettleHelper.setEnableItementry((IFormView)this.getView());
    }

    public abstract void onPeriodChange();

    private void onChangeOfTaxAmount(PropertyChangedArgs args) {
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        boolean isMultiRate = (Boolean)model.getValue("ismultirate");
        boolean isonlist = (Boolean)model.getValue("isonlist");
        BigDecimal ofTaxAmount = (BigDecimal)model.getValue("oftaxamount", rowIndex);
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal rate = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (isonlist) {
            DynamicObject rateObj = (DynamicObject)model.getValue("itemrate", rowIndex);
            if (rateObj != null) {
                rate = rateObj.getBigDecimal("taxrate");
            }
            amount = ofTaxAmount.divide(BigDecimal.ONE.add(rate.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP)), 10, RoundingMode.HALF_UP);
            taxAmount = ofTaxAmount.subtract(amount);
            if (isMultiRate && amount.compareTo(BigDecimal.ZERO) == 0 && taxAmount.compareTo(BigDecimal.ZERO) == 0) {
                rate = BigDecimal.ZERO;
            }
        } else {
            DynamicObject rateObj = (DynamicObject)model.getValue("itemrate", rowIndex);
            if (rateObj != null) {
                rate = rateObj.getBigDecimal("taxrate");
            }
            amount = ofTaxAmount.divide(BigDecimal.ONE.add(rate.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP)), 6, RoundingMode.HALF_UP);
            taxAmount = ofTaxAmount.subtract(amount);
        }
        model.beginInit();
        model.setValue("taxamt", (Object)taxAmount, rowIndex);
        model.setValue("amount", (Object)amount, rowIndex);
        model.endInit();
        this.getView().updateView("itementry", rowIndex);
        this.checkNeedReComputeItem(rowIndex);
        this.computeTotal();
    }

    private void onChangeRate(PropertyChangedArgs args) {
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal ofTaxAmount = (BigDecimal)model.getValue("oftaxamount", rowIndex);
        BigDecimal taxRate = BigDecimal.ZERO;
        DynamicObject rateObj = (DynamicObject)model.getValue("itemrate", rowIndex);
        if (rateObj != null) {
            taxRate = rateObj.getBigDecimal("taxrate");
        }
        BigDecimal amount = ofTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 10, 4);
        BigDecimal taxAmount = ofTaxAmount.subtract(amount);
        model.beginInit();
        model.setValue("taxamt", (Object)taxAmount, rowIndex);
        model.setValue("amount", (Object)amount, rowIndex);
        model.endInit();
        this.getView().updateView("itementry", rowIndex);
        this.checkNeedReComputeItem(rowIndex);
        this.computeTotal();
    }

    public void onChangeAmount(PropertyChangedArgs args) {
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal taxRate = BigDecimal.ZERO;
        DynamicObject rateObj = (DynamicObject)model.getValue("itemrate", rowIndex);
        if (rateObj != null) {
            taxRate = rateObj.getBigDecimal("taxrate");
        }
        BigDecimal amount = (BigDecimal)model.getValue("amount", rowIndex);
        BigDecimal ofTaxAmount = amount.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))));
        BigDecimal taxAmount = ofTaxAmount.subtract(amount);
        model.beginInit();
        model.setValue("taxamt", (Object)taxAmount, rowIndex);
        model.setValue("oftaxamount", (Object)ofTaxAmount, rowIndex);
        model.endInit();
        this.getView().updateView("itementry", rowIndex);
        this.checkNeedReComputeItem(rowIndex);
        this.computeTotal();
    }

    public void onChangeTaxAmt(PropertyChangedArgs args) {
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal ofTaxAmount = (BigDecimal)model.getValue("oftaxamount", rowIndex);
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamt", rowIndex);
        BigDecimal amount = ofTaxAmount.subtract(taxAmount);
        model.beginInit();
        model.setValue("amount", (Object)amount, rowIndex);
        model.endInit();
        this.getView().updateView("itementry", rowIndex);
        this.checkNeedReComputeItem(rowIndex);
        this.computeTotal();
    }

    public void computeTotal() {
        String conSettleEntity;
        String contractEntity;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject contract = (DynamicObject)model.getValue("contract");
        if (contract == null) {
            return;
        }
        String payDirection = dataEntity.getString("paydirection");
        if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
            contractEntity = "pmct_incontract";
            conSettleEntity = "pmct_incontract_settle";
        } else {
            contractEntity = "pmct_outcontract";
            conSettleEntity = "pmct_outcontract_settle";
        }
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)contractEntity);
        BigDecimal settleOfTaxAmount = BigDecimal.ZERO;
        BigDecimal calOfTaxAmt = BigDecimal.ZERO;
        BigDecimal notCalOfTaxAmt = BigDecimal.ZERO;
        BigDecimal totalCalOfTaxAmt = contract.getBigDecimal("totalcaloftaxamt");
        BigDecimal totalNotCalOfTaxAmt = contract.getBigDecimal("totalnotcaloftaxamt");
        BigDecimal totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
        BigDecimal settleAmount = BigDecimal.ZERO;
        BigDecimal calOfAmt = BigDecimal.ZERO;
        BigDecimal notCalOfAmt = BigDecimal.ZERO;
        BigDecimal totalCalOfAmt = contract.getBigDecimal("totalcalofamt");
        BigDecimal totalNotCalOfAmt = contract.getBigDecimal("totalnotcalofamt");
        BigDecimal totalSettleOfAmount = contract.getBigDecimal("totalsettleamount");
        DynamicObjectCollection itemEntryCol = model.getEntryEntity("itementry");
        for (DynamicObject itemEntry : itemEntryCol) {
            DynamicObject payItem = itemEntry.getDynamicObject("payitem");
            if (payItem == null) {
                return;
            }
            String direction = payItem.getString("direction");
            if (direction == null) continue;
            if (StringUtils.equals((CharSequence)"850444247600913408", (CharSequence)String.valueOf(payItem.getPkValue()))) {
                if (direction.equals(DirectionEnum.ADD.getValue())) {
                    calOfTaxAmt = calOfTaxAmt.add(itemEntry.getBigDecimal("oftaxamount"));
                    calOfAmt = calOfAmt.add(itemEntry.getBigDecimal("amount"));
                    continue;
                }
                if (!direction.equals(DirectionEnum.SUB.getValue())) continue;
                calOfTaxAmt = calOfTaxAmt.subtract(itemEntry.getBigDecimal("oftaxamount"));
                calOfAmt = calOfAmt.subtract(itemEntry.getBigDecimal("amount"));
                continue;
            }
            if (direction.equals(DirectionEnum.ADD.getValue())) {
                notCalOfTaxAmt = notCalOfTaxAmt.add(itemEntry.getBigDecimal("oftaxamount"));
                notCalOfAmt = notCalOfAmt.add(itemEntry.getBigDecimal("amount"));
                continue;
            }
            if (!direction.equals(DirectionEnum.SUB.getValue())) continue;
            notCalOfTaxAmt = notCalOfTaxAmt.subtract(itemEntry.getBigDecimal("oftaxamount"));
            notCalOfAmt = notCalOfAmt.subtract(itemEntry.getBigDecimal("amount"));
        }
        settleOfTaxAmount = calOfTaxAmt.add(notCalOfTaxAmt);
        settleAmount = calOfAmt.add(notCalOfAmt);
        totalCalOfTaxAmt = totalCalOfTaxAmt.add(calOfTaxAmt);
        totalCalOfAmt = totalCalOfAmt.add(calOfAmt);
        totalNotCalOfTaxAmt = totalNotCalOfTaxAmt.add(notCalOfTaxAmt);
        totalNotCalOfAmt = totalNotCalOfAmt.add(notCalOfAmt);
        totalSettleOfTaxAmount = totalSettleOfTaxAmount.add(settleOfTaxAmount);
        totalSettleOfAmount = totalSettleOfAmount.add(settleAmount);
        BigDecimal taxAmount = settleOfTaxAmount.subtract(settleAmount);
        BigDecimal calTaxAmt = calOfTaxAmt.subtract(calOfAmt);
        BigDecimal notCalTaxAmt = notCalOfTaxAmt.subtract(notCalOfAmt);
        BigDecimal totalCalTaxAmt = totalCalOfTaxAmt.subtract(totalCalOfAmt);
        BigDecimal totalNotCalTaxAmt = totalNotCalOfTaxAmt.subtract(totalNotCalOfAmt);
        BigDecimal totalSettleTaxAmount = totalSettleOfTaxAmount.subtract(totalSettleOfAmount);
        model.setValue("caloftaxamt", (Object)calOfTaxAmt);
        model.setValue("notcaloftaxamt", (Object)notCalOfTaxAmt);
        model.setValue("settleoftaxamount", (Object)settleOfTaxAmount);
        model.setValue("totalcaloftaxamt", (Object)totalCalOfTaxAmt);
        model.setValue("totalnotcaloftaxamt", (Object)totalNotCalOfTaxAmt);
        model.setValue("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
        model.setValue("calofamt", (Object)calOfAmt);
        model.setValue("notcalofamt", (Object)notCalOfAmt);
        model.setValue("settleamount", (Object)settleAmount);
        model.setValue("totalcalofamt", (Object)totalCalOfAmt);
        model.setValue("totalnotcalofamt", (Object)totalNotCalOfAmt);
        model.setValue("totalsettleofamount", (Object)totalSettleOfAmount);
        model.setValue("caltaxamt", (Object)calTaxAmt);
        model.setValue("notcaltaxamt", (Object)notCalTaxAmt);
        model.setValue("taxamount", (Object)taxAmount);
        model.setValue("totalcaltaxamt", (Object)totalCalTaxAmt);
        model.setValue("totalnotcaltaxamt", (Object)totalNotCalTaxAmt);
        model.setValue("totalsettletaxamount", (Object)totalSettleTaxAmount);
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        if (multiPartSettlement) {
            BigDecimal sumAmountFieldOrgPro = calOfTaxAmt;
            BigDecimal sumNotCalOfTaxAmtOrgPro = notCalOfTaxAmt;
            BigDecimal sumSettleOfTaxAmtOrgPro = settleOfTaxAmount;
            BigDecimal sumCalOfAmt = calOfAmt;
            BigDecimal sumNotCalOfAmt = notCalOfAmt;
            BigDecimal sumSettleOfAmt = settleAmount;
            BigDecimal sumCalTaxAmt = sumAmountFieldOrgPro.subtract(sumCalOfAmt);
            BigDecimal sumNotCalTaxAmt = sumNotCalOfTaxAmtOrgPro.subtract(sumNotCalOfAmt);
            BigDecimal sumSettleTaxAmt = sumSettleOfTaxAmtOrgPro.subtract(sumSettleOfAmt);
            DynamicObject thisBill = this.getModel().getDataEntity();
            DynamicObject org = thisBill.getDynamicObject("org");
            DynamicObject project = thisBill.getDynamicObject("project");
            QFilter filter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
            if (project != null) {
                filter.and(new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString())));
            }
            filter.and(new QFilter("contract", "=", (Object)Long.parseLong(contract.getPkValue().toString())));
            filter.and(new QFilter("billstatus", "=", (Object)"C"));
            DynamicObject[] settleBills = BusinessDataServiceHelper.load((String)conSettleEntity, (String)"billno, billstatus, creator, auditor, modifier, auditdate, createtime, modifytime, billname, contattr, org, project, period, begindate, enddate, conttotaloftaxamount, taxrate, ismultirate, ismulticurrency, isonlist, description, isvoucher, currency, stdcurrency, exratetable, exchangedate, exchangerate, radiofield, radiofield1, showcurrency, caloftaxamt, notcaloftaxamt, settleoftaxamount, totalcaloftaxamt, totalnotcaloftaxamt, totalsettleoftaxamount, totalplanpayoftaxamt, totalrealpayoftaxamt, stdcaloftaxamt, stdnotcaloftaxamt, stdsettleoftaxamount, stdtotalcaloftaxamt, stdtotalnotcaloftaxamt, stdtotalsettleoftaxamount, stdtotalplanpayoftaxamt, stdtotalrealpayoftaxamt, calofamt, notcalofamt, settleamount, totalcalofamt, totalnotcalofamt, totalsettleofamount, totalplanpayofamt, totalrealpayofamt, stdcalofamt, stdnotcalofamt, stdsettleamount, stdtotalcalofamt, stdtotalnotcalofamt, stdtotalsettleofamount, stdtotalplanpayofamt, stdtotalrealpayofamt, caltaxamt, notcaltaxamt, taxamount, totalcaltaxamt, totalnotcaltaxamt, totalsettletaxamount, totalplanpaytaxamt, totalrealpaytaxamt, stdcaltaxamt, stdnotcaltaxamt, stdtaxamount, stdtotalcaltaxamt, stdtotalnotcaltaxamt, stdtotalsettletaxamount, stdtotalplanpaytaxamt, stdtotalrealpaytaxamt, imageno, bizaccountorg, fiaccountorg, ismulticontract, sumamountfield_org_pro, sumnotcaloftaxamt_org_pro, sumsettleoftaxamt_org_pro, stdsumamtfield_org_pro, stdsumnotcalamt_org_pro, stdsumsettleamt_org_pro, sumcalofamt, sumnotcalofamt, sumsettleofamt, stdsumcalofamt, stdsumnotcalofamt, stdsumsettleofamt, sumcaltaxamt, sumnotcaltaxamt, sumsettletaxamt, stdsumcaltaxamt, stdsumnotcaltaxamt, stdsumsettletaxamt", (QFilter[])new QFilter[]{filter});
            if (settleBills != null && settleBills.length > 0) {
                for (DynamicObject settleBill : settleBills) {
                    sumAmountFieldOrgPro = sumAmountFieldOrgPro.add(settleBill.getBigDecimal("sumamountfield_org_pro"));
                    sumNotCalOfTaxAmtOrgPro = sumNotCalOfTaxAmtOrgPro.add(settleBill.getBigDecimal("sumnotcaloftaxamt_org_pro"));
                    sumSettleOfTaxAmtOrgPro = sumSettleOfTaxAmtOrgPro.add(settleBill.getBigDecimal("sumsettleoftaxamt_org_pro"));
                    sumCalOfAmt = sumCalOfAmt.add(settleBill.getBigDecimal("sumcalofamt"));
                    sumNotCalOfAmt = sumNotCalOfAmt.add(settleBill.getBigDecimal("sumnotcalofamt"));
                    sumSettleOfAmt = sumSettleOfAmt.add(settleBill.getBigDecimal("sumsettleofamt"));
                    sumCalTaxAmt = sumCalTaxAmt.add(settleBill.getBigDecimal("sumcaltaxamt"));
                    sumNotCalTaxAmt = sumNotCalTaxAmt.add(settleBill.getBigDecimal("sumnotcaltaxamt"));
                    sumSettleTaxAmt = sumSettleTaxAmt.add(settleBill.getBigDecimal("sumsettletaxamt"));
                }
            }
            model.setValue("sumamountfield_org_pro", (Object)sumAmountFieldOrgPro);
            model.setValue("sumnotcaloftaxamt_org_pro", (Object)sumNotCalOfTaxAmtOrgPro);
            model.setValue("sumsettleoftaxamt_org_pro", (Object)sumSettleOfTaxAmtOrgPro);
            model.setValue("sumcalofamt", (Object)sumCalOfAmt);
            model.setValue("sumnotcalofamt", (Object)sumNotCalOfAmt);
            model.setValue("sumsettleofamt", (Object)sumSettleOfAmt);
            model.setValue("sumcaltaxamt", (Object)sumCalTaxAmt);
            model.setValue("sumnotcaltaxamt", (Object)sumNotCalTaxAmt);
            model.setValue("sumsettletaxamt", (Object)sumSettleTaxAmt);
        }
    }

    public void checkNeedReComputeItem(int rowIndex) {
        ContractSettleHelper.checkNeedReComputeItem((int)rowIndex, (IFormView)this.getView());
    }

    public void reComputePayItem(int rowIndex) {
        ContractSettleHelper.reComputePayItem((int)rowIndex, (IFormView)this.getView());
    }

    public abstract void onChangeContract();

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (RELATE_LIST_CONFIRM_CALL_BACK.equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.relateListConfirmCallBack();
        } else if (CHANGE_LIST_BUDGET_CONFIRM_CALL_BACK.equals(callBackId)) {
            this.changeListBudgetConfirmCallBack(result);
        } else if (CHANGE_DETAIL_BUDGET_CONFIRM_CALL_BACK.equals(callBackId)) {
            this.changeDetailBudgetConfirmCallBack(result);
        }
    }

    protected void changeDetailBudgetConfirmCallBack(MessageBoxResult result) {
        int row = Integer.parseInt(this.getPageCache().get(BUDGET_ITEM_ROW));
        if (MessageBoxResult.Cancel.equals((Object)result)) {
            this.getModel().beginInit();
            if (this.getPageCache().get(OLD_BUDGET_ITEM_ID) == null || this.getPageCache().get(OLD_BUDGET_ITEM_ID).isEmpty()) {
                this.getModel().setValue("detailbudgetitem", null, row);
            } else {
                this.getModel().setValue("detailbudgetitem", (Object)Long.parseLong(this.getPageCache().get(OLD_BUDGET_ITEM_ID)), row);
            }
            this.getModel().endInit();
            this.getView().updateView("detailbudgetitem", row);
        } else {
            DynamicObject newBudget = (DynamicObject)this.getModel().getValue("detailbudgetitem", row);
            this.changePayItemByDetailBudgetChange(newBudget, row);
        }
    }

    protected void changeListBudgetConfirmCallBack(MessageBoxResult result) {
        int row = Integer.parseInt(this.getPageCache().get(BUDGET_ITEM_ROW));
        if (MessageBoxResult.Cancel.equals((Object)result)) {
            this.getModel().beginInit();
            if (this.getPageCache().get(OLD_BUDGET_ITEM_ID) == null || this.getPageCache().get(OLD_BUDGET_ITEM_ID).isEmpty()) {
                this.getModel().setValue("outbudget", null, row);
            } else {
                Long budgetId = Long.parseLong(this.getPageCache().get(OLD_BUDGET_ITEM_ID));
                this.getModel().setValue("outbudget", (Object)budgetId, row);
            }
            this.getModel().endInit();
            this.getView().updateView("outbudget", row);
        } else if (MessageBoxResult.Yes.equals((Object)result)) {
            DynamicObject newBudget = (DynamicObject)this.getModel().getValue("outbudget", row);
            this.changePayItemByListBudgetChange(newBudget, row);
        }
    }

    protected void relateListConfirmCallBack() {
        DynamicObjectCollection detailEntry = this.getModel().getEntryEntity("payitemdetailentry");
        DynamicObjectCollection listModelEntry = this.getModel().getEntryEntity("listmodelentry");
        EntryGrid entryGrid = (EntryGrid)this.getControl("itementry");
        int[] nArray = entryGrid.getSelectRows();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer row = nArray[i];
            Object payItemId = this.getModel().getEntryRowEntity("itementry", row.intValue()).getPkValue();
            for (DynamicObject model : listModelEntry) {
                DynamicObjectCollection listEntry = model.getDynamicObjectCollection("listentry");
                Iterator listIt = listEntry.iterator();
                while (listIt.hasNext()) {
                    if (!payItemId.equals(((DynamicObject)listIt.next()).getLong("payitemid"))) continue;
                    listIt.remove();
                }
            }
            Iterator detailIt = detailEntry.iterator();
            while (detailIt.hasNext()) {
                if (!payItemId.equals(((DynamicObject)detailIt.next()).getLong("itemid"))) continue;
                detailIt.remove();
            }
        }
        this.getModel().deleteEntryRows("itementry", entryGrid.getSelectRows());
        this.getModel().updateEntryCache(listModelEntry);
        this.getView().updateView("listentry");
        this.getModel().updateEntryCache(detailEntry);
        this.getView().updateView("payitemdetailentry");
        this.itemEntryClick();
        this.sumListModelAmount();
        this.computeTotal();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "deleteitementry": {
                EntryGrid control = (EntryGrid)this.getView().getControl("itementry");
                int[] selectRows = control.getSelectRows();
                DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
                DynamicObjectCollection modelEntry = this.getModel().getEntryEntity("listmodelentry");
                DynamicObjectCollection detailEntry = this.getModel().getEntryEntity("payitemdetailentry");
                StringBuilder listStringBuilder = new StringBuilder();
                StringBuilder detailStringBuilder = new StringBuilder();
                block11: for (int rowIndex : selectRows) {
                    Object payItemId = ((DynamicObject)itemEntry.get(rowIndex)).getPkValue();
                    block12: for (DynamicObject model : modelEntry) {
                        for (DynamicObject list : model.getDynamicObjectCollection("listentry")) {
                            if (!payItemId.equals(list.getLong("payitemid"))) continue;
                            listStringBuilder.append(rowIndex + 1).append("\uff0c");
                            break block12;
                        }
                    }
                    for (DynamicObject detail : detailEntry) {
                        if (!payItemId.equals(detail.getLong("itemid"))) continue;
                        detailStringBuilder.append(rowIndex + 1).append("\uff0c");
                        continue block11;
                    }
                }
                if (listStringBuilder.length() > 0) {
                    listStringBuilder.delete(listStringBuilder.length() - 1, listStringBuilder.length());
                }
                if (detailStringBuilder.length() > 0) {
                    detailStringBuilder.delete(detailStringBuilder.length() - 1, detailStringBuilder.length());
                }
                if (listStringBuilder.length() > 0 && detailStringBuilder.length() > 0) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5df2\u5173\u8054\u8ba1\u91cf\u6e05\u5355\uff0c\u7b2c%2$s\u884c\u5df2\u5173\u8054\u652f\u4ed8\u9879\u660e\u7ec6\u3002\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"AbstractContractSettleEditUI_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), listStringBuilder, detailStringBuilder), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RELATE_LIST_CONFIRM_CALL_BACK, (IFormPlugin)this));
                    args.setCancel(true);
                    break;
                }
                if (listStringBuilder.length() > 0 && detailStringBuilder.length() == 0) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5df2\u5173\u8054\u8ba1\u91cf\u6e05\u5355\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"AbstractContractSettleEditUI_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), listStringBuilder), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RELATE_LIST_CONFIRM_CALL_BACK, (IFormPlugin)this));
                    args.setCancel(true);
                    break;
                }
                if (listStringBuilder.length() != 0 || detailStringBuilder.length() <= 0) break;
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5df2\u5173\u8054\u652f\u4ed8\u9879\u660e\u7ec6\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"AbstractContractSettleEditUI_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), detailStringBuilder), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RELATE_LIST_CONFIRM_CALL_BACK, (IFormPlugin)this));
                args.setCancel(true);
                break;
            }
            case "addentry": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                if (contract == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"AbstractContractSettleEditUI_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmct_payitem", (boolean)true, (int)2);
                parameter.setShowUsed(true);
                parameter.setShowApproved(true);
                Long contTypePk = (Long)BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract").getDynamicObject("contracttype").getPkValue();
                QFilter contTypeFilter = new QFilter("contracttype.fbasedataid", "in", Collections.singletonList(contTypePk)).or("contracttype.fbasedataid", "=", null);
                QFilter enableFilter = new QFilter("enable", "=", (Object)true);
                parameter.getListFilterParameter().getQFilters().add(contTypeFilter);
                parameter.getListFilterParameter().getQFilters().add(enableFilter);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_payitem");
                parameter.setCloseCallBack(callBack);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "newlistentry": 
            case "deletelistentry": {
                int[] selectedRows;
                int listEntryIndex = this.getModel().getEntryCurrentRowIndex("listmodelentry");
                if (listEntryIndex < 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u6e05\u5355\u6a21\u677f\u5361\u7247\u3002", (String)"AbstractContractSettleEditUI_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.cancel = true;
                }
                if (LISTENTRY_ADDNEW.equals(operateKey)) {
                    ListShowParameter parameter1 = ShowFormHelper.createShowListForm((String)"pmct_contractlist", (boolean)true, (int)3, (boolean)true);
                    List qFilters = parameter1.getListFilterParameter().getQFilters();
                    int rowCount1 = this.getModel().getEntryRowCount("listentry");
                    ArrayList<Object> listingIds = new ArrayList<Object>();
                    for (int index = 0; index < rowCount1; ++index) {
                        DynamicObject listing = (DynamicObject)this.getModel().getValue("listing", index);
                        if (listing == null) continue;
                        listingIds.add(listing.getPkValue());
                    }
                    qFilters.add(new QFilter("id", "not in", listingIds));
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("listmodelentry");
                    Object listModelId = this.getModel().getValue("listmodelid", rowIndex);
                    qFilters.add(new QFilter("listingmodel", "=", listModelId));
                    DynamicObject contract1 = (DynamicObject)this.getModel().getValue("contract");
                    if (contract1 != null) {
                        qFilters.add(new QFilter("contractid", "=", (Object)contract1.getPkValue().toString()));
                    }
                    parameter1.setCustomParam("listmodelid", listModelId);
                    CloseCallBack callBack1 = new CloseCallBack((IFormPlugin)this, LISTENTRY_ADDNEW);
                    parameter1.setCloseCallBack(callBack1);
                    this.getView().showForm((FormShowParameter)parameter1);
                    break;
                }
                if (!LISTENTRY_DELETE.equals(operateKey)) break;
                HashSet<Integer> payItemIdSet = new HashSet<Integer>(16);
                SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl("listentry");
                DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
                for (int row : selectedRows = subEntryGrid.getSelectRows()) {
                    Long listPayItemId = (Long)this.getModel().getValue("payitemid", row);
                    for (int index = 0; index < itemEntry.size(); ++index) {
                        if (!((DynamicObject)itemEntry.get(index)).getPkValue().equals(listPayItemId)) continue;
                        payItemIdSet.add(index);
                    }
                }
                this.getPageCache().put(RELATE_LIST_PAY_ITEM_INDEX, SerializationUtils.toJsonString(payItemIdSet));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)OPERATE_DELETE, (CharSequence)operateKey)) {
            this.itemEntryClick();
            this.computeTotal();
        } else if (StringUtils.equals((CharSequence)LISTENTRY_DELETE, (CharSequence)operateKey)) {
            this.deletePayItem();
            this.itemEntryClick();
            this.sumListModelAmount();
            this.sumHeadAmount();
            EntryGrid entryGrid = (EntryGrid)this.getControl("itementry");
            int selectRows = this.getModel().getEntryEntity("itementry").size() - 1;
            entryGrid.selectRows(selectRows, true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (actionId.equals("pmct_payitem") && closedCallBackEvent.getReturnData() != null) {
            this.payItemCallBack(rows);
        } else if (LISTENTRY_ADDNEW.equals(actionId)) {
            this.listAddNewCallBack(rows);
        }
    }

    protected void payItemCallBack(ListSelectedRowCollection rows) {
        ArrayList<Object> selectedIds = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            selectedIds.add(row.getPrimaryKeyValue());
        }
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        DynamicObject taxRateObject = (DynamicObject)this.getModel().getValue("taxrate");
        for (Object e : selectedIds) {
            this.getModel().beginInit();
            int row = this.getModel().createNewEntryRow("itementry");
            this.getModel().setValue("payitem", e, row);
            DynamicObject payItem = (DynamicObject)this.getModel().getValue("payitem", row);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            this.getModel().setValue("remark", (Object)payItem.getString("description"), row);
            if (payItem.getBoolean("iscompute")) {
                this.reComputePayItem(row);
            }
            this.getView().updateView("itementry", row);
            this.getModel().endInit();
            ContractSettleHelper.setEnableItementry((IFormView)this.getView());
            SettleUpdateAmtUtils.calAllTypeAmount((IDataModel)this.getModel());
        }
    }

    protected void listAddNewCallBack(ListSelectedRowCollection rows) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        ArrayList<Integer> relateListPayItemsSeq = new ArrayList<Integer>(10);
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection itemEntry = data.getDynamicObjectCollection("itementry");
        DynamicObjectCollection listModelEntry = this.getModel().getEntryEntity("listmodelentry");
        for (DynamicObject model : listModelEntry) {
            DynamicObjectCollection listEntry = model.getDynamicObjectCollection("listentry");
            block1: for (DynamicObject list : listEntry) {
                for (int index = 0; index < itemEntry.size(); ++index) {
                    if (((DynamicObject)itemEntry.get(index)).getPkValue() == null || !((DynamicObject)itemEntry.get(index)).getPkValue().equals(list.getLong("payitemid"))) continue;
                    relateListPayItemsSeq.add(index);
                    continue block1;
                }
            }
        }
        DynamicObject settlePayItem = BusinessDataServiceHelper.loadSingle((Object)SETTLE_PAY_ITEM_ID, (String)"pmct_payitem");
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        boolean isMultiContract = (Boolean)this.getModel().getValue("ismulticontract");
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        List returnIds = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        ORM orm = ORM.create();
        long[] newPayItemIds = orm.genLongIds((IDataEntityType)itemEntry.getRootEntityType(), returnIds.size());
        for (int i = 0; i < returnIds.size(); ++i) {
            int listRow = this.getModel().createNewEntryRow("listentry");
            DynamicObject listing = BusinessDataServiceHelper.loadSingle(returnIds.get(i), (String)"pmct_contractlist");
            this.getModel().setValue("listing", (Object)listing, listRow);
            this.getModel().setValue("listingname", (Object)listing.getLocaleString("name").getLocaleValue(), listRow);
            this.getModel().setValue("measureunit", (Object)listing.getDynamicObject("measureunit"), listRow);
            this.getModel().setValue("totalqty", (Object)listing.getString("totalqty"), listRow);
            this.getModel().setValue("curtaxprice", (Object)listing.getBigDecimal("curtaxprice"), listRow);
            this.getModel().setValue("preqty", (Object)listing.getBigDecimal("lstsettleqty"), listRow);
            this.getModel().setValue("desc", (Object)listing.getString("desc"), listRow);
            BigDecimal lstSettleOfTaxAmount = listing.getBigDecimal("lstsettleoftaxamount");
            this.getModel().setValue("preamout", (Object)lstSettleOfTaxAmount.subtract(listing.getBigDecimal("lstsettletaxamt")), listRow);
            this.getModel().setValue("materiel", (Object)listing.getDynamicObject("material"), listRow);
            if (!isMultiContract) {
                this.getModel().beginInit();
                this.getModel().setValue("outbudget", (Object)listing.getDynamicObject("listingbudgetitem"), listRow);
                this.getModel().endInit();
                this.getView().updateView("outbudget", listRow);
            }
            this.getModel().setValue("lstqty", (Object)NumberHelper.add((Object)this.getModel().getValue("preqty", listRow), (Object)this.getModel().getValue("thisqty", listRow)), listRow);
            this.getModel().setValue("lstamount", (Object)NumberHelper.add((Object)this.getModel().getValue("preamout", listRow), (Object)this.getModel().getValue("thisamount", listRow)), listRow);
            DynamicObject listBudget = (DynamicObject)this.getModel().getValue("outbudget", listRow);
            boolean findPayItem = false;
            for (Integer seq : relateListPayItemsSeq) {
                DynamicObject payItem = (DynamicObject)itemEntry.get(seq.intValue());
                DynamicObject payItemBudget = payItem.getDynamicObject("paybudgetitem");
                if (listBudget != null && payItemBudget != null && payItemBudget.getPkValue().equals(listBudget.getPkValue())) {
                    this.getModel().setValue("payitemid", ((DynamicObject)itemEntry.get(seq.intValue())).getPkValue(), listRow);
                    findPayItem = true;
                    break;
                }
                if (listBudget != null || payItemBudget != null) continue;
                this.getModel().setValue("payitemid", ((DynamicObject)itemEntry.get(seq.intValue())).getPkValue(), listRow);
                findPayItem = true;
                break;
            }
            if (!findPayItem) {
                long newPayItemId = newPayItemIds[i];
                DynamicObject payItemEntry = new DynamicObject(itemEntry.getDynamicObjectType());
                payItemEntry.set("id", (Object)newPayItemId);
                payItemEntry.set("payitem", (Object)settlePayItem);
                payItemEntry.set("paybudgetitem", (Object)listBudget);
                itemEntry.add((Object)payItemEntry);
                this.getModel().setValue("payitem", settlePayItem.getPkValue(), itemEntry.size() - 1);
                this.getModel().setValue("payitemid", (Object)newPayItemId, listRow);
                relateListPayItemsSeq.add(itemEntry.size() - 1);
            }
            this.getModel().beginInit();
            this.getModel().setValue("listrate", listing.get("rateobj"), listRow);
            this.getModel().endInit();
            this.getView().updateView("listrate", listRow);
        }
        this.getView().updateView("itementry");
        ContractSettleHelper.setEnableItementry((IFormView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"itementry", (CharSequence)control.getKey())) {
            this.itemEntryClick();
        } else if (StringUtils.equals((CharSequence)"listmodelentry", (CharSequence)control.getKey())) {
            this.listModelEntryClick();
        }
    }

    protected void itemEntryClick() {
        EntryGrid itemGrid;
        int[] selectRows;
        ArrayList<Integer> setListColorIndex = new ArrayList<Integer>(10);
        DynamicObjectCollection listEntry = this.getModel().getEntryEntity("listentry");
        if (listEntry != null) {
            for (int index = 0; index < listEntry.size(); ++index) {
                setListColorIndex.add(index);
            }
        }
        SubEntryGrid listGrid = (SubEntryGrid)this.getControl("listentry");
        if (setListColorIndex.size() > 0) {
            listGrid.setRowBackcolor("", Arrays.stream(setListColorIndex.toArray(new Integer[setListColorIndex.size()])).mapToInt(Integer::valueOf).toArray());
        }
        ArrayList<Integer> setDetailColorIndex = new ArrayList<Integer>(10);
        DynamicObjectCollection detailEntry = this.getModel().getEntryEntity("payitemdetailentry");
        if (detailEntry != null) {
            for (int index = 0; index < detailEntry.size(); ++index) {
                setDetailColorIndex.add(index);
            }
        }
        EntryGrid detailGrid = (EntryGrid)this.getControl("payitemdetailentry");
        if (setDetailColorIndex.size() > 0) {
            detailGrid.setRowBackcolor("", Arrays.stream(setDetailColorIndex.toArray(new Integer[setDetailColorIndex.size()])).mapToInt(Integer::valueOf).toArray());
        }
        if ((selectRows = (itemGrid = (EntryGrid)this.getControl("itementry")).getSelectRows()).length == 0) {
            return;
        }
        for (int row : selectRows) {
            int index;
            DynamicObject item = this.getModel().getEntryRowEntity("itementry", row);
            setListColorIndex.clear();
            if (listEntry != null) {
                for (index = 0; index < listEntry.size(); ++index) {
                    if (!item.getPkValue().equals(((DynamicObject)listEntry.get(index)).getLong("payitemid"))) continue;
                    setListColorIndex.add(index);
                }
            }
            if (setListColorIndex.size() > 0) {
                listGrid.setRowBackcolor("#D2E9FF", Arrays.stream(setListColorIndex.toArray(new Integer[setListColorIndex.size()])).mapToInt(Integer::valueOf).toArray());
            }
            setDetailColorIndex.clear();
            if (detailEntry != null) {
                for (index = 0; index < detailEntry.size(); ++index) {
                    if (!item.getPkValue().equals(((DynamicObject)detailEntry.get(index)).getLong("itemid"))) continue;
                    setDetailColorIndex.add(index);
                }
            }
            if (setDetailColorIndex.size() <= 0) continue;
            detailGrid.setRowBackcolor("#D2E9FF", Arrays.stream(setDetailColorIndex.toArray(new Integer[setDetailColorIndex.size()])).mapToInt(Integer::valueOf).toArray());
        }
    }

    protected void listModelEntryClick() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("itementry");
        int[] nArray = entryGrid.getSelectRows();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer row = nArray[i];
            ArrayList<Integer> setListColorIndex = new ArrayList<Integer>(10);
            DynamicObjectCollection listEntry = this.getModel().getEntryEntity("listentry");
            DynamicObject item = this.getModel().getEntryRowEntity("itementry", row.intValue());
            for (int index = 0; index < listEntry.size(); ++index) {
                if (!item.getPkValue().equals(((DynamicObject)listEntry.get(index)).getLong("payitemid"))) continue;
                setListColorIndex.add(index);
            }
            SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl("listentry");
            if (setListColorIndex.size() <= 0) continue;
            subEntryGrid.setRowBackcolor("#D2E9FF", Arrays.stream(setListColorIndex.toArray(new Integer[setListColorIndex.size()])).mapToInt(Integer::valueOf).toArray());
        }
    }

    protected void deletePayItem() {
        String payItemSeqString = this.getPageCache().get(RELATE_LIST_PAY_ITEM_INDEX);
        if (payItemSeqString != null && !payItemSeqString.isEmpty()) {
            List payItemSeqSet = SerializationUtils.fromJsonStringToList((String)payItemSeqString, Object.class);
            DynamicObjectCollection listModelEntry = this.getModel().getEntryEntity("listmodelentry");
            Iterator it = payItemSeqSet.iterator();
            while (it.hasNext()) {
                Integer index = (Integer)it.next();
                Object payItemId = ((DynamicObject)this.getModel().getEntryEntity("itementry").get(index.intValue())).getPkValue();
                boolean findPayItem = false;
                for (DynamicObject model : listModelEntry) {
                    DynamicObjectCollection listEntry = model.getDynamicObjectCollection("listentry");
                    for (DynamicObject list : listEntry) {
                        if (!payItemId.equals(list.getLong("payitemid"))) continue;
                        findPayItem = true;
                    }
                }
                if (!findPayItem) continue;
                it.remove();
            }
            int[] deletePayItemIndex = Arrays.stream(payItemSeqSet.toArray(new Integer[payItemSeqSet.size()])).mapToInt(Integer::valueOf).toArray();
            this.getModel().deleteEntryRows("itementry", deletePayItemIndex);
        }
    }

    public void sumListModelAmount() {
        DynamicObjectCollection modelEntry = this.getModel().getEntryEntity("listmodelentry");
        for (int index = 0; index < modelEntry.size(); ++index) {
            DynamicObjectCollection entrys = ((DynamicObject)modelEntry.get(index)).getDynamicObjectCollection("listentry");
            if (entrys == null) {
                this.getModel().setValue("totalamount", (Object)0, index);
                this.getModel().setValue("totaloftaxamount", (Object)0, index);
                this.getModel().setValue("totaltax", (Object)0, index);
                return;
            }
            double totalamount = entrys.stream().collect(Collectors.summingDouble(obj -> {
                BigDecimal amt = obj.getBigDecimal("thisamount");
                if (amt == null || BigDecimal.ZERO.compareTo(amt) == 0) {
                    return 0.0;
                }
                return amt.doubleValue();
            }));
            double totaloftaxamount = entrys.stream().collect(Collectors.summingDouble(obj -> {
                BigDecimal amt = obj.getBigDecimal("thisoftaxmount");
                if (amt == null || BigDecimal.ZERO.compareTo(amt) == 0) {
                    return 0.0;
                }
                return amt.doubleValue();
            }));
            double tax = totaloftaxamount - totalamount;
            this.getModel().setValue("totalamount", (Object)totalamount, index);
            this.getModel().setValue("totaloftaxamount", (Object)totaloftaxamount, index);
            this.getModel().setValue("totaltax", (Object)tax, index);
        }
    }

    protected void sumHeadAmount() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity("listmodelentry");
        if (entries == null) {
            return;
        }
        DynamicObjectCollection itemEntry = model.getDataEntity(true).getDynamicObjectCollection("itementry");
        ArrayList<Integer> reSetPayItemIndex = new ArrayList<Integer>(10);
        for (DynamicObject listModel : entries) {
            String cmpType = listModel.getString("cmptype");
            BigDecimal coe = BigDecimal.ONE;
            if ("(+)".equals(cmpType)) {
                coe = BigDecimal.ONE;
            } else if ("(-)".equals(cmpType)) {
                coe = BigDecimal.valueOf(-1L);
            } else if ("(0)".equals(cmpType)) {
                coe = BigDecimal.ZERO;
            }
            DynamicObjectCollection listEntry = listModel.getDynamicObjectCollection("listentry");
            for (DynamicObject list : listEntry) {
                for (int index = 0; index < itemEntry.size(); ++index) {
                    if (!((DynamicObject)itemEntry.get(index)).getPkValue().equals(list.getLong("payitemid"))) continue;
                    if (!reSetPayItemIndex.contains(index)) {
                        this.getModel().beginInit();
                        this.getModel().setValue("oftaxamount", (Object)BigDecimal.ZERO, index);
                        this.getModel().setValue("amount", (Object)BigDecimal.ZERO, index);
                        this.getModel().setValue("taxamt", (Object)BigDecimal.ZERO, index);
                        this.getModel().endInit();
                        reSetPayItemIndex.add(index);
                    }
                    BigDecimal ofTaxAmount = (BigDecimal)this.getModel().getValue("oftaxamount", index);
                    BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", index);
                    BigDecimal taxAmt = (BigDecimal)this.getModel().getValue("taxamt", index);
                    BigDecimal listOfTaxAmount = list.getBigDecimal("thisoftaxmount");
                    BigDecimal listAmount = list.getBigDecimal("thisamount");
                    BigDecimal listTaxAmount = list.getBigDecimal("thistax");
                    this.getModel().beginInit();
                    this.getModel().setValue("oftaxamount", (Object)ofTaxAmount.add(listOfTaxAmount.multiply(coe)), index);
                    this.getModel().setValue("amount", (Object)amount.add(listAmount.multiply(coe)), index);
                    this.getModel().setValue("taxamt", (Object)taxAmt.add(listTaxAmount.multiply(coe)), index);
                    this.getModel().endInit();
                }
            }
        }
        this.getView().updateView("itementry");
        this.computeTotal();
    }
}

