/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmct.common.utils.RichEditorUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctFormPlugin;

public class ContRichTemplateEditPlugin
extends AbstractPmctFormPlugin
implements BeforeF7SelectListener {
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    private static final String BOS_ATTACHMENT = "bos_attachment";
    private static final String FINTERID = "finterid";
    private static final String FATTACHMENTPANEL = "fattachmentpanel";
    private static final String FFILEID = "FFileId";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object source = showParameter.getCustomParam("source");
        if (source != null) {
            this.getModel().setValue("source", source);
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)source, (String)"pmct_conttemplate");
            String newVersion = String.valueOf(sourceBill.getBigDecimal("version").add(BigDecimal.ONE).setScale(1, 4));
            String number = sourceBill.getString("number");
            String name = sourceBill.getString("number");
            number = number.lastIndexOf("_") != -1 ? number.substring(0, number.lastIndexOf("_")) : number;
            name = name.lastIndexOf("_") != -1 ? name.substring(0, name.lastIndexOf("_")) : name;
            this.getModel().setValue("number", (Object)String.join((CharSequence)"_", number, newVersion));
            this.getModel().setValue("name", (Object)String.join((CharSequence)"_", name, newVersion));
        }
    }

    public void afterBindData(EventObject e) {
        List attachmentData;
        List attachments;
        super.afterBindData(e);
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditor");
        richTextEditor.setText(this.getModel().getDataEntity().getString("templatetext"));
        boolean effective = (Boolean)this.getModel().getValue("effective");
        if (effective) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"fs_baseinfo"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"fs_baseinfo"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
        Object contTemplateId = this.getModel().getDataEntity().getPkValue();
        if (contTemplateId != null && !contTemplateId.equals(0L) && (attachments = AttachmentServiceHelper.getAttachments((String)"pmct_conttemplate", (Object)contTemplateId, (String)ATTACHMENT_PANEL)).size() > 0) {
            attachmentPanel.bindData(attachments);
        }
        if ((attachmentData = attachmentPanel.getAttachmentData()) == null || attachmentData.isEmpty()) {
            return;
        }
        for (Map attachmentMap : attachmentData) {
            String visiablePreview = "1";
            String visiableDownload = "1";
            String visiableRename = "0";
            String visiableDelete = "0";
            attachmentMap.put("visible", visiablePreview + visiableDownload + visiableRename + visiableDelete);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(ATTACHMENT_PANEL, "data", (Object)attachmentData);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"selectfield")) {
            String templateType = this.getModel().getDataEntity().getString("conttemplatetype");
            if (templateType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u7c7b\u578b\u3002", (String)"ContRichTemplateEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
            } else if (StringUtils.equals((CharSequence)"IN", (CharSequence)templateType)) {
                QFilter billtTypeFilter = new QFilter("billtypename", "=", (Object)"pmct_incontract");
                showParameter.getListFilterParameter().getQFilters().add(billtTypeFilter);
            } else if (StringUtils.equals((CharSequence)"OUT", (CharSequence)templateType)) {
                QFilter billTypeFilter = new QFilter("billtypename", "=", (Object)"pmct_outcontract");
                showParameter.getListFilterParameter().getQFilters().add(billTypeFilter);
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"selectentry")) {
            String templateType = this.getModel().getDataEntity().getString("conttemplatetype");
            if (templateType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u7c7b\u578b\u3002", (String)"ContRichTemplateEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
            } else if (StringUtils.equals((CharSequence)"IN", (CharSequence)templateType)) {
                QFilter billTypeFilter = new QFilter("billtypename", "=", (Object)"pmct_incontract");
                String[] fieldnames = new String[]{"incontpayplanentry", "riskentry"};
                QFilter fieldNameFilter = new QFilter("fieldname", "in", (Object)fieldnames);
                billTypeFilter.and(fieldNameFilter);
                showParameter.getListFilterParameter().getQFilters().add(billTypeFilter);
            } else if (StringUtils.equals((CharSequence)"OUT", (CharSequence)templateType)) {
                QFilter billTypeFilter = new QFilter("billtypename", "=", (Object)"pmct_outcontract");
                String[] fieldnames = new String[]{"outcontpayplanentry", "riskentry"};
                QFilter fieldNameFilter = new QFilter("fieldname", "in", (Object)fieldnames);
                billTypeFilter.and(fieldNameFilter);
                showParameter.getListFilterParameter().getQFilters().add(billTypeFilter);
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"selectlist")) {
            DynamicObject contarr = this.getModel().getDataEntity().getDynamicObject("group");
            if (contarr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u5c5e\u6027\u3002", (String)"ContRichTemplateEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            DynamicObjectCollection listconfigCol = contarr.getDynamicObjectCollection("listconfigentry");
            Set listconfigSet = listconfigCol.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            QFilter idFilter = new QFilter("id", "in", listconfigSet);
            showParameter.getListFilterParameter().getQFilters().add(idFilter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit selectField = (BasedataEdit)this.getControl("selectfield");
        selectField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit selectEntry = (BasedataEdit)this.getControl("selectentry");
        selectEntry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit selectPrivateInfo = (BasedataEdit)this.getControl("selectprivateinfo");
        if (selectPrivateInfo != null) {
            selectPrivateInfo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit selectList = (BasedataEdit)this.getControl("selectlist");
        selectList.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)callId, (CharSequence)"changeTemplateType")) {
            if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
                RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditor");
                richTextEditor.setText("");
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("conttemplatetype", (Object)this.getPageCache().get("templatetypeId"));
                this.getModel().endInit();
                this.getView().updateView("conttemplatetype");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
            DynamicObject thisModel = this.getModel().getDataEntity();
            boolean effective = thisModel.getBoolean("effective");
            if (effective) {
                ArrayList<DynamicObject> saveObjList = new ArrayList<DynamicObject>();
                QFilter effectiveFilter = new QFilter("effective", "=", (Object)"1");
                DynamicObject group = thisModel.getDynamicObject("group");
                QFilter groupFilter = null;
                if (group != null) {
                    groupFilter = new QFilter("group", "=", group.getPkValue());
                }
                String type = thisModel.getString("conttemplatetype");
                QFilter typeFilter = new QFilter("conttemplatetype", "=", (Object)type);
                QFilter idNotSelfFilter = new QFilter("id", "!=", thisModel.getPkValue());
                DynamicObject effectiveObj = BusinessDataServiceHelper.loadSingle((String)"pmct_conttemplate", (String)"id,group,effective", (QFilter[])new QFilter[]{idNotSelfFilter, effectiveFilter, groupFilter, typeFilter});
                if (effectiveObj != null) {
                    effectiveObj.set("effective", (Object)"0");
                    saveObjList.add(effectiveObj);
                    SaveServiceHelper.save((DynamicObject[])saveObjList.toArray(new DynamicObject[saveObjList.size()]));
                }
            }
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditor");
            String text = richTextEditor.getText();
            this.getModel().setValue("templatetext", (Object)text);
        } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            this.getView().invokeOperation("save");
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditor");
            String richText = (String)this.getModel().getValue("templatetext");
            richTextEditor.setText(richText);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        RichTextEditor richTextEditor;
        String richText;
        String oldValue;
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData xChangeData = e.getChangeSet()[0];
        Object newValue = xChangeData.getNewValue();
        if (StringUtils.equals((CharSequence)proName, (CharSequence)"selectfield")) {
            if (newValue == null) {
                return;
            }
            DynamicObject value = (DynamicObject)newValue;
            String codeBlock = RichEditorUtils.initpBlock((DynamicObject)value);
            this.appendString(codeBlock);
        } else if (StringUtils.equals((CharSequence)proName, (CharSequence)"selectentry")) {
            if (newValue == null) {
                return;
            }
            DynamicObject value = (DynamicObject)newValue;
            String table = RichEditorUtils.initTableControl((DynamicObject)value);
            this.appendString(table);
        } else if (StringUtils.equals((CharSequence)proName, (CharSequence)"selectlist")) {
            if (newValue == null) {
                return;
            }
            DynamicObject listValue = (DynamicObject)newValue;
            DynamicObject listModel = listValue.getDynamicObject("listmodel");
            if (listModel != null) {
                String table = "";
                String templateType = this.getModel().getDataEntity().getString("conttemplatetype");
                if (StringUtils.equals((CharSequence)"IN", (CharSequence)templateType)) {
                    table = RichEditorUtils.initListingTableControl((DynamicObject)listModel, (String)"pmct_incontract", (String)"listmodelentry", (String)"sublistentry");
                } else if (StringUtils.equals((CharSequence)"OUT", (CharSequence)templateType)) {
                    table = RichEditorUtils.initListingTableControl((DynamicObject)listModel, (String)"pmct_outcontract", (String)"listmodelentry", (String)"sublistentry");
                }
                this.appendString(table);
            }
        } else if (StringUtils.equals((CharSequence)proName, (CharSequence)"conttemplatetype") && (oldValue = (String)xChangeData.getOldValue()) != null && StringUtils.isNotBlank((CharSequence)(richText = (richTextEditor = (RichTextEditor)this.getControl("richtexteditor")).getText()))) {
            this.getPageCache().put("templatetypeId", oldValue);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6a21\u677f\u7c7b\u578b\u4f1a\u6e05\u7a7a\u5bcc\u6587\u672c\u5185\u5bb9\uff0c\u8fd8\u8981\u7ee7\u7eed\u5417\uff1f", (String)"ContRichTemplateEditPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("changeTemplateType"));
        }
    }

    private void appendString(String codeBlock) {
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditor");
        String text = richTextEditor.getText();
        if (StringUtils.isNotBlank((CharSequence)text)) {
            richTextEditor.setText(text + codeBlock);
        } else {
            richTextEditor.setText(codeBlock);
        }
    }
}

