/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.formplugin.base.AbstractPmgtBillPlugin;

public class ContStatusChangeEditPlugin
extends AbstractPmgtBillPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long contractId = (Long)this.getView().getFormShowParameter().getCustomParam("contractId");
        Long contStatusId = (Long)this.getView().getFormShowParameter().getCustomParam("contstatusId");
        if (contractId != null) {
            String formId = this.getView().getFormShowParameter().getFormId();
            String contractFormId = "";
            contractFormId = StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_contractstatus") ? "pmct_outcontract" : "pmct_incontract";
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)contractFormId);
            this.getModel().setValue("contract", (Object)contractId);
            this.getModel().setValue("currency", contract.getDynamicObject("currency").getPkValue());
            this.getView().setEnable(Boolean.FALSE, new String[]{"contract"});
        }
        if (contStatusId != null) {
            this.getModel().setValue("oldstatus", (Object)contStatusId);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"finlflexpanelap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        DynamicObject newStatus = (DynamicObject)this.getModel().getValue("newstatus");
        if (newStatus != null && ContractStatusEnum.CLOSED.getValue().equals(newStatus.getString("number"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"finlflexpanelap"});
            if (contract == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            } else {
                QFilter filter = new QFilter("contract", "=", contract.getPkValue());
                DynamicObject[] contBudgetInfo = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter});
                if (contBudgetInfo.length <= 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"finlflexpanelap"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit selectEntry = (BasedataEdit)this.getControl("newstatus");
        BasedataEdit contract = (BasedataEdit)this.getControl("contract");
        selectEntry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter filter;
        DynamicObject oldStatus;
        super.beforeF7Select(beforeF7SelectEvent);
        String propName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("newstatus".equals(propName) && (oldStatus = (DynamicObject)this.getModel().getValue("oldstatus")) != null) {
            filter = new QFilter("number", "!=", (Object)oldStatus.getString("number"));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
        if (StringUtils.equals((CharSequence)"contract", (CharSequence)propName)) {
            List statusNums = Stream.of(ContractStatusEnum.INDRAFT.getValue(), ContractStatusEnum.INAUDIT.getValue(), ContractStatusEnum.APPROVED.getValue(), ContractStatusEnum.CLOSED.getValue()).collect(Collectors.toList());
            filter = new QFilter("contractstatus.number", "not in", statusNums);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)operateKey)) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            QFilter filter = new QFilter("contract", "=", contract.getPkValue());
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmct_statuschange", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"createtime desc");
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (bills.length > 0 && !pkValue.equals(bills[0].getPkValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6700\u65b0\u7684\u72b6\u6001\u53d8\u66f4\u5355\uff0c\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ContStatusChangeEditPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if ("newstatus".equals(propName)) {
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (newValue != null && ContractStatusEnum.CLOSED.getValue().equals(newValue.getString("number"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"finlflexpanelap"});
                this.getBudgetInfo(contract);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"finlflexpanelap"});
                this.getModel().deleteEntryData("entryentity");
                this.getModel().setValue("appamount", null);
                this.getModel().setValue("apptax", null);
                this.getModel().setValue("apptaxamount", null);
                this.getModel().setValue("description", null);
            }
        }
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"contract") && contract != null) {
            DynamicObject[] staChanges;
            QFilter contFilter = new QFilter("contract", "=", contract.getPkValue());
            QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
            Object billPk = this.getModel().getDataEntity().getPkValue();
            if (billPk != null) {
                contFilter.and("id", "!=", billPk);
            }
            if ((staChanges = BusinessDataServiceHelper.load((String)"pmct_statuschange", (String)"id", (QFilter[])new QFilter[]{contFilter, statusFilter})).length > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55\uff0c\u8bf7\u67e5\u770b\u53d8\u66f4\u8bb0\u5f55\u3002", (String)"ContStatusChangeEditPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("contract", changeData.getOldValue());
                return;
            }
            DynamicObject contractStatus = contract.getDynamicObject("contractstatus");
            this.getModel().setValue("oldstatus", (Object)contractStatus);
        }
    }

    private void getBudgetInfo(DynamicObject contract) {
        this.getModel().deleteEntryData("entryentity");
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        DynamicObject[] contBudgetInfo = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter});
        if (contBudgetInfo.length > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity"});
            for (DynamicObject budgetInfo : contBudgetInfo) {
                BigDecimal contractAuditAmtEx = budgetInfo.getBigDecimal("contractauditamtex");
                BigDecimal settleAuditAmtEx = budgetInfo.getBigDecimal("settleauditamtex");
                BigDecimal payApplyAuditAmtEx = budgetInfo.getBigDecimal("payapplyauditamtex");
                BigDecimal actualAuditAmtEx = budgetInfo.getBigDecimal("actualauditamtex");
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("budgetitem", budgetInfo.getDynamicObject("budgetitem").getPkValue(), rowIndex);
                this.getModel().setValue("itemamount", (Object)contractAuditAmtEx, rowIndex);
                this.getModel().setValue("itemsettaomunt", (Object)settleAuditAmtEx, rowIndex);
                this.getModel().setValue("itempayaomunt", (Object)payApplyAuditAmtEx, rowIndex);
                this.getModel().setValue("itemreceiptsamt", (Object)actualAuditAmtEx, rowIndex);
                this.getModel().setValue("itemappamount", (Object)budgetInfo.getBigDecimal("occupyamtex"), rowIndex);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
        }
        this.getView().updateView("entryentity");
    }
}

