/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;

public class ContractCenterFormPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ContractCenterFormPlugin.class);
    private static final String[] COLORSARRAY = new String[]{"#73BF00", "#2894FF", "#FF0080", "#7B7B7B", "#921AFF", "#B766AD", "#7373B9", "#408080", "#804040", "#00FFFF"};
    private static final int MAX_SHOW_ITEMS = 10;

    private String[] getMonthArray() {
        return new String[]{ResManager.loadKDString((String)"1\u6708", (String)"ContractCenterFormPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"2\u6708", (String)"ContractCenterFormPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"3\u6708", (String)"ContractCenterFormPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"4\u6708", (String)"ContractCenterFormPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"5\u6708", (String)"ContractCenterFormPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"6\u6708", (String)"ContractCenterFormPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"7\u6708", (String)"ContractCenterFormPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"8\u6708", (String)"ContractCenterFormPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"9\u6708", (String)"ContractCenterFormPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"10\u6708", (String)"ContractCenterFormPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"11\u6708", (String)"ContractCenterFormPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"12\u6708", (String)"ContractCenterFormPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])};
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        PieChart pieContractAmount = (PieChart)this.getControl("piecontractamount");
        pieContractAmount.addClickListener((ClickListener)this);
        PieChart pieContractAmount1 = (PieChart)this.getControl("piecontractamount1");
        pieContractAmount1.addClickListener((ClickListener)this);
        CustomChart customChart = (CustomChart)this.getControl("customchartap");
        customChart.addClickListener((ClickListener)this);
        CustomChart customChart1 = (CustomChart)this.getControl("customchartap1");
        customChart1.addClickListener((ClickListener)this);
        OrgEdit org = (OrgEdit)this.getControl("orgfield");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit org1 = (OrgEdit)this.getControl("orgfield1");
        org1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit org2 = (OrgEdit)this.getControl("orgfield2");
        org2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit org3 = (OrgEdit)this.getControl("orgfield3");
        org3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("refershonechart".equals(formOperate.getOperateKey())) {
            PieChart pieContractAmount = (PieChart)this.getControl("piecontractamount");
            pieContractAmount.clearData();
            Object year = this.getModel().getValue("yearfield");
            Object payDirection = this.getModel().getValue("radiogroupfield");
            DynamicObject org = (DynamicObject)this.getModel().getValue("orgfield");
            this.setChartDateOne(year, payDirection, org);
        } else if ("refershtwochart".equals(formOperate.getOperateKey())) {
            Chart chart = (Chart)this.getControl("piecontractamount1");
            chart.clearData();
            Object year = this.getModel().getValue("yearfield1");
            Object payDirection = this.getModel().getValue("radiogroupfield1");
            DynamicObject org = (DynamicObject)this.getModel().getValue("orgfield1");
            this.setChartDateTwo(year, payDirection, org);
        } else if ("refershthreechart".equals(formOperate.getOperateKey())) {
            Chart chart = (Chart)this.getControl("customchartap");
            chart.clearData();
            Object year = this.getModel().getValue("yearfield2");
            Object payDirection = this.getModel().getValue("radiogroupfield2");
            DynamicObject org = (DynamicObject)this.getModel().getValue("orgfield2");
            this.setChartDateThree(year, payDirection, org);
        } else if ("setgrade".equals(formOperate.getOperateKey())) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setLookUp(false);
            parameter.setMultiSelect(true);
            parameter.setBillFormId("pmct_contractamtgrade");
            StyleCss css = new StyleCss();
            css.setWidth("780px");
            css.setHeight("430px");
            parameter.getOpenStyle().setInlineStyleCss(css);
            parameter.setShowTitle(false);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void afterBindData(EventObject eventobject) {
        super.afterBindData(eventobject);
        long orgId = RequestContext.get().getOrgId();
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        this.getModel().setValue("orgfield", (Object)currentOrg);
        this.getView().updateView("orgfield");
        this.getModel().setValue("radiogroupfield", (Object)"1");
        this.getView().updateView("radiogroupfield");
        this.getModel().setValue("orgfield1", (Object)currentOrg);
        this.getView().updateView("orgfield1");
        this.getModel().setValue("radiogroupfield1", (Object)"1");
        this.getView().updateView("radiogroupfield1");
        this.getModel().setValue("orgfield2", (Object)currentOrg);
        this.getView().updateView("orgfield2");
        this.getModel().setValue("radiogroupfield2", (Object)"1");
        this.getView().updateView("radiogroupfield2");
        this.getModel().setValue("orgfield3", (Object)currentOrg);
        this.getView().updateView("orgfield3");
        this.getModel().setValue("radiogroupfield3", (Object)"1");
        this.getView().updateView("radiogroupfield3");
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        this.getModel().setValue("yearfield", (Object)currentYear);
        this.getModel().setValue("yearfield1", (Object)currentYear);
        this.getModel().setValue("yearfield2", (Object)currentYear);
        this.getView().updateView("yearfield");
        this.getView().updateView("yearfield1");
        this.getView().updateView("yearfield2");
        Object year = this.getModel().getValue("yearfield");
        Object payDirection = this.getModel().getValue("radiogroupfield");
        this.setChartDateOne(year, payDirection, currentOrg);
        year = this.getModel().getValue("yearfield1");
        payDirection = this.getModel().getValue("radiogroupfield1");
        this.setChartDateTwo(year, payDirection, currentOrg);
        year = this.getModel().getValue("yearfield2");
        payDirection = this.getModel().getValue("radiogroupfield2");
        this.setChartDateThree(year, payDirection, currentOrg);
    }

    public void click(EventObject eventobject) {
        super.click(eventobject);
        if (eventobject.getSource().getClass().isAssignableFrom(CustomChart.class) || eventobject.getSource().getClass().isAssignableFrom(PieChart.class)) {
            ChartClickEvent event = (ChartClickEvent)eventobject;
            Chart chart = event.getSource();
            if ("piecontractamount".equals(chart.getKey())) {
                if (event.getName() == null || ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"ContractCenterFormPlugin_21", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]).equals(event.getName())) {
                    return;
                }
                Map orgContractMap = (Map)this.getView().getFormShowParameter().getCustomParam("org_ContractMapUsedForDrillDown");
                String formBillId = this.getContractFormBillId(this.getModel().getValue("radiogroupfield"));
                ListShowParameter parameter = this.hrefSetting(orgContractMap, event.getName(), formBillId);
                this.getView().showForm((FormShowParameter)parameter);
            } else if ("piecontractamount1".equals(chart.getKey())) {
                if (event.getName() == null || ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"ContractCenterFormPlugin_21", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]).equals(event.getName())) {
                    return;
                }
                Map gearContractMap = (Map)this.getView().getFormShowParameter().getCustomParam("dangwei_contractMap");
                String formBillId = this.getContractFormBillId(this.getModel().getValue("radiogroupfield1"));
                ListShowParameter parameter = this.hrefSetting(gearContractMap, event.getName(), formBillId);
                this.getView().showForm((FormShowParameter)parameter);
            } else if ("customchartap".equals(chart.getKey())) {
                if (event.getName() == null) {
                    return;
                }
                Map monthContractMap = (Map)this.getView().getFormShowParameter().getCustomParam("month_contractMap");
                String formBillId = this.getContractFormBillId(this.getModel().getValue("radiogroupfield2"));
                ListShowParameter parameter = this.hrefSetting(monthContractMap, event.getName(), formBillId);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldName = arg0.getProperty().getName();
        if ("orgfield".equals(fieldName) || "orgfield1".equals(fieldName) || "orgfield2".equals(fieldName) || "orgfield3".equals(fieldName)) {
            ArrayList orgIdList = new ArrayList(16);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
            if (!superUser) {
                HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()), (String)"15", (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac");
                List orgList = result.getHasPermOrgs();
                orgIdList.addAll(orgList);
                List childOrg = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIdList, (boolean)true);
                QFilter orgFilter = new QFilter("id", "in", (Object)childOrg);
                showParameter.getListFilterParameter().setFilter(orgFilter);
            }
            showParameter.setCustomParam("orgFuncId", (Object)"15");
        }
    }

    protected String getContractFormBillId(Object payDirection) {
        String formBillId = "1".equals(payDirection) ? "pmct_incontract" : "pmct_outcontract";
        return formBillId;
    }

    protected ListShowParameter hrefSetting(Map<String, JSONArray> contractMap, String keyName, String formBillId) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        JSONArray ids = contractMap.get(keyName);
        QFilter idFilter = null;
        if (ids != null && ids.size() != 0) {
            LinkQueryPkIdCollection xCollection = new LinkQueryPkIdCollection();
            for (Object id : ids) {
                xCollection.add((Object)new LinkQueryPkId(id));
            }
            parameter.setLinkQueryPkIdCollection(xCollection);
            idFilter = new QFilter("id", "in", (Object)ids.toJavaList(Long.class));
        }
        parameter.getListFilterParameter().setFilter(idFilter);
        parameter.setBillFormId(formBillId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return parameter;
    }

    protected void setChartDateThree(Object year, Object payDirection, DynamicObject org) {
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractCenterFormPlugin_31", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
        if (year == null || payDirection == null) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add((Long)org.getPkValue());
        List orgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIds, (boolean)true);
        Map<Object, DynamicObject> contractMap = this.getContractsByFilter(orgIdList, Integer.parseInt(year.toString()), payDirection);
        HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(16);
        HashMap monthContractMap = new HashMap(16);
        if (contractMap != null && !contractMap.isEmpty()) {
            for (DynamicObject contract : contractMap.values()) {
                Set<Long> contractIds;
                BigDecimal amount = contract.getBigDecimal("totaloftaxamount");
                boolean isMultiCurrency = contract.getBoolean("ismulticurrency");
                if (isMultiCurrency) {
                    amount = amount.multiply(contract.getBigDecimal("exchangerate"));
                }
                String[] signDate = contract.getDate("signdate");
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)signDate);
                String month = this.getMonthArray()[cal.get(2)];
                BigDecimal total = (BigDecimal)dataMap.get(month);
                if (total == null) {
                    dataMap.put(month, amount);
                    contractIds = new HashSet<Long>(1);
                    contractIds.add(Long.valueOf(contract.getPkValue().toString()));
                    monthContractMap.put(month, contractIds);
                    continue;
                }
                total = total.add(amount);
                dataMap.put(month, total);
                contractIds = (Set)monthContractMap.get(month);
                contractIds.add(Long.valueOf(contract.getPkValue().toString()));
                monthContractMap.put(month, contractIds);
            }
        }
        this.getView().getFormShowParameter().setCustomParam("month_contractMap", monthContractMap);
        this.getView().cacheFormShowParameter();
        DynamicObject currency = CurrencyHelper.getCurrency((Long)Long.valueOf(org.getPkValue().toString()));
        if (currency == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7%s\u6240\u5c5e\u6838\u7b97\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u5e01\u79cd\u8bbe\u7f6e\u3002", (String)"ContractCenterFormPlugin_38", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue()));
        }
        CustomChart customChart = (CustomChart)this.getControl("customchartap");
        Axis xaXis = customChart.createXAxis("", AxisType.category);
        xaXis.setCategorys(this.getMonthArray());
        customChart.createYAxis(currency.getString("sign"), AxisType.log);
        BarSeries series = customChart.createBarSeries(ResManager.loadKDString((String)"\u6708\u5ea6\u65b0\u7b7e\u5408\u540c\u91d1\u989d\u8d8b\u52bf\u5206\u6790", (String)"ContractCenterFormPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        for (String month : this.getMonthArray()) {
            series.addData((Number)dataMap.get(month));
            series.setBarWidth("20");
        }
        Map titleMap = customChart.getTitleData();
        titleMap.put("x", "center");
        customChart.setLegendVertical(true);
        customChart.setShowTooltip(true);
        customChart.bindData(null);
    }

    protected void setChartDateTwo(Object year, Object payDirection, DynamicObject org) {
        ItemValue[] items;
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractCenterFormPlugin_31", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
        if (year == null || payDirection == null) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add((Long)org.getPkValue());
        List orgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIds, (boolean)true);
        Map<Object, DynamicObject> contractMap = this.getContractsByFilter(orgIdList, Integer.parseInt(year.toString()), payDirection);
        DynamicObject[] gears = BusinessDataServiceHelper.load((String)"pmct_contractamtgrade", (String)"id,number,name,maxamount", (QFilter[])new QFilter[0], (String)"maxamount");
        if (gears == null || gears.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u53f3\u4fa7\u201c\u8bbe\u7f6e\u201d\u6309\u94ae\uff0c\u8fdb\u884c\u6863\u4f4d\u8bbe\u7f6e\u3002", (String)"ContractCenterFormPlugin_36", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(16);
        HashMap gearContractMap = new HashMap(16);
        if (contractMap != null && !contractMap.isEmpty()) {
            for (DynamicObject contract : contractMap.values()) {
                Set<Long> contractIds;
                String gear;
                BigDecimal count;
                BigDecimal amount = contract.getBigDecimal("totaloftaxamount");
                boolean isMultiCurrency = contract.getBoolean("ismulticurrency");
                if (isMultiCurrency) {
                    amount = amount.multiply(contract.getBigDecimal("exchangerate"));
                }
                if ((count = (BigDecimal)dataMap.get(gear = this.getAmountForGear(gears, amount))) == null) {
                    dataMap.put(gear, BigDecimal.ONE);
                    contractIds = new HashSet<Long>(1);
                    contractIds.add(Long.valueOf(contract.getPkValue().toString()));
                    gearContractMap.put(gear, contractIds);
                    continue;
                }
                count = count.add(BigDecimal.ONE);
                dataMap.put(gear, count);
                contractIds = (Set)gearContractMap.get(gear);
                contractIds.add(Long.valueOf(contract.getPkValue().toString()));
                gearContractMap.put(gear, contractIds);
            }
        }
        this.getView().getFormShowParameter().setCustomParam("dangwei_contractMap", gearContractMap);
        this.getView().cacheFormShowParameter();
        PieChart pieContractAmount = (PieChart)this.getControl("piecontractamount1");
        PieSeries series = pieContractAmount.createPieSeries(ResManager.loadKDString((String)"\u5e74\u5ea6\u65b0\u7b7e\u5408\u540c\u6570\u91cf\u5206\u6790\uff08\u5355\u4f4d\uff1a\u4e2a\uff09", (String)"ContractCenterFormPlugin_26", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        pieContractAmount.setShowTooltip(true);
        series.setRadius("20%", "65%");
        series.setCenter("50%", "50%");
        if (!dataMap.isEmpty()) {
            Set entrySet = dataMap.entrySet();
            items = new ItemValue[entrySet.size()];
            int index = 0;
            for (Map.Entry entry : entrySet) {
                ItemValue itemValue;
                items[index] = itemValue = new ItemValue((String)entry.getKey(), (Number)entry.getValue(), COLORSARRAY[index % 10]);
                ++index;
            }
        } else {
            ItemValue itemValue = new ItemValue(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"ContractCenterFormPlugin_21", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)BigDecimal.ZERO, "#BEBEBE");
            items = new ItemValue[]{itemValue};
        }
        series.setData(items);
        pieContractAmount.addTooltip("formatter", (Object)ResManager.loadKDString((String)"{b}\uff1a{c}\u4e2a\uff08{d}%\uff09", (String)"ContractCenterFormPlugin_34", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        pieContractAmount.addTooltip("trigger", (Object)"item");
        pieContractAmount.setLegendAlign(XAlign.left, YAlign.top);
        pieContractAmount.bindData(null);
    }

    protected void setChartDateOne(Object year, Object payDirection, DynamicObject org) {
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractCenterFormPlugin_31", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
        if (year == null || payDirection == null) {
            return;
        }
        DynamicObject currency = CurrencyHelper.getCurrency((Long)Long.valueOf(org.getPkValue().toString()));
        if (currency == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7%s\u6240\u5c5e\u6838\u7b97\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u5e01\u79cd\u8bbe\u7f6e\u3002", (String)"ContractCenterFormPlugin_38", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue()));
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add((Long)org.getPkValue());
        List<Long> orgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIds, (boolean)true);
        Map<Object, DynamicObject> allContractMap = this.getContractsByFilter(null, Integer.parseInt(year.toString()), payDirection);
        Set allContractOrgIdSet = allContractMap.values().stream().map(item -> Long.valueOf(item.getDynamicObject("org").getPkValue().toString())).collect(Collectors.toSet());
        orgIdList = orgIdList.stream().filter(allContractOrgIdSet::contains).collect(Collectors.toList());
        Map<Object, Object> contractMap = new HashMap(1);
        if (!orgIdList.isEmpty()) {
            contractMap = this.getContractsByFilter(orgIdList, Integer.parseInt(year.toString()), payDirection);
        }
        HashMap<Long, List<Long>> orgContractMap = new HashMap<Long, List<Long>>(10);
        HashMap<Long, BigDecimal> orgAmountMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject dynamicObject : contractMap.values()) {
            DynamicObject contractOrg = dynamicObject.getDynamicObject("org");
            Long contractOrgId = Long.valueOf(contractOrg.getPkValue().toString());
            BigDecimal total = (BigDecimal)orgAmountMap.get(contractOrgId);
            if (total == null) {
                total = BigDecimal.ZERO;
            }
            boolean isMultiCurrency = dynamicObject.getBoolean("ismulticurrency");
            BigDecimal amount = dynamicObject.getBigDecimal("totaloftaxamount");
            if (isMultiCurrency) {
                amount = amount.multiply(dynamicObject.getBigDecimal("exchangerate"));
            }
            total = total.add(amount);
            orgAmountMap.put(contractOrgId, total);
            ArrayList<Long> contractIdList = (ArrayList<Long>)orgContractMap.get(contractOrgId);
            if (contractIdList == null) {
                contractIdList = new ArrayList<Long>(1);
            }
            contractIdList.add((Long)dynamicObject.getPkValue());
            orgContractMap.put(contractOrgId, contractIdList);
        }
        this.getView().getFormShowParameter().setCustomParam("org_contractMap", orgContractMap);
        PieChart pieContractAmount = (PieChart)this.getControl("piecontractamount");
        PieSeries pieSeries = pieContractAmount.createPieSeries(String.format(ResManager.loadKDString((String)"\u5e74\u5ea6\u65b0\u7b7e\u5408\u540c\u91d1\u989d\u5206\u6790\uff08\u5e01\u79cd\uff1a%s\uff09", (String)"ContractCenterFormPlugin_39", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), currency.getString("sign")));
        pieContractAmount.setShowTooltip(true);
        pieSeries.setRadius("20%", "63%");
        pieSeries.setCenter("50%", "55%");
        ItemValue[] items = null;
        if (!orgAmountMap.isEmpty()) {
            Set entrySet = orgAmountMap.entrySet();
            items = new ItemValue[entrySet.size()];
            int index = 0;
            for (Map.Entry entry : entrySet) {
                ItemValue itemValue;
                items[index] = itemValue = new ItemValue(((Long)entry.getKey()).toString(), (Number)entry.getValue(), COLORSARRAY[index % 10]);
                ++index;
            }
        }
        pieSeries.setData(this.rebuildData(items, orgContractMap));
        pieContractAmount.addTooltip("formatter", (Object)("{b} : " + currency.getString("sign") + "{c}\uff08{d}%\uff09"));
        pieContractAmount.addTooltip("trigger", (Object)"item");
        pieContractAmount.setLegendAlign(XAlign.left, YAlign.top);
        pieContractAmount.bindData(null);
    }

    protected ItemValue[] rebuildData(ItemValue[] items, Map<Long, List<Long>> orgContractMap) {
        if (items == null || items.length == 0) {
            ItemValue itemValue = new ItemValue(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"ContractCenterFormPlugin_21", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)BigDecimal.ZERO, "#BEBEBE");
            items = new ItemValue[]{itemValue};
            return items;
        }
        int showItemSize = items.length <= 10 ? items.length : 10;
        ItemValue[] newItems = new ItemValue[showItemSize];
        ArrayList toSortItems = new ArrayList(10);
        toSortItems.addAll(Arrays.stream(items).collect(Collectors.toList()));
        toSortItems.sort((item1, item2) -> BigDecimal.valueOf(item2.getValue().doubleValue()).compareTo(BigDecimal.valueOf(item1.getValue().doubleValue())));
        ArrayList sortedItems = new ArrayList(10);
        sortedItems.addAll(toSortItems);
        int index = 0;
        HashMap<String, List<Long>> orgContractMapUsedForDrillDownMap = new HashMap<String, List<Long>>(10);
        String otherOrgName = ResManager.loadKDString((String)"\u5176\u5b83\u7ec4\u7ec7", (String)"ContractCenterFormPlugin_28", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]);
        for (ItemValue item : sortedItems) {
            if (index < 9) {
                DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)item.getName(), (String)"bos_org");
                String orgName = org.getLocaleString("name").getLocaleValue();
                if (orgName == null) {
                    String orgNumber = org.getString("number");
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7684\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u6570\u636e\u3002", (String)"ContractCenterFormPlugin_37", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), orgNumber));
                }
                orgContractMapUsedForDrillDownMap.put(orgName, orgContractMap.get(Long.valueOf(item.getName())));
                item.setColor(COLORSARRAY[index]);
                item.setName(orgName);
                newItems[index] = item;
            } else {
                BigDecimal otherTotalAmount = newItems[9] == null ? BigDecimal.ZERO : new BigDecimal(newItems[9].getValue().toString());
                otherTotalAmount = otherTotalAmount.add(new BigDecimal(item.getValue().toString()));
                newItems[9] = new ItemValue(otherOrgName, (Number)otherTotalAmount, COLORSARRAY[9]);
                ArrayList otherOrgContractIdList = (ArrayList)orgContractMapUsedForDrillDownMap.get(otherOrgName);
                if (otherOrgContractIdList == null) {
                    otherOrgContractIdList = new ArrayList(1);
                }
                otherOrgContractIdList.addAll(orgContractMap.get(Long.valueOf(item.getName())));
                if (otherOrgContractIdList.size() > 0) {
                    orgContractMapUsedForDrillDownMap.put(otherOrgName, otherOrgContractIdList);
                }
            }
            ++index;
        }
        this.getView().getFormShowParameter().setCustomParam("org_ContractMapUsedForDrillDown", orgContractMapUsedForDrillDownMap);
        this.getView().cacheFormShowParameter();
        return newItems;
    }

    protected String getAmountForGear(DynamicObject[] gears, BigDecimal amount) {
        if (gears == null || gears.length == 0 || amount == null) {
            return null;
        }
        List sortGears = Arrays.stream(gears).sorted(Comparator.comparing(a -> a.getBigDecimal("maxamount"))).collect(Collectors.toList());
        for (DynamicObject gear : sortGears) {
            String gearName = gear.getLocaleString("name").getLocaleValue();
            BigDecimal maxAmount = gear.getBigDecimal("maxamount");
            if (amount.compareTo(maxAmount) >= 0) continue;
            return gearName;
        }
        return null;
    }

    protected Map<Long, LinkedHashSet<Map<String, Object>>> getOrgAndChildrenRelationMap(DynamicObject rootOrg, String viewType) {
        if (rootOrg == null) {
            return null;
        }
        QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(rootOrg.getPkValue().toString())).and("view", "=", (Object)Long.parseLong(viewType));
        DynamicObject root = BusinessDataServiceHelper.loadSingle((String)"bos_org_structure", (String)"id,name,number,org,parent,isleaf,level", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, LinkedHashSet<Map<String, Object>>> orgAndChildrenRelationMap = new HashMap<Long, LinkedHashSet<Map<String, Object>>>(16);
        HashMap<String, Object> orgRootNode = new HashMap<String, Object>(16);
        DynamicObject org = root.getDynamicObject("org");
        orgRootNode.put("id", org.get("id"));
        orgRootNode.put("number", org.get("number"));
        orgRootNode.put("name", org.get("name"));
        orgRootNode.put("isleaf", root.getBoolean("isleaf"));
        DynamicObject parent = root.getDynamicObject("parent");
        orgRootNode.put("parentid", parent == null ? Long.valueOf(0L) : parent.getPkValue());
        orgRootNode.put("level", root.getInt("level"));
        HashMap<Long, Map<String, Object>> orgTreeNodeMap = new HashMap<Long, Map<String, Object>>(16);
        long startTime = System.currentTimeMillis();
        this.getTreeMap("15", orgRootNode, orgTreeNodeMap);
        long endTime = System.currentTimeMillis();
        logger.info("\u5f85\u8ba1\u7b97\u7684\u7ec4\u7ec7\u8282\u70b9\u603b\u6570{}\u4e2a,\u8017\u65f6{}\u6beb\u79d2", (Object)orgTreeNodeMap.size(), (Object)(endTime - startTime));
        startTime = System.currentTimeMillis();
        this.getChildrenMap(orgRootNode, orgTreeNodeMap, orgAndChildrenRelationMap);
        endTime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u540e\u7684\u7ec4\u7ec7\u8282\u70b9\u603b\u6570{}\u4e2a\uff0c\u8017\u65f6{}\u6beb\u79d2", (Object)orgAndChildrenRelationMap.size(), (Object)(endTime - startTime));
        return orgAndChildrenRelationMap;
    }

    private void getChildrenMap(Map<String, Object> rootNode, Map<Long, Map<String, Object>> treeNodeMap, Map<Long, LinkedHashSet<Map<String, Object>>> nodeAndChildrenMap) {
        int depth;
        int maxDepth = 1;
        for (Map.Entry<Long, Map<String, Object>> entry : treeNodeMap.entrySet()) {
            Map<String, Object> map = entry.getValue();
            depth = (Integer)map.get("level");
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        for (int level = maxDepth; level >= 1; --level) {
            for (Map map : treeNodeMap.values()) {
                LinkedHashSet<Map<String, Object>> parentNodeAndChildrenList;
                LinkedHashSet<Map<Object, Object>> currentNodeAndChildrenList;
                depth = (Integer)map.get("level");
                boolean isLeaf = (Boolean)map.get("isleaf");
                long currentNodeId = (Long)map.get("id");
                long parentNodeId = (Long)map.get("parentid");
                if (isLeaf) {
                    currentNodeAndChildrenList = new LinkedHashSet<Map>();
                    currentNodeAndChildrenList.add(map);
                    nodeAndChildrenMap.put(currentNodeId, currentNodeAndChildrenList);
                    parentNodeAndChildrenList = nodeAndChildrenMap.get(parentNodeId);
                    if (parentNodeAndChildrenList == null) {
                        parentNodeAndChildrenList = new LinkedHashSet();
                    }
                    parentNodeAndChildrenList.add(map);
                    nodeAndChildrenMap.put(parentNodeId, parentNodeAndChildrenList);
                    continue;
                }
                if (level != depth) continue;
                parentNodeAndChildrenList = nodeAndChildrenMap.get(parentNodeId);
                if (parentNodeAndChildrenList == null) {
                    parentNodeAndChildrenList = new LinkedHashSet();
                }
                parentNodeAndChildrenList.add(map);
                currentNodeAndChildrenList = nodeAndChildrenMap.get(currentNodeId);
                if (currentNodeAndChildrenList == null) {
                    currentNodeAndChildrenList = new LinkedHashSet();
                }
                currentNodeAndChildrenList.add(map);
                nodeAndChildrenMap.put(currentNodeId, currentNodeAndChildrenList);
                if (parentNodeId == 0L) continue;
                parentNodeAndChildrenList.addAll(currentNodeAndChildrenList);
                nodeAndChildrenMap.put(parentNodeId, parentNodeAndChildrenList);
            }
        }
        LinkedHashSet<Map<String, Object>> childrenList = nodeAndChildrenMap.get(Long.valueOf(rootNode.get("id").toString()));
        if (childrenList != null && childrenList.size() > 0) {
            List children = childrenList.stream().map(o -> (Long)o.get("id")).collect(Collectors.toList());
            Iterator<Map.Entry<Long, LinkedHashSet<Map<String, Object>>>> iterator = nodeAndChildrenMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, LinkedHashSet<Map<String, Object>>> entry = iterator.next();
                if (children.contains(Long.valueOf(((Object)entry.getKey()).toString()))) continue;
                iterator.remove();
            }
        }
    }

    private void getTreeMap(String viewType, Map<String, Object> rootNode, Map<Long, Map<String, Object>> treeNodeMap) {
        DynamicObject[] orgArray;
        Long rootNodeId = (Long)rootNode.get("id");
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add(rootNodeId);
        List orgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((String)viewType, orgIds, (boolean)true);
        String maxSize = System.getProperty("orm.opt.in.maxsize");
        int pageSize = 10000;
        if (!StringUtils.isEmpty((CharSequence)maxSize)) {
            pageSize = Integer.parseInt(maxSize);
        }
        int pageIndex = 1;
        QFilter qFilter = new QFilter("view", "=", (Object)Long.parseLong(viewType)).and("org", "in", (Object)orgIdList);
        ArrayList<DynamicObject> orgList = new ArrayList<DynamicObject>(10);
        do {
            orgArray = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"id,name,number,org,parent,isleaf,level", (QFilter[])new QFilter[]{qFilter}, null, (int)(pageIndex - 1), (int)pageSize);
            ++pageIndex;
            if (orgArray.length <= 0) continue;
            List<DynamicObject> orgTempList = Arrays.asList(orgArray);
            orgList.addAll(orgTempList);
        } while (orgArray.length > 0);
        for (DynamicObject childNode : orgList) {
            HashMap<String, Object> node = new HashMap<String, Object>(16);
            DynamicObject org = childNode.getDynamicObject("org");
            if (org == null) continue;
            node.put("id", org.get("id"));
            node.put("number", org.get("number"));
            node.put("name", org.get("name"));
            node.put("isleaf", childNode.getBoolean("isleaf"));
            DynamicObject parent = childNode.getDynamicObject("parent");
            node.put("parentid", parent == null ? Long.valueOf(0L) : parent.getPkValue());
            node.put("level", childNode.getInt("level"));
            treeNodeMap.put((Long)node.get("id"), node);
        }
    }

    protected Map<Object, DynamicObject> getContractsByFilter(List<Long> orgIdList, int year, Object payDirection) {
        PayDirectionEnum payDirectionEnum = "1".equals(payDirection) ? PayDirectionEnum.IN : PayDirectionEnum.OUT;
        QFilter filter = new QFilter("billstatus", "=", (Object)Character.valueOf('C'));
        if (orgIdList != null && !orgIdList.isEmpty()) {
            filter.and("org", "in", orgIdList);
        }
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, year);
        Date yearFirstDate = c.getTime();
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(1, year + 1);
        Date yearEndDate = c1.getTime();
        filter.and("signdate", ">=", (Object)yearFirstDate);
        filter.and("signdate", "<", (Object)yearEndDate);
        filter.and("paydirection", "=", (Object)payDirectionEnum.getValue());
        MainEntityType dt = payDirectionEnum == PayDirectionEnum.IN ? EntityMetadataCache.getDataEntityType((String)"pmct_incontract") : EntityMetadataCache.getDataEntityType((String)"pmct_outcontract");
        return BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dt, (QFilter[])new QFilter[]{filter});
    }
}

