/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.common.enums.InvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.OutInvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.formplugin.ListingSettleInfo;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ContractKanBanFormPlugin
extends AbstractPmctBillPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(ContractKanBanFormPlugin.class);

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("beginperiod".equals(propName) || "endperiod".equals(propName)) {
            this.onPeriodChanged();
        }
    }

    private void onPeriodChanged() {
        Map<String, ListingSettleInfo> settleListingMap = this.getSettleListingMap();
        int rowCount = this.getModel().getEntryRowCount("treelistentry1");
        for (int i = 0; i < rowCount; ++i) {
            ListingSettleInfo info;
            String listingPk = this.getModel().getEntryRowEntity("treelistentry1", i).getPkValue().toString();
            ListingSettleInfo listingSettleInfo = info = settleListingMap == null ? null : settleListingMap.get(listingPk);
            if (info != null) {
                this.getModel().setValue("preqty", (Object)info.getPreQty(), i);
                this.getModel().setValue("preamount", (Object)info.getPreAmount(), i);
                this.getModel().setValue("curqty", (Object)info.getThisQty(), i);
                this.getModel().setValue("curamount", (Object)info.getThisAmount(), i);
                this.getModel().setValue("lstqty", (Object)info.getLstQty(), i);
                this.getModel().setValue("lstamount", (Object)info.getLstAmount(), i);
            } else {
                this.getModel().setValue("preqty", null, i);
                this.getModel().setValue("preamount", null, i);
                this.getModel().setValue("curqty", null, i);
                this.getModel().setValue("curamount", null, i);
                this.getModel().setValue("lstqty", null, i);
                this.getModel().setValue("lstamount", null, i);
            }
            this.getView().updateView("preqty", i);
            this.getView().updateView("preamount", i);
            this.getView().updateView("curqty", i);
            this.getView().updateView("curamount", i);
            this.getView().updateView("lstqty", i);
            this.getView().updateView("lstamount", i);
        }
    }

    protected void setData(String contId) {
        String formBillId;
        IDataModel model = this.getModel();
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contId), (String)"pmct_contracttpl");
        DynamicObject currency = contract.getDynamicObject("currency");
        model.setValue("currency", (Object)currency);
        boolean isBasedOnList = contract.getBoolean("isonlist");
        if (isBasedOnList) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"listingpanel", "summarypanel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listingpanel", "summarypanel"});
        }
        model.setValue("beginperiod", null);
        model.setValue("endperiod", null);
        BigDecimal originalAmount = contract.getBigDecimal("originalamount");
        BigDecimal origianlOfTaxAmount = contract.getBigDecimal("originaloftaxamount");
        BigDecimal taxAmount = contract.getBigDecimal("taxamount");
        model.setValue("amount", (Object)originalAmount, 0);
        model.setValue("tax", (Object)taxAmount, 0);
        model.setValue("oftaxamount", (Object)origianlOfTaxAmount, 0);
        BigDecimal totalAdditionOfTaxAmt = contract.getBigDecimal("totaladditionoftaxamt");
        BigDecimal totalAdditionAmount = contract.getBigDecimal("totaladditionamount");
        model.setValue("amount", (Object)totalAdditionAmount, 1);
        model.setValue("tax", (Object)totalAdditionOfTaxAmt.subtract(totalAdditionAmount), 1);
        model.setValue("oftaxamount", (Object)totalAdditionOfTaxAmt, 1);
        BigDecimal totalrevisionoftaxamount = contract.getBigDecimal("totalrevisionoftaxamount");
        BigDecimal totalrevisionamount = contract.getBigDecimal("totalrevisionamount");
        model.setValue("amount", (Object)totalrevisionamount, 2);
        model.setValue("tax", (Object)totalrevisionoftaxamount.subtract(totalrevisionamount), 2);
        model.setValue("oftaxamount", (Object)totalrevisionoftaxamount, 2);
        BigDecimal totalclaimoftaxamount = contract.getBigDecimal("totalclaimoftaxamount");
        BigDecimal totalclaimamount = contract.getBigDecimal("totalclaimamount");
        model.setValue("amount", (Object)totalclaimamount, 3);
        model.setValue("tax", (Object)totalclaimoftaxamount.subtract(totalclaimamount), 3);
        model.setValue("oftaxamount", (Object)totalclaimoftaxamount, 3);
        BigDecimal totalamount = contract.getBigDecimal("totalamount");
        BigDecimal totaloftaxamount = contract.getBigDecimal("totaloftaxamount");
        if (totalamount.compareTo(BigDecimal.ZERO) == 0) {
            totalamount = originalAmount;
        }
        model.setValue("amount", (Object)totalamount, 4);
        model.setValue("tax", (Object)totaloftaxamount.subtract(totalamount), 4);
        model.setValue("oftaxamount", (Object)totaloftaxamount, 4);
        BigDecimal totalSettleAmount = contract.getBigDecimal("totalsettleamount");
        BigDecimal totalSettleOftaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
        model.setValue("amount", (Object)totalSettleAmount, 5);
        model.setValue("tax", (Object)totalSettleOftaxAmount.subtract(totalSettleAmount), 5);
        model.setValue("oftaxamount", (Object)totalSettleOftaxAmount, 5);
        String payDirection = contract.getString("paydirection");
        BigDecimal totalApplyOfTaxAmount = StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) ? ContractHelper.getPaymentApplyThisPayableAmount((Object)contract.getPkValue(), null) : ContractHelper.getInComeApplyApplyOfTaxAmount((Object)contract.getPkValue(), null);
        BigDecimal taxRate = !contract.getBoolean("ismultirate") ? contract.getDynamicObject("taxrate").getBigDecimal("taxrate") : contract.getBigDecimal("avgtaxrate");
        BigDecimal totalApplyAmount = totalApplyOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100"))), currency.getInt("amtprecision"), 4);
        BigDecimal singleContractPaymentApplyCurPayAmount = ContractHelper.getSingleContractPaymentApplyCurPayAmount((Object)contract.getPkValue());
        BigDecimal singleContractPaymentApplyTax = ContractHelper.getSingleContractPaymentApplyTax((Object)contract.getPkValue());
        model.setValue("amount", (Object)totalApplyAmount.add(singleContractPaymentApplyCurPayAmount), 6);
        model.setValue("tax", (Object)totalApplyOfTaxAmount.subtract(totalApplyAmount).add(singleContractPaymentApplyTax), 6);
        model.setValue("oftaxamount", (Object)totalApplyOfTaxAmount.add(singleContractPaymentApplyCurPayAmount).add(singleContractPaymentApplyTax), 6);
        BigDecimal sumOfTaxAmount = BigDecimal.ZERO;
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumTax = BigDecimal.ZERO;
        boolean isInContract = PayDirectionEnum.IN.getValue().equals(payDirection);
        String key = isInContract ? "pmct_incomeregister" : "pmct_paymentregister";
        QFilter filter = new QFilter("entryentity.entrycontract.id", "=", (Object)Long.parseLong(contId));
        filter.and(new QFilter("billStatus", "=", (Object)Character.valueOf('C')));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)key, (String)"id", (QFilter[])new QFilter[]{filter});
        if (bills != null && bills.length != 0) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)key);
            Object[] ids = Arrays.stream(bills).map(DataEntityBase::getPkValue).toArray();
            for (DynamicObject billInfo : bills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt)) {
                DynamicObjectCollection billEntries = billInfo.getDynamicObjectCollection("entryentity");
                for (DynamicObject billEntry : billEntries) {
                    BigDecimal tax;
                    BigDecimal amount;
                    BigDecimal ofTaxAmount;
                    if (billEntry.getDynamicObject("entrycontract") == null || !contId.equals(billEntry.getDynamicObject("entrycontract").getPkValue().toString())) continue;
                    if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                        ofTaxAmount = billEntry.getBigDecimal("receiptoftaxamount");
                        amount = billEntry.getBigDecimal("receiptamount");
                        tax = billEntry.getBigDecimal("receipttaxamount");
                    } else {
                        ofTaxAmount = billEntry.getBigDecimal("thispaymentoftaxamount");
                        amount = billEntry.getBigDecimal("thispaymentamount");
                        tax = billEntry.getBigDecimal("thispaymenttaxamount");
                    }
                    sumOfTaxAmount = sumOfTaxAmount.add(ofTaxAmount);
                    sumAmount = sumAmount.add(amount);
                    sumTax = sumTax.add(tax);
                }
            }
        }
        model.setValue("amount", (Object)sumAmount, 7);
        model.setValue("tax", (Object)sumTax, 7);
        model.setValue("oftaxamount", (Object)sumOfTaxAmount, 7);
        QFilter invoiceFilter = new QFilter("contract", "=", (Object)Long.parseLong(contId)).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue())) {
            formBillId = "pmct_outinvoice";
            invoiceFilter.and("invoicestatus", "!=", (Object)OutInvoiceStatusEnum.CANCEL_6.getValue());
        } else {
            formBillId = "pmct_ininvoice";
            invoiceFilter.and("invoicestatus", "!=", (Object)InvoiceStatusEnum.CANCEL_2.getValue());
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)formBillId, (String)"totalamount,totaloftaxamount", (QFilter[])new QFilter[]{invoiceFilter});
        BigDecimal totalInvoiceAmount = Arrays.stream(invoices).map(invoice -> invoice.getBigDecimal("totalamount") == null ? BigDecimal.ZERO : invoice.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalInvoiceOfTaxAmount = Arrays.stream(invoices).map(invoice -> invoice.getBigDecimal("totaloftaxamount") == null ? BigDecimal.ZERO : invoice.getBigDecimal("totaloftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("amount", (Object)totalInvoiceAmount, 8);
        model.setValue("tax", (Object)totalInvoiceOfTaxAmount.subtract(totalInvoiceAmount), 8);
        model.setValue("oftaxamount", (Object)totalInvoiceOfTaxAmount, 8);
        BigDecimal appamount = contract.getBigDecimal("appamount");
        BigDecimal apptaxamount = contract.getBigDecimal("apptaxamount");
        model.setValue("amount", (Object)appamount, 9);
        if (apptaxamount != null && apptaxamount.intValue() != 0) {
            model.setValue("tax", (Object)apptaxamount.subtract(appamount), 9);
        }
        model.setValue("oftaxamount", (Object)apptaxamount, 9);
        this.getView().updateView("dataentry");
    }

    private void setChartData() {
        String contIdStr = this.getPageCache().get("contId");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contIdStr), (String)"pmct_contracttpl", (String)"billno,currency,paydirection,totalrealoftaxamount");
        DynamicObject currency = contract.getDynamicObject("currency");
        int amtPrecision = currency != null ? currency.getInt("amtprecision") : 10;
        BigDecimal totaloriginaloftaxamount = (BigDecimal)this.getModel().getValue("oftaxamount", 0);
        BigDecimal totalAdditionOfTaxAmt = (BigDecimal)this.getModel().getValue("oftaxamount", 1);
        BigDecimal totalrevisionoftaxamount = (BigDecimal)this.getModel().getValue("oftaxamount", 2);
        BigDecimal totalclaimoftaxamount = (BigDecimal)this.getModel().getValue("oftaxamount", 3);
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        HashMap<String, String> titleMap = new HashMap<String, String>();
        titleMap.put("color", "#999999");
        pieChart.setTitlePropValue("textStyle", titleMap);
        pieChart.setTitlePropValue("x", (Object)"center");
        pieChart.setTitlePropValue("y", (Object)"bottom");
        pieChart.setMargin(Position.bottom, "50");
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u5408\u540c\u6784\u6210", (String)"ContractKanBanFormPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u5408\u540c\u7b7e\u8ba2", (String)"ContractKanBanFormPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)totaloriginaloftaxamount.setScale(amtPrecision, 4), "#2DC7C9"));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u8865\u5145\u534f\u8bae", (String)"ContractKanBanFormPlugin_32", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)totalAdditionOfTaxAmt.setScale(amtPrecision, 4), "#fdc200"));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u5408\u540c\u53d8\u66f4", (String)"ContractKanBanFormPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)totalrevisionoftaxamount.setScale(amtPrecision, 4), "#B6A2DF"));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u5408\u540c\u7d22\u8d54", (String)"ContractKanBanFormPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)totalclaimoftaxamount.setScale(amtPrecision, 4), "#59B1F0"));
        series.setRadius("50%", "70%");
        List data = series.getData();
        HashMap labelMap = new HashMap();
        HashMap<String, Object> normalMap = new HashMap<String, Object>();
        normalMap.put("show", Boolean.FALSE);
        normalMap.put("position", "inner");
        labelMap.put("normal", normalMap);
        Map dataMap = (Map)data.get(0);
        dataMap.put("label", labelMap);
        Map dataMap1 = (Map)data.get(1);
        dataMap1.put("label", labelMap);
        Map dataMap2 = (Map)data.get(2);
        dataMap2.put("label", labelMap);
        Map dataMap3 = (Map)data.get(3);
        dataMap3.put("label", labelMap);
        pieChart.setShowTooltip(true);
        pieChart.setLegendAlign(XAlign.right, YAlign.center);
        pieChart.setLegendPropValue("x", (Object)"75%");
        pieChart.bindData(null);
        int index = 4;
        BigDecimal totaloftaxamount = (BigDecimal)this.getModel().getValue("oftaxamount", index);
        BigDecimal totalsettleoftaxamount = (BigDecimal)this.getModel().getValue("oftaxamount", index + 1);
        BigDecimal totalApplyOfTaxAmount = (BigDecimal)this.getModel().getValue("oftaxamount", index + 2);
        BigDecimal totalrealoftaxamount = contract.getBigDecimal("totalrealoftaxamount");
        BigDecimal totalinvoiceoftaxamount = (BigDecimal)this.getModel().getValue("oftaxamount", index + 4);
        HistogramChart histogramChart = (HistogramChart)this.getControl("histogramchartap");
        histogramChart.setTitlePropValue("textStyle", titleMap);
        histogramChart.setTitlePropValue("x", (Object)"center");
        histogramChart.setTitlePropValue("y", (Object)"bottom");
        histogramChart.setMargin(Position.bottom, "50");
        Axis xaxis = PayDirectionEnum.OUT.getValue().equals(contract.getString("paydirection")) ? histogramChart.createXAxis(ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ContractKanBanFormPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), new String[]{ResManager.loadKDString((String)"\u5408\u540c\u603b\u91d1\u989d", (String)"ContractKanBanFormPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d", (String)"ContractKanBanFormPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d", (String)"ContractKanBanFormPlugin_33", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b9e\u4ed8\u91d1\u989d", (String)"ContractKanBanFormPlugin_35", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d2f\u8ba1\u6536\u7968\u91d1\u989d", (String)"ContractKanBanFormPlugin_36", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])}) : histogramChart.createXAxis(ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ContractKanBanFormPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), new String[]{ResManager.loadKDString((String)"\u5408\u540c\u603b\u91d1\u989d", (String)"ContractKanBanFormPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d", (String)"ContractKanBanFormPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d", (String)"ContractKanBanFormPlugin_33", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b9e\u6536\u91d1\u989d", (String)"ContractKanBanFormPlugin_37", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d2f\u8ba1\u5f00\u7968\u91d1\u989d", (String)"ContractKanBanFormPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])});
        Axis yaxis = histogramChart.createYAxis(ResManager.loadKDString((String)"\u91d1\u989d", (String)"ContractKanBanFormPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#999999");
        axisLineMap.put("lineStyle", lineStyleMap);
        xaxis.setPropValue("axisLine", axisLineMap);
        yaxis.setPropValue("axisLine", axisLineMap);
        BarSeries series2 = histogramChart.createSeries(ResManager.loadKDString((String)"\u6570\u636e", (String)"ContractKanBanFormPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        series2.addData(new ItemValue(ResManager.loadKDString((String)"\u5408\u540c\u603b\u91d1\u989d", (String)"ContractKanBanFormPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)totaloftaxamount.setScale(amtPrecision, 4), "#558ED5"));
        series2.addData(new ItemValue(ResManager.loadKDString((String)"\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d", (String)"ContractKanBanFormPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)totalsettleoftaxamount.setScale(amtPrecision, 4), "#00CCFF"));
        series2.addData(new ItemValue(ResManager.loadKDString((String)"\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d", (String)"ContractKanBanFormPlugin_33", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)totalApplyOfTaxAmount.setScale(amtPrecision, 4), "#C05067"));
        series2.addData(new ItemValue(ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b9e\u6536\u4ed8\u91d1\u989d", (String)"ContractKanBanFormPlugin_34", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)totalrealoftaxamount.setScale(amtPrecision, 4), "#2DC7C9"));
        series2.addData(new ItemValue(ResManager.loadKDString((String)"\u7d2f\u8ba1\u5f00\u7968\u91d1\u989d", (String)"ContractKanBanFormPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)totalinvoiceoftaxamount.setScale(amtPrecision, 4), "#B08060"));
        histogramChart.setLegendVertical(true);
        histogramChart.setShowTooltip(true);
        histogramChart.setLegendAlign(XAlign.right, YAlign.bottom);
        histogramChart.bindData(null);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map param = this.getView().getFormShowParameter().getCustomParams();
        Object id = param.get("contractId");
        if (id != null) {
            DynamicObject contract = BusinessDataServiceHelper.loadSingle(id, (String)"pmct_incontract");
            DynamicObject currency = contract.getDynamicObject("currency");
            this.getModel().setValue("currency", (Object)currency);
        }
    }

    public void afterBindData(EventObject e) {
        Object payDirection;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.TRUE, new String[]{"blankpanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"datapanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"labelap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"labelap"});
        Map param = this.getView().getFormShowParameter().getCustomParams();
        Object contId = param.get("contractId");
        if (contId != null) {
            this.initEntries(contId);
            String contractId = contId.toString();
            this.getPageCache().put("contId", contractId);
            this.setData(contractId);
            this.initPage(contractId);
            this.setChartData();
            this.getView().invokeOperation("viewsettle");
        }
        if ((payDirection = param.get("payDirection")) != null) {
            this.getPageCache().put("payDirection", payDirection.toString());
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"isclaimed", "isreceived", "isdeducted"});
    }

    private void initEntries(Object contId) {
        IDataModel model = this.getModel();
        model.deleteEntryData("dataentry");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contId, (String)"pmct_incontract");
        String payDirection = contract.getString("paydirection");
        boolean isInContract = StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection);
        for (int i = 0; i < 10; ++i) {
            model.createNewEntryRow("dataentry");
        }
        model.setValue("amounttype", (Object)ResManager.loadKDString((String)"\u5408\u540c\u7b7e\u8ba2", (String)"ContractKanBanFormPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), 0);
        model.setValue("amounttype", (Object)ResManager.loadKDString((String)"\u8865\u5145\u534f\u8bae", (String)"ContractKanBanFormPlugin_32", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), 1);
        model.setValue("amounttype", (Object)ResManager.loadKDString((String)"\u5408\u540c\u53d8\u66f4", (String)"ContractKanBanFormPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), 2);
        model.setValue("amounttype", (Object)ResManager.loadKDString((String)"\u5408\u540c\u7d22\u8d54", (String)"ContractKanBanFormPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), 3);
        model.setValue("amounttype", (Object)ResManager.loadKDString((String)"\u5408\u540c\u603b\u91d1\u989d", (String)"ContractKanBanFormPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), 4);
        model.setValue("amounttype", (Object)ResManager.loadKDString((String)"\u5408\u540c\u7ed3\u7b97", (String)"ContractKanBanFormPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), 5);
        model.setValue("amounttype", (Object)(isInContract ? ResManager.loadKDString((String)"\u8bf7\u6b3e", (String)"ContractKanBanFormPlugin_22", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7", (String)"ContractKanBanFormPlugin_23", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])), 6);
        model.setValue("amounttype", (Object)(isInContract ? ResManager.loadKDString((String)"\u6536\u6b3e\u767b\u8bb0", (String)"ContractKanBanFormPlugin_24", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u767b\u8bb0", (String)"ContractKanBanFormPlugin_25", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])), 7);
        model.setValue("amounttype", (Object)(isInContract ? ResManager.loadKDString((String)"\u9500\u9879\u53d1\u7968", (String)"ContractKanBanFormPlugin_26", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8fdb\u9879\u53d1\u7968", (String)"ContractKanBanFormPlugin_27", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])), 8);
        model.setValue("amounttype", (Object)ResManager.loadKDString((String)"\u5408\u540c\u51b3\u7b97", (String)"ContractKanBanFormPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), 9);
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("fc", "#5582f3");
        this.getView().updateControlMetadata("settleticon", propMap);
        this.getView().updateControlMetadata("settlelabel", propMap);
        this.getView().setVisible(Boolean.FALSE, new String[]{"inventryap", "receiveentryap", "revisionentryap", "claimentryap"});
    }

    private void setLabelNameByPayDirection(boolean isInContract) {
        Label applyLabel = (Label)this.getControl("applylabel");
        applyLabel.setText(isInContract ? ResManager.loadKDString((String)"\u8bf7\u6b3e", (String)"ContractKanBanFormPlugin_22", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7", (String)"ContractKanBanFormPlugin_23", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        Label receiveLabel = (Label)this.getControl("receivelabel");
        receiveLabel.setText(isInContract ? ResManager.loadKDString((String)"\u6536\u6b3e\u767b\u8bb0", (String)"ContractKanBanFormPlugin_24", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u767b\u8bb0", (String)"ContractKanBanFormPlugin_25", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid settleEntry = (EntryGrid)this.getControl("settleentry");
        settleEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid invEntry = (EntryGrid)this.getControl("inventry");
        invEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid receiveEntry = (EntryGrid)this.getControl("receiveentry");
        receiveEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid applyEntry = (EntryGrid)this.getControl("applyentry");
        applyEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid revisionEntry = (EntryGrid)this.getControl("revisionentry");
        revisionEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid claimEntry = (EntryGrid)this.getControl("claimentry");
        claimEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid additionEntry = (EntryGrid)this.getControl("additionentry");
        additionEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("listmodelentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getView().getControl("listmodelentry1");
        entryGrid1.addRowClickListener((RowClickEventListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String entryKey = ((EntryGrid)hyperLinkClickEvent.getSource()).getEntryKey();
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRow = this.getModel().getEntryRowEntity(entryKey, rowIndex);
        Long pk = (Long)entryRow.getPkValue();
        String payDirection = this.getPageCache().get("payDirection");
        switch (fieldName) {
            case "settlenum": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.openBill("pmct_incontract_settle", pk);
                    break;
                }
                this.openBill("pmct_outcontract_settle", pk);
                break;
            }
            case "invname": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.openBill("pmct_outinvoice", pk);
                    break;
                }
                this.openBill("pmct_ininvoice", pk);
                break;
            }
            case "incomebillno": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.openBill("pmct_incomeregister", pk);
                    break;
                }
                this.openBill("pmct_paymentregister", pk);
                break;
            }
            case "applybillno": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.openBill("pmct_incomeapply", pk);
                    break;
                }
                try {
                    DynamicObject applyBill = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"pmct_paymentapply");
                    if (applyBill != null) {
                        this.openBill("pmct_paymentapply", pk);
                        break;
                    }
                    logger.info("applyBill=Null\uff0cid={}", (Object)pk);
                    applyBill = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"pmct_applymentpay");
                    if (applyBill == null) break;
                    this.openBill("pmct_applymentpay", pk);
                }
                catch (Exception e) {
                    logger.info("applybillno error\uff0cid={}", (Object)pk);
                    DynamicObject applyBill = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"pmct_applymentpay");
                    if (applyBill == null) break;
                    this.openBill("pmct_applymentpay", pk);
                }
                break;
            }
            case "revisionnum": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.openBill("pmct_incontractrevision", pk);
                    break;
                }
                this.openBill("pmct_outcontractrevision", pk);
                break;
            }
            case "claimnum": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.openBill("pmct_inclaimbill", pk);
                    break;
                }
                this.openBill("pmct_outclaimbill", pk);
                break;
            }
            case "additionnum": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.openBill("pmct_inaddagreement", pk);
                    break;
                }
                this.openBill("pmct_outaddagreement", pk);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("contract_f7".equals(key)) {
            ListSelectedRowCollection col = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (col == null || col.isEmpty()) {
                return;
            }
            Object contId = col.get(0).getPrimaryKeyValue();
            String contIdStr = contId.toString();
            this.getPageCache().put("contId", contIdStr);
            this.initPage(contId);
            this.initEntries(contId);
            this.setData(contIdStr);
            this.setChartData();
            this.getView().invokeOperation("viewsettle");
        }
    }

    private void initPage(Object contId) {
        String contractId = contId.toString();
        this.getView().setVisible(Boolean.FALSE, new String[]{"blankpanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"datapanel"});
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contractId), (String)"pmct_contracttpl", (String)"billname,project.name,contracttype.name,totalamount,paydirection,totaloftaxamount,currency");
        String payDirection = contract.getString("paydirection");
        boolean isInContract = StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection);
        this.setLabelNameByPayDirection(isInContract);
        Label contNameLabel = (Label)this.getControl("contnamelable");
        contNameLabel.setText(contract.getString("billname"));
        String contName = contract.getString("billname");
        Label proNameLabel = (Label)this.getControl("pronamelabel");
        String proName = "";
        if (contract.getDynamicObject("project") != null) {
            proName = contract.getDynamicObject("project").getString("name");
        }
        proNameLabel.setText(proName);
        Label typeNameLabel = (Label)this.getControl("typenamelabel");
        typeNameLabel.setText(contract.getDynamicObject("contracttype") != null ? contract.getDynamicObject("contracttype").getString("name") : null);
        Label payDirectionLabel = (Label)this.getControl("payDirectionlabel");
        if (payDirection != null) {
            String payDirectionName = PayDirectionEnum.getEnumByValue((Object)payDirection).getName();
            payDirectionName = String.format(ResManager.loadKDString((String)"%s\u5408\u540c", (String)"ContractKanBanFormPlugin_38", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payDirectionName);
            payDirectionLabel.setText(payDirectionName);
            if (PayDirectionEnum.OUT.getValue().equals(payDirection)) {
                this.getPageCache().put("payDirection", PayDirectionEnum.OUT.getValue());
            } else {
                this.getPageCache().put("payDirection", PayDirectionEnum.IN.getValue());
            }
        }
        if (contName != null) {
            this.getModel().setValue("contname", (Object)contName);
            this.getView().updateView("contname");
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"labelap"});
        } else {
            this.getModel().setValue("contname", null);
        }
        DynamicObject currency = contract.getDynamicObject("currency");
        currency = BusinessDataServiceHelper.loadSingle((Object)currency.getPkValue(), (String)"bd_currency");
        if (contract.getBigDecimal("totaloftaxamount") != null && contract.getBigDecimal("totaloftaxamount").compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal totaloftaxamount = contract.getBigDecimal("totaloftaxamount").divide(BigDecimal.valueOf(10000L), 2, 4);
            this.getModel().setValue("amtoftax", (Object)(currency.getString("sign") + totaloftaxamount));
            this.getView().updateView("amtoftax");
        } else {
            this.getModel().setValue("amtoftax", (Object)(currency.getString("sign") + 0.0));
        }
    }

    private void openBill(String key, Long pk) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)key));
        if (obj != null) {
            Object id = obj.getPkValue();
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("formId", key);
            map.put("pkId", id.toString());
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        String payDirection = this.getPageCache().get("payDirection");
        String contId = this.getPageCache().get("contId");
        switch (key) {
            case "refreshdata": {
                this.getView().updateView();
                break;
            }
            case "viewsettle": {
                this.setEntryStyle("settleticon");
                this.updateSettle(contId, payDirection);
                break;
            }
            case "viewinvoice": {
                this.setEntryStyle("invoiceicon");
                this.updateInvoice(contId, payDirection);
                break;
            }
            case "viewreceive": {
                this.setEntryStyle("receiveicon");
                this.updateReceive(contId, payDirection);
                break;
            }
            case "viewapply": {
                this.setEntryStyle("applyicon");
                this.updateApply(contId, payDirection);
                break;
            }
            case "viewrevision": {
                this.setEntryStyle("revisionicon");
                this.updateRevision(contId, payDirection);
                break;
            }
            case "viewclaim": {
                this.setEntryStyle("claimicon");
                this.updateClaim(contId, payDirection);
                break;
            }
            case "viewdynamiclisting": {
                this.setEntryStyle("listingcon");
                this.updateDynamicListing(contId, payDirection);
                break;
            }
            case "viewlistingsummary": {
                this.setEntryStyle("summarycon");
                this.updateListingSummary(contId, payDirection);
                break;
            }
            case "viewcontract": {
                this.viewContract(contId, payDirection);
                break;
            }
            case "viewaddition": {
                this.setEntryStyle("additionicon");
                this.updateAdditionEntry(contId, payDirection);
                break;
            }
            case "switchcontract": {
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmct_contractf7", (boolean)false, (int)2);
                parameter.setShowUsed(true);
                parameter.setShowApproved(true);
                parameter.setShowFilter(true);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "contract_f7"));
                ContractHelper.getContractByStatus((String)"pmct_contractkanban", (ListShowParameter)parameter, null);
                long orgId = RequestContext.get().getOrgId();
                ArrayList<Long> orgIds = new ArrayList<Long>();
                orgIds.add(orgId);
                QFilter permContractFilter = ProjectPermissionHelper.getPermContractFilter(orgIds, (boolean)true, null, (String)this.getView().getEntityId(), (String)"view");
                parameter.getListFilterParameter().getQFilters().add(permContractFilter);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    private void updateApply(String contId, String payDirection) {
        BigDecimal applyOfTaxAmount;
        String thisApplyAmount;
        String thisPayAbleAmount;
        MainEntityType billDT;
        DynamicObject[] bills;
        boolean isInContract = PayDirectionEnum.IN.getValue().equals(payDirection);
        HashMap<String, LocaleString> thisCycleMap = new HashMap<String, LocaleString>(16);
        thisCycleMap.put("text", new LocaleString(isInContract ? ResManager.loadKDString((String)"\u8bf7\u6b3e\u660e\u7ec6", (String)"ContractKanBanFormPlugin_28", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6", (String)"ContractKanBanFormPlugin_29", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])));
        this.getView().updateControlMetadata("applyentry", thisCycleMap);
        this.getModel().deleteEntryData("applyentry");
        QFilter filter = new QFilter("entryentity.entrycontract.id", "=", (Object)Long.parseLong(contId));
        filter.and(new QFilter("billStatus", "=", (Object)Character.valueOf('C')));
        if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
            bills = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)"id", (QFilter[])new QFilter[]{filter});
            billDT = EntityMetadataCache.getDataEntityType((String)"pmct_incomeapply");
            thisPayAbleAmount = "applyoftaxamount";
            thisApplyAmount = "applyamount";
        } else {
            bills = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"id", (QFilter[])new QFilter[]{filter});
            billDT = EntityMetadataCache.getDataEntityType((String)"pmct_paymentapply");
            thisPayAbleAmount = "thispayableamount";
            thisApplyAmount = "thispayableexcltaxamount";
        }
        if (bills != null && bills.length != 0) {
            DynamicObjectCollection applyEntries = this.getModel().getEntryEntity("applyentry");
            Object[] billIds = Arrays.stream(bills).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            for (DynamicObject billInfo : bills = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)billDT)) {
                DynamicObjectCollection billEntries = billInfo.getDynamicObjectCollection("entryentity");
                for (DynamicObject billEntry : billEntries) {
                    if (billEntry.get("entrycontract.id") == null || !contId.equals(billEntry.get("entrycontract.id").toString())) continue;
                    DynamicObject entry = new DynamicObject(applyEntries.getDynamicObjectType());
                    entry.set("id", billInfo.getPkValue());
                    entry.set("applybillno", billInfo.get("billno"));
                    entry.set("applybillname", billInfo.get("billname"));
                    applyOfTaxAmount = billEntry.getBigDecimal(thisPayAbleAmount);
                    BigDecimal applyAmount = billEntry.getBigDecimal(thisApplyAmount);
                    BigDecimal applyTaxAmount = applyOfTaxAmount.subtract(applyAmount);
                    entry.set("applyoftaxamount", (Object)applyOfTaxAmount);
                    entry.set("applyamount", (Object)applyAmount);
                    entry.set("applytaxamount", (Object)applyTaxAmount);
                    entry.set("applybizdate", billInfo.get("bizdate"));
                    entry.set("applycreator", billInfo.get("creator"));
                    entry.set("applycreatedate", billInfo.get("createtime"));
                    entry.set("applydesc", billEntry.get("description"));
                    applyEntries.add((Object)entry);
                }
            }
        }
        if (PayDirectionEnum.OUT.getValue().equals(payDirection)) {
            QFilter contractFilter = new QFilter("contract", "=", (Object)Long.parseLong(contId));
            contractFilter.and(new QFilter("billStatus", "=", (Object)Character.valueOf('C')));
            DynamicObject[] applyBills = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"id", (QFilter[])new QFilter[]{contractFilter});
            DynamicObjectCollection applyEntries = this.getModel().getEntryEntity("applyentry");
            billDT = EntityMetadataCache.getDataEntityType((String)"pmct_applymentpay");
            if (applyBills.length > 0) {
                Object[] ids = Arrays.stream(applyBills).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
                for (DynamicObject billInfo : applyBills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)billDT)) {
                    DynamicObject entry = new DynamicObject(applyEntries.getDynamicObjectType());
                    entry.set("id", billInfo.getPkValue());
                    entry.set("applybillno", billInfo.get("billno"));
                    entry.set("applybillname", billInfo.get("billname"));
                    BigDecimal applyAmount = billInfo.getBigDecimal("applypaytotal");
                    applyOfTaxAmount = billInfo.getBigDecimal("curpaytotal");
                    entry.set("applyamount", (Object)applyAmount);
                    entry.set("applytaxamount", (Object)applyOfTaxAmount.subtract(applyAmount));
                    entry.set("applyoftaxamount", (Object)applyOfTaxAmount);
                    entry.set("applybizdate", billInfo.get("bizdate"));
                    entry.set("applycreator", billInfo.get("creator"));
                    entry.set("applycreatedate", billInfo.get("createtime"));
                    applyEntries.add((Object)entry);
                }
            }
        }
        this.getView().updateView("applyentry");
    }

    private void viewContract(String contId, String payDirection) {
        if (contId == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"ContractKanBanFormPlugin_39", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String formId = "";
        formId = PayDirectionEnum.IN.getValue().equals(payDirection) ? "pmct_incontract" : "pmct_outcontract";
        map.put("formId", formId);
        map.put("pkId", contId);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    private void updateSettle(String contId, String payDirection) {
        this.getModel().deleteEntryData("settleEntry");
        String key = PayDirectionEnum.IN.getValue().equals(payDirection) ? "pmct_incontract_settle" : "pmct_outcontract_settle";
        QFilter filter = new QFilter("contract", "=", (Object)Long.parseLong(contId));
        filter.and(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)key, (String)"id", (QFilter[])new QFilter[]{filter});
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)key);
        if (bills != null && bills.length != 0) {
            DynamicObjectCollection settleEntries = this.getModel().getEntryEntity("settleEntry");
            Object[] ids = Arrays.stream(bills).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            for (DynamicObject billInfo : bills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt)) {
                DynamicObject entry = new DynamicObject(settleEntries.getDynamicObjectType());
                entry.set("id", billInfo.getPkValue());
                entry.set("settleperiod", billInfo.get("period.number"));
                entry.set("settlenum", billInfo.get("billno"));
                entry.set("settlename", billInfo.get("billname"));
                entry.set("settleamount", billInfo.get("settleamount"));
                entry.set("settletax", billInfo.get("taxamount"));
                entry.set("oftaxsettleamount", billInfo.get("settleoftaxamount"));
                entry.set("settlecreator", billInfo.get("creator"));
                entry.set("settlecreatdate", billInfo.get("createtime"));
                settleEntries.add((Object)entry);
            }
            this.getView().updateView("settleEntry");
        }
    }

    private void updateInvoice(String contId, String payDirection) {
        this.getModel().deleteEntryData("inventry");
        QFilter filter = new QFilter("contract", "=", (Object)Long.parseLong(contId));
        filter.and(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isclaimed"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"isreceived"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"isdeducted"});
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_outinvoice", (String)"id", (QFilter[])new QFilter[]{filter});
            if (invoices != null && invoices.length != 0) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_outinvoice");
                Object[] ids = Arrays.stream(invoices).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
                invoices = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt);
                DynamicObjectCollection invoiceEntries = this.getModel().getEntryEntity("inventry");
                for (DynamicObject invoiceInfo : invoices) {
                    DynamicObject entry = new DynamicObject(invoiceEntries.getDynamicObjectType());
                    entry.set("id", invoiceInfo.getPkValue());
                    entry.set("invnumber", invoiceInfo.get("invoicecode"));
                    entry.set("invname", invoiceInfo.get("invoiceno"));
                    entry.set("invtotalamount", invoiceInfo.get("totalamount"));
                    entry.set("invtotaltax", invoiceInfo.get("totaltax"));
                    entry.set("invtotaloftaxamount", invoiceInfo.get("totaloftaxamount"));
                    entry.set("invbizdate", invoiceInfo.get("invoicedate"));
                    entry.set("invoicetype", invoiceInfo.get("invoicetype"));
                    entry.set("invoicestatus", invoiceInfo.get("invoicestatus"));
                    invoiceEntries.add((Object)entry);
                }
            }
        } else if (PayDirectionEnum.OUT.getValue().equals(payDirection)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isclaimed"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"isreceived"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"isdeducted"});
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"", (QFilter[])new QFilter[]{filter});
            if (invoices != null && invoices.length != 0) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice");
                Object[] ids = Arrays.stream(invoices).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
                invoices = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt);
                DynamicObjectCollection invoiceEntries = this.getModel().getEntryEntity("inventry");
                for (DynamicObject invoiceInfo : invoices) {
                    ILocaleString invoiceTypeName;
                    DynamicObject entry = new DynamicObject(invoiceEntries.getDynamicObjectType());
                    entry.set("id", invoiceInfo.getPkValue());
                    entry.set("invnumber", invoiceInfo.get("invoicecode"));
                    entry.set("invname", invoiceInfo.get("invoiceno"));
                    entry.set("invtotalamount", invoiceInfo.get("totalamount"));
                    entry.set("invtotaltax", invoiceInfo.get("totaltax"));
                    entry.set("invtotaloftaxamount", invoiceInfo.get("totaloftaxamount"));
                    entry.set("invbizdate", invoiceInfo.get("invoicedate"));
                    entry.set("isclaimed", invoiceInfo.get("isclaimed"));
                    entry.set("isreceived", invoiceInfo.get("isreceived"));
                    entry.set("isdeducted", invoiceInfo.get("isdeducted"));
                    DynamicObject invoiceType = invoiceInfo.getDynamicObject("invoicetypeid");
                    if (invoiceType != null && (invoiceTypeName = invoiceType.getLocaleString("name")) != null) {
                        entry.set("invoicetype", (Object)invoiceTypeName.getLocaleValue());
                    }
                    entry.set("invoicestatus", invoiceInfo.get("invoicestatus"));
                    invoiceEntries.add((Object)entry);
                }
            }
        }
        this.getView().updateView("inventry");
    }

    private void updateReceive(String contId, String payDirection) {
        boolean isInContract = PayDirectionEnum.IN.getValue().equals(payDirection);
        String key = isInContract ? "pmct_incomeregister" : "pmct_paymentregister";
        HashMap<String, LocaleString> thisCycleMap = new HashMap<String, LocaleString>(16);
        thisCycleMap.put("text", new LocaleString(isInContract ? ResManager.loadKDString((String)"\u6536\u6b3e\u767b\u8bb0\u660e\u7ec6", (String)"ContractKanBanFormPlugin_30", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u767b\u8bb0\u660e\u7ec6", (String)"ContractKanBanFormPlugin_31", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])));
        this.getView().updateControlMetadata("receiveentry", thisCycleMap);
        this.getModel().deleteEntryData("receiveentry");
        QFilter filter = new QFilter("entryentity.entrycontract.id", "=", (Object)Long.parseLong(contId));
        filter.and(new QFilter("billStatus", "=", (Object)Character.valueOf('C')));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)key, (String)"id", (QFilter[])new QFilter[]{filter});
        if (bills != null && bills.length != 0) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)key);
            Object[] ids = Arrays.stream(bills).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            bills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt);
            DynamicObjectCollection registerEntries = this.getModel().getEntryEntity("receiveentry");
            for (DynamicObject billInfo : bills) {
                DynamicObjectCollection billEntries = billInfo.getDynamicObjectCollection("entryentity");
                for (DynamicObject billEntry : billEntries) {
                    BigDecimal tax;
                    BigDecimal amount;
                    BigDecimal ofTaxAmount;
                    if (billEntry.getDynamicObject("entrycontract") == null || !contId.equals(billEntry.getDynamicObject("entrycontract").getPkValue().toString())) continue;
                    if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                        ofTaxAmount = billEntry.getBigDecimal("receiptoftaxamount");
                        amount = billEntry.getBigDecimal("receiptamount");
                        tax = billEntry.getBigDecimal("receipttaxamount");
                    } else {
                        ofTaxAmount = billEntry.getBigDecimal("thispaymentoftaxamount");
                        amount = billEntry.getBigDecimal("thispaymentamount");
                        tax = billEntry.getBigDecimal("thispaymenttaxamount");
                    }
                    DynamicObject entry = new DynamicObject(registerEntries.getDynamicObjectType());
                    entry.set("id", billInfo.getPkValue());
                    entry.set("incomebillno", billInfo.get("billno"));
                    entry.set("incomebillname", billInfo.get("billname"));
                    entry.set("incomeamount", (Object)amount);
                    entry.set("incometaxamount", (Object)tax);
                    entry.set("incomeoftaxamount", (Object)ofTaxAmount);
                    entry.set("incomebizdate", billInfo.get("bizdate"));
                    entry.set("incomecreator", billInfo.get("creator"));
                    entry.set("createdate", billInfo.get("createtime"));
                    entry.set("incomedesc", billEntry.get("description"));
                    registerEntries.add((Object)entry);
                }
            }
            this.getView().updateView("receiveentry");
        }
    }

    private void updateRevision(String contId, String payDirection) {
        this.getModel().deleteEntryData("revisionentry");
        String key = PayDirectionEnum.IN.getValue().equals(payDirection) ? "pmct_incontractrevision" : "pmct_outcontractrevision";
        QFilter filter = new QFilter("contract.id", "=", (Object)Long.parseLong(contId));
        filter.and(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)key, (String)"", (QFilter[])new QFilter[]{filter});
        if (bills != null && bills.length != 0) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)key);
            Object[] ids = Arrays.stream(bills).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            bills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt);
            DynamicObjectCollection revisionEntries = this.getModel().getEntryEntity("revisionentry");
            for (DynamicObject billInfo : bills) {
                DynamicObject entry = new DynamicObject(revisionEntries.getDynamicObjectType());
                entry.set("id", billInfo.getPkValue());
                entry.set("revisionperiodnum", billInfo.get("period.number"));
                entry.set("changetype", billInfo.get("changetype"));
                entry.set("revisionnum", billInfo.get("billno"));
                entry.set("revisionname", billInfo.get("billname"));
                entry.set("changeamount", billInfo.get("revisionamount"));
                entry.set("changetax", billInfo.get("taxamount"));
                entry.set("changeoftaxamount", billInfo.get("revisionoftaxamount"));
                entry.set("changecreator", billInfo.get("creator"));
                entry.set("changecreatedate", billInfo.get("createtime"));
                entry.set("changedesc", billInfo.get("changereason"));
                revisionEntries.add((Object)entry);
            }
            this.getView().updateView("revisionentry");
        }
    }

    private void updateAdditionEntry(String contId, String payDirection) {
        IDataModel model = this.getModel();
        model.deleteEntryData("additionentry");
        QFilter filter = new QFilter("contract", "=", (Object)Long.parseLong(contId));
        filter.and(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        String key = PayDirectionEnum.IN.getValue().equals(payDirection) ? "pmct_inaddagreement" : "pmct_outaddagreement";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)key, (String)"", (QFilter[])new QFilter[]{filter}, (String)"createtime asc");
        if (bills != null && bills.length != 0) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)key);
            Object[] ids = Arrays.stream(bills).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            bills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt);
            DynamicObjectCollection additionEntries = this.getModel().getEntryEntity("additionentry");
            for (DynamicObject billInfo : bills) {
                DynamicObject entry = new DynamicObject(additionEntries.getDynamicObjectType());
                entry.set("id", billInfo.getPkValue());
                entry.set("additionnum", billInfo.get("billno"));
                entry.set("additionname", billInfo.get("billname"));
                entry.set("additionamount", billInfo.get("addamount"));
                entry.set("additiontax", billInfo.get("taxamount"));
                entry.set("addoftaxamount", billInfo.get("addamountoftax"));
                entry.set("additioncreator", billInfo.get("creator"));
                entry.set("additioncreatedate", billInfo.get("createtime"));
                entry.set("additiondesc", billInfo.get("description"));
                additionEntries.add((Object)entry);
            }
            this.getView().updateView("additionentry");
        }
    }

    private void updateClaim(String contId, String payDirection) {
        this.getModel().deleteEntryData("claimentry");
        QFilter filter = new QFilter("contract.id", "=", (Object)Long.parseLong(contId));
        filter.and(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        String key = PayDirectionEnum.IN.getValue().equals(payDirection) ? "pmct_inclaimbill" : "pmct_outclaimbill";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)key, (String)"", (QFilter[])new QFilter[]{filter});
        if (bills != null && bills.length != 0) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)key);
            Object[] ids = Arrays.stream(bills).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            bills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt);
            DynamicObjectCollection claimEntries = this.getModel().getEntryEntity("claimentry");
            for (DynamicObject billInfo : bills) {
                DynamicObject entry = new DynamicObject(claimEntries.getDynamicObjectType());
                entry.set("id", billInfo.getPkValue());
                entry.set("claimperiodnum", billInfo.get("period.number"));
                entry.set("claimnum", billInfo.get("billno"));
                entry.set("claimname", billInfo.get("billname"));
                entry.set("claimamount", billInfo.get("claimamount"));
                entry.set("claimtax", billInfo.get("taxamount"));
                entry.set("claimoftaxamount", billInfo.get("claimoftaxamount"));
                entry.set("claimcreator", billInfo.get("creator"));
                entry.set("claimcreatedate", billInfo.get("createtime"));
                entry.set("claimdesc", billInfo.get("description"));
                claimEntries.add((Object)entry);
            }
            this.getView().updateView("claimentry");
        }
    }

    private void updateDynamicListing(String contId, String payDirection) {
        int rowCount;
        this.getModel().deleteEntryData("listmodelentry");
        this.getModel().deleteEntryData("treelistentry");
        String formId = null;
        formId = PayDirectionEnum.IN.getValue().equals(payDirection) ? "pmct_incontract" : "pmct_outcontract";
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contId, (String)formId);
        boolean isOnList = contract.getBoolean("isonlist");
        if (isOnList) {
            DynamicObject contType = contract.getDynamicObject("contracttype");
            DynamicObjectCollection cardEntry = contract.getDynamicObjectCollection("listmodelentry");
            ContractEditHelper.setNewListModel((Object)contract.getPkValue(), (DynamicObjectCollection)cardEntry);
            if (cardEntry != null && cardEntry.size() > 0) {
                DynamicObjectCollection entries = this.getModel().getEntryEntity("listmodelentry");
                DynamicObjectType dt = entries.getDynamicObjectType();
                for (DynamicObject entryEntity : cardEntry) {
                    DynamicObject dynamicObject = new DynamicObject(dt);
                    dynamicObject.set("modelname", entryEntity.get("modelname"));
                    dynamicObject.set("cmptype", entryEntity.get("cmptype"));
                    dynamicObject.set("rowtaxrate", entryEntity.get("rowtaxrate"));
                    dynamicObject.set("listmodelid", entryEntity.get("listmodelid"));
                    this.setModelAmountData(dynamicObject, contId, entryEntity.get("listmodelid"), true);
                    entries.add((Object)dynamicObject);
                }
                this.getModel().updateEntryCache(entries);
                this.getView().updateView("listmodelentry");
                CardEntry cardEntryGrid = (CardEntry)this.getControl("listmodelentry");
                cardEntryGrid.selectRows(0, true);
                cardEntryGrid.clickCell("modelname", 0);
            }
        }
        if ((rowCount = this.getModel().getEntryRowCount("listmodelentry")) <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listmodelentry"});
        }
    }

    private void updateListingSummary(String contId, String payDirection) {
        int rowCount;
        this.getModel().deleteEntryData("listmodelentry1");
        this.getModel().deleteEntryData("treelistentry1");
        String formId = PayDirectionEnum.IN.getValue().equals(payDirection) ? "pmct_incontract" : "pmct_outcontract";
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contId, (String)formId);
        boolean isOnList = contract.getBoolean("isonlist");
        if (isOnList) {
            DynamicObject contType = contract.getDynamicObject("contracttype");
            DynamicObjectCollection cardEntry = contract.getDynamicObjectCollection("listmodelentry");
            ContractEditHelper.setNewListModel((Object)contract.getPkValue(), (DynamicObjectCollection)cardEntry);
            if (cardEntry != null && cardEntry.size() > 0) {
                DynamicObjectCollection entries = this.getModel().getEntryEntity("listmodelentry1");
                DynamicObjectType dt = entries.getDynamicObjectType();
                for (DynamicObject entryEntity : cardEntry) {
                    DynamicObject dynamicObject = new DynamicObject(dt);
                    dynamicObject.set("modelname1", entryEntity.get("modelname"));
                    dynamicObject.set("cmptype1", entryEntity.get("cmptype"));
                    dynamicObject.set("rowtaxrate1", entryEntity.get("rowtaxrate"));
                    dynamicObject.set("listmodelid1", entryEntity.get("listmodelid"));
                    this.setModelAmountData(dynamicObject, contId, entryEntity.get("listmodelid"), false);
                    entries.add((Object)dynamicObject);
                }
                this.getModel().updateEntryCache(entries);
                this.getView().updateView("listmodelentry1");
                CardEntry cardEntryGrid = (CardEntry)this.getControl("listmodelentry1");
                cardEntryGrid.selectRows(0, true);
                cardEntryGrid.clickCell("modelname1", 0);
            }
        }
        if ((rowCount = this.getModel().getEntryRowCount("listmodelentry1")) <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listmodelentry1"});
        }
    }

    private void setModelAmountData(DynamicObject dynamicObject, String contId, Object modelId, boolean isDynamicListing) {
        QFilter qFilter = new QFilter("contractid", "=", (Object)contId);
        qFilter.and(new QFilter("listingmodel", "=", (Object)modelId.toString()));
        qFilter.and(new QFilter("isleaf", "=", (Object)Character.valueOf('1')));
        DynamicObject[] listings = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"lstoftaxamount,taxrate", (QFilter[])new QFilter[]{qFilter});
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal ofTax = BigDecimal.ZERO;
        DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("currency");
        int amtprecision = 2;
        if (currency != null) {
            amtprecision = currency.getInt("amtprecision");
        }
        for (DynamicObject listing : listings) {
            BigDecimal listingOfTax = listing.getBigDecimal("lstoftaxamount");
            BigDecimal taxrate = listing.getBigDecimal("taxrate").divide(new BigDecimal(100), 6, RoundingMode.HALF_UP);
            BigDecimal listingAmount = listingOfTax.divide(BigDecimal.ONE.add(taxrate), 6, 4);
            BigDecimal listingTax = listingOfTax.subtract(listingAmount).setScale(amtprecision, RoundingMode.HALF_UP);
            tax = tax.add(listingTax);
            ofTax = ofTax.add(listingOfTax);
        }
        dynamicObject.set(isDynamicListing ? "rowamount" : "rowamount1", (Object)ofTax.subtract(tax));
        dynamicObject.set(isDynamicListing ? "rowtax" : "rowtax1", (Object)tax);
        dynamicObject.set(isDynamicListing ? "rowoftax" : "rowoftax1", (Object)ofTax);
    }

    private void setEntryStyle(String key) {
        HashMap<String, String> navMap = new HashMap<String, String>();
        navMap.put("settleticon", "settleentryap");
        navMap.put("invoiceicon", "inventryap");
        navMap.put("applyicon", "applyentryap");
        navMap.put("receiveicon", "receiveentryap");
        navMap.put("revisionicon", "revisionentryap");
        navMap.put("claimicon", "claimentryap");
        navMap.put("listingcon", "dynamiclistingentryap");
        navMap.put("summarycon", "summaryentryap");
        navMap.put("additionicon", "additionentryap");
        HashMap<String, String> labelMap = new HashMap<String, String>();
        labelMap.put("settleticon", "settlelabel");
        labelMap.put("invoiceicon", "invoicelabel");
        labelMap.put("receiveicon", "receivelabel");
        labelMap.put("revisionicon", "revisionlabel");
        labelMap.put("claimicon", "claimlabel");
        labelMap.put("listingcon", "listinglabel");
        labelMap.put("summarycon", "summarylabel");
        labelMap.put("additionicon", "additionlabel");
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("fc", "#5582f3");
        HashMap<String, String> propMap1 = new HashMap<String, String>();
        propMap1.put("fc", "#999999");
        Set entries = navMap.entrySet();
        for (Map.Entry entry : entries) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)((CharSequence)entry.getKey()))) {
                this.getView().updateControlMetadata((String)entry.getKey(), propMap);
                this.getView().setVisible(Boolean.TRUE, new String[]{(String)entry.getValue()});
                this.getView().updateControlMetadata((String)labelMap.get(entry.getKey()), propMap);
                continue;
            }
            this.getView().updateControlMetadata((String)entry.getKey(), propMap1);
            this.getView().setVisible(Boolean.FALSE, new String[]{(String)entry.getValue()});
            this.getView().updateControlMetadata((String)labelMap.get(entry.getKey()), propMap1);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"listmodelentry", (CharSequence)source.getKey())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("listmodelentry");
            String modelId = this.getModel().getEntryRowEntity("listmodelentry", rowIndex).getString("listmodelid");
            String contId = this.getPageCache().get("contId");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("listingmodel", "=", (Object)modelId));
            qFilters.add(new QFilter("contractid", "=", (Object)contId));
            this.initList(qFilters, "treelistentry");
        } else if (StringUtils.equals((CharSequence)"listmodelentry1", (CharSequence)source.getKey())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("listmodelentry1");
            String modelId = this.getModel().getEntryRowEntity("listmodelentry1", rowIndex).getString("listmodelid1");
            String contId = this.getPageCache().get("contId");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("listingmodel", "=", (Object)modelId));
            qFilters.add(new QFilter("contractid", "=", (Object)contId));
            this.initList(qFilters, "treelistentry1");
        }
    }

    private void initList(List<QFilter> qFilters, String entryId) {
        List<DynamicObject> childList;
        DynamicObject parent;
        this.getModel().deleteEntryData(entryId);
        DynamicObject[] listing = null;
        String payDirection = this.getPageCache().get("payDirection");
        boolean isInListing = StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection);
        listing = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"modifier, createtime, modifytime, number, name, status, creator, enable, masterid, level, longnumber, fullname, isleaf, parent, sysnumber, measureunit, qty, taxprice, taxrate, rateobj, amount, price, tax, oftax, desc, lstsettleqty, lstsettleoftaxamount, changeqty, chgeffectqty, chgoftaxamount, totalqty, curtaxprice, lstoftaxamount, avgtaxprice, ischanged, isaddnew, material, sequence, entryid, currency, listparentid, listingmodel, contractid, paydirection,listingbudgetitem", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"sequence,number");
        if (listing == null || listing.length == 0) {
            this.getView().updateView(entryId);
            return;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity(entryId);
        DynamicObjectType dt = entries.getDynamicObjectType();
        ArrayList<DynamicObject> firstLevelList = new ArrayList<DynamicObject>();
        HashMap<Long, List<DynamicObject>> childMap = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject list : listing) {
            if (list.getInt("sequence") == 0) continue;
            parent = list.getDynamicObject("parent");
            if (parent != null) {
                childList = (ArrayList<DynamicObject>)childMap.get(parent.getLong("id"));
                if (childList == null) {
                    childList = new ArrayList<DynamicObject>();
                    childMap.put(parent.getLong("id"), childList);
                }
                childList.add(list);
                continue;
            }
            firstLevelList.add(list);
        }
        for (DynamicObject list : listing) {
            if (list.getInt("sequence") != 0) continue;
            parent = list.getDynamicObject("parent");
            if (parent != null) {
                childList = (List)childMap.get(parent.getLong("id"));
                if (childList == null) {
                    childList = new ArrayList();
                    childMap.put(parent.getLong("id"), childList);
                }
                childList.add(list);
                continue;
            }
            firstLevelList.add(list);
        }
        for (DynamicObject firstLevelListing : firstLevelList) {
            if (StringUtils.equals((CharSequence)entryId, (CharSequence)"treelistentry")) {
                this.addAllChildsToDynamicListingEntry(isInListing, entries, dt, childMap, firstLevelListing);
                continue;
            }
            this.addAllChildsToListingSummaryEntry(isInListing, entries, dt, childMap, firstLevelListing);
            this.addSettleDataToEntry(entries);
        }
        this.getModel().updateEntryCache(entries);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(entryId);
        treeEntryGrid.setCollapse(false);
        int rowCount = this.getModel().getEntryRowCount(entryId);
        if (StringUtils.equals((CharSequence)entryId, (CharSequence)"treelistentry")) {
            for (int i = 0; i < rowCount; ++i) {
                Object type = this.getModel().getValue("flag", i);
                if (type != null && "01".equals(type.toString())) {
                    treeEntryGrid.setRowBackcolor("#6093e5", new int[]{i});
                    continue;
                }
                if (type == null || !"02".equals(type.toString())) continue;
                treeEntryGrid.setRowBackcolor("#ffff00", new int[]{i});
            }
        }
        this.getView().updateView(entryId);
    }

    private void addSettleDataToEntry(DynamicObjectCollection entries) {
        Map<String, ListingSettleInfo> settleListingMap = this.getSettleListingMap();
        if (settleListingMap != null) {
            for (DynamicObject entry : entries) {
                String listingId = entry.get("id").toString();
                ListingSettleInfo info = settleListingMap.get(listingId);
                if (info == null) continue;
                entry.set("preqty", (Object)info.getPreQty());
                entry.set("preamount", (Object)info.getPreAmount());
                entry.set("curqty", (Object)info.getThisQty());
                entry.set("curamount", (Object)info.getThisAmount());
                entry.set("lstqty", (Object)info.getLstQty());
                entry.set("lstamount", (Object)info.getLstAmount());
            }
        }
    }

    private Map<String, ListingSettleInfo> getSettleListingMap() {
        String contractId = this.getPageCache().get("contId");
        if (contractId == null || contractId.isEmpty() || "0".equals(contractId)) {
            return null;
        }
        DynamicObject beginPeriod = (DynamicObject)this.getModel().getValue("beginperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (beginPeriod == null || endPeriod == null) {
            return null;
        }
        Date beginDate = beginPeriod.getDate("beginDate");
        Date endDate = endPeriod.getDate("endDate");
        if (endDate.compareTo(beginDate) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u53ef\u665a\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"ContractKanBanFormPlugin_21", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return null;
        }
        HashMap<String, ListingSettleInfo> settleListingMap = new HashMap<String, ListingSettleInfo>();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("listmodelentry1");
        String modelId = this.getModel().getEntryRowEntity("listmodelentry1", rowIndex).getString("listmodelid1");
        this.addCurrentPeriodSettleListingData(contractId, beginDate, endDate, settleListingMap, modelId);
        this.addPreviousPeriodSettleListingData(contractId, beginDate, settleListingMap, modelId);
        return settleListingMap;
    }

    private void addPreviousPeriodSettleListingData(String contractId, Date beginDate, Map<String, ListingSettleInfo> settleListingMap, String modelId) {
        QFilter[] currentFilters = new QFilter[]{new QFilter("contract", "=", (Object)Long.parseLong(contractId)), new QFilter("enddate", "<", (Object)beginDate), new QFilter("billstatus", "=", (Object)Character.valueOf('C'))};
        DynamicObject[] currentContractSettles = BusinessDataServiceHelper.load((String)"pmct_incontract_settle", (String)"id,billno,billname", (QFilter[])currentFilters, (String)"begindate");
        if (currentContractSettles.length > 0) {
            Object[] ids = Arrays.stream(currentContractSettles).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_incontract_settle");
            for (DynamicObject singleContractSettle : currentContractSettles = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt)) {
                DynamicObjectCollection settleListModels = singleContractSettle.getDynamicObjectCollection("listmodelentry");
                for (DynamicObject settleListModel : settleListModels) {
                    if (!settleListModel.getString("listmodelid").equals(modelId)) continue;
                    DynamicObjectCollection settleListings = settleListModel.getDynamicObjectCollection("listentry");
                    for (DynamicObject settleList : settleListings) {
                        Long listingPk = settleList.getDynamicObject("listing").getLong("id");
                        ListingSettleInfo info = settleListingMap.get(listingPk.toString());
                        if (info == null) {
                            info = new ListingSettleInfo();
                            info.setPkValue(listingPk);
                            settleListingMap.put(listingPk.toString(), info);
                        }
                        info.setPreQty(info.getPreQty().add(settleList.getBigDecimal("thisqty")));
                        info.setPreAmount(info.getPreAmount().add(settleList.getBigDecimal("thisoftaxmount")));
                    }
                }
            }
        }
    }

    private void addCurrentPeriodSettleListingData(String contractId, Date beginDate, Date endDate, Map<String, ListingSettleInfo> settleListingMap, String modelId) {
        QFilter[] currentFilters = new QFilter[]{new QFilter("contract", "=", (Object)Long.parseLong(contractId)), new QFilter("begindate", ">=", (Object)beginDate), new QFilter("enddate", "<=", (Object)endDate), new QFilter("billstatus", "=", (Object)Character.valueOf('C'))};
        DynamicObject[] currentContractSettles = BusinessDataServiceHelper.load((String)"pmct_incontract_settle", (String)"id,billno,billname", (QFilter[])currentFilters, (String)"begindate");
        if (currentContractSettles.length > 0) {
            Object[] ids = Arrays.stream(currentContractSettles).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_incontract_settle");
            for (DynamicObject singleContractSettle : currentContractSettles = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt)) {
                DynamicObjectCollection settleListModels = singleContractSettle.getDynamicObjectCollection("listmodelentry");
                for (DynamicObject settleListModel : settleListModels) {
                    if (!settleListModel.getString("listmodelid").equals(modelId)) continue;
                    DynamicObjectCollection settleListings = settleListModel.getDynamicObjectCollection("listentry");
                    for (DynamicObject settleList : settleListings) {
                        Long listingPk = settleList.getDynamicObject("listing").getLong("id");
                        ListingSettleInfo info = settleListingMap.get(listingPk.toString());
                        if (info == null) {
                            info = new ListingSettleInfo();
                            info.setPkValue(listingPk);
                            settleListingMap.put(listingPk.toString(), info);
                        }
                        info.setThisQty(info.getThisQty().add(settleList.getBigDecimal("thisqty")));
                        info.setThisAmount(info.getThisAmount().add(settleList.getBigDecimal("thisoftaxmount")));
                    }
                }
            }
        }
    }

    private void addAllChildsToListingSummaryEntry(boolean isInListing, DynamicObjectCollection entries, DynamicObjectType dt, HashMap<Long, List<DynamicObject>> childMap, DynamicObject listing) {
        entries.add((Object)this.convertToListingSummaryEntryEntity(dt, listing, isInListing));
        List<DynamicObject> childList = childMap.get(listing.getLong("id"));
        if (childList != null) {
            for (DynamicObject child : childList) {
                this.addAllChildsToListingSummaryEntry(isInListing, entries, dt, childMap, child);
            }
        }
    }

    private void addAllChildsToDynamicListingEntry(boolean isInListing, DynamicObjectCollection entries, DynamicObjectType dt, HashMap<Long, List<DynamicObject>> childMap, DynamicObject listing) {
        entries.add((Object)this.convertToDynamicListingEntryEntity(dt, listing, isInListing));
        List<DynamicObject> childList = childMap.get(listing.getLong("id"));
        if (childList != null) {
            for (DynamicObject child : childList) {
                this.addAllChildsToDynamicListingEntry(isInListing, entries, dt, childMap, child);
            }
        }
    }

    private DynamicObject convertToDynamicListingEntryEntity(DynamicObjectType dt, DynamicObject list, boolean isInListing) {
        boolean isLeaf;
        DynamicObject newItem = new DynamicObject(dt);
        newItem.set("id", list.getPkValue());
        newItem.set("treelistnumber", list.get("number"));
        newItem.set("pid", (Object)list.getLong("parent_id"));
        newItem.set("treelistname", (Object)list.getLocaleString("name").getLocaleValue());
        newItem.set("treeisleaf", list.get("isleaf"));
        if (list.getDynamicObject("currency") != null) {
            newItem.set("treecurrency", (Object)list.getDynamicObject("currency"));
        }
        if (list.get("material") != null) {
            newItem.set("treematerial", (Object)list.getDynamicObject("material"));
        }
        if (list.get("measureunit") != null) {
            newItem.set("treemeasureunit", (Object)list.getDynamicObject("measureunit"));
        }
        if (isLeaf = list.getBoolean("isleaf")) {
            newItem.set("changeqty", list.get("changeqty"));
            newItem.set("chgeffectqty", list.get("chgeffectqty"));
            newItem.set("chgoftaxamount", list.get("chgoftaxamount"));
            newItem.set("totalqty", list.get("totalqty"));
            newItem.set("curtaxprice", list.get("curtaxprice"));
            newItem.set("avgtaxprice", list.get("avgtaxprice"));
            newItem.set("treerate", list.get("taxrate"));
        }
        newItem.set("treeqty", list.get("qty"));
        newItem.set("treetaxprice", list.get("taxprice"));
        newItem.set("treeoftax", list.get("oftax"));
        newItem.set("treedesc", list.get("desc"));
        newItem.set("lstoftaxamount", list.get("lstoftaxamount"));
        if (list.getBoolean("ischanged")) {
            if (isLeaf) {
                newItem.set("oftaxchangeprice", list.get("curtaxprice"));
            }
            newItem.set("flag", (Object)"01");
        }
        if (list.getBoolean("isaddnew")) {
            newItem.set("flag", (Object)"02");
        }
        return newItem;
    }

    private DynamicObject convertToListingSummaryEntryEntity(DynamicObjectType dt, DynamicObject list, boolean isInListing) {
        boolean isLeaf;
        DynamicObject newItem = new DynamicObject(dt);
        newItem.set("id", list.getPkValue());
        newItem.set("treelistnumber1", list.get("number"));
        newItem.set("pid", (Object)list.getLong("parent_id"));
        newItem.set("treelistname1", (Object)list.getLocaleString("name").getLocaleValue());
        newItem.set("treeisleaf1", list.get("isleaf"));
        if (list.getDynamicObject("currency") != null) {
            newItem.set("treecurrency1", (Object)list.getDynamicObject("currency"));
        }
        if (list.get("material") != null) {
            newItem.set("treematerial1", (Object)list.getDynamicObject("material"));
        }
        if (list.get("measureunit") != null) {
            newItem.set("treemeasureunit1", (Object)list.getDynamicObject("measureunit"));
        }
        if (isLeaf = list.getBoolean("isleaf")) {
            newItem.set("treetotalqty", list.get("totalqty") == null ? BigDecimal.ZERO : list.get("totalqty"));
            newItem.set("treeavgtaxprice", list.get("avgtaxprice") == null ? BigDecimal.ZERO : list.get("avgtaxprice"));
            newItem.set("treerate1", list.get("taxrate"));
        }
        return newItem;
    }
}

