/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.EcConstant;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.formplugin.TreeListingComparator;

public class ContractListingListPlugin
extends AbstractListPlugin
implements CellClickListener {
    private static final String KEY_TREEENTRYENTITY = "treeentryentity";
    private static final String RETURN_DATA = "doreturndata";
    private static final String OPERATE_CLOSE = "close";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void setFilter(SetFilterEvent setfilterevent) {
        super.setFilter(setfilterevent);
        List qFilters = setfilterevent.getQFilters();
        if (this.getPageCache().get("initfilter") == null) {
            this.getPageCache().put("initfilter", SerializationUtils.toJsonString((Object)qFilters));
        } else {
            qFilters.addAll(SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("initfilter"), QFilter.class));
        }
        this.initList(qFilters);
    }

    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        grid.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent cellclickevent) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isMultiSelect = listShowParameter.isMultiSelect();
        TreeEntryGrid grid = (TreeEntryGrid)cellclickevent.getSource();
        int row = cellclickevent.getRow();
        int[] selectRows = grid.getSelectRows();
        if (!isMultiSelect && selectRows != null && selectRows.length > 0) {
            grid.selectRows(new int[]{row}, row);
        }
        if (isMultiSelect) {
            HashSet<Integer> selectRowSet = new HashSet<Integer>();
            if (selectRows != null && selectRows.length > 0) {
                for (int index : selectRows) {
                    boolean isLeaf = (Boolean)this.getModel().getValue("isleaf", index);
                    String listEntryId = this.getModel().getEntryRowEntity(KEY_TREEENTRYENTITY, index).getPkValue().toString();
                    boolean result = ContractListingListPlugin.validatorListing(listEntryId, listShowParameter.getParentFormId());
                    if (result) {
                        Object name = this.getModel().getValue("name", index);
                        String tip = listShowParameter.getParentFormId().equals("pmct_outcontract_settle") || listShowParameter.getParentFormId().equals("pmct_incontract_settle") ? String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u6e05\u5355\u6b63\u5728\u53d8\u66f4\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"ContractListingListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), name) : String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u6e05\u5355\u6b63\u5728\u7ed3\u7b97\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d8\u66f4\u3002", (String)"ContractListingListPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), name);
                        this.getView().showTipNotification(tip);
                    }
                    if (!isLeaf || result) continue;
                    selectRowSet.add(index);
                }
            }
            int[] finalSelectRows = selectRowSet.stream().mapToInt(Number::intValue).toArray();
            grid.selectRows(finalSelectRows, row);
        }
    }

    private static boolean validatorListing(String listEntryId, String parentFormId) {
        if (StringUtils.isNotEmpty((CharSequence)listEntryId)) {
            DynamicObject listing = BusinessDataServiceHelper.loadSingle((Object)listEntryId, (String)"pmct_contractlist");
            String contractId = listing.getString("contractid");
            String listingModelId = listing.getString("listingmodel_id");
            if (parentFormId.equals("pmct_outcontract_settle") || parentFormId.equals("pmct_incontract_settle")) {
                boolean result = ContractListingListPlugin.validatorUnAuditRevision(contractId, listingModelId, listEntryId, parentFormId);
                if (result) {
                    return true;
                }
                result = ContractListingListPlugin.validatorUnAuditAddAgreement(contractId, listingModelId, listEntryId, parentFormId);
                if (result) {
                    return true;
                }
                result = ContractListingListPlugin.validatorUnAuditOutClaimBill(contractId, listingModelId, listEntryId, parentFormId);
                return result;
            }
            boolean result = ContractListingListPlugin.validatorUnAuditSettle(contractId, listingModelId, listEntryId, parentFormId);
            return result;
        }
        return false;
    }

    private static boolean validatorUnAuditRevision(String contractId, String listingModelId, String listEntryId, String parentFormId) {
        boolean result = false;
        String formBillId = parentFormId.equals("pmct_outcontract_settle") ? "pmct_outcontractrevision" : "pmct_incontractrevision";
        String listModel = parentFormId.equals("pmct_outcontract_settle") ? "kapianentry" : "kapianentry";
        String listModelId = parentFormId.equals("pmct_outcontract_settle") ? "listmodelid" : "listmodelid";
        String entryEntity = parentFormId.equals("pmct_outcontract_settle") ? "entryentity" : "entryentity";
        String listId = parentFormId.equals("pmct_outcontract_settle") ? "listid" : "listid";
        QFilter contFilter = new QFilter("contract", "=", (Object)Long.parseLong(contractId)).and("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)formBillId, (String)"id", (QFilter[])new QFilter[]{contFilter});
        if (null != contractRevisions && contractRevisions.length > 0) {
            for (DynamicObject contractRevision : contractRevisions) {
                boolean present;
                DynamicObjectCollection listEntry;
                DynamicObjectCollection listModelEntry = (contractRevision = BusinessDataServiceHelper.loadSingle((Object)contractRevision.getPkValue().toString(), (String)formBillId)).getDynamicObjectCollection(listModel);
                DynamicObject modelEntry = listModelEntry.stream().filter(entry -> listingModelId.equals(entry.getString(listModelId))).findFirst().orElse(null);
                if (null == modelEntry || null == (listEntry = modelEntry.getDynamicObjectCollection(entryEntity)) || listEntry.isEmpty() || !(present = listEntry.stream().anyMatch(entry -> entry.getDynamicObject(listId) != null && listEntryId.equals(entry.getDynamicObject(listId).getPkValue().toString())))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static boolean validatorUnAuditAddAgreement(String contractId, String listingModelId, String listEntryId, String parentFormId) {
        QFilter contFilter;
        boolean result = false;
        String formBillId = parentFormId.equals("pmct_outcontract_settle") ? "pmct_outaddagreement" : "pmct_inaddagreement";
        DynamicObject[] addAgreements = BusinessDataServiceHelper.load((String)formBillId, (String)"id", (QFilter[])new QFilter[]{contFilter = new QFilter("contract", "=", (Object)Long.parseLong(contractId)).and("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue())});
        if (null != addAgreements && addAgreements.length > 0) {
            for (DynamicObject addAgreement : addAgreements) {
                boolean present;
                DynamicObjectCollection listEntry;
                DynamicObjectCollection listModelEntry = (addAgreement = BusinessDataServiceHelper.loadSingle((Object)addAgreement.getPkValue().toString(), (String)formBillId)).getDynamicObjectCollection("cardentry");
                DynamicObject modelEntry = listModelEntry.stream().filter(entry -> listingModelId.equals(entry.getString("listmodelid"))).findFirst().orElse(null);
                if (null == modelEntry || null == (listEntry = modelEntry.getDynamicObjectCollection("entryentity")) || listEntry.isEmpty() || !(present = listEntry.stream().anyMatch(entry -> entry.getDynamicObject("listid") != null && listEntryId.equals(entry.getDynamicObject("listid").getPkValue().toString())))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static boolean validatorUnAuditOutClaimBill(String contractId, String listingModelId, String listEntryId, String parentFormId) {
        QFilter contFilter;
        boolean result = false;
        String contract = parentFormId.equals("pmct_outcontract_settle") ? "contract" : "contract";
        String formBillId = parentFormId.equals("pmct_outcontract_settle") ? "pmct_outclaimbill" : "pmct_inclaimbill";
        DynamicObject[] claims = BusinessDataServiceHelper.load((String)formBillId, (String)"id", (QFilter[])new QFilter[]{contFilter = new QFilter(contract, "=", (Object)Long.parseLong(contractId)).and("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue())});
        if (null != claims && claims.length > 0) {
            for (DynamicObject claim : claims) {
                boolean present;
                DynamicObjectCollection listEntry;
                DynamicObjectCollection listModelEntry = (claim = BusinessDataServiceHelper.loadSingle((Object)claim.getPkValue(), (String)formBillId)).getDynamicObjectCollection("kapianentry");
                DynamicObject modelEntry = listModelEntry.stream().filter(entry -> listingModelId.equals(entry.getString("listmodelid"))).findFirst().orElse(null);
                if (null == modelEntry || null == (listEntry = modelEntry.getDynamicObjectCollection("entryentity")) || listEntry.isEmpty() || !(present = listEntry.stream().anyMatch(entry -> entry.getDynamicObject("listid") != null && listEntryId.equals(entry.getDynamicObject("listid").getPkValue().toString())))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static boolean validatorUnAuditSettle(String contractId, String listingModelId, String listEntryId, String parentFormId) {
        QFilter contFilter;
        boolean result = false;
        String contract = parentFormId.equals("pmct_outcontract_settle") ? "contract" : "contract";
        String formBillId = parentFormId.equals("pmct_inclaimbill") || parentFormId.equals("pmct_inaddagreement") || parentFormId.equals("pmct_incontractrevision") ? "pmct_incontract_settle" : "pmct_outcontract_settle";
        DynamicObject[] contractSettles = BusinessDataServiceHelper.load((String)formBillId, (String)"id", (QFilter[])new QFilter[]{contFilter = new QFilter(contract, "=", (Object)Long.parseLong(contractId)).and("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue())});
        if (null != contractSettles && contractSettles.length > 0) {
            for (DynamicObject contractSettle : contractSettles) {
                boolean present;
                DynamicObjectCollection listEntry;
                DynamicObjectCollection listModelEntry = (contractSettle = BusinessDataServiceHelper.loadSingle((Object)contractSettle.getPkValue(), (String)formBillId)).getDynamicObjectCollection("listmodelentry");
                DynamicObject modelEntry = listModelEntry.stream().filter(entry -> listingModelId.equals(entry.getString("listmodelid"))).findFirst().orElse(null);
                if (null == modelEntry || null == (listEntry = modelEntry.getDynamicObjectCollection("listentry")) || listEntry.isEmpty() || !(present = listEntry.stream().anyMatch(entry -> entry.getDynamicObject("listing") != null && listEntryId.equals(entry.getDynamicObject("listing").getPkValue().toString())))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        if (operateKey.equals(RETURN_DATA)) {
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ContractListingListPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRowCollection returnData = new ListSelectedRowCollection();
            for (int index : selectRows) {
                ListSelectedRow returnListing = new ListSelectedRow(this.getModel().getEntryRowEntity(KEY_TREEENTRYENTITY, index).getPkValue(), Boolean.TRUE);
                returnData.add((Object)returnListing);
            }
            this.getView().returnDataToParent((Object)returnData);
            this.getView().invokeOperation(OPERATE_CLOSE);
        }
    }

    public void cellDoubleClick(CellClickEvent cellclickevent) {
    }

    protected void initList(List<QFilter> qFilters) {
        this.getModel().deleteEntryData(KEY_TREEENTRYENTITY);
        IListView view = (IListView)this.getView();
        String formId = view.getBillFormId();
        DynamicObjectCollection idList = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence,number asc");
        Object[] pkArray = idList.stream().map(dyn -> dyn.get("id")).toArray();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        DynamicObject[] listings = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)entityType);
        DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        DynamicObjectType dt = entries.getDynamicObjectType();
        HashMap<Long, TreeSet<DynamicObject>> childMap = new HashMap<Long, TreeSet<DynamicObject>>();
        TreeSet<DynamicObject> firstLevelList = new TreeSet<DynamicObject>(new TreeListingComparator());
        HashSet<Long> hasAddIds = new HashSet<Long>();
        HashMap<Long, DynamicObject> allListingMap = new HashMap<Long, DynamicObject>();
        this.addFromDbListing(formId, listings, childMap, firstLevelList, hasAddIds, allListingMap);
        this.addFromReverseListing(formId, childMap, firstLevelList, qFilters, hasAddIds, allListingMap);
        if (!firstLevelList.isEmpty()) {
            for (DynamicObject firstLevelListing : firstLevelList) {
                this.addAllChilds(entries, dt, childMap, firstLevelListing);
            }
        }
        this.getModel().updateEntryCache(entries);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        treeEntryGrid.setCollapse(false);
        this.getView().updateView(KEY_TREEENTRYENTITY);
    }

    protected void addFromDbListing(String formId, DynamicObject[] listings, HashMap<Long, TreeSet<DynamicObject>> childMap, TreeSet<DynamicObject> firstLevelList, Set<Long> hasAddIds, HashMap<Long, DynamicObject> allListingMap) {
        if (listings != null && listings.length > 0) {
            for (DynamicObject list : listings) {
                DynamicObject parent = list.getDynamicObject("parent");
                if (parent != null) {
                    TreeSet<DynamicObject> childList = childMap.get(parent.getLong("id"));
                    if (childList == null) {
                        childList = new TreeSet<DynamicObject>(new TreeListingComparator());
                        childMap.put(parent.getLong("id"), childList);
                    }
                    childList.add(list);
                } else {
                    firstLevelList.add(list);
                }
                allListingMap.put(list.getLong("id"), list);
            }
            for (DynamicObject list : listings) {
                this.completeTree(list, hasAddIds, childMap, firstLevelList, allListingMap, formId, null);
            }
        }
    }

    protected void addFromReverseListing(String formId, HashMap<Long, TreeSet<DynamicObject>> childMap, TreeSet<DynamicObject> firstLevelList, List<QFilter> qFilters, Set<Long> hasAddIds, HashMap<Long, DynamicObject> allListingMap) {
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("addlisting");
        if (customParam != null) {
            Object[] listings = DynamicObjectSerializeUtil.deserialize((String)customParam, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
            HashMap<Long, DynamicObject> reverseListingsMap = new HashMap<Long, DynamicObject>(listings.length);
            ArrayList<DynamicObject> allListings = new ArrayList<DynamicObject>(listings.length);
            for (Object list : listings) {
                DynamicObject listObject = (DynamicObject)list;
                allListings.add(listObject);
                reverseListingsMap.put(listObject.getLong("id"), listObject);
            }
            List<DynamicObject> afterFilterListings = this.filterListing(allListings, qFilters);
            for (DynamicObject listObject : afterFilterListings) {
                long parentId = listObject.getLong("parent_id");
                if (parentId != 0L) {
                    TreeSet<DynamicObject> childList = childMap.get(parentId);
                    if (childList == null) {
                        childList = new TreeSet<DynamicObject>(new TreeListingComparator());
                        childMap.put(parentId, childList);
                    }
                    childList.add(listObject);
                } else {
                    firstLevelList.add(listObject);
                }
                allListingMap.put(listObject.getLong("id"), listObject);
            }
            for (DynamicObject list : afterFilterListings) {
                this.completeTree(list, hasAddIds, childMap, firstLevelList, allListingMap, formId, reverseListingsMap);
            }
        }
    }

    protected List<DynamicObject> filterListing(List<DynamicObject> allListings, List<QFilter> qFilters) {
        boolean filter = false;
        String name = null;
        String number = null;
        for (QFilter qFilter : qFilters) {
            if (!"ftlike".equals(qFilter.getCP())) continue;
            filter = true;
            String filterString = qFilter.getValue().toString();
            String[] proAndValue = filterString.split("#");
            if (proAndValue[0].contains("name")) {
                name = proAndValue[1];
            }
            if (!proAndValue[0].contains("number")) break;
            number = proAndValue[1];
            break;
        }
        if (filter) {
            ArrayList<DynamicObject> afterFilterListings = new ArrayList<DynamicObject>();
            for (DynamicObject listing : allListings) {
                if ((name == null || !listing.getString("name").contains(name)) && (number == null || !listing.getString("number").contains(number))) continue;
                afterFilterListings.add(listing);
            }
            return afterFilterListings;
        }
        return allListings;
    }

    protected void completeTree(DynamicObject list, Set<Long> hasAddIds, HashMap<Long, TreeSet<DynamicObject>> childMap, TreeSet<DynamicObject> firstLevelList, HashMap<Long, DynamicObject> allListingMap, String formId, Map<Long, DynamicObject> reverseListingsMap) {
        boolean isAdded = hasAddIds.contains(list.getLong("id"));
        if (!isAdded) {
            long parentId = list.getLong("parent_id");
            DynamicObject listing = allListingMap.get(list.getLong("id"));
            if (parentId != 0L) {
                DynamicObject parentObject;
                if (listing == null) {
                    TreeSet<DynamicObject> childList = childMap.get(parentId);
                    if (childList == null) {
                        childList = new TreeSet<DynamicObject>(new TreeListingComparator());
                        childMap.put(parentId, childList);
                    }
                    childList.add(list);
                    allListingMap.put(list.getLong("id"), list);
                }
                if ((parentObject = allListingMap.get(parentId)) == null && reverseListingsMap != null) {
                    parentObject = reverseListingsMap.get(parentId);
                }
                if (parentObject == null) {
                    parentObject = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)formId);
                }
                this.completeTree(parentObject, hasAddIds, childMap, firstLevelList, allListingMap, formId, reverseListingsMap);
            } else if (listing == null) {
                firstLevelList.add(list);
                allListingMap.put(list.getLong("id"), list);
            }
            hasAddIds.add(list.getLong("id"));
        }
    }

    protected void addAllChilds(DynamicObjectCollection entries, DynamicObjectType dt, HashMap<Long, TreeSet<DynamicObject>> childMap, DynamicObject listing) {
        entries.add((Object)this.convertToTreeEntryEntity(dt, listing));
        TreeSet<DynamicObject> childList = childMap.get(listing.getLong("id"));
        if (childList != null) {
            for (DynamicObject child : childList) {
                this.addAllChilds(entries, dt, childMap, child);
            }
        }
    }

    protected DynamicObject convertToTreeEntryEntity(DynamicObjectType dt, DynamicObject list) {
        DynamicObject newItem = new DynamicObject(dt);
        DataEntityPropertyCollection properties = dt.getProperties();
        DataEntityPropertyCollection listProperties = list.getDynamicObjectType().getProperties();
        Map listMap = listProperties.stream().collect(Collectors.toMap(IMetadata::getName, Function.identity(), (key1, key2) -> key2));
        ArrayList<String> excludeProperties = new ArrayList<String>(16);
        excludeProperties.add("id");
        excludeProperties.add("number");
        excludeProperties.add("pid");
        excludeProperties.add("name");
        excludeProperties.add("currency");
        excludeProperties.add("material");
        excludeProperties.add("materialname");
        excludeProperties.add("materialmodelnum");
        excludeProperties.add("isleaf");
        excludeProperties.add("measureunit");
        excludeProperties.add("qty");
        excludeProperties.add("oftaxprice");
        excludeProperties.add("taxrate");
        excludeProperties.add("price");
        excludeProperties.add("oftaxamt");
        excludeProperties.add("amt");
        excludeProperties.add("taxamt");
        excludeProperties.add("desc");
        newItem.set("id", list.getPkValue());
        newItem.set("number", list.get("number"));
        newItem.set("pid", (Object)list.getLong("parent_id"));
        newItem.set("name", (Object)list.getLocaleString("name").getLocaleValue());
        newItem.set("isleaf", list.get("isleaf"));
        DynamicObject currency = list.getDynamicObject("currency");
        if (list.get("currency") != null) {
            newItem.set("currency", (Object)currency);
        }
        if (list.get("material") != null) {
            newItem.set("material", (Object)list.getDynamicObject("material"));
            newItem.set("materialname", (Object)list.getDynamicObject("material").getLocaleString("name").getLocaleValue());
            newItem.set("materialmodelnum", (Object)list.getDynamicObject("material").getLocaleString("modelnum").getLocaleValue());
        }
        boolean isLeaf = list.getBoolean("isleaf");
        BigDecimal taxRate = (BigDecimal)list.get("taxrate");
        if (isLeaf) {
            if (list.get("measureunit") != null) {
                newItem.set("measureunit", (Object)list.getDynamicObject("measureunit"));
            }
            newItem.set("qty", list.get("totalqty"));
            BigDecimal curTaxPrice = (BigDecimal)list.get("curtaxprice");
            newItem.set("oftaxprice", (Object)curTaxPrice);
            newItem.set("taxrate", (Object)taxRate);
            int pricePrecision = currency != null ? currency.getInt("priceprecision") : 10;
            BigDecimal price = NumberHelper.divide((Object)curTaxPrice, (Object)BigDecimal.ONE.add(taxRate.divide(EcConstant.ONE_HUNDRED)), (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
            newItem.set("price", (Object)price);
        }
        BigDecimal lstOfTaxAmount = list.getBigDecimal("lstoftaxamount");
        newItem.set("oftaxamt", (Object)lstOfTaxAmount);
        int amtPrecision = currency != null ? currency.getInt("amtprecision") : 10;
        BigDecimal amount = list.getBigDecimal("latestamount");
        newItem.set("amt", (Object)amount);
        newItem.set("taxamt", (Object)lstOfTaxAmount.subtract(amount).setScale(amtPrecision, RoundingMode.HALF_UP));
        newItem.set("desc", list.get("desc"));
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (excludeProperties.contains(name) || !listMap.containsKey(name)) continue;
            newItem.set(name, list.get(name));
        }
        return newItem;
    }
}

