/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ContractSignEditPlugin
extends AbstractPmctBillPlugin
implements ClickListener {
    public static final String PARTAPERSON = "partaperson";
    public static final String PARTBPERSON = "partbperson";
    public static final String PARTOTHERPERSON = "partotherperson";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PARTAPERSON, PARTBPERSON, PARTOTHERPERSON});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object contractId = this.getView().getFormShowParameter().getCustomParam("contractId");
        String contStatus = (String)this.getView().getFormShowParameter().getCustomParam("contractstatus");
        Object signdate = this.getView().getFormShowParameter().getCustomParam("signdate");
        Boolean isMultiContract = (Boolean)this.getView().getFormShowParameter().getCustomParam("ismulticontract");
        QFilter contFilter = new QFilter("contract", "=", (Object)Long.parseLong(String.valueOf(contractId)));
        String selectedProperties = "partaperson, partaphone, partbperson, partbphone, partotherperson, partotherphone, signdate, signaddress, signaddressdetail, contract";
        DynamicObject[] contractSigns = BusinessDataServiceHelper.load((String)"pmct_contsign", (String)selectedProperties, (QFilter[])new QFilter[]{contFilter});
        if (isMultiContract == null) {
            isMultiContract = false;
        }
        if (isMultiContract.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PARTOTHERPERSON, "partotherphone"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{PARTOTHERPERSON, "partotherphone"});
        }
        if (contractSigns != null && contractSigns.length > 0 && StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.RUNNING.getValue())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnflexpanel"});
        } else if (contractSigns == null || contractSigns.length == 0) {
            this.getModel().setValue("contract", contractId);
            if (signdate != null) {
                this.getModel().setValue("signdate", signdate);
            } else {
                Date currentDate = new Date();
                this.getModel().setValue("signdate", (Object)currentDate);
            }
        } else if (signdate != null) {
            this.getModel().setValue("signdate", signdate);
        } else {
            Date currentDate = new Date();
            this.getModel().setValue("signdate", (Object)currentDate);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            if (StringUtils.equals((CharSequence)"docancel", (CharSequence)operateKey)) {
                this.getView().invokeOperation("close");
            } else if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
                this.getView().returnDataToParent((Object)"okbtn");
                this.getView().invokeOperation("close");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        TextEdit textEdit = (TextEdit)evt.getSource();
        String personProp = textEdit.getKey();
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)false);
        Object contractId = this.getView().getFormShowParameter().getCustomParam("contractId");
        if (contractId != null && QueryServiceHelper.exists((String)"pmct_contracttpl", (Object)contractId)) {
            QFilter qFilter;
            List qFilters = para.getListFilterParameter().getQFilters();
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_contracttpl");
            long projectId = 0L;
            DynamicObject project = contract.getDynamicObject("project");
            if (project != null) {
                projectId = Long.parseLong(project.getPkValue().toString());
            }
            if ((qFilter = UserOrgRangeHelper.loadUserOrgRanges((Long)RequestContext.get().getCurrUserId(), (Long)projectId)) != null) {
                qFilters.add(qFilter);
            }
        }
        para.setCustomParam("person", (Object)personProp);
        para.setShowQuickFilter(true);
        para.setF7Style(3);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, String.format("%s_callback", personProp));
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)para);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (returnData == null || returnData.isEmpty()) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRow row = returnData.get(0);
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bos_user");
        Object phone = user.get("phone");
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"partaperson_callback")) {
            this.getModel().setValue(PARTAPERSON, (Object)row.getName());
            this.getModel().setValue("partaphone", phone);
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"partbperson_callback")) {
            this.getModel().setValue(PARTBPERSON, (Object)row.getName());
            this.getModel().setValue("partbphone", phone);
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"partotherperson_callback")) {
            this.getModel().setValue(PARTOTHERPERSON, (Object)row.getName());
            this.getModel().setValue("partotherphone", phone);
        }
    }
}

