/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import org.apache.commons.compress.utils.Lists;

public class InContractBotpConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] billList = targetExtDataEntitySet.FindByEntityKey(this.getTgtMainType().toString());
        ArrayList dataEntities = Lists.newArrayList();
        for (ExtendedDataEntity entity : billList) {
            DynamicObject bill = entity.getDataEntity();
            bill.set("billno", (Object)this.generateBillNo(bill));
            dataEntities.add(bill);
        }
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"OBBotpConvertServiceImpl", (String)"originalBillsBotpConvert", (Object[])new Object[]{dataEntities});
        for (DynamicObject bill : dataEntities) {
            String billNo = bill.getString("billno");
            DynamicObject dataEntityNew = (DynamicObject)map.get(billNo);
            bill.set("buyername", dataEntityNew.get("buyername"));
            bill.set("buyertaxno", dataEntityNew.get("buyertaxno"));
            bill.set("buyerbank", dataEntityNew.get("buyerbank"));
            bill.set("buyeraddr", dataEntityNew.get("buyeraddr"));
            bill.set("buyerphone", dataEntityNew.get("buyerphone"));
            bill.set("buyeremail", dataEntityNew.get("buyeremail"));
            bill.set("salername", dataEntityNew.get("salername"));
            bill.set("salertaxno", dataEntityNew.get("salertaxno"));
            bill.set("salerbank", dataEntityNew.get("salerbank"));
            bill.set("saleraddr", dataEntityNew.get("saleraddr"));
            bill.set("drawer", dataEntityNew.get("drawer"));
            bill.set("payee", dataEntityNew.get("payee"));
            bill.set("reviewer", dataEntityNew.get("reviewer"));
            bill.set("specialtype", dataEntityNew.get("specialtype"));
            bill.set("jqbh", dataEntityNew.get("jqbh"));
            Date billDate = dataEntityNew.getDate("billdate");
            if (billDate == null) {
                billDate = new Date();
            }
            bill.set("billdate", (Object)billDate);
        }
    }

    public String generateBillNo(DynamicObject dataEntity) {
        String billNo = dataEntity.getString("billno");
        boolean isExistCodeRule = false;
        DynamicObject org = dataEntity.getDynamicObject("orgid");
        if (org != null) {
            isExistCodeRule = CodeRuleServiceHelper.isExist((String)"sim_original_bill", (DynamicObject)dataEntity, (String)org.getPkValue().toString());
            billNo = "";
        }
        if (!isExistCodeRule) {
            billNo = this.getBillNextNo(dataEntity, billNo);
        }
        return billNo;
    }

    public String getBillNextNo(DynamicObject dataEntity, String billNo) {
        if (StringUtils.isBlank((CharSequence)billNo)) {
            billNo = "INV";
        }
        QFilter billNoFilter = new QFilter("billno", "like", (Object)(billNo + "%"));
        QFilter orgIdFilter = new QFilter("orgid", "=", dataEntity.getDynamicObject("orgid").getPkValue());
        DynamicObject[] billNoArr = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"", (QFilter[])new QFilter[]{billNoFilter, orgIdFilter});
        String nextBillNo = String.format("%s_%s", billNo, billNoArr.length + 1);
        return nextBillNo;
    }
}

