/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.business.helper.InvoiceImportHelper;
import kd.pmgt.pmbs.business.invoicecloud.InvoiceVO;
import kd.pmgt.pmbs.common.enums.InvoiceInterfaceEnum;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmbs.common.utils.invoicecloud.InvoiceCloudConfigHelper;

public class InInvoiceBillImportPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String InterfaceVO = "invoiceinterface";
    private static final String CompanyId = "companyid";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long orgId = RequestContext.get().getOrgId();
        Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (mapOrg != null && !mapOrg.isEmpty() && mapOrg.get("id") != null) {
            this.getModel().setValue("accountorg", mapOrg.get("id"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accountOrg = (BasedataEdit)this.getControl("accountorg");
        accountOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if ("accountorg".equals(key)) {
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            Map permItem = ProjectPermissionHelper.getPermObj((String)"pmct_ininvoice", (String)"importinvoice");
            List hashPermOrgUnits = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(RequestContext.get().getCurrUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)"pmct_ininvoice", (String)String.valueOf(permItem.get("id")));
            if (hashPermOrgUnits.size() == 0) {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            } else {
                ArrayList accountPermOrgs = new ArrayList(16);
                hashPermOrgUnits.forEach(orgId -> {
                    Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                    if (mapOrg != null && !mapOrg.isEmpty() && mapOrg.get("id") != null) {
                        accountPermOrgs.add(Long.parseLong(mapOrg.get("id").toString()));
                    }
                });
                if (accountPermOrgs.size() > 0) {
                    String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"orgseparate");
                    List accountOrgs = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, accountPermOrgs, (String)"10");
                    if (accountOrgs.size() == 0) {
                        qFilters.add(new QFilter("id", "=", (Object)0L));
                    } else {
                        List allOrgIds = OrgTreeUtils.getParentByOrgIds((List)accountOrgs, (String)"10");
                        if (allOrgIds.size() > 0) {
                            qFilters.add(new QFilter("id", "in", (Object)allOrgIds));
                        }
                    }
                } else {
                    qFilters.add(new QFilter("id", "=", (Object)0L));
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("importinvoice".equals(operateKey)) {
            DynamicObject accountOrg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountOrg == null) {
                return;
            }
            this.getPageCache().put(CompanyId, accountOrg.getPkValue().toString());
            String invoiceInterface = SystemParamHelper.getSystemParameter((String)InterfaceVO, (String)"pmct", (Long)Long.parseLong(accountOrg.getPkValue().toString())).toString();
            this.getPageCache().put(InterfaceVO, invoiceInterface);
            if (InvoiceInterfaceEnum.AWS.getValue().equals(invoiceInterface)) {
                this.openAWSInvoicePage();
            } else {
                this.openInvoiceCloudPage();
            }
        }
    }

    private void openAWSInvoicePage() {
        HashMap<String, Object> data = new HashMap<String, Object>(10);
        data.put("formId", "pmbs_invoicecloudpage");
        data.put("companyId", this.getPageCache().get(CompanyId));
        data.put("billNo", Character.valueOf('0'));
        data.put("billId", "0");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(data);
        StyleCss css = new StyleCss();
        css.setHeight("600px");
        css.setWidth("968px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmbs_invoicecloudpage"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(data);
        this.getView().showForm(showParameter);
    }

    private void openInvoiceCloudPage() {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("billType", "pmct_ininvoice");
        customParams.put("entityId", "pmct_ininvoice");
        customParams.put("billNo", "0");
        customParams.put("billId", "0");
        customParams.put("viewPage", this.getView().getPageId());
        String orgId = this.getPageCache().get(CompanyId);
        if (StringUtils.isNotEmpty((CharSequence)orgId) && QueryServiceHelper.exists((String)"bos_org", (Object)orgId)) {
            customParams.put("orgId", orgId);
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            if (org != null) {
                List companyInfo = InvoiceCloudConfigHelper.getConfigByInvoiceCloud((DynamicObject)org);
                customParams.put("companyInfo", companyInfo);
            }
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("rim_fpzs_main");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_fpzs_main");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        Object returnData = callBackEvent.getReturnData();
        if (returnData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a\u3002", (String)"InInvoiceBillImportPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        paramsMap.put(InterfaceVO, this.getPageCache().get(InterfaceVO));
        paramsMap.put(CompanyId, this.getPageCache().get(CompanyId));
        paramsMap.put("returnData", returnData);
        List invoiceVOS = new InvoiceImportHelper().analysisInvoiceData(paramsMap);
        this.processInvoiceVO(invoiceVOS);
    }

    public void processInvoiceVO(List<InvoiceVO> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        List invoiceVOS = new InvoiceImportHelper().checkInvoice(list, this.getView());
        DynamicObject[] invoiceList = new InvoiceImportHelper().syncIntoInvoicePool(invoiceVOS, this.getPageCache().get(CompanyId));
        if (invoiceList != null && invoiceList.length > 0) {
            DynamicObject[] invoices = new DynamicObject[invoiceList.length];
            for (int i = 0; i < invoiceList.length; ++i) {
                DynamicObject invoice = invoiceList[i];
                invoices[i] = invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_ininvoice");
            }
            new InvoiceImportHelper().doAuditInvoice(invoices);
            for (DynamicObject inInvoice : invoices) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                QFilter qFilter = new QFilter("billno", "=", (Object)inInvoice.getString("billno"));
                inInvoice = BusinessDataServiceHelper.loadSingle((String)"pmct_ininvoice", (String)String.join((CharSequence)",", "serialno", "billno"), (QFilter[])new QFilter[]{qFilter});
                map.put("billId", inInvoice.getPkValue().toString());
                map.put("billNo", inInvoice.getString("billno"));
                map.put("billType", "pmct_ininvoice");
                map.put("entityId", "pmct_ininvoice");
                map.put("appId", "pmct");
                ArrayList invoiceListMap = new ArrayList(16);
                HashMap<String, String> invoiceMap = new HashMap<String, String>(16);
                invoiceMap.put("serialNo", inInvoice.getString("serialno"));
                invoiceListMap.add(invoiceMap);
                map.put("invoiceData", invoiceListMap);
                JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"save", (Object[])new Object[]{map});
                if ("0000".equals(result.getString("errcode"))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u7968\u4e91\u53d1\u7968\u4e1a\u52a1\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"InInvoiceBillImportPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), result.getString("description")));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5bfc\u5165\u6210\u529f\u3002", (String)"InInvoiceBillImportPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }
}

