/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.formplugin.invoicecloud.AbstractImportInvoicePlugin;

public class InvoiceImportPlugin
extends AbstractImportInvoicePlugin {
    private static final Log log = LogFactory.getLog(InvoiceImportPlugin.class);
    private static final String IMPORT_INVOICE_OPERATE = "importinvoice";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String billFormId = ((ListView)this.getView()).getBillFormId();
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)IMPORT_INVOICE_OPERATE)) {
            if (selectedRows != null && selectedRows.size() == 1) {
                String contractId = selectedRows.get(0).getPrimaryKeyValue().toString();
                DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_outcontract");
                String contStatus = contract.getDynamicObject("contractstatus").getString("number");
                if (StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INDRAFT.getValue()) || StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INAUDIT.getValue()) || StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.APPROVED.getValue())) {
                    String tipMsg = String.format(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a\uff1a%1$s\uff0c\u4e0d\u80fd\u5bfc\u5165\u53d1\u7968\u3002", (String)"InvoiceImportPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ContractStatusEnum.getEnumByValue((Object)contStatus).getName());
                    this.getView().showErrorNotification(tipMsg);
                    args.setCancel(true);
                    return;
                }
                this.getPageCache().put("billid", contractId);
                this.getPageCache().put("curformid", billFormId);
                this.showSelectedInvoicePage();
            }
            if (selectedRows != null && selectedRows.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u5408\u540c\u8fdb\u884c\u53d1\u7968\u5bfc\u5165\u64cd\u4f5c\u3002", (String)"InvoiceImportPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    protected String getCloseCallBackKey() {
        return IMPORT_INVOICE_OPERATE;
    }
}

