/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.business.helper.SerializeHelper;
import kd.pmgt.pmbs.common.enums.AgreementAdapteScopeEnum;
import kd.pmgt.pmbs.common.enums.AgreementStatusEnum;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.ContractPayItemSourceEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.StringUtils;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.common.utils.ContractSupplierHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class OutContractEditPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener {
    private static final String CONTPAYPLANENTRY = "outcontpayplanentry";
    private static final String ADVCONAP = "advconap1";
    private static final String RISKPANEL = "risk_panel";
    private static final String BTN_DEL_COMP1 = "delcomp1";
    private static final String BTN_DEL_COMP2 = "delcomp2";
    private static final String CALLBACKDELETEPAYPLANENTRY = "deletepayplanentry";
    private static final String CALLBACKBIDRESULT = "bidresult";
    private static final String LOAD_PLAN_ENTRY_COMP = "loadplanentrycomp";
    private static final String LOAD_RISK_ITEM_COMP = "loadriskitem";
    private static final String CONTRISKENTRY = "riskentry";
    private static final String VIEWSTYLE = "viewStyle";
    private static final String CONTRACTSTATUS = "contractstatus";
    private static final String REFRESH_FLAG = "refreshflag";
    private static Log logger = LogFactory.getLog(OutContractEditPlugin.class);
    private static final String CTRL_NEWENTRY = "newentry";
    private static final String CTRL_DELETEENTRY = "deleteentry";
    private static final String SUBMIT = "submit";
    private static final String UNSUBMIT = "unsubmit";
    private static final String UNAUDIT = "unaudit";
    private static final String ATTACHMENTPANEL = "attachmentpanel";
    private static final String TEXTATTACHMENTPANEL = "textattachmentpanel";
    private static final String LASTATTACHMENTPANEL = "lastattachmentpanel";
    private static final String LASTTEXTATTACHMENTPANEL = "lasttextattachmentpanel";
    private static final String FILEFLEX = "fileflex";
    private static final String LASTFILEFLEX = "lastfileflex";
    private static final String ADJUST = "adjust";

    public void afterBindData(EventObject e) {
        DynamicObject org;
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String viewStyle = (String)formShowParameter.getCustomParam(VIEWSTYLE);
        boolean ifExist = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        DynamicObject contractStatus = this.getModel().getDataEntity().getDynamicObject(CONTRACTSTATUS);
        if (ifExist && contractStatus != null) {
            String contStatus = this.getModel().getDataEntity().getDynamicObject(CONTRACTSTATUS).getString("number");
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)viewStyle) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INDRAFT.getValue()) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INAUDIT.getValue()) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.APPROVED.getValue())) {
                this.gainOriginalContract();
                ContractPayItemHelper.setBillNameInPayPlanEntry((IDataModel)this.getModel());
                this.getView().setVisible(Boolean.FALSE, new String[]{LASTFILEFLEX});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tbviewoldcontract"});
            } else {
                this.gainLastNewContract();
                this.loadLastAttachment();
                this.getView().setVisible(Boolean.TRUE, new String[]{"tbviewoldcontract"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"isadjustamount", "isenteramount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{FILEFLEX});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{LASTFILEFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbviewoldcontract"});
        }
        int riskEntryCount = this.getModel().getEntryRowCount(CONTRISKENTRY);
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)StatusEnum.TEMPSAVE.getValue(), (CharSequence)billStatus)) {
            this.getView().setVisible(Boolean.valueOf(riskEntryCount > 0), new String[]{RISKPANEL, BTN_DEL_COMP2});
            this.getView().setVisible(Boolean.valueOf(riskEntryCount == 0), new String[]{LOAD_RISK_ITEM_COMP});
        } else {
            this.getView().setVisible(Boolean.valueOf(riskEntryCount > 0), new String[]{RISKPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{LOAD_RISK_ITEM_COMP, BTN_DEL_COMP2});
        }
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            return;
        }
        if (this.isOpenAccountOrgNullCheck() && (org = (DynamicObject)this.getModel().getValue(this.getAccountingOrg())) != null) {
            Map bizOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)Long.valueOf(org.getPkValue().toString()), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            logger.error("orgName={},ID={},bizOrg={}\u3002", new Object[]{org.getLocaleString("name"), org.getPkValue(), bizOrg});
            if (bizOrg == null || bizOrg.isEmpty()) {
                logger.error("orgName={},ID={} is Empty\u3002", (Object)org.getLocaleString("name"), org.getPkValue());
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\uff1a%s\uff0c\u6240\u5c5e\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"OutContractEditPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), org.getLocaleString("name")));
            } else {
                this.getModel().setValue("fiaccountorg", bizOrg.get("id"));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.VIEW)) {
            e.setCheckDataChange(false);
            return;
        }
        DynamicObjectCollection outContPayPlanEntry = this.getModel().getEntryEntity(CONTPAYPLANENTRY);
        DynamicProperty payItemNameProp = outContPayPlanEntry.getDynamicObjectType().getProperty("payitemname");
        for (DynamicObject payPlan : outContPayPlanEntry) {
            payPlan.getDataEntityState().setBizChanged(payItemNameProp.getOrdinal(), Boolean.FALSE.booleanValue());
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection payPlanEntrys = this.getModel().getEntryEntity(CONTPAYPLANENTRY);
        Map completeMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])((DynamicObject[])payPlanEntrys.toArray((Object[])new DynamicObject[payPlanEntrys.size()])));
        Map mapData = (Map)completeMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject payPlanEntry : payPlanEntrys) {
            DynamicObject nodeSetting = payPlanEntry.getDynamicObject("nodesetting");
            if (null == nodeSetting) continue;
            payPlanEntry.set("taskcompletestate", mapData.get(nodeSetting.getPkValue()));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "newentry": {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(CONTPAYPLANENTRY);
                int rowIndex = entrys.size() - 1;
                DynamicObject partB = (DynamicObject)this.getModel().getValue("partb");
                if (partB != null) {
                    this.getModel().setValue("supplier", (Object)partB, rowIndex);
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                ContractPayItemHelper.setBillNameInPayPlanEntry((IDataModel)this.getModel());
                break;
            }
        }
    }

    protected boolean isOpenAccountOrgNullCheck() {
        return true;
    }

    private void gainLastNewContract() {
        this.loadListModelEntryData();
        this.loadLastOutContPlanEntry();
        this.loadLastRiskEntry(Long.parseLong(this.getModel().getValue("id").toString()));
    }

    private void loadLastAttachment() {
        String refresh = this.getPageCache().get(REFRESH_FLAG);
        if (refresh == null) {
            String cacheJsonString;
            String cacheKey;
            DynamicObject[] outContractAddAgreements;
            DynamicObject[] outContractRevisions;
            List attachments;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            ArrayList newAttachments = new ArrayList(10);
            ArrayList newTextAttachments = new ArrayList(10);
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            statusFilter.and(new QFilter("contract", "=", dataEntity.getPkValue()));
            DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)String.join((CharSequence)",", "billno", "auditdate"), (QFilter[])new QFilter[]{statusFilter}, (String)"auditdate desc");
            if (contractRevisions != null && contractRevisions.length > 0) {
                DynamicObject[] textAttachments;
                DynamicObject contractRevision = contractRevisions[0];
                attachments = AttachmentServiceHelper.getAttachments((String)"pmct_contractrevision", (Object)contractRevision.getPkValue(), (String)ATTACHMENTPANEL);
                if (attachments != null && attachments.size() > 0) {
                    FileAttachmentHelper.setAttachmentUrl((List)attachments);
                    newAttachments.addAll(attachments);
                }
                if ((textAttachments = AttachmentServiceHelper.getAttachments((String)"pmct_contractrevision", (Object)contractRevision.getPkValue(), (String)TEXTATTACHMENTPANEL)) != null && textAttachments.size() > 0) {
                    FileAttachmentHelper.setAttachmentUrl((List)textAttachments);
                    newTextAttachments.addAll(textAttachments);
                }
            } else {
                List textAttachments;
                List attachments2 = AttachmentServiceHelper.getAttachments((String)"pmct_outcontract", (Object)dataEntity.getPkValue(), (String)ATTACHMENTPANEL);
                if (attachments2 != null && attachments2.size() > 0) {
                    FileAttachmentHelper.setAttachmentUrl((List)attachments2);
                    newAttachments.addAll(attachments2);
                }
                if ((textAttachments = AttachmentServiceHelper.getAttachments((String)"pmct_outcontract", (Object)dataEntity.getPkValue(), (String)TEXTATTACHMENTPANEL)) != null && textAttachments.size() > 0) {
                    FileAttachmentHelper.setAttachmentUrl((List)textAttachments);
                    newTextAttachments.addAll(textAttachments);
                }
            }
            DynamicObject contractSign = BusinessDataServiceHelper.loadSingle((String)"pmct_contsign", (String)"id", (QFilter[])new QFilter[]{new QFilter("contract", "=", dataEntity.getPkValue())});
            if (contractSign != null && (attachments = AttachmentServiceHelper.getAttachments((String)"pmct_contsign", (Object)contractSign.getPkValue(), (String)ATTACHMENTPANEL)) != null && attachments.size() > 0) {
                FileAttachmentHelper.setAttachmentUrl((List)attachments);
                newAttachments.addAll(attachments);
            }
            if ((outContractRevisions = BusinessDataServiceHelper.load((String)"pmct_outcontractrevision", (String)String.join((CharSequence)",", "billno", "auditdate"), (QFilter[])new QFilter[]{statusFilter}, (String)"auditdate desc")) != null && outContractRevisions.length > 0) {
                for (DynamicObject outContractRevision : outContractRevisions) {
                    List attachments3 = AttachmentServiceHelper.getAttachments((String)"pmct_outcontractrevision", (Object)outContractRevision.getPkValue(), (String)ATTACHMENTPANEL);
                    if (attachments3 == null || attachments3.size() <= 0) continue;
                    FileAttachmentHelper.setAttachmentUrl((List)attachments3);
                    newAttachments.addAll(attachments3);
                }
            }
            if ((outContractAddAgreements = BusinessDataServiceHelper.load((String)"pmct_outaddagreement", (String)String.join((CharSequence)",", "billno", "auditdate"), (QFilter[])new QFilter[]{statusFilter}, (String)"auditdate desc")) != null && outContractAddAgreements.length > 0) {
                for (DynamicObject outContractAddAgreement : outContractAddAgreements) {
                    List textAttachments;
                    List attachments4 = AttachmentServiceHelper.getAttachments((String)"pmct_outaddagreement", (Object)outContractAddAgreement.getPkValue(), (String)ATTACHMENTPANEL);
                    if (attachments4 != null && attachments4.size() > 0) {
                        FileAttachmentHelper.setAttachmentUrl((List)attachments4);
                        newAttachments.addAll(attachments4);
                    }
                    if ((textAttachments = AttachmentServiceHelper.getAttachments((String)"pmct_outaddagreement", (Object)outContractAddAgreement.getPkValue(), (String)TEXTATTACHMENTPANEL)) == null || textAttachments.size() <= 0) continue;
                    FileAttachmentHelper.setAttachmentUrl((List)textAttachments);
                    newTextAttachments.addAll(textAttachments);
                }
            }
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            HashMap attachmentInfo = new HashMap();
            if (newAttachments.size() > 0) {
                AttachmentPanel panel = (AttachmentPanel)this.getControl(LASTATTACHMENTPANEL);
                cacheKey = "TampAttCache" + this.getView().getPageId();
                attachmentInfo.put(LASTATTACHMENTPANEL, newAttachments);
                cacheJsonString = SerializationUtils.toJsonString(attachmentInfo);
                cache.put(cacheKey, cacheJsonString);
                panel.bindData(newAttachments);
                this.getView().updateView(LASTATTACHMENTPANEL);
            }
            if (newTextAttachments.size() > 0) {
                AttachmentPanel textPanel = (AttachmentPanel)this.getControl(LASTTEXTATTACHMENTPANEL);
                cacheKey = "TampAttCache" + this.getView().getPageId();
                attachmentInfo.put(LASTTEXTATTACHMENTPANEL, newTextAttachments);
                cacheJsonString = SerializationUtils.toJsonString(attachmentInfo);
                cache.put(cacheKey, cacheJsonString);
                textPanel.bindData(newTextAttachments);
                this.getView().updateView(LASTTEXTATTACHMENTPANEL);
            }
        }
    }

    private void loadLastRiskEntry(Long contractPk) {
        QFilter contFilter = new QFilter("contract", "=", (Object)contractPk).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{contFilter}, (String)"versionnumber desc");
        if (contractRevisions != null && contractRevisions.length > 0) {
            HashMap<String, DynamicObject> revisionMap = new HashMap<String, DynamicObject>();
            Object[] revisionIds = Arrays.stream(contractRevisions).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            for (DynamicObject contractRevision : contractRevisions = BusinessDataServiceHelper.load((Object[])revisionIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractrevision"))) {
                String conPkValue = contractRevision.getDynamicObject("contract").getPkValue().toString();
                DynamicObject lastRevision = (DynamicObject)revisionMap.get(conPkValue);
                if (lastRevision == null) {
                    revisionMap.put(conPkValue, contractRevision);
                    continue;
                }
                BigDecimal lastVersion = lastRevision.getBigDecimal("versionnumber");
                BigDecimal curVersion = contractRevision.getBigDecimal("versionnumber");
                if (curVersion.compareTo(lastVersion) <= 0) continue;
                revisionMap.put(conPkValue, contractRevision);
            }
            Set revisionEntrySet = revisionMap.entrySet();
            for (Map.Entry revisionEntry : revisionEntrySet) {
                DynamicObject contractRevision;
                contractRevision = (DynamicObject)revisionEntry.getValue();
                this.loadRiskEntry(contractRevision);
            }
        }
    }

    private void loadLastOutContPlanEntry() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(CONTPAYPLANENTRY);
        QFilter contFilter = new QFilter("contract", "=", this.getModel().getValue("id")).and("source", "=", (Object)ContractPayItemSourceEnum.PAYPLAN);
        DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{contFilter}, (String)"createtime asc");
        if (null != contractPayItems && contractPayItems.length > 0) {
            entries.clear();
            List payItemIds = Arrays.stream(contractPayItems).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem");
            for (DynamicObject contractPayItem : contractPayItems = BusinessDataServiceHelper.load((Object[])payItemIds.toArray(), (DynamicObjectType)dt)) {
                boolean autogenerated = contractPayItem.getBoolean("autogenerated");
                if (autogenerated) continue;
                DynamicObject item = entries.addNew();
                item.set("supplier", contractPayItem.get("supplier"));
                item.set("payway", contractPayItem.get("payway"));
                item.set("paytype", contractPayItem.get("paytype"));
                item.set("paymethod", contractPayItem.get("payfeq"));
                item.set("paypercent", contractPayItem.get("paypercent"));
                item.set("payamount", contractPayItem.get("payamount"));
                item.set("planpaytime", contractPayItem.get("planpaytime"));
                item.set("remarks", contractPayItem.get("remarks"));
                item.set("nodesettingsource", contractPayItem.get("nodesettingsource"));
                item.set("ctrlstrategy", contractPayItem.get("ctrlstrategy"));
                item.set("conplanitemid", (Object)contractPayItem.getPkValue().toString());
                String payItemName = contractPayItem.getLocaleString("name").getLocaleValue();
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)payItemName)) {
                    payItemName = contractPayItem.getString("name");
                }
                item.set("payitemname", (Object)payItemName);
                DynamicObject nodeSetting = contractPayItem.getDynamicObject("nodesetting");
                item.set("nodesetting", (Object)nodeSetting);
                if (null == nodeSetting) continue;
                nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = nodeSetting.getString("completionstatus");
                String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                item.set("taskcompletestate", (Object)status);
            }
        }
        this.getModel().updateEntryCache(entries);
        this.getView().updateView(CONTPAYPLANENTRY);
    }

    private void gainOriginalContract() {
        QFilter contFilter = new QFilter("contract", "=", this.getModel().getValue("id")).and("versionnumber", "=", (Object)1);
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{contFilter});
        if (contractRevisions != null && contractRevisions.length == 1) {
            String contractRevisionId = contractRevisions[0].getPkValue().toString();
            DynamicObject contractRevision = BusinessDataServiceHelper.loadSingle((Object)contractRevisionId, (String)"pmct_contractrevision");
            this.loadHeadData(contractRevision);
            this.loadRiskEntry(contractRevision);
            this.loadOutContPlanEntry(contractRevision);
        }
        ContractPayItemHelper.setBillNameInPayPlanEntry((IDataModel)this.getModel());
    }

    private void loadHeadData(DynamicObject contractRevision) {
        String contractName = contractRevision.getString("contractname");
        BigDecimal payRate = contractRevision.get("payrate") == null ? BigDecimal.ZERO : contractRevision.getBigDecimal("payrate");
        this.getModel().setValue("billname", (Object)contractName);
        this.getModel().setValue("payrate", (Object)payRate);
        Boolean percentModel = contractRevision.getBoolean("outpercentmodel");
        this.getModel().setValue("percentmodel", (Object)percentModel);
    }

    private void loadListModelEntryData() {
        int pricePrecision;
        IDataModel model = this.getModel();
        DynamicObjectCollection listModelEntry = this.getModel().getEntryEntity("listmodelentry");
        ContractEditHelper.setNewListModel((Object)this.getModel().getDataEntity().getPkValue(), (DynamicObjectCollection)listModelEntry);
        Boolean isOnList = (Boolean)model.getValue("isonlist");
        Boolean isMultiRate = (Boolean)model.getValue("ismultirate");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int amtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        int n = pricePrecision = currency == null ? 10 : currency.getInt("priceprecision");
        if (listModelEntry.size() > 0 && isOnList.booleanValue()) {
            BigDecimal originalAmount;
            BigDecimal originalOfTaxAmount = BigDecimal.ZERO;
            BigDecimal taxAmount = BigDecimal.ZERO;
            DynamicObjectType sublistDy = this.getModel().getEntryEntity("sublistentry").getDynamicObjectType();
            for (DynamicObject listModel : listModelEntry) {
                String cmpType;
                DynamicObjectCollection sublistEntries = new DynamicObjectCollection(sublistDy, (Object)listModel);
                String listModelId = listModel.getString("listmodelid");
                String allProperty = "modifier, createtime, modifytime, number, name, status, creator, enable, masterid, level, longnumber, fullname, isleaf, parent, sysnumber, measureunit, qty, taxprice, taxrate, rateobj, amount, price, tax, oftax, desc, lstsettleqty, lstsettleoftaxamount, changeqty, chgeffectqty, chgoftaxamount, totalqty, curtaxprice, lstoftaxamount, avgtaxprice, ischanged, isaddnew, material, sequence, entryid, currency, listparentid, listingmodel, contractid, paydirection,listingbudgetitem,latestamount";
                QFilter contFilter = new QFilter("contractid", "=", (Object)model.getValue("id").toString()).and("listingmodel", "=", (Object)listModelId);
                DynamicObject[] listEntries = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)allProperty, (QFilter[])new QFilter[]{contFilter}, (String)"sysnumber desc");
                if (null == listEntries || listEntries.length <= 0) continue;
                sublistEntries.clear();
                BigDecimal rowOfTax = BigDecimal.ZERO;
                BigDecimal rowTax = BigDecimal.ZERO;
                for (int i = listEntries.length - 1; i >= 0; --i) {
                    DynamicObject listEntry = listEntries[i];
                    DynamicObject item = sublistEntries.addNew();
                    item.set("id", listEntry.get("id"));
                    item.set("listnumber", (Object)listEntry.getString("number"));
                    item.set("listname", (Object)listEntry.getString("name"));
                    item.set("level", (Object)listEntry.getInt("level"));
                    item.set("longnumber", (Object)listEntry.getString("longnumber"));
                    item.set("isleaf", (Object)listEntry.getBoolean("isleaf"));
                    item.set("parent", (Object)listEntry.getDynamicObject("parent"));
                    item.set("sysnumber", (Object)listEntry.getString("sysnumber"));
                    item.set("measureunit", (Object)listEntry.getDynamicObject("measureunit"));
                    item.set("rate", (Object)listEntry.getBigDecimal("taxrate"));
                    item.set("rateobj", (Object)listEntry.getDynamicObject("rateobj"));
                    BigDecimal lstOfTaxAmount = listEntry.getBigDecimal("lstoftaxamount");
                    item.set("oftax", (Object)lstOfTaxAmount);
                    if (listEntry.getBoolean("isleaf")) {
                        rowOfTax = rowOfTax.add(lstOfTaxAmount);
                    }
                    item.set("desc", (Object)listEntry.getString("desc"));
                    item.set("qty", (Object)listEntry.getBigDecimal("totalqty"));
                    item.set("taxprice", (Object)listEntry.getBigDecimal("curtaxprice"));
                    BigDecimal rate = listEntry.getBigDecimal("taxrate").divide(BigDecimal.valueOf(100L));
                    BigDecimal price = listEntry.getBigDecimal("curtaxprice").divide(BigDecimal.ONE.add(rate), pricePrecision, 4);
                    item.set("price", (Object)price);
                    BigDecimal lstOfAmount = listEntry.getBigDecimal("latestamount");
                    if (lstOfAmount == null || lstOfAmount.compareTo(BigDecimal.ZERO) == 0) {
                        lstOfAmount = lstOfTaxAmount.divide(BigDecimal.ONE.add(rate), amtPrecision, 4);
                    }
                    item.set("tax", (Object)lstOfTaxAmount.subtract(lstOfAmount));
                    if (listEntry.getBoolean("isleaf")) {
                        rowTax = rowTax.add(item.getBigDecimal("tax"));
                    }
                    item.set("amount", (Object)lstOfAmount);
                    item.set("material", (Object)listEntry.getDynamicObject("material"));
                    item.set("seq", (Object)listEntry.getInt("sequence"));
                    item.set("listparentid", (Object)listEntry.getString("listparentid"));
                    item.set("sublistmodelid", (Object)listEntry.getLong("listingmodel_id"));
                    item.set("listingbudgetitem", (Object)listEntry.getDynamicObject("listingbudgetitem"));
                }
                listModel.set("rowoftax", (Object)rowOfTax);
                rowTax = rowTax.setScale(amtPrecision, 4);
                BigDecimal rowOriginalAmount = rowOfTax.subtract(rowTax);
                listModel.set("rowtax", (Object)rowTax);
                listModel.set("rowamount", (Object)rowOriginalAmount);
                if (isMultiRate.booleanValue()) {
                    if (listModel.getBigDecimal("rowamount").compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal taxRate = rowTax.divide(listModel.getBigDecimal("rowamount"), amtPrecision, 4);
                        listModel.set("rowtaxrate", (Object)taxRate.multiply(BigDecimal.valueOf(100L)));
                    }
                } else {
                    DynamicObject lstTaxRate = (DynamicObject)model.getValue("lsttaxrate");
                    BigDecimal taxRate = BigDecimal.ZERO;
                    if (lstTaxRate != null) {
                        taxRate = lstTaxRate.getBigDecimal("taxrate");
                    }
                    listModel.set("rowtaxrate", (Object)taxRate);
                }
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(cmpType = listModel.getString("cmptype"))) && cmpType.contains("+")) {
                    originalOfTaxAmount = originalOfTaxAmount.add(rowOfTax);
                    taxAmount = taxAmount.add(rowTax);
                } else if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)cmpType) && cmpType.contains("-")) {
                    originalOfTaxAmount = originalOfTaxAmount.subtract(rowOfTax);
                    taxAmount = taxAmount.subtract(rowTax);
                }
                listModel.set("sublistentry", (Object)sublistEntries);
            }
            if (isOnList.booleanValue() && !isMultiRate.booleanValue() && null != model.getValue("taxrate")) {
                DynamicObject dataEntity = model.getDataEntity();
                BigDecimal taxRate = dataEntity.getDynamicObject("taxrate").getBigDecimal("taxrate");
                originalAmount = originalOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), amtPrecision, 4);
                taxAmount = originalOfTaxAmount.subtract(originalAmount);
            }
            if (isMultiRate.booleanValue() && (originalAmount = originalOfTaxAmount.subtract(taxAmount)).compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal taxRate = taxAmount.divide(originalAmount, amtPrecision, 4);
                model.setValue("avgtaxrate", (Object)taxRate.multiply(BigDecimal.valueOf(100L)));
            }
        }
        BigDecimal totalOfTaxAmount = (BigDecimal)model.getValue("totaloftaxamount");
        BigDecimal totalAmount = (BigDecimal)model.getValue("totalamount");
        model.beginInit();
        model.setValue("originaloftaxamount", (Object)totalOfTaxAmount);
        model.setValue("originalamount", (Object)totalAmount);
        model.setValue("taxamount", (Object)totalOfTaxAmount.subtract(totalAmount));
        model.setValue("taxrate", model.getValue("lsttaxrate"));
        model.setValue("avgtaxrate", model.getValue("lstavgtaxrate"));
        model.endInit();
        this.getView().updateView("originaloftaxamount");
        this.getView().updateView("originalamount");
        this.getView().updateView("taxamount");
        this.getView().updateView("taxrate");
        this.getView().updateView("avgtaxrate");
        model.updateEntryCache(listModelEntry);
        this.getView().updateView("listmodelentry");
        if (listModelEntry.size() == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listmodelentry"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"contractlistingpanel"});
        } else if (listModelEntry.size() > 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"contractlistingpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"listmodelentry"});
        }
        int rowCount = model.getEntryRowCount("listmodelentry");
        if (rowCount > 1) {
            CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
            cardEntry.selectRows(0);
            cardEntry.entryRowClick(Integer.valueOf(0));
        } else {
            this.initTreeListEntry();
        }
    }

    private void initTreeListEntry() {
        this.getModel().deleteEntryData("treelistentry");
        DynamicObjectCollection subListEntry = this.getModel().getEntryEntity("sublistentry");
        DynamicObjectCollection treeListEntry = this.getModel().getEntryEntity("treelistentry");
        String payDirection = (String)this.getModel().getValue("paydirection");
        DynamicObjectType dt = treeListEntry.getDynamicObjectType();
        if (subListEntry == null) {
            return;
        }
        for (int i = 0; i < subListEntry.size(); ++i) {
            DynamicObject listing = new DynamicObject(dt);
            listing.set("treesysnumber", ((DynamicObject)subListEntry.get(i)).get("sysnumber"));
            listing.set("treelistnumber", ((DynamicObject)subListEntry.get(i)).get("listnumber"));
            listing.set("treematerial", ((DynamicObject)subListEntry.get(i)).get("material"));
            listing.set("treemeasureunit", ((DynamicObject)subListEntry.get(i)).get("measureunit"));
            listing.set("treeqty", ((DynamicObject)subListEntry.get(i)).get("qty"));
            listing.set("treetaxprice", ((DynamicObject)subListEntry.get(i)).get("taxprice"));
            listing.set("treerate", ((DynamicObject)subListEntry.get(i)).get("rate"));
            listing.set("treeamount", ((DynamicObject)subListEntry.get(i)).get("amount"));
            listing.set("treeprice", ((DynamicObject)subListEntry.get(i)).get("price"));
            listing.set("treetax", ((DynamicObject)subListEntry.get(i)).get("tax"));
            listing.set("treeprice", ((DynamicObject)subListEntry.get(i)).get("price"));
            listing.set("treeoftax", ((DynamicObject)subListEntry.get(i)).get("oftax"));
            listing.set("treedesc", ((DynamicObject)subListEntry.get(i)).get("desc"));
            listing.set("treeisleaf", ((DynamicObject)subListEntry.get(i)).get("isleaf"));
            listing.set("treelistname", ((DynamicObject)subListEntry.get(i)).get("listname"));
            listing.set("treerateobj", ((DynamicObject)subListEntry.get(i)).get("rateobj"));
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue())) {
                listing.set("treelistingbudgetitem", ((DynamicObject)subListEntry.get(i)).get("listingbudgetitem"));
            }
            String pid = "0";
            if (((DynamicObject)subListEntry.get(i)).get("listparentid") != null && !"".equals(((DynamicObject)subListEntry.get(i)).get("listparentid"))) {
                pid = String.valueOf(((DynamicObject)subListEntry.get(i)).get("listparentid"));
            }
            listing.set("pid", (Object)pid);
            listing.set("id", (Object)((DynamicObject)subListEntry.get(i)).getString("id"));
            treeListEntry.add((Object)listing);
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treelistentry");
        grid.setCollapse(false);
        this.getModel().updateEntryCache(treeListEntry);
        this.getView().updateView("treelistentry");
    }

    private void loadRiskEntry(DynamicObject contractRevision) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(CONTRISKENTRY);
        DynamicObjectCollection riskEntry = contractRevision.getDynamicObjectCollection(CONTRISKENTRY);
        entries.clear();
        if (riskEntry != null && riskEntry.size() > 0) {
            for (int i = 0; i < riskEntry.size(); ++i) {
                DynamicObject item = entries.addNew();
                DynamicObject entry = (DynamicObject)riskEntry.get(i);
                item.set("risktype", entry.get("risktype"));
                item.set("riskname", entry.get("riskname"));
                item.set("riskdesc", entry.get("riskdesc"));
                item.set("measures", entry.get("measures"));
                item.set("islegalrisk", entry.get("islegalrisk"));
            }
        }
        this.getModel().updateEntryCache(entries);
        this.getView().updateView(CONTRISKENTRY);
    }

    private void loadOutContPlanEntry(DynamicObject contractRevision) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(CONTPAYPLANENTRY);
        DynamicObjectCollection outContPayPlanEntry = contractRevision.getDynamicObjectCollection(CONTPAYPLANENTRY);
        if (outContPayPlanEntry != null && outContPayPlanEntry.size() > 0) {
            entries.clear();
            for (int i = 0; i < outContPayPlanEntry.size(); ++i) {
                DynamicObject item = entries.addNew();
                DynamicObject entry = (DynamicObject)outContPayPlanEntry.get(i);
                item.set("supplier", entry.get("supplier"));
                item.set("payway", entry.get("payway"));
                item.set("paytype", entry.get("paytype"));
                item.set("paymethod", entry.get("paymethod"));
                item.set("paypercent", entry.get("paypercent"));
                item.set("payamount", entry.get("payamount"));
                item.set("planpaytime", entry.get("planpaytime"));
                item.set("remarks", entry.get("paydescription"));
                DynamicObject nodeSetting = entry.getDynamicObject("nodesetting");
                item.set("nodesetting", (Object)nodeSetting);
                if (null == nodeSetting) continue;
                nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = nodeSetting.getString("completionstatus");
                String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                item.set("taskcompletestate", (Object)status);
                item.set("nodesettingsource", entry.get("nodesettingsource"));
                item.set("ctrlstrategy", entry.get("ctrlstrategy"));
                item.set("conplanitemid", (Object)String.valueOf(entry.getLong("conpayitemid")));
            }
        }
        this.getModel().updateEntryCache(entries);
        this.getView().updateView(CONTPAYPLANENTRY);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contractEdit = (BasedataEdit)this.getControl("refcontract");
        contractEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("budgetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit listingBudgetItem = (BasedataEdit)this.getView().getControl("treelistingbudgetitem");
        listingBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit parentPro = (BasedataEdit)this.getView().getControl("project");
        parentPro.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit partB = (BasedataEdit)this.getControl("partb");
        partB.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit treeMaterial = (BasedataEdit)this.getControl("treematerial");
        treeMaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit strategicAgreement = (BasedataEdit)this.getControl("strategicagreement");
        strategicAgreement.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit wbsEdit = (BasedataEdit)this.getControl("wbsname");
        wbsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplierEdit = (BasedataEdit)this.getControl("supplier");
        supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit bidResult = (MulBasedataEdit)this.getControl(CALLBACKBIDRESULT);
        bidResult.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit multiSettlePro = (BasedataEdit)this.getView().getControl("multisettlepro");
        multiSettlePro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit nodeSettingEdit = (BasedataEdit)this.getControl("nodesetting");
        nodeSettingEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        nodeSettingEdit.addBeforeF7ViewDetailListener(evt -> {
            DynamicObject nodeSetting;
            evt.setCancel(true);
            Object pkId = evt.getPkId();
            if (null != pkId && !(nodeSetting = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)NodeSettingSourceEnum.PMBS_TASK.getValue())).getBoolean("islatest")) {
                DynamicObject sourceTask = nodeSetting.getDynamicObject("sourcetask");
                nodeSetting = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)String.join((CharSequence)",", new CharSequence[0]), (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue()), new QFilter("islatest", "=", (Object)Boolean.TRUE)});
                pkId = nodeSetting.getPkValue();
            }
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (String)"id", (Object)pkId));
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("deleteplanentrycomp".equals(operateKey)) {
            ConfirmCallBackListener planCallback = new ConfirmCallBackListener(CALLBACKDELETEPAYPLANENTRY, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7684\u6570\u636e\u5c06\u88ab\u5220\u9664\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractEditPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, planCallback);
        }
        if ("showbudget".equals(operateKey)) {
            DynamicObject budgetItem = this.getModel().getDataEntity().getDynamicObject("budgetitem");
            if (budgetItem == null) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u672a\u5173\u8054\u5bf9\u5e94\u7684\u9884\u7b97\u9879\u3002", (String)"OutContractEditPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pmct_checkbudgetbalance");
            showParameter.setCustomParam("budget", budgetItem.getPkValue());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
        if ("save".equals(operateKey)) {
            this.setBidResult();
            QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INDRAFT.getValue());
            DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
            this.getModel().setValue(CONTRACTSTATUS, (Object)contStatusObj);
        }
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operateKey)) {
            this.setBidResult();
        }
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"doviewoldcontract", (CharSequence)operateKey)) {
            this.doViewContract();
        }
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"refresh", (CharSequence)operateKey)) {
            this.getPageCache().put(REFRESH_FLAG, String.valueOf(Boolean.TRUE));
        }
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)ADJUST, (CharSequence)operateKey)) {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put("direction", PayDirectionEnum.OUT.getValue());
            paramMap.put("planEntry", CONTPAYPLANENTRY);
            paramMap.put("percentModel", "percentmodel");
            paramMap.put("payPercent", "paypercent");
            paramMap.put("payAmount", "payamount");
            paramMap.put("Originaloftaxamount", "originaloftaxamount");
            ContractEditHelper.adjustPayPlan((IFormView)this.getView(), paramMap);
        }
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)CTRL_NEWENTRY, (CharSequence)operateKey)) {
            this.recountOutPayPlan();
        }
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)CTRL_DELETEENTRY, (CharSequence)operateKey)) {
            this.recountOutPayPlan();
        }
    }

    private void setBidResult() {
        QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INDRAFT.getValue());
        DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
        this.getModel().setValue(CONTRACTSTATUS, (Object)contStatusObj);
        String bidResult = this.getPageCache().get("bidresultid");
        DynamicObject contract = this.getModel().getDataEntity();
        if (bidResult != null && !bidResult.isEmpty()) {
            List bidResultIds = SerializationUtils.fromJsonStringToList((String)bidResult, Object.class);
            if (bidResultIds != null && bidResultIds.size() > 0) {
                int index = 0;
                for (Object bidResultId : bidResultIds) {
                    DynamicObject bidContract;
                    DynamicObject bidMessage = BusinessDataServiceHelper.loadSingle(bidResultId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bidmessage"));
                    DynamicObjectCollection contractCollection = bidMessage.getDynamicObjectCollection("contractcode");
                    Iterator iterator = contractCollection.iterator();
                    while (iterator.hasNext() && !(bidContract = (DynamicObject)iterator.next()).get(2).equals(contract.getPkValue())) {
                        ++index;
                    }
                    if (index < contractCollection.size()) {
                        contractCollection.remove(index);
                        SaveServiceHelper.update((DynamicObject)bidMessage);
                    }
                    index = 0;
                }
            }
            this.getPageCache().remove("bidresultid");
        }
    }

    private void doViewContract() {
        HashMap<String, String> param = new HashMap<String, String>();
        String pkId = this.getModel().getValue("id").toString();
        param.put("pkId", pkId);
        param.put("formId", "pmct_outcontract");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam(VIEWSTYLE, (Object)"oldContrct");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmct_outcontract"));
        this.getView().showForm(showParameter);
    }

    @Deprecated
    private void setDefaultSupplierByMultiContract() {
        boolean isMultiContract = (Boolean)this.getModel().getValue("ismulticontract");
        if (!isMultiContract) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CONTPAYPLANENTRY);
            entryEntity.forEach(entry -> entry.set("supplier", this.getModel().getValue("partb")));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) throws KDException {
        super.confirmCallBack(messageBoxClosedEvent);
        String message = messageBoxClosedEvent.getCallBackId();
        if (message.equals(CALLBACKDELETEPAYPLANENTRY)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData(CONTPAYPLANENTRY);
                this.getView().setVisible(Boolean.FALSE, new String[0]);
            }
        } else if (message.equals(CALLBACKBIDRESULT)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
                this.getModel().setValue(CALLBACKBIDRESULT, null);
                String originPartB = this.getView().getPageCache().get("originPartB");
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)originPartB)) {
                    this.getModel().setValue("partb", (Object)Long.parseLong(originPartB));
                } else {
                    this.getModel().setValue("partb", null);
                }
                this.getView().getPageCache().remove("originPartB");
            } else {
                String partB = this.getView().getPageCache().get("partb");
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)partB)) {
                    this.getModel().setValue("partb", (Object)Long.parseLong(partB));
                } else {
                    this.getModel().setValue("partb", null);
                }
                this.getView().getPageCache().remove("partb");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) throws KDBizException {
        super.beforeF7Select(arg0);
        String name = arg0.getProperty().getName();
        ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject strategicAgreement = (DynamicObject)this.getModel().getValue("strategicagreement");
        switch (name) {
            case "refcontract": {
                ListShowParameter parameter = (ListShowParameter)arg0.getFormShowParameter();
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
                parameter.getListFilterParameter().getQFilters().add(orgFilter);
                ContractHelper.getContractByStatus((String)"pmct_contract", (ListShowParameter)parameter, (String)"");
                if (project == null) break;
                QFilter projectFilter = new QFilter("project", "=", (Object)project.getLong("id"));
                parameter.getListFilterParameter().getQFilters().add(projectFilter);
                break;
            }
            case "budgetitem": 
            case "treelistingbudgetitem": {
                if (project == null) {
                    arg0.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"OutContractEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
                QFilter sourceTypeFilter = new QFilter("sourcetype", "!=", (Object)"IN");
                qFilters.add(projectFilter);
                qFilters.add(sourceTypeFilter);
                DynamicObject[] budgetItems = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"parent", (QFilter[])qFilters.toArray(new QFilter[0]));
                if (budgetItems.length == 0) {
                    arg0.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u4e0d\u5b58\u5728\u9884\u7b97\u9879\u3002", (String)"OutContractEditPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    return;
                }
                List ids = Arrays.stream(budgetItems).filter(budgetItem -> {
                    QFilter parentFilter = new QFilter("parent", "=", (Object)budgetItem.getLong("id"));
                    DynamicObject[] children = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"", (QFilter[])new QFilter[]{parentFilter});
                    return children == null || children.length == 0;
                }).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                QFilter filter = new QFilter("id", "in", ids);
                ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
                listShowParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "partb": {
                if (null == strategicAgreement) break;
                String partBScope = (String)strategicAgreement.get("partbscope");
                if ("B".equals(partBScope)) {
                    this.agreementFilter(strategicAgreement, param, "partbscopeentry", "supplier");
                    break;
                }
                DynamicObject partB = strategicAgreement.getDynamicObject("partb");
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", partB.getPkValue()));
                break;
            }
            case "treematerial": {
                if (null != strategicAgreement) {
                    DynamicObjectCollection priceDetailEntry = strategicAgreement.getDynamicObjectCollection("pricedetailentry");
                    boolean anyMatch = true;
                    for (DynamicObject row : priceDetailEntry) {
                        Object listNumber = row.get("listnumber");
                        if (null != listNumber && listNumber.toString().equals("")) {
                            anyMatch = true;
                            continue;
                        }
                        anyMatch = false;
                        break;
                    }
                    if (!anyMatch) {
                        this.agreementFilter(strategicAgreement, param, "pricedetailentry", "materiel");
                    }
                }
                int row = arg0.getRow();
                DynamicObjectCollection treeListEntry = this.getModel().getEntryEntity("treelistentry");
                param.setMultiSelect(false);
                if (treeListEntry == null || treeListEntry.size() != row + 1) break;
                param.setMultiSelect(true);
                break;
            }
            case "wbsname": {
                if (project != null) {
                    QFilter proFilter = new QFilter("project", "=", project.getPkValue());
                    logger.info(String.format("\u652f\u51fa\u5408\u540c\u67e5\u8be2 wbs \u8fc7\u6ee4\u6761\u4ef6: %s", proFilter));
                    DynamicObject[] wbsObj = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)String.join((CharSequence)",", "number", "longnumber"), (QFilter[])new QFilter[]{proFilter});
                    HashSet<Object> wbsIdSet = new HashSet<Object>(16);
                    for (DynamicObject dy : wbsObj) {
                        wbsIdSet.add(dy.getPkValue());
                    }
                    QFilter wbsFilter = new QFilter("id", "in", (Object)wbsIdSet.toArray());
                    arg0.addCustomQFilter(wbsFilter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"OutContractEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                break;
            }
            case "bidresult": {
                if (project != null) {
                    QFilter proFilter = new QFilter("project.id", "=", project.getPkValue());
                    QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"pmfs_supplierident", (String)"id", (QFilter[])new QFilter[]{proFilter, statusFilter});
                    ArrayList<Object> supplierId = new ArrayList<Object>(10);
                    if (suppliers != null) {
                        for (DynamicObject supplier : suppliers) {
                            if (supplier == null) continue;
                            DynamicObject supplierObject = BusinessDataServiceHelper.loadSingle((Object)supplier.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_supplierident"));
                            DynamicObjectCollection entryCollection = supplierObject.getDynamicObjectCollection("entryentity");
                            for (DynamicObject entry : entryCollection) {
                                if (entry.getPkValue() == null) continue;
                                supplierId.add(entry.getPkValue());
                            }
                        }
                    }
                    QFilter supplierFilter = new QFilter("id", "in", (Object)supplierId.toArray());
                    arg0.addCustomQFilter(supplierFilter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"OutContractEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                break;
            }
            case "supplier": {
                DynamicObject partB = (DynamicObject)this.getModel().getValue("partb");
                if (partB == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5408\u540c\u4e59\u65b9\u201d\u3002", (String)"OutContractEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    arg0.setCancel(true);
                    return;
                }
                DynamicObjectCollection otherParts = (DynamicObjectCollection)this.getModel().getValue("otherpart");
                QFilter supplierIdFilter = ContractSupplierHelper.getContractSupplierFilter((DynamicObject)partB, (DynamicObjectCollection)otherParts);
                arg0.addCustomQFilter(supplierIdFilter);
                break;
            }
            case "strategicagreement": {
                this.beforeSelectStrategic(param);
                break;
            }
            case "nodesetting": {
                this.beforeSelectNodeSetting(param);
                break;
            }
            case "multisettlepro": {
                List proQFilters = param.getListFilterParameter().getQFilters();
                ArrayList<String> excludeStatusIds = new ArrayList<String>();
                excludeStatusIds.add(ProjectStatusEnum.BUSSINESS_CLOSE.getId());
                excludeStatusIds.add(ProjectStatusEnum.SUSPEND.getId());
                excludeStatusIds.add(ProjectStatusEnum.QUIT.getId());
                QFilter proStatusFilter = new QFilter("prostatus", "not in", (Object)StringUtils.stringArrToLongArr((String[])excludeStatusIds.toArray(new String[excludeStatusIds.size()])));
                proStatusFilter.and("prostatus", "!=", (Object)0);
                DynamicObject[] projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro", (QFilter[])new QFilter[]{proStatusFilter});
                Set projectIdSet = Arrays.stream(projectApprovals).filter(o -> o.getDynamicObject("pro") != null).map(projectApproval -> projectApproval.getDynamicObject("pro").getPkValue()).collect(Collectors.toSet());
                proQFilters.add(new QFilter("id", "in", projectIdSet));
                proQFilters.add(proStatusFilter);
                break;
            }
        }
    }

    protected void beforeSelectNodeSetting(ListShowParameter param) {
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        param.setFormId("bos_listf7");
        QFilter qFilter = new QFilter("project", "=", null != project ? project.getPkValue() : null);
        param.getListFilterParameter().getQFilters().add(qFilter);
        QFilter txTypeFilter = new QFilter("number", "=", (Object)"004");
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)"pmpt_transactiontype", (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        qFilter = new QFilter(String.join((CharSequence)".", "transactiontype", "fbasedataid_id"), "in", txType.getPkValue());
        param.getListFilterParameter().getQFilters().add(qFilter);
        qFilter = new QFilter("islatest", "=", (Object)Boolean.TRUE);
        param.getListFilterParameter().getQFilters().add(qFilter);
    }

    public void beforeSelectStrategic(ListShowParameter param) {
        DynamicObject[] wholeAgreements;
        DynamicObject[] specialAgreements;
        DynamicObject contractType = (DynamicObject)this.getModel().getValue("contracttype");
        if (null == contractType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u6218\u7565\u534f\u8bae\u524d\uff0c\u8bf7\u5148\u9009\u62e9\u5408\u540c\u7c7b\u578b\u3002", (String)"OutContractEditPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgPkValue = (Long)org.getPkValue();
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        HashSet<Long> agreeIdSet = new HashSet<Long>(16);
        QFilter specialFilter = new QFilter("agreementstate", "=", (Object)AgreementStatusEnum.EFFECTING.getValue()).and("billstatus", "=", (Object)"C").and("islatest", "=", (Object)"1").and("agreementtype", "=", contractType.getPkValue());
        for (DynamicObject agreementObj : specialAgreements = BusinessDataServiceHelper.load((String)"pmct_strategicagreement", (String)"orgscopeentry,orgscopeentry.scopeorg,projectscopeentry,projectscopeentry.project", (QFilter[])specialFilter.toArray())) {
            DynamicObjectCollection orgScopeEntry = agreementObj.getDynamicObjectCollection("orgscopeentry");
            if (null == orgPkValue || null == orgScopeEntry) continue;
            for (DynamicObject dynamicObject : orgScopeEntry) {
                Long scopeOrgPkValue = (Long)dynamicObject.getDynamicObject("scopeorg").getPkValue();
                if (null == scopeOrgPkValue) continue;
                if (orgPkValue.compareTo(scopeOrgPkValue) == 0 && null != project) {
                    DynamicObjectCollection subProjectScopeEntry = dynamicObject.getDynamicObjectCollection("projectscopeentry");
                    for (DynamicObject row : subProjectScopeEntry) {
                        Long scopeProject = (Long)row.getDynamicObject("project").getPkValue();
                        Long projectPkValue = (Long)project.getPkValue();
                        if (projectPkValue.compareTo(scopeProject) != 0) continue;
                        agreeIdSet.add((Long)agreementObj.getPkValue());
                    }
                    continue;
                }
                if (orgPkValue.compareTo(scopeOrgPkValue) != 0 || null != project) continue;
                agreeIdSet.add((Long)agreementObj.getPkValue());
            }
        }
        QFilter wholeFilter = new QFilter("agreementstate", "=", (Object)AgreementStatusEnum.EFFECTING.getValue()).and("islatest", "=", (Object)"1").and("billstatus", "=", (Object)"C").and("agreementtype", "=", contractType.getPkValue()).and("adaptescope", "=", (Object)AgreementAdapteScopeEnum.WHOLE.getValue());
        for (DynamicObject row : wholeAgreements = BusinessDataServiceHelper.load((String)"pmct_strategicagreement", (String)"", (QFilter[])wholeFilter.toArray())) {
            agreeIdSet.add((Long)row.getPkValue());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org", orgPkValue);
        map.put("project", project == null ? Integer.valueOf(0) : project.getPkValue());
        map.put("openstyle", "F7");
        QFilter agreeIdFilter = new QFilter("id", "in", agreeIdSet);
        map.put("defaultFilter", SerializeHelper.serialize((Object)agreeIdFilter));
        param.setCustomParams(map);
        param.getListFilterParameter().getQFilters().add(agreeIdFilter);
    }

    private void agreementFilter(DynamicObject strategicAgreement, ListShowParameter param, String strategicAgreementEntryEntity, String agreementF7) {
        DynamicObjectCollection supplierEntries = strategicAgreement.getDynamicObjectCollection(strategicAgreementEntryEntity);
        if (null != supplierEntries) {
            ArrayList<Long> list = new ArrayList<Long>();
            for (DynamicObject row : supplierEntries) {
                DynamicObject f7InRow = row.getDynamicObject(agreementF7);
                if (null == f7InRow) continue;
                Long o = (Long)row.getDynamicObject(agreementF7).getPkValue();
                list.add(o);
            }
            param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", list));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (name) {
            case "treelistingbudgetitem": {
                this.setBlankChildren(e.getChangeSet()[0]);
                break;
            }
            case "budgetitem": {
                this.budgetItemChanged(e.getChangeSet()[0]);
                break;
            }
            case "strategicagreement": {
                if (null == newValue) break;
                Object value = model.getValue("partb");
                this.afterAgreementClearUp(value, "partb");
                model.setValue("originaloftaxamount", (Object)0);
                model.setValue("originalamount", (Object)0);
                model.setValue("taxamount", (Object)0);
                DynamicObjectCollection listModelEntry = this.getModel().getEntryEntity("listmodelentry");
                if (listModelEntry == null || listModelEntry.isEmpty()) break;
                for (DynamicObject listModel : listModelEntry) {
                    DynamicObjectCollection contractListEntry = listModel.getDynamicObjectCollection("sublistentry");
                    contractListEntry.clear();
                    listModel.set("rowamount", (Object)0);
                    listModel.set("rowtax", (Object)0);
                    listModel.set("rowoftax", (Object)0);
                }
                this.getView().updateView("sublistentry");
                this.getView().updateView("listmodelentry");
                model.deleteEntryData("treelistentry");
                break;
            }
            case "contracttype": {
                DynamicObject contractType = model.getDataEntity().getDynamicObject("contracttype");
                if (contractType == null) break;
                contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                this.getModel().setValue("isincost", (Object)contractType.getBoolean("isincost"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"isincost"});
                this.getModel().setValue("contractpaycontrol", (Object)contractType.getString("contractpaycontrol"));
                break;
            }
            case "project": {
                model.setValue(CALLBACKBIDRESULT, null);
                this.clearBudgetItem(model);
                break;
            }
            case "bidresult": {
                this.getOldBidResult(e);
                this.setPartB();
                break;
            }
            case "partb": {
                Boolean isMultiContract = (Boolean)this.getModel().getValue("ismulticontract");
                if (isMultiContract.booleanValue()) {
                    DynamicObject partB = (DynamicObject)model.getValue("partb");
                    DynamicObjectCollection otherParts = (DynamicObjectCollection)model.getValue("otherpart");
                    List supplierIds = otherParts.stream().map(entry -> entry.get("fbasedataid_id")).collect(Collectors.toList());
                    if (newValue != null) {
                        supplierIds.add(((DynamicObject)newValue).getPkValue());
                    }
                    DynamicObjectCollection outContractPayPlanEntries = model.getEntryEntity(CONTPAYPLANENTRY);
                    outContractPayPlanEntries.forEach(entry -> {
                        DynamicObject supplier = entry.getDynamicObject("supplier");
                        if (supplier != null && !supplierIds.contains(supplier.getPkValue())) {
                            entry.set("supplier", newValue);
                        } else if (supplier == null) {
                            entry.set("supplier", (Object)partB);
                        }
                    });
                    this.getView().updateView(CONTPAYPLANENTRY);
                    break;
                }
                DynamicObjectCollection outContractPayPlanEntries = model.getEntryEntity(CONTPAYPLANENTRY);
                if (newValue != null) {
                    outContractPayPlanEntries.forEach(entry -> entry.set("supplier", newValue));
                } else {
                    outContractPayPlanEntries.forEach(entry -> entry.set("supplier", null));
                }
                this.getView().updateView(CONTPAYPLANENTRY);
                break;
            }
            case "otherpart": {
                DynamicObject partB = (DynamicObject)model.getValue("partb");
                DynamicObjectCollection otherParts = (DynamicObjectCollection)model.getValue("otherpart");
                List supplierIds = otherParts.stream().map(entry -> entry.get("fbasedataid_id")).collect(Collectors.toList());
                if (partB != null) {
                    supplierIds.add(partB.getPkValue());
                }
                DynamicObjectCollection outContractPayPlanEntries = model.getEntryEntity(CONTPAYPLANENTRY);
                outContractPayPlanEntries.forEach(entry -> {
                    DynamicObject supplier = entry.getDynamicObject("supplier");
                    if (supplier != null && !supplierIds.contains(supplier.getPkValue())) {
                        entry.set("supplier", (Object)partB);
                    } else if (supplier == null) {
                        entry.set("supplier", (Object)partB);
                    }
                });
                this.getView().updateView(CONTPAYPLANENTRY);
                break;
            }
            case "originaloftaxamount": {
                DynamicObjectCollection outContPayPlanEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(CONTPAYPLANENTRY);
                BigDecimal originalOfTaxAmount = this.getModel().getDataEntity().getBigDecimal("originaloftaxamount");
                for (int i = 0; i < outContPayPlanEntries.size(); ++i) {
                    DynamicObject outContPayPlanEntry = (DynamicObject)outContPayPlanEntries.get(i);
                    BigDecimal payPercent = outContPayPlanEntry.getBigDecimal("paypercent").divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP);
                    BigDecimal payAmount = outContPayPlanEntry.getBigDecimal("payamount");
                    this.getModel().beginInit();
                    if (BigDecimal.ZERO.compareTo(payPercent) != 0) {
                        this.getModel().setValue("payamount", (Object)originalOfTaxAmount.multiply(payPercent), i);
                        this.getView().updateView("payamount", i);
                    } else if (BigDecimal.ZERO.compareTo(payAmount) != 0) {
                        payPercent = BigDecimal.ZERO.compareTo(originalOfTaxAmount) != 0 ? payAmount.divide(originalOfTaxAmount, 10, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                        this.getModel().setValue("paypercent", (Object)payPercent, i);
                        this.getView().updateView("paypercent", i);
                    }
                    this.getModel().endInit();
                }
                break;
            }
            case "paypercent": {
                this.recountOutPayPlan();
                BigDecimal payPercent = (BigDecimal)this.getModel().getValue("paypercent", rowIndex);
                payPercent = payPercent.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP);
                BigDecimal originalOfTaxAmount = this.getModel().getDataEntity().getBigDecimal("originaloftaxamount");
                this.getModel().beginInit();
                if (BigDecimal.ZERO.compareTo(originalOfTaxAmount) != 0) {
                    this.getModel().setValue("payamount", (Object)originalOfTaxAmount.multiply(payPercent), rowIndex);
                    this.getView().updateView("payamount", rowIndex);
                }
                this.getModel().endInit();
                break;
            }
            case "payamount": {
                this.recountOutPayPlan();
                BigDecimal originalOfTaxAmount = this.getModel().getDataEntity().getBigDecimal("originaloftaxamount");
                BigDecimal payAmount = (BigDecimal)this.getModel().getValue("payamount", rowIndex);
                this.getModel().beginInit();
                if (BigDecimal.ZERO.compareTo(originalOfTaxAmount) != 0) {
                    this.getModel().setValue("paypercent", (Object)payAmount.divide(originalOfTaxAmount, 10, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)), rowIndex);
                }
                if (BigDecimal.ZERO.compareTo(originalOfTaxAmount) == 0) {
                    this.getModel().setValue("paypercent", (Object)BigDecimal.ZERO, rowIndex);
                }
                this.getView().updateView("paypercent", rowIndex);
                this.getModel().endInit();
                break;
            }
            case "nodesetting": {
                if (null == newValue) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
                    this.getModel().setValue("ctrlstrategy", null, rowIndex);
                    this.getModel().setValue("taskcompletestate", null, rowIndex);
                    return;
                }
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = task.getString("completionstatus");
                String taskState = CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                this.getModel().setValue("taskcompletestate", (Object)taskState, rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"ctrlstrategy"});
                break;
            }
        }
    }

    private void clearBudgetItem(IDataModel model) {
        model.setValue("budgetitem", null);
        DynamicObjectCollection listModelEntry = model.getEntryEntity("listmodelentry");
        for (DynamicObject listModelEntryObj : listModelEntry) {
            DynamicObjectCollection treeListEntry = model.getEntryEntity("treelistentry");
            for (DynamicObject treeListEntryObj : treeListEntry) {
                treeListEntryObj.set("treelistingbudgetitem", null);
            }
            DynamicObjectCollection subListEntry = listModelEntryObj.getDynamicObjectCollection("sublistentry");
            for (DynamicObject subListEntryObj : subListEntry) {
                subListEntryObj.set("listingbudgetitem", null);
            }
            this.getModel().setValue("treelistentry", (Object)treeListEntry);
        }
        this.getModel().setValue("listmodelentry", (Object)listModelEntry);
        this.getView().updateView("sublistentry");
        this.getView().updateView("treelistentry");
    }

    private void getOldBidResult(PropertyChangedArgs e) {
        DynamicObjectCollection oldValueCollection = (DynamicObjectCollection)e.getChangeSet()[0].getOldValue();
        this.getPageCache().remove("bidresultid");
        if (oldValueCollection != null && !oldValueCollection.isEmpty()) {
            HashSet<Object> bidResultIds = new HashSet<Object>(16);
            for (DynamicObject oldValue : oldValueCollection) {
                if (oldValue == null) continue;
                bidResultIds.add(oldValue.get(2));
            }
            if (!bidResultIds.isEmpty()) {
                this.getPageCache().put("bidresultid", SerializationUtils.toJsonString(bidResultIds));
            }
        }
    }

    public void setPartB() {
        DynamicObject contract = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidEntry = contract.getDynamicObjectCollection(CALLBACKBIDRESULT);
        if (bidEntry != null) {
            HashSet<Object> bidId = new HashSet<Object>();
            HashSet<Object> contractId = new HashSet<Object>();
            for (DynamicObject bid : bidEntry) {
                if (bid == null) continue;
                DynamicObject bidResult = BusinessDataServiceHelper.loadSingle((Object)bid.get("fbasedataid_id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bidmessage"));
                DynamicObject succeedBidder = bidResult.getDynamicObject("succeedbidder");
                if (succeedBidder != null) {
                    bidId.add(succeedBidder.getPkValue());
                }
                DynamicObjectCollection contractEntry = bidResult.getDynamicObjectCollection("contractcode");
                for (DynamicObject dy : contractEntry) {
                    if (dy == null || dy.get("fbasedataid_id").equals(contract.getPkValue())) continue;
                    contractId.add(dy.get("fbasedataid_id"));
                }
            }
            if (bidId.size() == 1) {
                if (!contractId.isEmpty()) {
                    this.getView().getPageCache().remove("partb");
                    this.getView().getPageCache().put("partb", String.valueOf(bidId.toArray()[0]));
                    DynamicObject partB = (DynamicObject)this.getModel().getValue("partb");
                    this.getView().getPageCache().remove("originPartB");
                    if (partB != null) {
                        this.getView().getPageCache().put("originPartB", partB.getPkValue().toString());
                    }
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CALLBACKBIDRESULT, (IFormPlugin)this);
                    String confirmTip = ResManager.loadKDString((String)"\u672c\u62db\u6807\u7ed3\u679c\u5df2\u88ab\u5176\u4ed6\u5408\u540c\u5f15\u7528\uff0c\u8bf7\u786e\u8ba4\u672c\u6b21\u62db\u6807\u9700\u7b7e\u7f72\u591a\u4efd\u5408\u540c\u3002", (String)"OutContractEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, confirmCallBacks);
                } else {
                    this.getModel().setValue("partb", (Object)Long.parseLong(bidId.toArray()[0].toString()));
                }
            } else if (bidId.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u4e0d\u662f\u540c\u4e00\u4e2a\u4e2d\u6807\u4eba\uff0c\u4e0d\u80fd\u5408\u5e76\u7b7e\u7f72\u5408\u540c\u3002", (String)"OutContractEditPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(CALLBACKBIDRESULT, null);
                this.getModel().setValue("partb", null);
            } else {
                this.getModel().setValue("partb", null);
            }
        } else {
            this.getModel().setValue("partb", null);
        }
    }

    protected void setBlankChildren(ChangeData changeData) {
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        DynamicObjectCollection lists = this.getModel().getEntryEntity("treelistentry");
        this.doSetBlankChildren(newValue, rowIndex, lists);
    }

    private void doSetBlankChildren(DynamicObject newValue, int rowIndex, DynamicObjectCollection lists) {
        if (rowIndex >= lists.size()) {
            logger.error("rowIndex: {}, \u7d22\u5f15\u8d8a\u754c\uff0c\u65e0\u6cd5\u81ea\u52a8\u586b\u5145\u5206\u644a\u660e\u7ec6\u5b50\u7ea7\u7a7a\u767d\u9884\u7b97\u9879\u3002", (Object)rowIndex);
            return;
        }
        String parentId = Optional.ofNullable(((DynamicObject)lists.get(rowIndex)).getPkValue().toString()).orElse("0");
        for (int index = rowIndex + 1; index < lists.size(); ++index) {
            String pid = ((DynamicObject)lists.get(index)).getString("pid");
            if (pid == null || "0".equals(pid) || null != ((DynamicObject)lists.get(index)).getString("treelistingbudgetitem") || !parentId.equals(pid)) continue;
            this.getModel().setValue("treelistingbudgetitem", (Object)newValue, index);
        }
        this.doSetBlankChildren(newValue, rowIndex + 1, lists);
    }

    protected boolean isControlProjectBudget(DynamicObject project) {
        if (project == null) {
            return false;
        }
        DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
        return proApp != null && proApp.length > 0 && proApp[0].getBoolean("projectcostcontrol");
    }

    private void afterAgreementClearUp(Object object, String field) {
        if (null != object) {
            this.getModel().setValue(field, null);
        }
    }

    protected void budgetItemChanged(ChangeData changeData) {
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        if (newValue != null && this.getModel().getDataEntity().getBoolean("isonlist")) {
            DynamicObjectCollection listModelEntry = this.getModel().getEntryEntity("listmodelentry");
            for (DynamicObject model : listModelEntry) {
                DynamicObjectCollection listEntry = model.getDynamicObjectCollection("sublistentry");
                for (DynamicObject list : listEntry) {
                    DynamicObject budgetItem = list.getDynamicObject("listingbudgetitem");
                    if (budgetItem != null && (oldValue == null || !budgetItem.getPkValue().equals(oldValue.getPkValue()))) continue;
                    list.set("listingbudgetitem", (Object)newValue);
                }
            }
            DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("treelistentry");
            for (DynamicObject entry : treeEntry) {
                DynamicObject budgetItem = entry.getDynamicObject("treelistingbudgetitem");
                if (budgetItem != null && (oldValue == null || !budgetItem.getPkValue().equals(oldValue.getPkValue()))) continue;
                entry.set("treelistingbudgetitem", (Object)newValue);
            }
            this.getModel().setValue("listmodelentry", (Object)listModelEntry);
            this.getModel().setValue("treelistentry", (Object)treeEntry);
            this.getView().updateView("treelistentry");
        }
    }

    @Deprecated
    protected void listingBudgetItemChanged(ChangeData changeData) {
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if (oldValue != null && newValue != null) {
            int rowCount = this.getModel().getEntryRowCount("treelistentry");
            DynamicObject changedEntity = this.getModel().getEntryRowEntity("treelistentry", rowIndex);
            String changedEntryId = changedEntity.getPkValue().toString();
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("treelistentry", i);
                DynamicObject budgetItem = rowEntity.getDynamicObject("treelistingbudgetitem");
                if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)rowEntity.getString("pid"), (CharSequence)changedEntryId) || budgetItem == null || !budgetItem.getPkValue().equals(oldValue.getPkValue())) continue;
                this.getModel().setValue("treelistingbudgetitem", newValue.getPkValue(), i);
            }
        }
    }

    private void recountOutPayPlan() {
        HashMap<String, String> percentParamMap = new HashMap<String, String>(16);
        percentParamMap.put("planEntry", CONTPAYPLANENTRY);
        percentParamMap.put("percentModel", "percentmodel");
        percentParamMap.put("payPercent", "paypercent");
        percentParamMap.put("payAmount", "payamount");
        percentParamMap.put("Originaloftaxamount", "originaloftaxamount");
        ContractEditHelper.recountPayPlan((IFormView)this.getView(), percentParamMap);
    }
}

