/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.addition;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.ContractListHelper;

public class ContAddAgreeListingPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static String LISTINGFORMID = "pmct_contractlist";
    private static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    private static final String CUR_MODEL_ROW = "curModelRow";
    private static final String CHANGETYPE_DETAILLISTING = "2";
    private static final String CHANGETYPE_NOTDETAILLISTING = "3";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payeebanknum = (TextEdit)this.getView().getControl("superlistingname");
        payeebanknum.addButtonClickListener((ClickListener)this);
        BasedataEdit listing = (BasedataEdit)this.getControl("listid");
        listing.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (key.equals("superlistingname")) {
            this.showListingList();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "listname": {
                this.listNameChanged(newValue, rowIndex);
                break;
            }
            case "superlistingname": {
                this.superListingNameChanged(newValue, rowIndex);
                break;
            }
            case "parentlisting": {
                this.parentChanged((DynamicObject)e.getChangeSet()[0].getNewValue(), rowIndex);
                break;
            }
            case "listid": {
                this.listidChanged((DynamicObject)e.getChangeSet()[0].getNewValue(), oldValue, rowIndex);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("listingcallback".equals(actionId) && (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !returnData.isEmpty()) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object pkValue = returnData.get(0).getPrimaryKeyValue();
            this.getModel().setValue("superlistingid", pkValue, rowIndex);
            boolean isExist = QueryServiceHelper.exists((String)LISTINGFORMID, (Object)pkValue);
            String sysNum = null;
            if (isExist) {
                sysNum = this.genSysNum(pkValue, isExist);
                this.getModel().setValue("sysnum", (Object)sysNum, rowIndex);
                this.getModel().setValue("parentlisting", pkValue, rowIndex);
            } else {
                this.getModel().setValue("parentlisting", null, rowIndex);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject entry : entryEntity) {
                    long listingId = entry.getLong("newlistingid");
                    if (listingId != Long.parseLong(pkValue.toString())) continue;
                    this.getModel().setValue("superlistingname", (Object)entry.getString("listname"), rowIndex);
                }
                sysNum = this.genSysNum(pkValue, isExist);
                this.getModel().setValue("sysnum", (Object)sysNum, rowIndex);
            }
            this.setSubChangeTypeEnable();
        }
    }

    public String genSysNum(Object pkValue, boolean isExist) {
        int count = 0;
        String sysNum = null;
        if (isExist) {
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> excludeSysNum = new ArrayList<String>();
            for (DynamicObject listEntryObj : subEntryEntity) {
                String subChangeType = listEntryObj.getString("subaddtype");
                if (!StringUtils.equals((CharSequence)subChangeType, (CharSequence)CHANGETYPE_DETAILLISTING) && !StringUtils.equals((CharSequence)subChangeType, (CharSequence)CHANGETYPE_NOTDETAILLISTING)) continue;
                String entrySysNum = listEntryObj.getString("sysnum");
                excludeSysNum.add(entrySysNum);
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            int parentRowIndex = this.getModel().getEntryCurrentRowIndex("cardentry");
            Object listModelId = this.getModel().getValue("listmodelid", parentRowIndex);
            QFilter listModelFilter = new QFilter("listingmodel", "=", listModelId);
            qFilters.add(listModelFilter);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                QFilter contractIdFilter = new QFilter("contractid", "=", (Object)contract.getString("id"));
                qFilters.add(contractIdFilter);
            }
            QFilter parentFilter = new QFilter("parent", "=", pkValue);
            qFilters.add(parentFilter);
            DynamicObject[] listings = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"sysnumber", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
            DynamicObject parentListing = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmct_contractlist");
            String parentSysNum = parentListing.getString("sysnumber");
            sysNum = String.format("%s.%03d", parentSysNum, ++count);
            if (listings.length > 0) {
                for (DynamicObject listing : listings) {
                    String curSysNum = listing.getString("sysnumber");
                    while (StringUtils.equals((CharSequence)curSysNum, (CharSequence)sysNum)) {
                        sysNum = String.format("%s.%03d", parentSysNum, ++count);
                    }
                }
            }
            while (excludeSysNum.contains(sysNum)) {
                sysNum = String.format("%s.%03d", parentSysNum, ++count);
            }
        } else {
            ArrayList<String> excludeSysNum = new ArrayList<String>();
            String parentSysNum = null;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entryEntity) {
                long superListingId;
                long listingId = entry.getLong("newlistingid");
                if (listingId == Long.parseLong(pkValue.toString())) {
                    parentSysNum = entry.getString("sysnum");
                    sysNum = String.format("%s.%03d", parentSysNum, ++count);
                }
                if ((superListingId = entry.getLong("superlistingid")) != Long.parseLong(pkValue.toString())) continue;
                String entrySysNum = entry.getString("sysnum");
                excludeSysNum.add(entrySysNum);
            }
            while (sysNum != null && excludeSysNum.contains(sysNum)) {
                sysNum = String.format("%s.%03d", parentSysNum, ++count);
            }
        }
        return sysNum;
    }

    private String genSysNumber(String type) {
        String sysNum = null;
        if (StringUtils.equals((CharSequence)type, (CharSequence)CHANGETYPE_DETAILLISTING) || StringUtils.equals((CharSequence)type, (CharSequence)CHANGETYPE_NOTDETAILLISTING)) {
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> excludeSysNum = new ArrayList<String>();
            for (DynamicObject listEntryObj : subEntryEntity) {
                String subChangeType = listEntryObj.getString("subaddtype");
                if (!StringUtils.equals((CharSequence)subChangeType, (CharSequence)CHANGETYPE_DETAILLISTING) && !StringUtils.equals((CharSequence)subChangeType, (CharSequence)CHANGETYPE_NOTDETAILLISTING)) continue;
                String entrySysNum = listEntryObj.getString("sysnum");
                excludeSysNum.add(entrySysNum);
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            int parentRowIndex = this.getModel().getEntryCurrentRowIndex("cardentry");
            Object listModelId = this.getModel().getValue("listmodelid", parentRowIndex);
            QFilter listModelFilter = new QFilter("listingmodel", "=", listModelId);
            qFilters.add(listModelFilter);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                QFilter contractIdFilter = new QFilter("contractid", "=", (Object)contract.getString("id"));
                qFilters.add(contractIdFilter);
            }
            QFilter parentFilter = new QFilter("parent", "=", (Object)0);
            qFilters.add(parentFilter);
            DynamicObject[] listings = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"sysnumber", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
            sysNum = ContractListHelper.genSysNumberRule((DynamicObject[])listings, excludeSysNum);
        }
        return sysNum;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforef7selectevent) {
        String name = beforef7selectevent.getProperty().getName();
        if (name.equals("listid")) {
            this.beforeListingSelect(beforef7selectevent);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)key)) {
            int[] selectRows;
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            for (int rowIndex : selectRows = grid.getSelectRows()) {
                Long listingId;
                boolean exist;
                String changeType = (String)this.getModel().getValue("subaddtype", rowIndex);
                if (!CHANGETYPE_NOTDETAILLISTING.equals(changeType) || !(exist = this.isExistSubEntry(listingId = (Long)this.getModel().getValue("newlistingid", rowIndex)))) continue;
                args.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u975e\u660e\u7ec6\u6e05\u5355\u5b58\u5728\u4e0b\u7ea7\u660e\u7ec6\u5206\u5f55\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ContAddAgreeListingPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), rowIndex + 1));
                return;
            }
            this.updateSuperAmount(selectRows);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterdooperationeventargs) {
        super.afterDoOperation(afterdooperationeventargs);
        String operateKey = afterdooperationeventargs.getOperateKey();
        if (operateKey.equals("deleteentry")) {
            this.setSubChangeTypeEnable();
        }
    }

    private void listNameChanged(Object newValue, int rowIndex) {
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        String subChangeType = (String)this.getModel().getValue("subaddtype", rowIndex, parentModelRow);
        if (StringUtils.equals((CharSequence)CHANGETYPE_NOTDETAILLISTING, (CharSequence)subChangeType)) {
            Long listingId = (Long)this.getModel().getValue("newlistingid", rowIndex, parentModelRow);
            DynamicObject cardEntry = this.getModel().getEntryRowEntity("cardentry", parentModelRow);
            DynamicObjectCollection subEntrys = (DynamicObjectCollection)cardEntry.get("entryentity");
            int rowCount = subEntrys.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                long superListingId = (Long)this.getModel().getValue("superlistingid", i, parentModelRow);
                if (superListingId != listingId) continue;
                this.getModel().setValue("superlistingname", newValue, i, parentModelRow);
            }
        }
    }

    private void superListingNameChanged(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        DynamicObject row = (DynamicObject)((DynamicObject)model.getEntryEntity("cardentry").get(parentModelRow)).getDynamicObjectCollection("entryentity").get(rowIndex);
        if (newValue == null || newValue.toString().isEmpty()) {
            model.setValue("superlistingid", (Object)0, rowIndex, parentModelRow);
            model.setValue("parentlisting", null, rowIndex, parentModelRow);
            String subChangeType = row.getString("subaddtype");
            String sysNum = this.genSysNumber(subChangeType);
            model.setValue("sysnum", (Object)sysNum, rowIndex, parentModelRow);
            return;
        }
        DynamicObject parentListing = (DynamicObject)model.getValue("parentlisting", rowIndex, parentModelRow);
        Long superListingId = Long.valueOf(model.getValue("superlistingid", rowIndex, parentModelRow).toString());
        if (parentListing != null) {
            String parentListingName = parentListing.getLocaleString("name").getLocaleValue();
            if (!StringUtils.equals((CharSequence)newValue.toString(), (CharSequence)parentListingName)) {
                model.setValue("superlistingname", (Object)parentListingName, rowIndex, parentModelRow);
            }
        } else if (superListingId != null && superListingId != 0L) {
            DynamicObject cardEntry = model.getEntryRowEntity("cardentry", parentModelRow);
            DynamicObjectCollection entryEntity = (DynamicObjectCollection)cardEntry.get("entryentity");
            for (DynamicObject entry : entryEntity) {
                long listingId = entry.getLong("newlistingid");
                if (superListingId != listingId || StringUtils.equals((CharSequence)newValue.toString(), (CharSequence)entry.getString("listname"))) continue;
                model.setValue("superlistingname", (Object)entry.getString("listname"), rowIndex, parentModelRow);
                break;
            }
        } else {
            model.setValue("superlistingname", null, rowIndex, parentModelRow);
        }
    }

    private void parentChanged(DynamicObject parentListing, int rowIndex) {
        if (parentListing != null) {
            this.getModel().setValue("superlistingname", (Object)parentListing.getLocaleString("name").getLocaleValue(), rowIndex);
            this.getModel().setValue("superlistingid", (Object)parentListing.getLong("id"), rowIndex);
        } else {
            this.getModel().setValue("superlistingname", (Object)"", rowIndex);
            this.getModel().setValue("superlistingid", (Object)0, rowIndex);
        }
    }

    private void listidChanged(DynamicObject conlist, Object oldValue, int rowIndex) {
        IDataModel model = this.getModel();
        int currentIndex = model.getEntryCurrentRowIndex("entryentity");
        String subChangeType = (String)model.getValue("subaddtype", currentIndex);
        if (conlist != null) {
            boolean result = this.validatorListing(conlist.getPkValue().toString());
            if (result) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u8be5\u6e05\u5355\u6b63\u5728\u7ed3\u7b97\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d8\u66f4\u3002", (String)"ContAddAgreeListingPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), conlist.get("name")));
                if (oldValue != null) {
                    model.setValue("listid", ((DynamicObject)oldValue).getPkValue(), currentIndex);
                    conlist = (DynamicObject)oldValue;
                } else {
                    model.setValue("listid", null, currentIndex);
                    return;
                }
            }
            conlist = BusinessDataServiceHelper.loadSingle((Object)conlist.getPkValue(), (String)"pmct_contractlist");
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            model.setValue("subaddtype", (Object)subChangeType, rowIndex);
            if (model.getValue("listid", rowIndex) == null) {
                model.setValue("listid", conlist.getPkValue(), rowIndex);
                return;
            }
            if (conlist.getDynamicObject("material") != null) {
                model.setValue("materiel", conlist.getDynamicObject("material").getPkValue(), rowIndex);
            }
            model.setValue("parentlisting", conlist.get("parent"), rowIndex);
            model.setValue("listnumber", conlist.get("number"), rowIndex);
            model.setValue("listname", conlist.get("name"), rowIndex);
            model.setValue("measureunit", conlist.get("measureunit"), rowIndex);
            model.setValue("qty", conlist.get("totalqty"), rowIndex);
            BigDecimal curTaxPirce = (BigDecimal)conlist.get("curtaxprice");
            model.setValue("priceoftax", (Object)curTaxPirce, rowIndex);
            BigDecimal latestTaxAmount = (BigDecimal)conlist.get("lstoftaxamount");
            model.setValue("oftax", (Object)latestTaxAmount, rowIndex);
            DynamicObject rateObject = (DynamicObject)conlist.get("rateobj");
            if (rateObject != null) {
                model.setValue("rateobj", (Object)rateObject, rowIndex);
            }
            BigDecimal taxrate = (BigDecimal)conlist.get("taxrate");
            model.setValue("subtaxrate", (Object)taxrate, rowIndex);
            int pricePrecision = currency != null ? currency.getInt("priceprecision") : 10;
            BigDecimal price = NumberHelper.divide((Object)curTaxPirce, (Object)BigDecimal.ONE.add(taxrate.divide(ONE_HUNDRED)), (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
            model.setValue("price", (Object)price, rowIndex);
            int amtPrecision = currency != null ? currency.getInt("amtprecision") : 10;
            BigDecimal amount = (BigDecimal)conlist.get("latestamount");
            if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) {
                amount = NumberHelper.divide((Object)latestTaxAmount, (Object)BigDecimal.ONE.add(taxrate.divide(ONE_HUNDRED)), (int)amtPrecision, (RoundingMode)RoundingMode.HALF_UP);
            }
            model.setValue("amount", (Object)amount, rowIndex);
            model.setValue("tax", (Object)latestTaxAmount.subtract(amount), rowIndex);
            model.setValue("settledqty", conlist.get("lstsettleqty"), rowIndex);
            model.setValue("settledamountoftax", conlist.get("lstsettleoftaxamount"), rowIndex);
            model.setValue("settledtaxamt", conlist.get("lstsettletaxamt"), rowIndex);
            model.setValue("changeqty", null, rowIndex);
            model.setValue("changedpriceoftax", null, rowIndex);
            model.setValue("sysnum", (Object)conlist.getString("sysnumber"), rowIndex);
        } else {
            model.setValue("parentlisting", null, rowIndex);
            model.setValue("listnumber", null, rowIndex);
            model.setValue("listname", null, rowIndex);
            model.setValue("measureunit", null, rowIndex);
            model.setValue("qty", null, rowIndex);
            model.setValue("priceoftax", null, rowIndex);
            model.setValue("oftax", null, rowIndex);
            model.setValue("rateobj", null, rowIndex);
            model.setValue("subtaxrate", null, rowIndex);
            model.setValue("price", null, rowIndex);
            model.setValue("amount", null, rowIndex);
            model.setValue("tax", null, rowIndex);
            model.setValue("settledqty", null, rowIndex);
            model.setValue("settledamountoftax", null, rowIndex);
            model.setValue("settledtaxamt", null, rowIndex);
            model.setValue("materiel", null, rowIndex);
            model.setValue("changeqty", null, rowIndex);
            model.setValue("affectedqty", null, rowIndex);
            model.setValue("changedpriceoftax", null, rowIndex);
            model.setValue("sysnum", null, rowIndex);
        }
    }

    private boolean validatorListing(String listEntryId) {
        String contractSettleFromId;
        boolean result = false;
        String formBillId = this.getModel().getDataEntityType().getName();
        String string = contractSettleFromId = formBillId.equals("pmct_inaddagreement") ? "pmct_incontract_settle" : "pmct_outcontract_settle";
        if (StringUtils.isNotEmpty((CharSequence)listEntryId)) {
            DynamicObject listing = BusinessDataServiceHelper.loadSingle((Object)listEntryId, (String)"pmct_contractlist");
            String contractId = listing.getString("contractid");
            String listingModelId = listing.getString("listingmodel_id");
            QFilter contFilter = new QFilter("contract", "=", (Object)Long.parseLong(contractId)).and("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
            DynamicObject[] contractSettles = BusinessDataServiceHelper.load((String)contractSettleFromId, (String)"id", (QFilter[])new QFilter[]{contFilter});
            if (null != contractSettles && contractSettles.length > 0) {
                for (DynamicObject contractSettle : contractSettles) {
                    boolean present;
                    DynamicObjectCollection listEntry;
                    DynamicObjectCollection listModelEntry = (contractSettle = BusinessDataServiceHelper.loadSingle((Object)contractSettle.getPkValue(), (String)contractSettleFromId)).getDynamicObjectCollection("listmodelentry");
                    DynamicObject modelEntry = listModelEntry.stream().filter(entry -> listingModelId.equals(entry.getString("listmodelid"))).findFirst().orElse(null);
                    if (null == modelEntry || null == (listEntry = modelEntry.getDynamicObjectCollection("listentry")) || listEntry.isEmpty() || !(present = listEntry.stream().anyMatch(entry -> listEntryId.equals(entry.getDynamicObject("listing").getPkValue().toString())))) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private void setSubChangeTypeEnable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> hasSubIdSet = new HashSet<Long>();
        for (DynamicObject entry : entryEntity) {
            if (!StringUtils.equals((CharSequence)CHANGETYPE_DETAILLISTING, (CharSequence)entry.getString("subaddtype")) || entry.getDynamicObject("parentlisting") != null || entry.getLong("superlistingid") == 0L) continue;
            hasSubIdSet.add(entry.getLong("superlistingid"));
        }
        int rowCount = entryEntity.size();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            if (StringUtils.equals((CharSequence)CHANGETYPE_NOTDETAILLISTING, (CharSequence)entry.getString("subaddtype")) && hasSubIdSet.contains(entry.getLong("newlistingid"))) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"subaddtype"});
                continue;
            }
            if (!StringUtils.equals((CharSequence)CHANGETYPE_NOTDETAILLISTING, (CharSequence)entry.getString("subaddtype"))) continue;
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"subaddtype"});
        }
    }

    private boolean isExistSubEntry(Long listingId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntity) {
            long superListingId = entry.getLong("superlistingid");
            if (superListingId != listingId) continue;
            return true;
        }
        return false;
    }

    private void beforeListingSelect(BeforeF7SelectEvent beforef7selectevent) {
        ListShowParameter lsp = (ListShowParameter)beforef7selectevent.getFormShowParameter();
        List qFilters = lsp.getListFilterParameter().getQFilters();
        this.addContractAndModelFilter(qFilters);
        this.addNewListingSuperFilter(qFilters);
        qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
        int row = beforef7selectevent.getRow();
        String subChangeType = (String)this.getModel().getValue("subaddtype", row);
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)"1")) {
            qFilters.add(new QFilter("lstsettleqty", "<", (Object)"totalqty", true));
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex("cardentry");
        Object listModelId = this.getModel().getValue("listmodelid", rowIndex);
        lsp.setCustomParam("listmodelid", listModelId);
    }

    private void addNewListingSuperFilter(List<QFilter> qFilters) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntity) {
            if (CHANGETYPE_NOTDETAILLISTING.equals(entry.getString("subaddtype")) || CHANGETYPE_DETAILLISTING.equals(entry.getString("subaddtype"))) {
                boolean isLeaf;
                DynamicObject parent = entry.getDynamicObject("parentlisting");
                if (parent == null || !(isLeaf = parent.getBoolean("isleaf"))) continue;
                qFilters.add(new QFilter("id", "<>", (Object)parent.getLong("id")));
                continue;
            }
            DynamicObject listing = entry.getDynamicObject("listid");
            if (listing == null) continue;
            qFilters.add(new QFilter("id", "<>", (Object)listing.getLong("id")));
        }
    }

    private void showListingList() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)LISTINGFORMID, (boolean)true, (int)3, (boolean)true);
        List qFilters = lsp.getListFilterParameter().getQFilters();
        this.addContractAndModelFilter(qFilters);
        lsp.setBillFormId(LISTINGFORMID);
        lsp.setMultiSelect(false);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList<DynamicObject> listingList = new ArrayList<DynamicObject>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)LISTINGFORMID);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        ArrayList<Long> excludeListings = new ArrayList<Long>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject listing;
            if (i == rowIndex) continue;
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            if (StringUtils.equals((CharSequence)CHANGETYPE_NOTDETAILLISTING, (CharSequence)entry.getString("subaddtype"))) {
                listing = new DynamicObject((DynamicObjectType)dt);
                listing.set("id", entry.get("newlistingid"));
                listing.set("parent_id", entry.get("superlistingid"));
                listing.set("number", entry.get("listnumber"));
                listing.set("name", entry.get("listname"));
                listing.set("desc", entry.get("remark"));
                DynamicObject material = entry.getDynamicObject("materiel");
                if (material != null) {
                    listing.set("material", (Object)material);
                }
                listingList.add(listing);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)entry.getString("subaddtype")) && !StringUtils.equals((CharSequence)"1", (CharSequence)entry.getString("subaddtype")) || (listing = entry.getDynamicObject("listid")) == null) continue;
            excludeListings.add(listing.getLong("id"));
        }
        qFilters.add(new QFilter("id", "not in", excludeListings));
        qFilters.add(new QFilter("isleaf", "=", (Object)DefaultEnum.NO.getValue()));
        lsp.setCustomParam("addlisting", (Object)DynamicObjectSerializeUtil.serialize((Object[])listingList.toArray(new DynamicObject[listingList.size()]), (DynamicObjectType)dt));
        int index = this.getModel().getEntryCurrentRowIndex("cardentry");
        Object listModelId = this.getModel().getValue("listmodelid", index);
        lsp.setCustomParam("listmodelid", listModelId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "listingcallback");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void addContractAndModelFilter(List<QFilter> qFilters) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("cardentry");
        Object listModelId = this.getModel().getValue("listmodelid", rowIndex);
        qFilters.add(new QFilter("listingmodel", "=", listModelId));
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract != null) {
            qFilters.add(new QFilter("contractid", "=", (Object)contract.getPkValue().toString()));
        }
    }

    private void updateSuperAmount(int[] selectRows) {
        if (selectRows == null || selectRows.length <= 0) {
            return;
        }
        HashSet<Integer> selectRowSet = new HashSet<Integer>();
        HashSet<Integer> updateSet = new HashSet<Integer>();
        for (int i : selectRows) {
            selectRowSet.add(i);
        }
        Object object = selectRowSet.iterator();
        while (object.hasNext()) {
            Integer rowIndex = (Integer)object.next();
            String changeType = (String)this.getModel().getValue("subaddtype", rowIndex.intValue());
            if (!CHANGETYPE_DETAILLISTING.equals(changeType)) continue;
            long superId = Long.parseLong(this.getModel().getValue("superlistingid", rowIndex.intValue()).toString());
            Object parent = this.getModel().getValue("parentlisting", rowIndex.intValue());
            if (superId == 0L || parent != null) continue;
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            int parentRowIndex = -1;
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTaxAmount = BigDecimal.ZERO;
            BigDecimal totalOfTaxAmount = BigDecimal.ZERO;
            for (int i = 0; i < rowCount; ++i) {
                if (selectRowSet.contains(i)) continue;
                long newListingId = Long.parseLong(this.getModel().getValue("newlistingid", i).toString());
                long superListingId = Long.parseLong(this.getModel().getValue("superlistingid", i).toString());
                if (newListingId == superId) {
                    parentRowIndex = i;
                    if (!updateSet.contains(parentRowIndex)) continue;
                    break;
                }
                if (superListingId != superId) continue;
                totalAmount = NumberHelper.add((Object)((BigDecimal)this.getModel().getValue("amount", i)), (Object)totalAmount);
                totalTaxAmount = NumberHelper.add((Object)((BigDecimal)this.getModel().getValue("tax", i)), (Object)totalTaxAmount);
                totalOfTaxAmount = NumberHelper.add((Object)((BigDecimal)this.getModel().getValue("oftax", i)), (Object)totalOfTaxAmount);
            }
            if (parentRowIndex == -1 || updateSet.contains(parentRowIndex)) continue;
            this.getModel().setValue("amount", (Object)totalAmount, parentRowIndex);
            this.getModel().setValue("tax", (Object)totalTaxAmount, parentRowIndex);
            this.getModel().setValue("oftax", (Object)totalOfTaxAmount, parentRowIndex);
            this.getView().updateView("amount", parentRowIndex);
            this.getView().updateView("tax", parentRowIndex);
            this.getView().updateView("oftax", parentRowIndex);
            updateSet.add(parentRowIndex);
        }
    }
}

