/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.addition;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.business.utils.ContractTypeUtils;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.ContractPayItemSourceEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.enums.pmct.ChangeTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.business.helper.ContractListHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ContAddAgreementEditPlugin
extends AbstractPmctBillPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    public static final BigDecimal MAX_CONTROL_DECIMAL = new BigDecimal("9999999999999.999");
    public static final BigDecimal MIN_CONTROL_DECIMAL = new BigDecimal("-9999999999999.999");
    public static final String ADDITIONPAYPLAN = "additionpayplan";
    public static final String INCOMEPLAN_PANEL = "incomeplanpanel";
    public static final String JUMP_PROPERTY_CHANGE_EVENT = "jumpPropertyChangeEvent";
    public static final String CUR_MODEL_ROW = "curModelRow";
    private static final String JUMPTOUNAUDITADDITION_CALLBACKID = "jumpToUnAuditAdditionId";
    private static final String ADDITIONID = "additionId";
    private static final String CHANGETYPE_DETAILLISTING = "2";
    private static final String CHANGETYPE_NOTDETAILLISTING = "3";

    public void afterBindData(EventObject e) {
        int rowCount;
        String parentId;
        if (this.getView().getParentView() != null && StringUtils.equals((CharSequence)(parentId = this.getView().getParentView().getEntityId()), (CharSequence)"pmct_dynamiccontract")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
        if ((rowCount = this.getModel().getEntryRowCount("cardentry")) == 1) {
            this.getPageCache().put(CUR_MODEL_ROW, "0");
            this.getView().setVisible(Boolean.FALSE, new String[]{"cardentry"});
        }
        if (rowCount > 0) {
            CardEntry cardEntry = (CardEntry)this.getControl("cardentry");
            cardEntry.selectRows(0);
            cardEntry.entryRowClick(Integer.valueOf(0));
        }
        if (this.isOutContract()) {
            ContractPayItemHelper.setBillNameInPayPlanEntry((IDataModel)this.getModel());
        } else {
            ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("cardentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        String formId = this.getFormId();
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                if ("pmct_outaddagreement".equals(formId)) {
                    this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
                } else {
                    this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_incontract", (Object)beforeF7ViewDetailEvent.getPkId()));
                }
            });
        }
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"cardentry", (CharSequence)control.getKey())) {
            int curRowIndex = evt.getRow();
            this.getPageCache().put(CUR_MODEL_ROW, String.valueOf(curRowIndex));
            int size = this.getModel().getEntryRowCount("entryentity");
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                this.setSubChangeTypeEnable();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (StringUtils.equals((CharSequence)"newentry", (CharSequence)key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("cardentry");
            if (rowIndex < 0) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u6e05\u5355\u6a21\u677f\u3002", (String)"ContAddAgreementEditPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getDynamicObject("contract").getPkValue(), (String)"pmct_contracttpl");
            DynamicObject contStatus = contract.getDynamicObject("contractstatus");
            List statusNums = Stream.of(ContractStatusEnum.CLOSED.getValue()).collect(Collectors.toList());
            if (statusNums.contains(contStatus.getString("number"))) {
                String tip = String.format(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a%s\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ContAddAgreementEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contStatus.getString("name"));
                this.getView().showTipNotification(tip);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"deleteentry")) {
            this.summaryAmountToCardEntry();
            this.summaryAmountToHeadInfo();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"newentry")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.initEntryTaxRate(rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callId = e.getCallBackId();
        if (JUMPTOUNAUDITADDITION_CALLBACKID.equals(callId) && MessageBoxResult.Yes == e.getResult()) {
            String changeId = this.getPageCache().get(ADDITIONID);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pkId", changeId);
            map.put("formId", this.getFormId());
            FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(map);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(formShowParameter);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String property = e.getKey();
        int rowIndex = e.getRowIndex();
        int parentRowIndex = e.getParentRowIndex();
        Object newValue = e.getValue();
        switch (property) {
            case "oftax": 
            case "amount": {
                boolean isAdjustAmount = (Boolean)this.getModel().getValue("isadjustamount");
                if (!isAdjustAmount) break;
                DynamicObjectCollection subEntries = this.getModel().getEntryEntity("entryentity");
                DynamicObject subEntry = (DynamicObject)subEntries.get(rowIndex);
                BigDecimal qty = subEntry.getBigDecimal("qty");
                BigDecimal priceOfTax = subEntry.getBigDecimal("priceoftax");
                BigDecimal price = subEntry.getBigDecimal("price");
                BigDecimal oldAmount = property.equalsIgnoreCase("amount") ? price.multiply(qty) : priceOfTax.multiply(qty);
                boolean isRollBack = ContractEditHelper.amountRollback((IFormView)this.getView(), (DynamicObject)subEntry, (Object)newValue, (Object)oldAmount, (String)property, (int)rowIndex);
                if (!isRollBack) break;
                this.getModel().updateEntryCache(subEntries);
                e.setCancel(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object propValue = e.getChangeSet()[0].getNewValue();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "project": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                if (contract == null || propValue == null || propValue.equals(contract.getDynamicObject("project"))) break;
                this.getModel().setValue("contract", null);
                break;
            }
            case "contract": {
                this.contractChanged(e);
                break;
            }
            case "addamountoftax": {
                this.addAmountOfTaxChanged();
                break;
            }
            case "addamount": {
                this.additionAmountChanged();
                break;
            }
            case "taxrate": {
                this.taxRateChanged();
                break;
            }
            case "materiel": {
                this.materialChanged(e, index);
                break;
            }
            case "affectedqty": {
                this.effectedQtyChanged(e);
                this.effQtyOrChangedOfTaxPriceChanged(index);
                break;
            }
            case "subaddtype": {
                this.subChangedTypeChanged(e, propValue);
                break;
            }
            case "changeqty": {
                this.changedQtyChanged(e);
                break;
            }
            case "changedpriceoftax": {
                this.effQtyOrChangedOfTaxPriceChanged(index);
                break;
            }
            case "qty": 
            case "price": 
            case "subtaxrate": {
                this.qtyOrPriceOrTaxrateChanged(index);
                break;
            }
            case "priceoftax": {
                this.ofTaxPriceChanged(index);
                break;
            }
            case "oftax": {
                this.ofTaxChanged(index);
                break;
            }
            case "amount": {
                this.amountChanged(propValue, index);
                break;
            }
            case "superlistingid": {
                this.superListingIdChanged(index, e.getChangeSet()[0]);
                break;
            }
            case "sysnum": {
                this.validateSysNum(e);
                break;
            }
            case "latesttaxamount": 
            case "latestamount": {
                this.calculationAvgTaxRate();
                break;
            }
            case "isadjustamount": {
                boolean isAdjustAmount = (Boolean)propValue;
                DynamicObjectCollection entityEntry = this.getModel().getDataEntity().getDynamicObjectCollection("cardentry");
                if (isAdjustAmount) break;
                for (DynamicObject entity : entityEntry) {
                    DynamicObjectCollection subEntries = entity.getDynamicObjectCollection("entryentity");
                    boolean isEnterAmount = (Boolean)this.getModel().getValue("isenteramount");
                    boolean isOfTaxContract = (Boolean)this.getModel().getValue("isoftaxcontract");
                    DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                    ContractEditHelper.resetEntryAmountField((DynamicObjectCollection)subEntries, (boolean)isEnterAmount, (boolean)isOfTaxContract, (DynamicObject)currency, (String)"qty", (String)"oftax", (String)"amount", (String)"subtaxrate", (String)"priceoftax", (String)"price", (String)"tax");
                    this.getModel().updateEntryCache(subEntries);
                    this.getView().updateView("entryentity");
                    int rowIndex = 0;
                    for (DynamicObject subEntry : subEntries) {
                        String subChangeType = subEntry.getString("subaddtype");
                        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue())) {
                            this.summaryAmountToSuperListing(rowIndex, -1);
                        }
                        ++rowIndex;
                    }
                    this.summaryAmountToCardEntry();
                    this.summaryAmountToHeadInfo();
                }
                break;
            }
        }
    }

    private void calculationAvgTaxRate() {
        Boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        if (isMultiRate.booleanValue()) {
            BigDecimal latestTaxAmount = (BigDecimal)this.getModel().getValue("latesttaxamount");
            BigDecimal latestAmount = (BigDecimal)this.getModel().getValue("latestamount");
            if (latestAmount != null && latestAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("avgtaxrate", (Object)latestTaxAmount.multiply(new BigDecimal("100")).divide(latestAmount, 100, RoundingMode.HALF_UP));
            }
        }
    }

    private void validateSysNum(PropertyChangedArgs e) {
        String jumpPropertyChangeEvent = this.getView().getPageCache().get(JUMP_PROPERTY_CHANGE_EVENT);
        if (StringUtils.equals((CharSequence)jumpPropertyChangeEvent, (CharSequence)"true")) {
            this.getView().getPageCache().remove(JUMP_PROPERTY_CHANGE_EVENT);
            return;
        }
        Object propValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        HashSet<String> sysNumSet = new HashSet<String>();
        DynamicObjectCollection listModelEntry = this.getModel().getEntryEntity("cardentry");
        DynamicObject currentListModel = (DynamicObject)listModelEntry.get(parentModelRow);
        DynamicObjectCollection entryEntity = currentListModel.getDynamicObjectCollection("entryentity");
        String changeType = (String)this.getModel().getValue("subaddtype", rowIndex, parentModelRow);
        if (StringUtils.equals((CharSequence)changeType, (CharSequence)CHANGETYPE_DETAILLISTING) || StringUtils.equals((CharSequence)changeType, (CharSequence)CHANGETYPE_NOTDETAILLISTING)) {
            DynamicObject[] listings;
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryEntityObj;
                String sysNumber;
                if (i == rowIndex || !StringUtils.isNotEmpty((CharSequence)(sysNumber = (entryEntityObj = (DynamicObject)entryEntity.get(i)).getString("sysnum")))) continue;
                sysNumSet.add(sysNumber);
            }
            if (propValue != null && sysNumSet.contains(propValue.toString())) {
                this.getView().getPageCache().put(JUMP_PROPERTY_CHANGE_EVENT, "true");
                this.getModel().setValue("sysnum", oldValue, rowIndex, parentModelRow);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u81ea\u52a8\u6539\u56de\u539f\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ContAddAgreementEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), propValue, oldValue));
                return;
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            Object listModelId = this.getModel().getValue("listmodelid", parentModelRow);
            QFilter listModelFilter = new QFilter("listingmodel", "=", listModelId);
            qFilters.add(listModelFilter);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                QFilter contractIdFilter = new QFilter("contractid", "=", (Object)contract.getString("id"));
                qFilters.add(contractIdFilter);
            }
            for (DynamicObject listing : listings = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"sysnumber", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]))) {
                String listSysNum = listing.getString("sysnumber");
                if (!StringUtils.isNotEmpty((CharSequence)listSysNum)) continue;
                sysNumSet.add(listSysNum);
            }
            if (propValue != null && sysNumSet.contains(propValue.toString())) {
                this.getView().getPageCache().put(JUMP_PROPERTY_CHANGE_EVENT, "true");
                this.getModel().setValue("sysnum", oldValue, rowIndex, parentModelRow);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u81ea\u52a8\u6539\u56de\u539f\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ContAddAgreementEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), propValue, oldValue));
            }
        }
    }

    private void initEntryTaxRate(int rowIndex) {
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        DynamicObject taxRateObj = (DynamicObject)this.getModel().getValue("taxrate");
        String changeType = (String)this.getModel().getValue("subaddtype", rowIndex);
        if (!isMultiRate && taxRateObj != null && !StringUtils.equals((CharSequence)changeType, (CharSequence)CHANGETYPE_NOTDETAILLISTING)) {
            taxRateObj = BusinessDataServiceHelper.loadSingle((Object)taxRateObj.getPkValue(), (String)"bd_taxrate");
            BigDecimal rate = taxRateObj.getBigDecimal("taxrate");
            this.getModel().setValue("rateobj", taxRateObj.getPkValue(), rowIndex);
            this.getModel().setValue("subtaxrate", (Object)rate, rowIndex);
        }
    }

    private void superListingIdChanged(int index, ChangeData changeData) {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int parentRowIndex = -1;
        int oldParentRowIndex = -1;
        for (int i = 0; i < rowCount; ++i) {
            long newLong;
            long newListingId = (Long)this.getModel().getValue("newlistingid", i);
            if (oldValue != null) {
                long newLong2;
                long oldLong = Long.parseLong(oldValue.toString());
                if (oldLong != 0L && newListingId == oldLong) {
                    oldParentRowIndex = i;
                    continue;
                }
                if (newValue == null || (newLong2 = Long.parseLong(newValue.toString())) == 0L || newListingId != newLong2) continue;
                parentRowIndex = i;
                continue;
            }
            if (newValue == null || (newLong = Long.parseLong(newValue.toString())) == 0L || newListingId != newLong) continue;
            parentRowIndex = i;
        }
        if (parentRowIndex != -1) {
            this.summaryAmountToSuperListing(index, parentRowIndex);
        }
        if (oldParentRowIndex != -1) {
            this.summaryAmountToSuperListing(index, oldParentRowIndex);
        }
    }

    private void materialChanged(PropertyChangedArgs e, int index) {
        DynamicObject material = (DynamicObject)e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        IDataModel model = this.getModel();
        int currentIndex = model.getEntryCurrentRowIndex("entryentity");
        String subChangeType = (String)model.getValue("subaddtype", currentIndex);
        if (material != null) {
            model.setValue("subaddtype", (Object)subChangeType, index);
            if (model.getValue("materiel", index) == null) {
                model.setValue("materiel", material.getPkValue(), index);
                return;
            }
            String name = material.getLocaleString("name").getLocaleValue();
            String number = material.getString("number");
            model.setValue("listname", (Object)name, index);
            model.setValue("listnumber", (Object)number, index);
            DynamicObject measureunit = material.getDynamicObject("baseunit");
            if (measureunit != null) {
                model.setValue("measureunit", measureunit.getPkValue(), index);
            }
            model.setValue("qty", null, index);
            model.setValue("price", null, index);
            model.setValue("priceoftax", null, index);
            model.setValue("oftax", null, index);
            if (oldValue != null) {
                model.setValue("superlistingname", null, index);
                model.setValue("superlistingid", null, index);
            }
            model.setValue("remark", null, index);
        } else {
            model.setValue("listname", null, index);
            model.setValue("listnumber", null, index);
            model.setValue("measureunit", null, index);
            model.setValue("qty", null, index);
            model.setValue("price", null, index);
            model.setValue("priceoftax", null, index);
            model.setValue("oftax", null, index);
            model.setValue("remark", null, index);
        }
    }

    private void contractChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject newContract = (DynamicObject)e.getChangeSet()[0].getNewValue();
        model.setValue("addamountoftax", (Object)0);
        model.setValue("addamount", (Object)0);
        model.setValue("taxamount", (Object)0);
        model.setValue("srcamountoftax", (Object)0);
        model.setValue("srctaxamount", (Object)0);
        model.setValue("srcamount", (Object)0);
        model.setValue("latestamountoftax", (Object)0);
        model.setValue("latesttaxamount", (Object)0);
        model.setValue("latestamount", (Object)0);
        if (newContract == null) {
            model.setValue("taxrate", null);
            model.setValue("avgtaxrate", (Object)0);
            model.setValue("isbasedonlist", (Object)Boolean.FALSE);
            model.deleteEntryData("cardentry");
            if (StringUtils.equals((CharSequence)"pmct_outaddagreement", (CharSequence)this.getFormId())) {
                model.deleteEntryData("payplanentry");
                this.getView().setVisible(Boolean.FALSE, new String[]{ADDITIONPAYPLAN});
            } else {
                model.deleteEntryData("incomeplanentry");
                this.getView().setVisible(Boolean.FALSE, new String[]{INCOMEPLAN_PANEL});
            }
            model.setValue("contattr", null);
            return;
        }
        if (this.checkContractMutex(model, dataEntity, newContract = BusinessDataServiceHelper.loadSingle((Object)newContract.getPkValue(), (String)"pmct_outcontract"))) {
            if (StringUtils.equals((CharSequence)"pmct_outaddagreement", (CharSequence)this.getFormId())) {
                model.deleteEntryData("payplanentry");
            }
            this.setCurrencyFlexSpace(newContract);
            return;
        }
        this.setCurrencyFlexSpace(newContract);
        DynamicObject project = newContract.getDynamicObject("project");
        if (project != null) {
            model.setValue("project", project.getPkValue(), 0);
        } else {
            model.setValue("project", null);
        }
        boolean isMultiRate = newContract.getBoolean("ismultirate");
        model.setValue("ismultirate", (Object)isMultiRate);
        DynamicObject taxRate = newContract.getDynamicObject("lsttaxrate");
        if (taxRate != null) {
            model.setValue("taxrate", taxRate.getPkValue());
        } else {
            taxRate = newContract.getDynamicObject("taxrate");
            if (taxRate != null) {
                model.setValue("taxrate", taxRate.getPkValue());
            }
        }
        BigDecimal totalOfTaxAmount = newContract.getBigDecimal("totaloftaxamount");
        BigDecimal totalAmount = newContract.getBigDecimal("totalamount");
        BigDecimal srcTaxAmout = NumberHelper.subtract((Object)totalOfTaxAmount, (Object)totalAmount);
        model.setValue("srcamountoftax", (Object)totalOfTaxAmount);
        model.setValue("srctaxamount", (Object)srcTaxAmout);
        model.setValue("srcamount", (Object)totalAmount);
        model.setValue("latestamountoftax", (Object)totalOfTaxAmount);
        model.setValue("latestamount", (Object)totalAmount);
        model.setValue("latesttaxamount", (Object)srcTaxAmout);
        if (isMultiRate) {
            model.setValue("taxrate", null);
            model.setValue("avgtaxrate", (Object)this.getTaxRateByAmount(totalAmount, srcTaxAmout));
        }
        DynamicObject contractType = newContract.getDynamicObject("contracttype");
        boolean isonlist = newContract.getBoolean("isonlist");
        model.setValue("isbasedonlist", (Object)isonlist);
        this.isBaseList(model, contractType, isonlist);
        this.loadPlanEntry(model, newContract);
    }

    private void setCurrencyFlexSpace(DynamicObject newContract) {
        boolean isMultiCurrency = this.getModel().getDataEntity().getBoolean("ismulticurrency");
        if (newContract != null) {
            isMultiCurrency = newContract.getBoolean("ismulticurrency");
        }
        if (isMultiCurrency) {
            HashMap ctrl = new HashMap();
            HashMap<String, String> marginMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>();
            marginMap.put("r", "5px");
            styleMap.put("m", marginMap);
            ctrl.put("s", styleMap);
            this.getView().updateControlMetadata("amountinfo", ctrl);
            ctrl = new HashMap();
            marginMap = new HashMap();
            styleMap = new HashMap();
            marginMap.put("l", "5px");
            styleMap.put("m", marginMap);
            ctrl.put("s", styleMap);
            this.getView().updateControlMetadata("stdcurrencyinfo", ctrl);
        } else {
            HashMap ctrl = new HashMap();
            HashMap<String, String> marginMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>();
            marginMap.put("r", "0px");
            styleMap.put("m", marginMap);
            ctrl.put("s", styleMap);
            this.getView().updateControlMetadata("amountinfo", ctrl);
        }
    }

    private void loadPlanEntry(IDataModel model, DynamicObject newContract) {
        if (this.isOutContract()) {
            QFilter contractFilter = new QFilter("contract", "=", newContract.getPkValue());
            QFilter autogenFilter = new QFilter("autogenerated", "=", (Object)Boolean.FALSE);
            QFilter sourceFilter = new QFilter("source", "=", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
            String selectProperties = String.join((CharSequence)",", "supplier", "paytype", "payfeq", "payway", "paypercent", "payamount", "planpaytime", "remarks", "payplanentryid", "nodesetting", "ctrlstrategy", "nodesettingsource", "name");
            DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)selectProperties, (QFilter[])new QFilter[]{contractFilter, autogenFilter, sourceFilter}, (String)"createtime");
            this.getView().setVisible(Boolean.TRUE, new String[]{ADDITIONPAYPLAN});
            this.getPageCache().put("visible", String.valueOf(true));
            DynamicObjectCollection payPlanEntryEntity = model.getEntryEntity("payplanentry");
            payPlanEntryEntity.clear();
            DynamicObjectType entryDt = payPlanEntryEntity.getDynamicObjectType();
            for (DynamicObject payItem : payItems) {
                DynamicObject payPlanObj = new DynamicObject(entryDt);
                payPlanObj.set("supplier", payItem.get("supplier"));
                payPlanObj.set("paytype", (Object)payItem.getString("paytype"));
                payPlanObj.set("payfeq", (Object)payItem.getString("payfeq"));
                payPlanObj.set("payway", (Object)payItem.getDynamicObject("payway"));
                payPlanObj.set("paypercent", (Object)payItem.getBigDecimal("paypercent"));
                payPlanObj.set("payamountoftax", (Object)payItem.getBigDecimal("payamount"));
                payPlanObj.set("planpaytime", (Object)payItem.getDate("planpaytime"));
                payPlanObj.set("remarks", (Object)payItem.getString("remarks"));
                payPlanObj.set("payplansourceid", (Object)payItem.getString("payplanentryid"));
                payPlanObj.set("conplanitemid", (Object)payItem.getString("id"));
                DynamicObject nodeSetting = payItem.getDynamicObject("nodesetting");
                payPlanObj.set("nodesetting", (Object)nodeSetting);
                if (null != nodeSetting && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
                    nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                    String completionStatus = nodeSetting.getString("completionstatus");
                    String status = CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                    payPlanObj.set("taskcompletestate", (Object)status);
                }
                payPlanObj.set("nodesettingsource", (Object)payItem.getString("nodesettingsource"));
                payPlanObj.set("ctrlstrategy", (Object)payItem.getString("ctrlstrategy"));
                payPlanObj.set("conplanitemid", (Object)payItem.getPkValue().toString());
                String payItemName = payItem.getLocaleString("name").getLocaleValue();
                if (StringUtils.isBlank((CharSequence)payItemName)) {
                    payItemName = payItem.getString("name");
                }
                payPlanObj.set("payitemname", (Object)payItemName);
                payPlanEntryEntity.add((Object)payPlanObj);
            }
            this.getView().updateView("payplanentry");
            DynamicObjectCollection payPlanEntry = this.getModel().getEntryEntity("payplanentry");
            boolean isMultiContract = newContract.getBoolean("ismulticontract");
            for (int i = 0; i < payPlanEntry.size(); ++i) {
                DynamicObject entryEntity = (DynamicObject)payPlanEntry.get(i);
                if (null != entryEntity.get("nodesetting")) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"ctrlstrategy"});
            }
            if (!isMultiContract) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"supplier"});
            }
        } else {
            QFilter contractFilter = new QFilter("contract", "=", newContract.getPkValue());
            QFilter autogenFilter = new QFilter("autogenerated", "=", (Object)Boolean.FALSE);
            QFilter sourceFilter = new QFilter("sourcebilltype", "<>", (Object)PayPlanSourceEnum.PERFORM.getValue());
            String selectProperties = String.join((CharSequence)",", "customer", "collecttype", "collectfeq", "collectway", "collectpercent", "collectamount", "plancollecttime", "remarks", "sourcebill", "nodesetting", "ctrlstrategy", "nodesettingsource", "name");
            DynamicObjectCollection incomeItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)selectProperties, (QFilter[])new QFilter[]{contractFilter, autogenFilter, sourceFilter}, (String)"createtime");
            this.getView().setVisible(Boolean.TRUE, new String[]{INCOMEPLAN_PANEL});
            this.getPageCache().put("visible", String.valueOf(true));
            DynamicObjectCollection incomePlanEntryEntity = model.getEntryEntity("incomeplanentry");
            incomePlanEntryEntity.clear();
            DynamicObjectType entryDt = incomePlanEntryEntity.getDynamicObjectType();
            for (DynamicObject incomeItem : incomeItems) {
                DynamicObject incomePlanObj = new DynamicObject(entryDt);
                incomePlanObj.set("customer", incomeItem.get("customer"));
                incomePlanObj.set("incometype", (Object)incomeItem.getString("collecttype"));
                incomePlanObj.set("incomefeq", (Object)incomeItem.getString("collectfeq"));
                incomePlanObj.set("incomeway", (Object)incomeItem.getDynamicObject("collectway"));
                incomePlanObj.set("incomepercent", (Object)incomeItem.getBigDecimal("collectpercent"));
                incomePlanObj.set("incomeamountoftax", (Object)incomeItem.getBigDecimal("collectamount"));
                incomePlanObj.set("planincometime", (Object)incomeItem.getDate("plancollecttime"));
                incomePlanObj.set("remarks", (Object)incomeItem.getString("remarks"));
                incomePlanObj.set("conplanitemid", (Object)incomeItem.getString("id"));
                incomePlanObj.set("incomeplansourceid", (Object)String.valueOf(incomeItem.getLong("sourcebill")));
                DynamicObject nodeSetting = incomeItem.getDynamicObject("nodesetting");
                incomePlanObj.set("nodesetting", (Object)nodeSetting);
                if (null != nodeSetting && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
                    nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                    String completionStatus = nodeSetting.getString("completionstatus");
                    String status = CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                    incomePlanObj.set("taskcompletestate", (Object)status);
                }
                incomePlanObj.set("nodesettingsource", (Object)incomeItem.getString("nodesettingsource"));
                incomePlanObj.set("ctrlstrategy", (Object)incomeItem.getString("ctrlstrategy"));
                incomePlanObj.set("incomeitemname", (Object)incomeItem.getString("name"));
                incomePlanEntryEntity.add((Object)incomePlanObj);
            }
            this.getView().updateView("incomeplanentry");
            DynamicObjectCollection payPlanEntry = this.getModel().getEntryEntity("incomeplanentry");
            for (int i = 0; i < payPlanEntry.size(); ++i) {
                DynamicObject entryEntity = (DynamicObject)payPlanEntry.get(i);
                if (null != entryEntity.get("nodesetting")) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"ctrlstrategy"});
            }
        }
    }

    private void isBaseList(IDataModel model, DynamicObject contractType, boolean isonlist) {
        if (isonlist) {
            if (contractType != null) {
                DynamicObjectCollection listConfigs = ContractTypeUtils.getListConfigs((DynamicObject)contractType);
                if (listConfigs == null || listConfigs.size() <= 0) {
                    return;
                }
                model.deleteEntryData("cardentry");
                for (DynamicObject listConfig : listConfigs) {
                    String tabname = listConfig.getString("tabname");
                    String cmpRule = listConfig.getString("computerule");
                    int rowIndex = model.createNewEntryRow("cardentry");
                    model.setValue("modelname", (Object)tabname, rowIndex);
                    model.setValue("listmodelid", listConfig.getPkValue(), rowIndex);
                    if (StringUtils.equals((CharSequence)"00", (CharSequence)cmpRule)) {
                        model.setValue("cmptype", (Object)"(+)", rowIndex);
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)"01", (CharSequence)cmpRule)) {
                        model.setValue("cmptype", (Object)"(-)", rowIndex);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)"02", (CharSequence)cmpRule)) continue;
                    model.setValue("cmptype", (Object)"(0)", rowIndex);
                }
                CardEntry cardEntry = (CardEntry)this.getControl("cardentry");
                cardEntry.selectRows(0);
                if (listConfigs.size() == 1) {
                    this.getPageCache().put(CUR_MODEL_ROW, "0");
                    this.getView().setVisible(Boolean.FALSE, new String[]{"cardentry"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"cardentry"});
                }
            }
        } else {
            model.deleteEntryData("cardentry");
        }
    }

    private boolean checkContractMutex(IDataModel model, DynamicObject dataEntity, DynamicObject newContract) {
        QFilter contractFilter = new QFilter("contract", "=", newContract.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "not in", (Object)StatusEnum.CHECKED.getValue());
        QFilter isNeedSettleFilter = new QFilter("isneedsettle", "=", (Object)Boolean.TRUE);
        QFilter unContainFilter = new QFilter("id", "!=", (Object)Long.parseLong(dataEntity.getPkValue().toString()));
        String claimFormBillId = null;
        String contractRevisionFormId = null;
        String formId = this.getView().getFormShowParameter().getFormId();
        if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_inaddagreement")) {
            claimFormBillId = "pmct_inclaimbill";
            contractRevisionFormId = "pmct_incontractrevision";
        } else if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outaddagreement")) {
            claimFormBillId = "pmct_outclaimbill";
            contractRevisionFormId = "pmct_outcontractrevision";
        }
        DynamicObject[] inContractRevisions = BusinessDataServiceHelper.load((String)contractRevisionFormId, (String)"id", (QFilter[])new QFilter[]{billStatusFilter, contractFilter, unContainFilter});
        DynamicObject[] inClaims = BusinessDataServiceHelper.load((String)claimFormBillId, (String)"id", (QFilter[])new QFilter[]{billStatusFilter, isNeedSettleFilter, contractFilter, unContainFilter});
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, contractFilter, unContainFilter});
        DynamicObject[] contAddAgreements = BusinessDataServiceHelper.load((String)formId, (String)"id", (QFilter[])new QFilter[]{billStatusFilter, contractFilter, unContainFilter});
        if (inClaims.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u8865\u5145\u534f\u8bae\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7d22\u8d54\u5355\uff0c\u8bf7\u5f85\u7d22\u8d54\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"ContAddAgreementEditPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("contract", null);
            return true;
        }
        if (contractRevisions.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u8865\u5145\u534f\u8bae\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4fee\u8ba2\u5355\uff0c\u8bf7\u5f85\u4fee\u8ba2\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"ContAddAgreementEditPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("contract", null);
            return true;
        }
        if (inContractRevisions.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u8865\u5145\u534f\u8bae\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u53d8\u66f4\u5355\uff0c\u8bf7\u5f85\u53d8\u66f4\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"ContAddAgreementEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("contract", null);
            return true;
        }
        if (contAddAgreements.length > 0) {
            model.setValue("contract", null);
            DynamicObject contAddAgreement = contAddAgreements[0];
            this.getPageCache().put(ADDITIONID, contAddAgreement.getPkValue().toString());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u8865\u5145\u534f\u8bae\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u8865\u5145\u534f\u8bae\u5355\u3002\u662f\u5426\u8df3\u8f6c\u5230\u672a\u5ba1\u6838\u7684\u8865\u5145\u534f\u8bae\u5355\u8fdb\u884c\u5904\u7406\uff1f", (String)"ContAddAgreementEditPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(JUMPTOUNAUDITADDITION_CALLBACKID, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private void addAmountOfTaxChanged() {
        IDataModel model = this.getModel();
        BigDecimal addAmountOfTax = (BigDecimal)model.getValue("addamountoftax");
        boolean isMultiRate = (Boolean)model.getValue("ismultirate");
        DynamicObject taxRateObject = (DynamicObject)model.getValue("taxrate");
        if (!isMultiRate && taxRateObject != null) {
            String jumpPropertyChangeEvent = this.getPageCache().get(JUMP_PROPERTY_CHANGE_EVENT);
            if (StringUtils.equals((CharSequence)jumpPropertyChangeEvent, (CharSequence)"true")) {
                this.getPageCache().remove(JUMP_PROPERTY_CHANGE_EVENT);
                return;
            }
            BigDecimal taxRate = taxRateObject.getBigDecimal("taxrate");
            BigDecimal addAmount = this.getWithoutTaxValue(taxRate, addAmountOfTax);
            BigDecimal taxAmount = addAmountOfTax.subtract(addAmount);
            this.getPageCache().put(JUMP_PROPERTY_CHANGE_EVENT, "true");
            model.setValue("addamount", (Object)addAmount);
            model.setValue("taxamount", (Object)taxAmount);
            BigDecimal srcAmountoftax = (BigDecimal)model.getValue("srcamountoftax");
            BigDecimal srcTaxAmount = (BigDecimal)model.getValue("srctaxamount");
            BigDecimal srcAmount = (BigDecimal)model.getValue("srcamount");
            model.setValue("latestamountoftax", (Object)NumberHelper.add((Object)srcAmountoftax, (Object)addAmountOfTax));
            model.setValue("latesttaxamount", (Object)NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount));
            model.setValue("latestamount", (Object)NumberHelper.add((Object)srcAmount, (Object)addAmount));
        } else if (isMultiRate) {
            BigDecimal addAmount = (BigDecimal)model.getValue("addamount");
            BigDecimal taxAmount = addAmountOfTax.subtract(addAmount);
            model.setValue("taxamount", (Object)taxAmount);
            BigDecimal srcAmountoftax = (BigDecimal)model.getValue("srcamountoftax");
            BigDecimal srcTaxAmount = (BigDecimal)model.getValue("srctaxamount");
            BigDecimal srcAmount = (BigDecimal)model.getValue("srcamount");
            model.setValue("latestamountoftax", (Object)NumberHelper.add((Object)srcAmountoftax, (Object)addAmountOfTax));
            model.setValue("latesttaxamount", (Object)NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount));
            model.setValue("latestamount", (Object)NumberHelper.add((Object)srcAmount, (Object)addAmount));
            if (taxAmount != null && addAmount.compareTo(BigDecimal.ZERO) != 0) {
                model.setValue("avgtaxrate", (Object)this.getTaxRateByAmount(NumberHelper.add((Object)srcAmount, (Object)addAmount), NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount)));
            } else {
                model.setValue("avgtaxrate", (Object)0);
            }
        }
    }

    private void additionAmountChanged() {
        IDataModel model = this.getModel();
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        DynamicObject taxRateObject = (DynamicObject)model.getValue("taxrate");
        BigDecimal additionAmount = (BigDecimal)model.getValue("addamount");
        if (!isMultiRate && taxRateObject != null) {
            String jumpPropertyChangeEvent = this.getPageCache().get(JUMP_PROPERTY_CHANGE_EVENT);
            if (StringUtils.equals((CharSequence)jumpPropertyChangeEvent, (CharSequence)"true")) {
                this.getPageCache().remove(JUMP_PROPERTY_CHANGE_EVENT);
                return;
            }
            BigDecimal taxRate = taxRateObject.getBigDecimal("taxrate");
            BigDecimal rate = taxRate.divide(BigDecimal.valueOf(100L));
            BigDecimal addAmountOfTax = additionAmount.multiply(BigDecimal.ONE.add(rate));
            BigDecimal taxAmount = addAmountOfTax.subtract(additionAmount);
            this.getPageCache().put(JUMP_PROPERTY_CHANGE_EVENT, "true");
            model.setValue("addamountoftax", (Object)addAmountOfTax);
            model.setValue("taxamount", (Object)taxAmount);
            BigDecimal srcAmountoftax = (BigDecimal)model.getValue("srcamountoftax");
            BigDecimal srcTaxAmount = (BigDecimal)model.getValue("srctaxamount");
            BigDecimal srcAmount = (BigDecimal)model.getValue("srcamount");
            model.setValue("latestamountoftax", (Object)NumberHelper.add((Object)srcAmountoftax, (Object)addAmountOfTax));
            model.setValue("latesttaxamount", (Object)NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount));
            model.setValue("latestamount", (Object)NumberHelper.add((Object)srcAmount, (Object)additionAmount));
        }
        if (isMultiRate) {
            BigDecimal additionOfTaxAmount = (BigDecimal)model.getValue("addamountoftax");
            BigDecimal taxAmount = additionOfTaxAmount.subtract(additionAmount);
            this.getModel().setValue("taxamount", (Object)taxAmount);
            BigDecimal srcAmountoftax = (BigDecimal)model.getValue("srcamountoftax");
            BigDecimal srcTaxAmount = (BigDecimal)model.getValue("srctaxamount");
            BigDecimal srcAmount = (BigDecimal)model.getValue("srcamount");
            model.setValue("latestamountoftax", (Object)NumberHelper.add((Object)srcAmountoftax, (Object)additionOfTaxAmount));
            model.setValue("latesttaxamount", (Object)NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount));
            model.setValue("latestamount", (Object)NumberHelper.add((Object)srcAmount, (Object)additionAmount));
            if (taxAmount != null && additionAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("avgtaxrate", (Object)this.getTaxRateByAmount(NumberHelper.add((Object)srcAmount, (Object)additionAmount), NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount)));
            } else {
                this.getModel().setValue("avgtaxrate", (Object)0);
            }
        }
    }

    private void taxRateChanged() {
        DynamicObject taxRateObject = (DynamicObject)this.getModel().getValue("taxrate");
        if (taxRateObject != null) {
            BigDecimal revisionOfTaxAmount = (BigDecimal)this.getModel().getValue("addamountoftax");
            BigDecimal revisionAmount = this.getWithoutTaxValue(taxRateObject.getBigDecimal("taxrate"), revisionOfTaxAmount);
            BigDecimal taxAmount = revisionOfTaxAmount.subtract(revisionAmount);
            this.getModel().setValue("addamount", (Object)revisionAmount);
            this.getModel().setValue("taxamount", (Object)taxAmount);
        }
    }

    private void effectedQtyChanged(PropertyChangedArgs e) {
        BigDecimal qty;
        BigDecimal affectedQty;
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String subChangeType = (String)this.getModel().getValue("subaddtype", rowIndex);
        if (StringUtils.equals((CharSequence)"1", (CharSequence)subChangeType) && NumberHelper.compareValue((Object)(affectedQty = (BigDecimal)this.getModel().getValue("affectedqty", rowIndex)), (Object)(qty = (BigDecimal)this.getModel().getValue("qty", rowIndex))) > 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u53d7\u5f71\u54cd\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u539f\u6570\u91cf\u201c%s\u201d\u3002", (String)"ContAddAgreementEditPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), qty.toString()));
            this.getModel().setValue("affectedqty", e.getChangeSet()[0].getOldValue(), rowIndex);
        }
    }

    private void effQtyOrChangedOfTaxPriceChanged(int rowIndex) {
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        String subChangeType = (String)this.getModel().getValue("subaddtype", rowIndex, parentModelRow);
        if (StringUtils.equals((CharSequence)"1", (CharSequence)subChangeType)) {
            BigDecimal curChangePrice = (BigDecimal)this.getModel().getValue("changedpriceoftax", rowIndex, parentModelRow);
            BigDecimal curChangeQty = (BigDecimal)this.getModel().getValue("affectedqty", rowIndex, parentModelRow);
            BigDecimal curTaxPrice = (BigDecimal)this.getModel().getValue("priceoftax", rowIndex, parentModelRow);
            BigDecimal changedTaxPrice = NumberHelper.multiply((Object)curChangePrice.subtract(curTaxPrice), (Object)curChangeQty);
            if (this.checkIsOutOfRand(changedTaxPrice)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContAddAgreementEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("affectedqty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
            this.getModel().setValue("changeamountoftax", (Object)changedTaxPrice, rowIndex, parentModelRow);
            BigDecimal lastTotalTaxAmount = (BigDecimal)this.getModel().getValue("oftax", rowIndex, parentModelRow);
            BigDecimal afterChangedTotalAmount = NumberHelper.add((Object)lastTotalTaxAmount, (Object)changedTaxPrice);
            if (!this.checkIsOutOfRand(afterChangedTotalAmount)) {
                this.getModel().setValue("totalchangedamtoftax", (Object)afterChangedTotalAmount, rowIndex, parentModelRow);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContAddAgreementEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("affectedqty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
        }
        if (!this.summaryAmountToCardEntry()) {
            this.getModel().setValue("affectedqty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
            return;
        }
        if (!this.summaryAmountToHeadInfo()) {
            this.getModel().setValue("affectedqty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
    }

    private void subChangedTypeChanged(PropertyChangedArgs e, Object propValue) {
        IDataModel model = this.getModel();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        model.setValue("listid", null, rowIndex);
        model.setValue("parentlisting", null, rowIndex);
        model.setValue("listnumber", (Object)"", rowIndex);
        model.setValue("listname", (Object)"", rowIndex);
        model.setValue("measureunit", null, rowIndex);
        model.setValue("qty", null, rowIndex);
        model.setValue("price", null, rowIndex);
        model.setValue("amount", null, rowIndex);
        model.setValue("rateobj", null, rowIndex);
        model.setValue("tax", null, rowIndex);
        model.setValue("priceoftax", null, rowIndex);
        model.setValue("oftax", null, rowIndex);
        model.setValue("settledqty", (Object)0, rowIndex);
        model.setValue("settledamountoftax", (Object)0, rowIndex);
        model.setValue("changeqty", (Object)0, rowIndex);
        model.setValue("affectedqty", null, rowIndex);
        model.setValue("changedpriceoftax", null, rowIndex);
        model.setValue("changeamountoftax", null, rowIndex);
        model.setValue("totalchangedamtoftax", null, rowIndex);
        model.setValue("remark", (Object)"", rowIndex);
        model.setValue("materiel", null, rowIndex);
        model.setValue("subtaxrate", (Object)0, rowIndex);
        model.setValue("superlistingid", null, rowIndex);
        model.setValue("superlistingname", null, rowIndex);
        if (StringUtils.equals((CharSequence)propValue.toString(), (CharSequence)CHANGETYPE_DETAILLISTING) || StringUtils.equals((CharSequence)propValue.toString(), (CharSequence)CHANGETYPE_NOTDETAILLISTING)) {
            ORM orm = ORM.create();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_contractlist");
            long genLongId = orm.genLongId((IDataEntityType)dt);
            model.setValue("newlistingid", (Object)genLongId, rowIndex);
            model.setValue("sysnum", null, rowIndex);
            String sysNum = this.genSysNumber(propValue.toString());
            model.setValue("sysnum", (Object)sysNum, rowIndex);
        } else {
            model.setValue("newlistingid", (Object)0, rowIndex);
            model.setValue("sysnum", null, rowIndex);
        }
        this.initEntryTaxRate(rowIndex);
        if ((StringUtils.equals((CharSequence)propValue.toString(), (CharSequence)CHANGETYPE_DETAILLISTING) || StringUtils.equals((CharSequence)propValue.toString(), (CharSequence)CHANGETYPE_NOTDETAILLISTING)) && this.isOutContract()) {
            this.setDefaultBudget(rowIndex);
        }
    }

    private String genSysNumber(String type) {
        String sysNum = null;
        if (StringUtils.equals((CharSequence)type, (CharSequence)CHANGETYPE_DETAILLISTING) || StringUtils.equals((CharSequence)type, (CharSequence)CHANGETYPE_NOTDETAILLISTING)) {
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> excludeSysNum = new ArrayList<String>();
            for (DynamicObject listEntryObj : subEntryEntity) {
                String subChangeType = listEntryObj.getString("subaddtype");
                if (!StringUtils.equals((CharSequence)subChangeType, (CharSequence)CHANGETYPE_DETAILLISTING) && !StringUtils.equals((CharSequence)subChangeType, (CharSequence)CHANGETYPE_NOTDETAILLISTING)) continue;
                String entrySysNum = listEntryObj.getString("sysnum");
                excludeSysNum.add(entrySysNum);
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            int parentRowIndex = this.getModel().getEntryCurrentRowIndex("cardentry");
            Object listModelId = this.getModel().getValue("listmodelid", parentRowIndex);
            QFilter listModelFilter = new QFilter("listingmodel", "=", listModelId);
            qFilters.add(listModelFilter);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                QFilter contractIdFilter = new QFilter("contractid", "=", (Object)contract.getString("id"));
                qFilters.add(contractIdFilter);
            }
            QFilter parentFilter = new QFilter("parent", "=", (Object)0);
            qFilters.add(parentFilter);
            DynamicObject[] listings = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"sysnumber", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
            sysNum = ContractListHelper.genSysNumberRule((DynamicObject[])listings, excludeSysNum);
        }
        return sysNum;
    }

    protected void setDefaultBudget(int rowIndex) {
    }

    private void changedQtyChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        String subChangeType = (String)this.getModel().getValue("subaddtype", rowIndex, parentModelRow);
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)"0")) {
            BigDecimal qty;
            BigDecimal curChangeQty = (BigDecimal)this.getModel().getValue("changeqty", rowIndex, parentModelRow);
            if (NumberHelper.compareValue((Object)curChangeQty.add(qty = (BigDecimal)this.getModel().getValue("qty", rowIndex, parentModelRow)), (Object)BigDecimal.ZERO) < 0) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u539f\u6570\u91cf\u7684\u8d1f\u503c\uff08-%s\uff09\u3002", (String)"ContAddAgreementEditPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), qty.toString()));
                this.getModel().setValue("changeqty", e.getChangeSet()[0].getOldValue(), rowIndex, parentModelRow);
                return;
            }
            BigDecimal curTaxPrice = (BigDecimal)this.getModel().getValue("priceoftax", rowIndex, parentModelRow);
            BigDecimal changedTaxPrice = NumberHelper.multiply((Object)curTaxPrice, (Object)curChangeQty);
            if (this.checkIsOutOfRand(changedTaxPrice)) {
                this.getModel().setValue("changeqty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
            this.getModel().setValue("changeamountoftax", (Object)changedTaxPrice, rowIndex, parentModelRow);
            BigDecimal lastTotalTaxAmount = (BigDecimal)this.getModel().getValue("oftax", rowIndex, parentModelRow);
            BigDecimal afterChangedTotalAmount = lastTotalTaxAmount.add(changedTaxPrice);
            if (!this.checkIsOutOfRand(afterChangedTotalAmount)) {
                this.getModel().setValue("totalchangedamtoftax", (Object)afterChangedTotalAmount, rowIndex, parentModelRow);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContAddAgreementEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("changeqty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
        }
        if (!this.summaryAmountToCardEntry()) {
            this.getModel().setValue("changeqty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
        if (!this.summaryAmountToHeadInfo()) {
            this.getModel().setValue("changeqty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
    }

    private void qtyOrPriceOrTaxrateChanged(int rowIndex) {
        String curModelRow;
        int parentModelRow;
        IDataModel model = this.getModel();
        String subChangeType = (String)model.getValue("subaddtype", rowIndex, parentModelRow = Integer.parseInt(curModelRow = this.getPageCache().get(CUR_MODEL_ROW)));
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)CHANGETYPE_DETAILLISTING)) {
            BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex, parentModelRow);
            BigDecimal price = (BigDecimal)model.getValue("price", rowIndex, parentModelRow);
            BigDecimal subTaxRate = (BigDecimal)model.getValue("subtaxrate", rowIndex, parentModelRow);
            BigDecimal amount = NumberHelper.multiply((Object)qty, (Object)price);
            BigDecimal priceOfTax = this.getOfTaxValue(subTaxRate, price);
            BigDecimal oftax = NumberHelper.multiply((Object)priceOfTax, (Object)qty);
            if (this.checkIsOutOfRand(amount, priceOfTax, oftax, NumberHelper.subtract((Object)oftax, (Object)amount))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContAddAgreementEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                model.setValue("qty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
            model.beginInit();
            model.setValue("amount", (Object)amount, rowIndex, parentModelRow);
            model.setValue("priceoftax", (Object)priceOfTax, rowIndex, parentModelRow);
            model.setValue("oftax", (Object)oftax, rowIndex, parentModelRow);
            model.setValue("tax", (Object)NumberHelper.subtract((Object)oftax, (Object)amount), rowIndex, parentModelRow);
            model.endInit();
            this.getView().updateView("entryentity");
        }
        if (!this.summaryAmountToCardEntry()) {
            model.setValue("qty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
            return;
        }
        if (!this.summaryAmountToHeadInfo()) {
            model.setValue("qty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
    }

    private void ofTaxChanged(int rowIndex) {
        String curModelRow;
        int parentModelRow;
        IDataModel model = this.getModel();
        String subChangeType = (String)model.getValue("subaddtype", rowIndex, parentModelRow = Integer.parseInt(curModelRow = this.getPageCache().get(CUR_MODEL_ROW)));
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)CHANGETYPE_DETAILLISTING)) {
            BigDecimal oftax = (BigDecimal)model.getValue("oftax", rowIndex, parentModelRow);
            boolean isAdjustAmount = (Boolean)this.getModel().getValue("isadjustamount");
            if (isAdjustAmount) {
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
                this.getModel().setValue("tax", (Object)oftax.subtract(amount), rowIndex, parentModelRow);
            } else {
                BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex, parentModelRow);
                BigDecimal subTaxRate = (BigDecimal)model.getValue("subtaxrate", rowIndex, parentModelRow);
                BigDecimal priceOfTax = (BigDecimal)model.getValue("priceoftax", rowIndex, parentModelRow);
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex, parentModelRow);
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    priceOfTax = NumberHelper.divide((Object)oftax, (Object)qty, (int)10, (RoundingMode)RoundingMode.HALF_UP);
                    price = this.getWithoutTaxValue(subTaxRate, priceOfTax);
                }
                BigDecimal amount = NumberHelper.multiply((Object)qty, (Object)price);
                if (this.checkIsOutOfRand(amount, price, priceOfTax, NumberHelper.subtract((Object)oftax, (Object)amount))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContAddAgreementEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    model.setValue("oftax", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                    return;
                }
                model.beginInit();
                model.setValue("amount", (Object)amount, rowIndex, parentModelRow);
                model.setValue("priceoftax", (Object)priceOfTax, rowIndex, parentModelRow);
                model.setValue("price", (Object)price, rowIndex, parentModelRow);
                model.setValue("tax", (Object)NumberHelper.subtract((Object)oftax, (Object)amount), rowIndex, parentModelRow);
                model.endInit();
                this.getView().updateView("entryentity");
            }
            this.summaryAmountToSuperListing(rowIndex, -1);
        }
        if (!this.summaryAmountToCardEntry()) {
            model.setValue("oftax", (Object)BigDecimal.ZERO, rowIndex);
            return;
        }
        if (!this.summaryAmountToHeadInfo()) {
            model.setValue("oftax", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    protected void amountChanged(Object propNewValue, int rowIndex) {
        int parentModelRow = Integer.parseInt(this.getPageCache().get(CUR_MODEL_ROW));
        String subChangeType = (String)this.getModel().getValue("subaddtype", rowIndex, parentModelRow);
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue())) {
            BigDecimal amount = (BigDecimal)propNewValue;
            boolean isAdjustAmount = (Boolean)this.getModel().getValue("isadjustamount");
            if (isAdjustAmount) {
                BigDecimal ofTax = (BigDecimal)this.getModel().getValue("oftax");
                this.getModel().setValue("tax", (Object)ofTax.subtract(amount), rowIndex, parentModelRow);
            } else {
                this.getModel().beginInit();
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                int pricePrecision = CurrencyHelper.getPriceAccuracy((DynamicObject)currency);
                BigDecimal subTaxRate = ((BigDecimal)this.getModel().getValue("subtaxrate", rowIndex, parentModelRow)).divide(BigDecimal.valueOf(100L), 10, 4);
                BigDecimal ofTax = amount.multiply(BigDecimal.ONE.add(subTaxRate));
                this.getModel().setValue("oftax", (Object)ofTax, rowIndex, parentModelRow);
                this.getModel().setValue("tax", (Object)ofTax.subtract(amount), rowIndex, parentModelRow);
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex, parentModelRow);
                if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal price = amount.divide(qty, pricePrecision, 4);
                    this.getModel().setValue("price", (Object)price, rowIndex, parentModelRow);
                    this.getModel().setValue("priceoftax", (Object)price.multiply(BigDecimal.ONE.add(subTaxRate)), rowIndex, parentModelRow);
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            }
            this.summaryAmountToSuperListing(rowIndex, -1);
        }
        if (!this.summaryAmountToCardEntry()) {
            this.getModel().setValue("oftax", (Object)BigDecimal.ZERO, rowIndex);
            return;
        }
        if (!this.summaryAmountToHeadInfo()) {
            this.getModel().setValue("oftax", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private void ofTaxPriceChanged(int rowIndex) {
        String curModelRow;
        int parentModelRow;
        IDataModel model = this.getModel();
        String subChangeType = (String)model.getValue("subaddtype", rowIndex, parentModelRow = Integer.parseInt(curModelRow = this.getPageCache().get(CUR_MODEL_ROW)));
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)CHANGETYPE_DETAILLISTING)) {
            BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex, parentModelRow);
            BigDecimal subTaxRate = (BigDecimal)model.getValue("subtaxrate", rowIndex, parentModelRow);
            BigDecimal priceOfTax = (BigDecimal)model.getValue("priceoftax", rowIndex, parentModelRow);
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            int pricePrecision = CurrencyHelper.getPriceAccuracy((DynamicObject)currency);
            BigDecimal oftax = NumberHelper.multiply((Object)priceOfTax, (Object)qty);
            BigDecimal price = priceOfTax.divide(BigDecimal.ONE.add(subTaxRate.divide(new BigDecimal(100))), pricePrecision, 4);
            BigDecimal amount = NumberHelper.multiply((Object)qty, (Object)price);
            if (this.checkIsOutOfRand(amount, price, oftax, NumberHelper.subtract((Object)oftax, (Object)amount))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContAddAgreementEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                model.setValue("priceoftax", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
            model.beginInit();
            model.setValue("amount", (Object)amount, rowIndex, parentModelRow);
            model.setValue("price", (Object)price, rowIndex, parentModelRow);
            model.setValue("oftax", (Object)oftax, rowIndex, parentModelRow);
            model.setValue("tax", (Object)NumberHelper.subtract((Object)oftax, (Object)amount), rowIndex, parentModelRow);
            model.endInit();
            this.getView().updateView("entryentity");
        }
        if (!this.summaryAmountToCardEntry()) {
            model.setValue("priceoftax", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
            return;
        }
        if (!this.summaryAmountToHeadInfo()) {
            model.setValue("priceoftax", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
    }

    private String getFormId() {
        return this.getView().getFormShowParameter().getFormId();
    }

    private void setSubChangeTypeEnable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> hasSubIdSet = new HashSet<Long>();
        for (DynamicObject entry : entryEntity) {
            if (!StringUtils.equals((CharSequence)CHANGETYPE_DETAILLISTING, (CharSequence)entry.getString("subaddtype")) || entry.getDynamicObject("parentlisting") != null || entry.getLong("superlistingid") == 0L) continue;
            hasSubIdSet.add(entry.getLong("superlistingid"));
        }
        int rowCount = entryEntity.size();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            if (StringUtils.equals((CharSequence)CHANGETYPE_NOTDETAILLISTING, (CharSequence)entry.getString("subaddtype")) && hasSubIdSet.contains(entry.getLong("newlistingid"))) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"subaddtype"});
                continue;
            }
            if (!StringUtils.equals((CharSequence)CHANGETYPE_NOTDETAILLISTING, (CharSequence)entry.getString("subaddtype"))) continue;
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"subaddtype"});
        }
    }

    private void summaryAmountToSuperListing(int rowIndex, int parentIndex) {
        IDataModel model = this.getModel();
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        long superId = 0L;
        if (parentIndex != -1) {
            superId = Long.parseLong(model.getValue("newlistingid", parentIndex).toString());
        } else if (model.getValue("superlistingid", rowIndex, parentModelRow) != null) {
            superId = Long.parseLong(model.getValue("superlistingid", rowIndex, parentModelRow).toString());
        } else {
            return;
        }
        if (superId != 0L) {
            DynamicObject cardEntry = model.getEntryRowEntity("cardentry", parentModelRow);
            DynamicObjectCollection subEntrys = (DynamicObjectCollection)cardEntry.get("entryentity");
            int rowCount = subEntrys.getRowCount();
            int parentRowIndex = -1;
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTaxAmount = BigDecimal.ZERO;
            BigDecimal totalOfTaxAmount = BigDecimal.ZERO;
            for (int i = 0; i < rowCount; ++i) {
                long newListingId = Long.parseLong(model.getValue("newlistingid", i, parentModelRow).toString());
                long superListingId = Long.parseLong(model.getValue("superlistingid", i, parentModelRow).toString());
                if (newListingId == superId) {
                    parentRowIndex = i;
                    continue;
                }
                if (superListingId != superId) continue;
                totalAmount = NumberHelper.add((Object)model.getValue("amount", i, parentModelRow), (Object)totalAmount);
                totalTaxAmount = NumberHelper.add((Object)model.getValue("tax", i, parentModelRow), (Object)totalTaxAmount);
                totalOfTaxAmount = NumberHelper.add((Object)model.getValue("oftax", i, parentModelRow), (Object)totalOfTaxAmount);
            }
            if (parentRowIndex != -1) {
                model.setValue("amount", (Object)totalAmount, parentRowIndex, parentModelRow);
                model.setValue("tax", (Object)totalTaxAmount, parentRowIndex, parentModelRow);
                model.setValue("oftax", (Object)totalOfTaxAmount, parentRowIndex, parentModelRow);
            }
        }
    }

    private boolean summaryAmountToCardEntry() {
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int cardRowIndex = Integer.parseInt(curModelRow);
        DynamicObject cardEntry = this.getModel().getEntryRowEntity("cardentry", cardRowIndex);
        DynamicObjectCollection subEntrys = (DynamicObjectCollection)cardEntry.get("entryentity");
        BigDecimal additionAmountOfTax = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        HashMap<Object, DynamicObject> parentMap = new HashMap<Object, DynamicObject>();
        for (int j = 0; j < subEntrys.size(); ++j) {
            DynamicObject additionEntry = (DynamicObject)subEntrys.get(j);
            String string = additionEntry.getString("subaddtype");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)string) || StringUtils.equals((CharSequence)"1", (CharSequence)string)) {
                BigDecimal ofTaxAmount = (BigDecimal)additionEntry.get("changeamountoftax");
                BigDecimal amount = this.getWithoutTaxValue(additionEntry.getBigDecimal("subtaxrate"), ofTaxAmount);
                BigDecimal tax = NumberHelper.subtract((Object)ofTaxAmount, (Object)amount);
                taxAmount = NumberHelper.add((Object)taxAmount, (Object)tax);
                additionAmountOfTax = NumberHelper.add((Object)additionAmountOfTax, (Object)ofTaxAmount);
                continue;
            }
            if (!StringUtils.equals((CharSequence)CHANGETYPE_DETAILLISTING, (CharSequence)string)) continue;
            BigDecimal oftax = (BigDecimal)additionEntry.get("oftax");
            BigDecimal tax = (BigDecimal)additionEntry.get("tax");
            additionAmountOfTax = NumberHelper.add((Object)additionAmountOfTax, (Object)oftax);
            taxAmount = NumberHelper.add((Object)taxAmount, (Object)tax);
            DynamicObject parent = this.getOriginalParent(additionEntry, subEntrys);
            if (parent == null || !parent.getBoolean("isleaf")) continue;
            parentMap.put(parent.getPkValue(), BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"pmct_contractlist"));
        }
        Set entries = parentMap.entrySet();
        for (Map.Entry entry : entries) {
            DynamicObject parent = (DynamicObject)entry.getValue();
            BigDecimal lastOfTaxAmount = parent.getBigDecimal("lstoftaxamount");
            BigDecimal taxrate = parent.getBigDecimal("taxrate");
            BigDecimal amount = this.getWithoutTaxValue(taxrate, lastOfTaxAmount);
            BigDecimal tax = NumberHelper.subtract((Object)lastOfTaxAmount, (Object)amount);
            additionAmountOfTax = NumberHelper.subtract((Object)additionAmountOfTax, (Object)lastOfTaxAmount);
            taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)tax);
        }
        boolean isOutOfRand = this.checkIsOutOfRand(additionAmountOfTax, taxAmount, NumberHelper.subtract((Object)additionAmountOfTax, (Object)taxAmount));
        if (isOutOfRand) {
            return false;
        }
        this.getModel().setValue("totaloftaxamount", (Object)additionAmountOfTax, cardRowIndex);
        this.getModel().setValue("totaltax", (Object)taxAmount, cardRowIndex);
        this.getModel().setValue("totalamount", (Object)NumberHelper.subtract((Object)additionAmountOfTax, (Object)taxAmount), cardRowIndex);
        return true;
    }

    private boolean summaryAmountToHeadInfo() {
        IDataModel model = this.getModel();
        DynamicObjectCollection cardEntrys = model.getEntryEntity("cardentry");
        BigDecimal additionAmountOfTax = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        HashMap<Object, DynamicObject> addParentMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, DynamicObject> subtractParentMap = new HashMap<Object, DynamicObject>();
        for (int i = 0; i < cardEntrys.size(); ++i) {
            DynamicObject cardEntry = (DynamicObject)cardEntrys.get(i);
            String string = cardEntry.getString("cmptype");
            int n = 0;
            if (StringUtils.equals((CharSequence)string, (CharSequence)"(+)")) {
                n = 1;
            } else if (StringUtils.equals((CharSequence)string, (CharSequence)"(-)")) {
                n = -1;
            }
            if (n == 0) continue;
            DynamicObjectCollection subEntrys = (DynamicObjectCollection)cardEntry.get("entryentity");
            for (int j = 0; j < subEntrys.size(); ++j) {
                DynamicObject additionEntry = (DynamicObject)subEntrys.get(j);
                String subChangeType = additionEntry.getString("subaddtype");
                if (StringUtils.equals((CharSequence)"0", (CharSequence)subChangeType) || StringUtils.equals((CharSequence)"1", (CharSequence)subChangeType)) {
                    BigDecimal ofTaxAmount = (BigDecimal)additionEntry.get("changeamountoftax");
                    BigDecimal amount = this.getWithoutTaxValue(additionEntry.getBigDecimal("subtaxrate"), ofTaxAmount);
                    BigDecimal tax = NumberHelper.subtract((Object)ofTaxAmount, (Object)amount);
                    if (n == 1) {
                        additionAmountOfTax = NumberHelper.add((Object)additionAmountOfTax, (Object)ofTaxAmount);
                        taxAmount = NumberHelper.add((Object)taxAmount, (Object)tax);
                        continue;
                    }
                    if (n != -1) continue;
                    additionAmountOfTax = NumberHelper.subtract((Object)additionAmountOfTax, (Object)ofTaxAmount);
                    taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)tax);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)CHANGETYPE_DETAILLISTING, (CharSequence)subChangeType)) continue;
                BigDecimal oftax = (BigDecimal)additionEntry.get("oftax");
                BigDecimal tax = (BigDecimal)additionEntry.get("tax");
                if (n == 1) {
                    additionAmountOfTax = NumberHelper.add((Object)additionAmountOfTax, (Object)oftax);
                    taxAmount = NumberHelper.add((Object)taxAmount, (Object)tax);
                } else if (n == -1) {
                    additionAmountOfTax = NumberHelper.subtract((Object)additionAmountOfTax, (Object)oftax);
                    taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)tax);
                }
                DynamicObject parent = this.getOriginalParent(additionEntry, subEntrys);
                if (parent == null || !parent.getBoolean("isleaf")) continue;
                if (n == 1) {
                    addParentMap.put(parent.getPkValue(), BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"pmct_contractlist"));
                    continue;
                }
                if (n != -1) continue;
                subtractParentMap.put(parent.getPkValue(), BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"pmct_contractlist"));
            }
        }
        Set entries = addParentMap.entrySet();
        for (Map.Entry entry : entries) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            BigDecimal lastOfTaxAmount = dynamicObject.getBigDecimal("lstoftaxamount");
            BigDecimal taxrate = dynamicObject.getBigDecimal("taxrate");
            BigDecimal amount = this.getWithoutTaxValue(taxrate, lastOfTaxAmount);
            BigDecimal tax = NumberHelper.subtract((Object)lastOfTaxAmount, (Object)amount);
            additionAmountOfTax = NumberHelper.subtract((Object)additionAmountOfTax, (Object)lastOfTaxAmount);
            taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)tax);
        }
        Set entries1 = subtractParentMap.entrySet();
        for (Map.Entry entry : entries1) {
            DynamicObject parent = (DynamicObject)entry.getValue();
            BigDecimal lastOfTaxAmount = parent.getBigDecimal("lstoftaxamount");
            BigDecimal taxrate = parent.getBigDecimal("taxrate");
            BigDecimal amount = this.getWithoutTaxValue(taxrate, lastOfTaxAmount);
            BigDecimal tax = NumberHelper.subtract((Object)lastOfTaxAmount, (Object)amount);
            additionAmountOfTax = NumberHelper.add((Object)additionAmountOfTax, (Object)lastOfTaxAmount);
            taxAmount = NumberHelper.add((Object)taxAmount, (Object)tax);
        }
        BigDecimal bigDecimal = NumberHelper.subtract((Object)additionAmountOfTax, (Object)taxAmount);
        boolean bl = this.checkIsOutOfRand(additionAmountOfTax, taxAmount, bigDecimal);
        if (bl) {
            return false;
        }
        model.beginInit();
        model.setValue("addamountoftax", (Object)additionAmountOfTax);
        model.setValue("taxamount", (Object)taxAmount);
        model.setValue("addamount", (Object)bigDecimal);
        model.endInit();
        BigDecimal srcAmountoftax = (BigDecimal)model.getValue("srcamountoftax");
        BigDecimal srcTaxAmount = (BigDecimal)model.getValue("srctaxamount");
        BigDecimal srcAmount = (BigDecimal)model.getValue("srcamount");
        model.setValue("latestamountoftax", (Object)NumberHelper.add((Object)srcAmountoftax, (Object)additionAmountOfTax));
        model.setValue("latesttaxamount", (Object)NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount));
        model.setValue("latestamount", (Object)NumberHelper.add((Object)srcAmount, (Object)bigDecimal));
        this.getView().updateView("addamountoftax");
        this.getView().updateView("taxamount");
        this.getView().updateView("addamount");
        return true;
    }

    private DynamicObject getOriginalParent(DynamicObject changeEntry, DynamicObjectCollection subEntrys) {
        if (changeEntry != null) {
            DynamicObject parentListing = changeEntry.getDynamicObject("parentlisting");
            long superListingId = changeEntry.getLong("superlistingid");
            if (parentListing != null) {
                return parentListing;
            }
            if (parentListing == null && superListingId != 0L) {
                return this.getOriginalParent(this.findParentIndex(superListingId, subEntrys), subEntrys);
            }
        }
        return null;
    }

    private DynamicObject findParentIndex(long superListingId, DynamicObjectCollection subEntrys) {
        for (DynamicObject entry : subEntrys) {
            if (entry.getLong("newlistingid") != superListingId) continue;
            return entry;
        }
        return null;
    }

    private BigDecimal getWithoutTaxValue(BigDecimal taxRate, BigDecimal value) {
        BigDecimal rate = taxRate.divide(BigDecimal.valueOf(100L));
        return value.divide(BigDecimal.ONE.add(rate), 10, 4);
    }

    private BigDecimal getTaxRateByAmount(BigDecimal amount, BigDecimal taxAmount) {
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal taxRate = taxAmount.divide(amount, 10, 4);
        return taxRate.multiply(BigDecimal.valueOf(100L));
    }

    private BigDecimal getOfTaxValue(BigDecimal rate, BigDecimal value) {
        BigDecimal taxrate = rate.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
        return value.multiply(taxrate.add(BigDecimal.ONE));
    }

    private boolean checkIsOutOfRand(BigDecimal ... bigDecimals) {
        for (BigDecimal bigDecimal : bigDecimals) {
            if (bigDecimal == null) break;
            if (bigDecimal.compareTo(MAX_CONTROL_DECIMAL) <= 0 && bigDecimal.compareTo(MIN_CONTROL_DECIMAL) >= 0) continue;
            return true;
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (propertyName.equals("contract")) {
            String formId = this.getView().getEntityId();
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outaddagreement")) {
                ContractHelper.getContractByStatus((String)formId, (ListShowParameter)parameter, (String)PayDirectionEnum.OUT.getValue());
            } else {
                ContractHelper.getContractByStatus((String)formId, (ListShowParameter)parameter, (String)PayDirectionEnum.IN.getValue());
            }
        }
    }

    private boolean isOutContract() {
        String payDirection = this.getModel().getDataEntity().getString("paydirection");
        return StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue());
    }
}

