/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.common.utils.InComeUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctListPlugin;
import org.apache.commons.lang3.StringUtils;

public class IncomeApplyListPlugin
extends AbstractPmctListPlugin {
    public static final String CAS_REC_PUSH_OP = "casrecpush";
    public static final String INCOME_REGISTER_PUSH_OP = "incomeregisterpush";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
        if ("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey)) {
            this.updateEntryData(selectedRows);
        } else if (CAS_REC_PUSH_OP.equals(operateKey) || INCOME_REGISTER_PUSH_OP.equals(operateKey)) {
            ListView listView = (ListView)this.getView();
            int rows = listView.getSelectedRows().getBillListSelectedRowCollection().size();
            if (rows > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"IncomeApplyListPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow row = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
            Long incomeApplyPk = (Long)row.getPrimaryKeyValue();
            DynamicObject incomeApply = BusinessDataServiceHelper.loadSingle((Object)incomeApplyPk, (String)"pmct_incomeapply");
            DynamicObjectCollection entries = incomeApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                if (entry.getBigDecimal("entrylockamount").compareTo(entry.getBigDecimal("applyoftaxamount")) < 0) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d\u201d\u5c06\u8d85\u51fa\u9650\u989d\u3002", (String)"IncomeApplyListPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), entry.getDynamicObject("entrycontract").getString("billname")));
                return;
            }
        }
    }

    private void updateEntryData(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"IncomeApplyListPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> inComeApplyList = new ArrayList<DynamicObject>(10);
        String names = "";
        for (ListSelectedRow selectedRow : selectedRows) {
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            DynamicObject inComeApply = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incomeapply"));
            DynamicObjectCollection contractInComeCollection = inComeApply.getDynamicObjectCollection("entryentity");
            DynamicObject org = inComeApply.getDynamicObject("org");
            DynamicObject period = inComeApply.getDynamicObject("period");
            String contractName = "";
            if (contractInComeCollection.size() > 0) {
                for (DynamicObject contractInCome : contractInComeCollection) {
                    BigDecimal totalRealOfTaxAmount;
                    BigDecimal totalSettleOfTaxAmount;
                    boolean flag = false;
                    DynamicObject contract = contractInCome.getDynamicObject("entrycontract");
                    contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"));
                    DynamicObject entryPro = contractInCome.getDynamicObject("contpro");
                    if (contractInCome.getBigDecimal("totaloftaxamount").compareTo(contract.getBigDecimal("totaloftaxamount")) != 0) {
                        contractInCome.set("totaloftaxamount", (Object)contract.getBigDecimal("totaloftaxamount"));
                        flag = true;
                    }
                    boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                    String multiPayType = contract.getString("multipaytype");
                    if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                        MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                        totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryPro, contract, period, null);
                        totalRealOfTaxAmount = multiSettleAmtService.getMultiIncomeAmount(org, entryPro, contract, period);
                    } else {
                        InComeUtils inComeUtils = new InComeUtils();
                        totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, null);
                        totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, null);
                    }
                    if (contractInCome.getBigDecimal("totalsettleoftaxamount").compareTo(totalSettleOfTaxAmount) != 0) {
                        contractInCome.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
                        flag = true;
                    }
                    if (contractInCome.getBigDecimal("totalrealoftaxamount").compareTo(totalRealOfTaxAmount) != 0) {
                        contractInCome.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount);
                        flag = true;
                    }
                    contractInCome.set("totalunreceiptamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
                    BigDecimal totalInvoiceOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
                    if (contractInCome.getBigDecimal("totalinvoiceoftaxamt").compareTo(totalInvoiceOfTaxAmount) != 0) {
                        contractInCome.set("totalinvoiceoftaxamt", (Object)totalInvoiceOfTaxAmount);
                        flag = true;
                        contractInCome.set("totaluninvoicetaxamount", (Object)totalInvoiceOfTaxAmount.subtract(totalRealOfTaxAmount));
                    }
                    if (!flag) continue;
                    if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                        contractName = contractName + "," + contract.getString("billname");
                        continue;
                    }
                    contractName = contract.getString("billname");
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)contractName)) continue;
            inComeApplyList.add(inComeApply);
            if (names.isEmpty()) {
                names = inComeApply.getString("billno") + ":" + contractName;
                continue;
            }
            names = names + ";" + inComeApply.getString("billno") + ":" + contractName;
        }
        if (inComeApplyList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])inComeApplyList.toArray(new DynamicObject[0]));
            this.getView().getPageCache().put("names", names);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        FormOperate source = (FormOperate)args.getSource();
        if ("trackup".equals(operateKey)) {
            ListSelectedRowCollection listSelectedData = source.getListSelectedData();
            if (listSelectedData.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"IncomeApplyListPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Long> paymentApplyIds = listSelectedData.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pmct_incomeapply", (Long[])paymentApplyIds.toArray(new Long[0]));
            if (sourceBills.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"IncomeApplyListPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] incomeApplys = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", paymentApplyIds)});
            List orgIds = Arrays.stream(incomeApplys).map(incomeApply -> incomeApply.getDynamicObject("org").getString("id")).distinct().collect(Collectors.toList());
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("org", orgIds);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5408\u540c\u6536\u6b3e\u6761\u76ee-\u67e5\u770b", (String)"IncomeApplyListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            listShowParameter.setBillFormId("pmbs_contractcolitembook");
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", sourceBills.get("pmbs_contractcolitembook")));
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("submit".equals(operateKey) || "audit".equals(operateKey)) {
            String[] billNames;
            String flagNames = this.getView().getPageCache().get("names");
            this.getView().getPageCache().remove("names");
            if (args.getOperationResult().isSuccess() && StringUtils.isNotEmpty((CharSequence)flagNames) && (billNames = flagNames.split(";")).length > 0) {
                for (String contractName : billNames) {
                    String[] names = contractName.split(":");
                    if (names.length <= 0) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u5408\u540c\u8bf7\u6b3e\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u8bf7\u6b3e\u542b\u7a0e\u603b\u91d1\u989d\u201d\u3002", (String)"IncomeApplyListPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), names[0], names[1]));
                }
            }
        } else if ("confirmbillrec".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

