/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.formplugin.base.AbstractPmctListPlugin;
import kd.pmgt.pmct.formplugin.convert.ApplyConvertHelper;

public class PaymentApplyListPlugin
extends AbstractPmctListPlugin {
    private static final String OPERATE_BILL_PAY_CONFIRM_WARN = "billpayconfirmwarn";
    private static final String OPERATE_BILL_PAY_CONFIRM = "billpayconfirm";
    private static final String OPERATE_PAY_INIT_WARN = "payinitwarn";
    private static final String OPERATE_PAY_INIT = "payinit";
    private static final String OPERATE_BANK_INFO_PUSH = "bankinfopush";
    public static final String CAS_PAY_PUSH_OP = "caspaypush";
    public static final String PAY_REGISTER_PUSH_OP = "payregister";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String name = "";
        String operateKey = args.getOperateKey();
        FormOperate source = (FormOperate)args.getSource();
        if ("trackup".equals(operateKey)) {
            ListSelectedRowCollection listSelectedData = source.getListSelectedData();
            if (listSelectedData.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PaymentApplyListPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Long> paymentApplyIds = listSelectedData.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pmct_paymentapply", (Long[])paymentApplyIds.toArray(new Long[0]));
            if (sourceBills.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"PaymentApplyListPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] paymentApplys = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", paymentApplyIds)});
            List orgIds = Arrays.stream(paymentApplys).map(payApply -> payApply.getDynamicObject("org").getString("id")).distinct().collect(Collectors.toList());
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("org", orgIds);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5408\u540c\u4ed8\u6b3e\u6761\u76ee-\u67e5\u770b", (String)"PaymentApplyListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            listShowParameter.setBillFormId("pmbs_contractpayitembook");
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", sourceBills.get("pmbs_contractpayitembook")));
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("submit".equals(operateKey) || "audit".equals(operateKey)) {
            if (args.getOperationResult().isSuccess()) {
                String contractName = this.getView().getPageCache().get("contractName");
                this.getView().getPageCache().remove("contractName");
                if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                    String[] paymentNames;
                    for (String paymentName : paymentNames = contractName.split(";")) {
                        String[] names = paymentName.split(":");
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u7533\u8bf7\u542b\u7a0e\u603b\u91d1\u989d\u201d\u3002", (String)"PaymentApplyListPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), names[0], names[1]));
                    }
                }
            }
        } else if ((OPERATE_BILL_PAY_CONFIRM.equals(operateKey) || OPERATE_PAY_INIT.equals(operateKey)) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.updateEntryData(operate);
                break;
            }
            case "billpayconfirmwarn": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u6574\u5355\u4ed8\u6b3e\u786e\u8ba4\u201d\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u4e14\u5df2\u201c\u6574\u5355\u4ed8\u6e05\u201d\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u8fdb\u884c\u5904\u7406\u3002\u201c\u6574\u5355\u4ed8\u6b3e\u786e\u8ba4\u201d\u53ef\u5c06\u6240\u9009\u4ed8\u6b3e\u7533\u8bf7\u5355\u6807\u8bc6\u4e3a\u201c\u6574\u5355\u4ed8\u6e05\u201d\uff0c\u4e0d\u53ef\u518d\u8fdb\u884c\u4ed8\u6b3e\u64cd\u4f5c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PaymentApplyListPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OPERATE_BILL_PAY_CONFIRM_WARN, (IFormPlugin)this));
                break;
            }
            case "payinitwarn": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u4ed8\u6b3e\u521d\u59cb\u5316\u201d\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u4e14\u5df2\u201c\u6574\u5355\u4ed8\u6e05\u201d\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u8fdb\u884c\u5904\u7406\uff1b\u201c\u4ed8\u6b3e\u521d\u59cb\u5316\u201d\u53ef\u5c06\u6240\u9009\u4ed8\u6b3e\u7533\u8bf7\u5355\u6807\u8bc6\u4e3a\u201c\u6574\u5355\u4ed8\u6e05\u201d\uff0c\u4e0d\u53ef\u518d\u8fdb\u884c\u4ed8\u6b3e\u767b\u8bb0\uff0c\u5e76\u4e14\u4f1a\u5c06\u6240\u9009\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u201c\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u201d\u5199\u5165\u201c\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PaymentApplyListPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OPERATE_PAY_INIT_WARN, (IFormPlugin)this));
                break;
            }
            case "bankinfolist": {
                ListView listView = (ListView)this.getView();
                int rows = listView.getSelectedRows().getBillListSelectedRowCollection().size();
                if (rows > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PaymentApplyListPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListSelectedRow row = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
                Long paymentApplyPk = (Long)row.getPrimaryKeyValue();
                ListShowParameter parameter = new ListShowParameter();
                if (ApplyConvertHelper.validateCanNotBankChangeList(paymentApplyPk)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentApplyListPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                parameter.getListFilterParameter().getQFilters().add(new QFilter("paymentapply", "=", (Object)paymentApplyPk));
                parameter.setBillFormId("pmct_bankchange");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "bankinfopush": {
                ListView listView = (ListView)this.getView();
                int rows = listView.getSelectedRows().getBillListSelectedRowCollection().size();
                if (rows > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PaymentApplyListPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListSelectedRow row = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
                Long paymentApplyPk = (Long)row.getPrimaryKeyValue();
                if (!ApplyConvertHelper.validateCanNotBankChangePush(paymentApplyPk)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u201c\u5df2\u5ba1\u6838\u201d\u3001\u8fd8\u672a\u201c\u6574\u5355\u4ed8\u6e05\u201d\u3001\u4e14\u6ca1\u6709\u5173\u8054\u672a\u5ba1\u6838\u7684\u94f6\u884c\u4fe1\u606f\u53d8\u66f4\u5355\u7684\u6570\u636e\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentApplyListPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "caspaypush": {
                ListView listView = (ListView)this.getView();
                int rows = listView.getSelectedRows().getBillListSelectedRowCollection().size();
                if (rows > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PaymentApplyListPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListSelectedRow row = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
                Long paymentApplyPk = (Long)row.getPrimaryKeyValue();
                if (!ApplyConvertHelper.validateCanNotBankChangePush(paymentApplyPk)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u201c\u5df2\u5ba1\u6838\u201d\u3001\u8fd8\u672a\u201c\u6574\u5355\u4ed8\u6e05\u201d\u3001\u4e14\u6ca1\u6709\u5173\u8054\u672a\u5ba1\u6838\u7684\u94f6\u884c\u4fe1\u606f\u53d8\u66f4\u5355\u7684\u6570\u636e\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentApplyListPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "payregister": {
                ListView listView = (ListView)this.getView();
                int rows = listView.getSelectedRows().getBillListSelectedRowCollection().size();
                if (rows > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PaymentApplyListPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListSelectedRow row = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
                Long paymentApplyPk = (Long)row.getPrimaryKeyValue();
                DynamicObject payment = BusinessDataServiceHelper.loadSingle((Object)paymentApplyPk, (String)"pmct_paymentapply");
                if (ApplyConvertHelper.validateIsBankBOTP(payment.getPkValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u201c\u5df2\u5ba1\u6838\u201d\u3001\u8fd8\u672a\u201c\u6574\u5355\u4ed8\u6e05\u201d\u3001\u4e14\u6ca1\u6709\u5173\u8054\u672a\u5ba1\u6838\u7684\u94f6\u884c\u4fe1\u606f\u53d8\u66f4\u5355\u7684\u6570\u636e\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentApplyListPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection entries = payment.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    if (entry.getBigDecimal("entrylockamount").compareTo(entry.getBigDecimal("thispayableamount")) < 0) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d\u201d\u5c06\u8d85\u51fa\u9650\u989d\u3002", (String)"PaymentApplyListPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), entry.getDynamicObject("entrycontract").getString("billname")));
                    return;
                }
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String message = messageBoxClosedEvent.getCallBackId();
        if (message.equals(OPERATE_BILL_PAY_CONFIRM_WARN)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getView().invokeOperation(OPERATE_BILL_PAY_CONFIRM);
            }
        } else if (message.equals(OPERATE_PAY_INIT_WARN) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation(OPERATE_PAY_INIT);
        }
    }

    private void updateEntryData(FormOperate operate) {
        ListSelectedRowCollection listSelectedData = operate.getListSelectedData();
        if (listSelectedData.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PaymentApplyListPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> paymentList = new ArrayList<DynamicObject>(10);
        String names = "";
        for (ListSelectedRow listSelectedDatum : listSelectedData) {
            String paymentName = "";
            Object primaryKeyValue = listSelectedDatum.getPrimaryKeyValue();
            DynamicObject payment = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_paymentapply"));
            if (payment != null) {
                DynamicObject period = payment.getDynamicObject("period");
                DynamicObject org = payment.getDynamicObject("org");
                DynamicObjectCollection contractCollection = payment.getDynamicObjectCollection("entryentity");
                if (contractCollection != null && contractCollection.size() > 0) {
                    for (DynamicObject contractPay : contractCollection) {
                        DynamicObjectCollection payApplySplitEntry;
                        BigDecimal totalUnInvoiceAmount;
                        BigDecimal totalRealOfTaxAmount;
                        BigDecimal totalSettleOfTaxAmount;
                        boolean flag = false;
                        DynamicObject contract = contractPay.getDynamicObject("entrycontract");
                        if (contract == null) continue;
                        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                        DynamicObject entryPro = contractPay.getDynamicObject("contpro");
                        DynamicObject supplier = contractPay.getDynamicObject("contpartb");
                        if (contractPay.getBigDecimal("totaloftaxamount").compareTo(contract.getBigDecimal("totaloftaxamount")) != 0) {
                            contractPay.set("totaloftaxamount", (Object)contract.getBigDecimal("totaloftaxamount"));
                            flag = true;
                        }
                        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                        String multiPayType = contract.getString("multipaytype");
                        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                            MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                            totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryPro, contract, period, supplier);
                            totalRealOfTaxAmount = multiSettleAmtService.getMultiPayAmount(org, entryPro, contract, period, supplier);
                        } else {
                            totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
                            totalRealOfTaxAmount = contract.getBigDecimal("totalrealoftaxamount");
                        }
                        if (contractPay.getBigDecimal("totalsettleoftaxamount").compareTo(totalSettleOfTaxAmount) != 0) {
                            contractPay.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
                            flag = true;
                        }
                        if (contractPay.getBigDecimal("totalrealoftaxamount").compareTo(totalRealOfTaxAmount) != 0) {
                            contractPay.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount);
                            flag = true;
                        }
                        BigDecimal totalSettleAndUnRealPayAmount = totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount);
                        contractPay.set("totalunpaidoftaxamount", (Object)totalSettleAndUnRealPayAmount);
                        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
                        BigDecimal invoiceOfTaxAmount = BigDecimal.ZERO;
                        if (!contract.getBoolean("ismulticontract")) {
                            invoiceOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
                            totalUnInvoiceAmount = contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalRealOfTaxAmount);
                        } else {
                            QFilter contpartbFilter;
                            QFilter claimFilter;
                            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{contractFilter, statusFilter, claimFilter = new QFilter("isclaimed", "=", (Object)Boolean.TRUE), contpartbFilter = new QFilter("contpartb", "=", contract.getDynamicObject("partb").getPkValue())});
                            if (invoices.length > 0) {
                                for (DynamicObject inVo : invoices) {
                                    invoiceOfTaxAmount = invoiceOfTaxAmount.add(inVo.getBigDecimal("totaloftaxamount"));
                                }
                            }
                            totalUnInvoiceAmount = invoiceOfTaxAmount.subtract(totalRealOfTaxAmount);
                        }
                        if (contractPay.getBigDecimal("totalinvoiceoftaxamount").compareTo(invoiceOfTaxAmount) != 0) {
                            contractPay.set("totalinvoiceoftaxamount", (Object)invoiceOfTaxAmount);
                            contractPay.set("totaluninvoicetaxamount", (Object)totalUnInvoiceAmount);
                            flag = true;
                        }
                        if ((payApplySplitEntry = contractPay.getDynamicObjectCollection("payapplysplitentry")) != null && payApplySplitEntry.size() > 0) {
                            for (DynamicObject payApplySplit : payApplySplitEntry) {
                                DynamicObject proBudget = payApplySplit.getDynamicObject("bugdetitem");
                                if (proBudget == null) continue;
                                QFilter budgetFilter = new QFilter("budgetitem", "=", proBudget.getPkValue());
                                DynamicObject contractBudget = BusinessDataServiceHelper.loadSingle((String)"pmbs_contractbudget", (String)String.join((CharSequence)",", "contractauditamtex", "settleauditamtex", "payapplyauditamtex"), (QFilter[])new QFilter[]{contractFilter, budgetFilter});
                                if (contractBudget == null) continue;
                                payApplySplit.set("contractamount", (Object)contractBudget.getBigDecimal("contractauditamtex"));
                                payApplySplit.set("settledamount", (Object)contractBudget.getBigDecimal("settleauditamtex"));
                                payApplySplit.set("payedamount", (Object)contractBudget.getBigDecimal("payapplyauditamtex"));
                            }
                        }
                        if (!flag) continue;
                        if (StringUtils.isNotEmpty((CharSequence)paymentName)) {
                            paymentName = paymentName + "," + contract.getString("billname");
                            continue;
                        }
                        paymentName = paymentName + contract.getString("billname");
                    }
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)paymentName)) continue;
            paymentList.add(payment);
            if (names.isEmpty()) {
                names = payment.getString("billno") + ":" + paymentName;
                continue;
            }
            names = names + ";" + payment.getString("billno") + ":" + paymentName;
        }
        if (paymentList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])paymentList.toArray(new DynamicObject[0]));
            this.getView().getPageCache().put("contractName", names);
        }
    }

    public void setFilter(SetFilterEvent e) {
        if (this.getControlFilters().getFilter("org.id").size() == 0) {
            e.setMainOrgQFilter(null);
        }
    }
}

