/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.apply;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.pmct.ContractMultiTypeEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmct.business.service.PrePayService;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class PrePayDetailPlugin
extends AbstractPmctBillPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid deductionDetailEntry = (EntryGrid)this.getView().getControl("deductiondetailentity");
        deductionDetailEntry.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        if (contract != null) {
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("contractcurrency", showParameter.getCustomParam("contractcurrency"));
        String billStatus = (String)showParameter.getCustomParam("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue())) {
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"thisprepaydeduction"});
        } else {
            String paymentType = (String)showParameter.getCustomParam("paymenttype");
            this.getView().setEnable(Boolean.valueOf(!StringUtils.equals((CharSequence)paymentType, (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue())), 0, new String[]{"thisprepaydeduction"});
        }
        Object contractId = showParameter.getCustomParam("contract");
        Object orgId = showParameter.getCustomParam("org");
        Object projectId = showParameter.getCustomParam("project");
        Object thisPrePayDeductionAmount = showParameter.getCustomParam("thisprepaydeduction");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_outcontract");
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        boolean separatePay = multiPartSettlement && StringUtils.equals((CharSequence)contract.getString("multipaytype"), (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue());
        PrePayService prePayService = new PrePayService();
        BigDecimal prePayAmount = prePayService.getPrePayAmount(contract, projectId, orgId);
        BigDecimal prePayDeductionSubmitAndAuditAmount = prePayService.getPrePayDeductionAmount(contract, projectId, orgId, Boolean.valueOf(true));
        BigDecimal deductibleAmount = prePayAmount.subtract(prePayDeductionSubmitAndAuditAmount);
        this.getModel().setValue("contract", contractId, 0);
        if (separatePay) {
            this.getModel().setValue("org", orgId, 0);
        }
        this.getModel().setValue("project", projectId, 0);
        this.getModel().setValue("contractamount", showParameter.getCustomParam("contractamount"), 0);
        this.getModel().setValue("prepayamount", (Object)prePayAmount, 0);
        this.getModel().setValue("prepaydeductionsubmit", (Object)prePayDeductionSubmitAndAuditAmount, 0);
        this.getModel().setValue("deductibleamount", (Object)deductibleAmount, 0);
        this.getModel().setValue("thisprepaydeduction", thisPrePayDeductionAmount, 0);
        this.getView().updateView("prepayentry");
        List deductionDetailDataList = prePayService.getDeductionDetailDataList(contract, projectId, orgId);
        for (Map data : deductionDetailDataList) {
            int row = this.getModel().createNewEntryRow("deductiondetailentity");
            this.getModel().setValue("paymenttype", data.get("paymenttype"), row);
            this.getModel().setValue("period", data.get("period"), row);
            this.getModel().setValue("applyamount", data.get("applyamount"), row);
            this.getModel().setValue("deductionamount", data.get("deductionamount"), row);
            this.getModel().setValue("payableamount", data.get("payableamount"), row);
            this.getModel().setValue("billno", data.get("billno"), row);
            this.getModel().setValue("billstatus", data.get("billstatus"), row);
        }
        this.getView().updateView("deductiondetailentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        if (event.getFieldName().equals("billno")) {
            this.hyperLinkClickDeductionDetailEntryBillNo(event);
        }
    }

    private void hyperLinkClickDeductionDetailEntryBillNo(HyperLinkClickEvent event) {
        DynamicObject paymentApply;
        int row = event.getRowIndex();
        String billNo = (String)this.getModel().getValue("billno", row);
        if (StringUtils.isNotEmpty((CharSequence)billNo) && (paymentApply = BusinessDataServiceHelper.loadSingle((String)"pmct_paymentapply", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)})) != null) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("pmct_paymentapply");
            billShowParameter.setPkId(paymentApply.getPkValue());
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

