/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.apply;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SupplierBankInfoClickBillPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit account = (TextEdit)this.getView().getControl("account");
        account.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (key.equals("account")) {
            this.showBankInfoF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("payeeaccountbank".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
            DynamicObject bankRowObject = this.loadBankInfo((Long)entryKey);
            this.getPageCache().put("bankaccountcache", bankRowObject.getString("bankaccount"));
            this.getModel().setValue("bank", (Object)bankRowObject.getDynamicObject("bank").getString("name"));
            this.getModel().setValue("account", (Object)bankRowObject.getString("bankaccount"));
        }
    }

    private void showBankInfoF7() {
        DynamicObject suppier = (DynamicObject)this.getModel().getValue("supplier");
        if (suppier == null) {
            return;
        }
        boolean hasDefaultBankInfo = this.hasDefaultBankInfo(suppier);
        if (!hasDefaultBankInfo) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u4f9b\u5e94\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"SupplierBankInfoClickBillPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = this.getSupplierBankInfoShowParameter(suppier.getPkValue());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payeeaccountbank");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private boolean hasDefaultBankInfo(DynamicObject supplier) {
        if (supplier == null) {
            return false;
        }
        String entity = supplier.getDataEntityType().getName();
        supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)entity);
        DynamicObjectCollection bankColls = supplier.getDynamicObjectCollection("entry_bank");
        DynamicObject defaultBankAccountInfo = null;
        for (int i = 0; i < bankColls.size(); ++i) {
            if (i != 0 && !((DynamicObject)bankColls.get(i)).getBoolean("isdefault_bank")) continue;
            defaultBankAccountInfo = (DynamicObject)bankColls.get(i);
        }
        return defaultBankAccountInfo != null;
    }

    private ListShowParameter createDynamicListShowParameter(String entity, String entry, List<String> showFields) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entity, (boolean)false, (int)2);
        lsp.setCustomParam("entity", (Object)entity);
        lsp.setCustomParam("entry", (Object)entry);
        lsp.setCustomParam("isEntryMain", (Object)Boolean.TRUE);
        lsp.setCustomParam("showFields", showFields);
        this.clearPlugins(lsp);
        this.registerScript("kingdee.pmgt.pmct.mainpage.pmctdynamiclistscriptplugin", lsp);
        this.setMergeRow(false, lsp);
        lsp.setAppId("pmct");
        return lsp;
    }

    private void registerScript(String script, ListShowParameter lsp) {
        List plugins = this.getOrCreateFormConfig(lsp).getPlugins();
        Plugin p = new Plugin();
        p.setClassName(script);
        p.setType(1);
        plugins.add(p);
    }

    private void clearPlugins(ListShowParameter lsp) {
        List plugins = this.getOrCreateFormConfig(lsp).getPlugins();
        plugins.clear();
    }

    private void setMergeRow(boolean mergeRow, ListShowParameter lsp) {
        Map listUserOptions = ParameterHelper.getListOptions((long)Long.parseLong(RequestContext.get().getUserId()), (String)lsp.getBillFormId(), (String)this.getOrCreateFormConfig(lsp).getListUserOption(), null);
        ListUserOption listUserOption = new ListUserOption(listUserOptions);
        listUserOption.setMergeRow(mergeRow);
        lsp.setListUserOption(listUserOption);
    }

    private FormConfig getOrCreateFormConfig(ListShowParameter lsp) {
        FormConfig formConfig = lsp.getFormConfig();
        if (formConfig == null) {
            formConfig = FormMetadataCache.getFormConfig((String)lsp.getFormId());
            lsp.setFormConfig(formConfig);
        }
        return formConfig;
    }

    private ListShowParameter getSupplierBankInfoShowParameter(Object pk) {
        DynamicObjectCollection entryBank;
        Set<Object> entryIds = new HashSet(16);
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bd_supplier");
        if (supplier != null && !(entryBank = supplier.getDynamicObjectCollection("entry_bank")).isEmpty()) {
            entryIds = entryBank.stream().map(it -> Long.parseLong(it.getPkValue().toString())).collect(Collectors.toSet());
        }
        ArrayList<String> showFields = new ArrayList<String>();
        showFields.add("bank.name");
        showFields.add("bankaccount");
        showFields.add("accountname");
        showFields.add("currency.name");
        showFields.add("isdefault_bank");
        ListShowParameter lsp = this.createDynamicListShowParameter("bd_supplier", "entry_bank", showFields);
        ListFilterParameter lfp = new ListFilterParameter();
        if (!entryIds.isEmpty()) {
            lfp.setFilter(new QFilter("entry_bank.id", "in", entryIds));
        } else {
            lfp.setFilter(new QFilter("entry_bank.id", "=", (Object)0L));
        }
        lsp.setListFilterParameter(lfp);
        lsp.setCaption(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546-\u94f6\u884c\u4fe1\u606f", (String)"SupplierBankInfoClickBillPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        return lsp;
    }

    public DynamicObject loadBankInfo(Long entryPk) {
        DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"entry_bank.bankaccount, entry_bank.accountname, entry_bank.bank, entry_bank.isdefault_bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", (Object)entryPk)});
        if (customerOrSupplier != null) {
            DynamicObjectCollection entryBanks = customerOrSupplier.getDynamicObjectCollection("entry_bank");
            for (DynamicObject row : entryBanks) {
                if (!row.getPkValue().equals(entryPk)) continue;
                return row;
            }
        }
        return null;
    }
}

