/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.apply;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmct.common.utils.ShowBankUtils;
import org.apache.commons.lang3.StringUtils;

public class SupplierBankListPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit account = (TextEdit)this.getView().getControl("bankaccount");
        account.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (key.equals("bankaccount")) {
            this.showBankInfoF7();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int currentRowIndex = e.getChangeSet()[0].getRowIndex();
        String formId = this.getView().getEntityId();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"bankaccount")) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isNotEmpty((CharSequence)newValue)) {
                DynamicObject supplier = (DynamicObject)this.getModel().getValue("contpartb", currentRowIndex);
                boolean hasDefaultBankInfo = ShowBankUtils.hasDefaultBankInfo((DynamicObject)supplier);
                if (!hasDefaultBankInfo) {
                    this.getModel().setValue("bankaccount", null, currentRowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u4f9b\u5e94\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"SupplierBankListPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    return;
                }
                supplier = BusinessDataServiceHelper.loadSingle((Object)supplier.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_supplier"));
                DynamicObjectCollection bankCollection = supplier.getDynamicObjectCollection("entry_bank");
                boolean exist = false;
                for (DynamicObject bank : bankCollection) {
                    if (!bank.getString("bankaccount").equals(newValue)) continue;
                    exist = true;
                    if (!StringUtils.equals((CharSequence)"pmct_paymentregister", (CharSequence)formId)) {
                        this.getModel().setValue("bebank", (Object)bank.getDynamicObject("bank"), currentRowIndex);
                        if (bank.getLocaleString("accountname") != null) {
                            this.getModel().setValue("accountname", (Object)bank.getLocaleString("accountname").getLocaleValue(), currentRowIndex);
                        }
                    }
                    if (bank.getDynamicObject("bank") == null) break;
                    this.getModel().setValue("bankname", (Object)bank.getDynamicObject("bank").getString("name"), currentRowIndex);
                    break;
                }
                if (!exist) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u94f6\u884c\u8d26\u53f7\u3002", (String)"SupplierBankListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("bankaccount", oldValue, currentRowIndex);
                }
            } else {
                if (!StringUtils.equals((CharSequence)"pmct_paymentregister", (CharSequence)formId)) {
                    this.getModel().setValue("bebank", null, currentRowIndex);
                    this.getModel().setValue("accountname", null, currentRowIndex);
                }
                this.getModel().setValue("bankname", null, currentRowIndex);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("payeeaccountbank".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
            DynamicObject bankRowObject = this.loadBankInfo((Long)entryKey);
            this.getModel().setValue("bankname", (Object)bankRowObject.getDynamicObject("bank").getString("name"));
            this.getModel().setValue("bankaccount", (Object)bankRowObject.getString("bankaccount"));
        }
    }

    private void showBankInfoF7() {
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("contpartb");
        if (supplier == null) {
            return;
        }
        boolean hasDefaultBankInfo = ShowBankUtils.hasDefaultBankInfo((DynamicObject)supplier);
        if (!hasDefaultBankInfo) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u4f9b\u5e94\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"SupplierBankListPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = ShowBankUtils.getBankInfoShowParameter((Object)supplier.getPkValue(), (String)"bd_supplier");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payeeaccountbank");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public DynamicObject loadBankInfo(Long entryPk) {
        return ShowBankUtils.loadBankInfo((Long)entryPk, (String)"bd_supplier");
    }
}

