/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.argeement;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import kd.pmgt.pmct.common.utils.ContractListingPOIHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctFormPlugin;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class StrategicAgreementExcelImportFormPlugin
extends AbstractPmctFormPlugin
implements UploadListener {
    public static final String KEY_ATTACHMENTPANEL = "attachmentpanel";
    public static final String OPERATE_CONFIRM = "confirm";
    public static final String OPERATE_DOWNLOADTEMPLATE = "downloadtemplate";
    public static final String OPERATE_CLOSE = "close";
    protected static final String KEY_URLCACHE = "uploadfileurl";
    private static final Log logger = LogFactory.getLog(StrategicAgreementExcelImportFormPlugin.class);

    public List<String> getExcelMustFillColumn() {
        ArrayList<String> excelMustFillColumn = new ArrayList<String>();
        return excelMustFillColumn;
    }

    protected String getSheetName() {
        String sheetName = ResManager.loadKDString((String)"\u534f\u8bae\u4ef7\u683c\u660e\u7ec6\u5bfc\u5165", (String)"StrategicAgreementExcelImportFormPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]);
        return sheetName;
    }

    protected String[] getExcelColumnTitle() {
        return new String[]{ResManager.loadKDString((String)"\u6e05\u5355\u7f16\u7801", (String)"StrategicAgreementExcelImportFormPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6e05\u5355\u540d\u79f0", (String)"StrategicAgreementExcelImportFormPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StrategicAgreementExcelImportFormPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"StrategicAgreementExcelImportFormPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u91cf", (String)"StrategicAgreementExcelImportFormPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"StrategicAgreementExcelImportFormPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u5355\u4ef7", (String)"StrategicAgreementExcelImportFormPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7a0e\u7387\uff08%\uff09", (String)"StrategicAgreementExcelImportFormPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d", (String)"StrategicAgreementExcelImportFormPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"StrategicAgreementExcelImportFormPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7a0e\u989d", (String)"StrategicAgreementExcelImportFormPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"StrategicAgreementExcelImportFormPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7\u6e05\u5355\u7f16\u7801", (String)"StrategicAgreementExcelImportFormPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])};
    }

    public static String[] getExcelColumnKey() {
        return new String[]{"listnumber", "listname", "materiel", "measureunit", "qty", "pricewithtax", "pricewithouttax", "tax", "amountwithtax", "amountwithouttax", "taxamount", "note", "parentlistnumber"};
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length == 1) {
            String url = (String)((Map)urls[0]).get("url");
            this.getPageCache().put(KEY_URLCACHE, url);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "confirm": {
                this.afterConfirm();
                break;
            }
            case "downloadtemplate": {
                this.downloadTemplate();
                break;
            }
        }
    }

    protected void afterConfirm() {
        String url = this.getPageCache().get(KEY_URLCACHE);
        if (url != null && !"".equals(url.trim())) {
            this.getView().returnDataToParent((Object)url);
            this.getView().invokeOperation(OPERATE_CLOSE);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"StrategicAgreementExcelImportFormPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
    }

    protected void downloadTemplate() {
        String sheetName = this.getSheetName();
        String url = StrategicAgreementExcelImportFormPlugin.outPutExcel(sheetName, sheetName, this.getExcelColumnTitle(), StrategicAgreementExcelImportFormPlugin.getExcelColumnKey(), this.getExcelMustFillColumn(), null);
        this.getView().download(url);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff0c\u5df2\u4e0b\u8f7d\u5230\u6d4f\u89c8\u5668\u4e0b\u8f7d\u76ee\u5f55\u3002", (String)"StrategicAgreementExcelImportFormPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
    }

    public static String outPutExcel(String fileName, String sheetName, String[] header, String[] columnKey, List<String> mustFillColumn, JSONArray data) {
        int j;
        int i;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow columnKeyHashRow = sheet.createRow(0);
        columnKeyHashRow.setHeight((short)0);
        Cell columnKeyHashCell = columnKeyHashRow.createCell(0);
        HSSFCellStyle columnKeyHashCellCss = wb.createCellStyle();
        HSSFDataFormat columnKeyHashCellFormat = wb.createDataFormat();
        columnKeyHashCellCss.setDataFormat(columnKeyHashCellFormat.getFormat("@"));
        columnKeyHashCell.setCellStyle((CellStyle)columnKeyHashCellCss);
        columnKeyHashCell.setCellValue(POIHelper.stringArrayToHash((String[])columnKey));
        HSSFRow columnKeyRow = sheet.createRow(1);
        columnKeyRow.setHeight((short)0);
        HSSFRow nameRow = sheet.createRow(2);
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        Cell columnKeyCell = null;
        Cell nameCell = null;
        for (i = 0; i < header.length; ++i) {
            sheet.setColumnWidth(i, header[i].getBytes(StandardCharsets.UTF_8).length * 2 * 256);
            columnKeyCell = columnKeyRow.createCell(i);
            columnKeyCell.setCellValue(columnKey[i]);
            columnKeyCell.setCellStyle((CellStyle)titleCellStyle);
            nameCell = nameRow.createCell(i);
            if (mustFillColumn != null && mustFillColumn.contains(header[i])) {
                HSSFCellStyle mustFillColumnStyle = wb.createCellStyle();
                mustFillColumnStyle.setAlignment(HorizontalAlignment.CENTER);
                mustFillColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                mustFillColumnStyle.setBorderTop(BorderStyle.THIN);
                mustFillColumnStyle.setBorderLeft(BorderStyle.THIN);
                mustFillColumnStyle.setBorderRight(BorderStyle.THIN);
                mustFillColumnStyle.setBorderBottom(BorderStyle.THIN);
                mustFillColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                mustFillColumnStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
                HSSFFont mheadFont = wb.createFont();
                mheadFont.setColor(IndexedColors.RED.getIndex());
                mustFillColumnStyle.setFont((Font)mheadFont);
                nameCell.setCellValue(header[i] + "*");
                nameCell.setCellStyle((CellStyle)mustFillColumnStyle);
                continue;
            }
            nameCell.setCellValue(header[i]);
            nameCell.setCellStyle((CellStyle)titleCellStyle);
        }
        for (i = 0; i < columnKey.length; ++i) {
            if (!columnKey[i].equals("tax")) continue;
            QFilter taxrateFiler = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
            DynamicObject[] taxrateCol = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"number,name,taxrate", (QFilter[])new QFilter[]{taxrateFiler});
            int len = taxrateCol.length;
            String[] dataList = new String[len];
            for (j = 0; j < len; ++j) {
                BigDecimal taxrate = taxrateCol[j].getBigDecimal("taxrate");
                dataList[j] = String.valueOf(taxrate);
            }
            ContractListingPOIHelper.setDropDownAndHidden((Workbook)wb, (String)sheetName, (int)3, (int)200, (int)i, (int)i, (String[])dataList);
        }
        HSSFCellStyle css = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        css.setDataFormat(format.getFormat("@"));
        sheet.setDefaultColumnStyle(0, (CellStyle)css);
        sheet.setDefaultColumnStyle(1, (CellStyle)css);
        sheet.setDefaultColumnStyle(2, (CellStyle)css);
        sheet.setDefaultColumnStyle(12, (CellStyle)css);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        if (data != null && !data.isEmpty()) {
            for (int i2 = 0; i2 < data.size(); ++i2) {
                JSONObject jsonObject = data.getJSONObject(i2);
                nameRow = sheet.createRow(i2 + 3);
                for (j = 0; j < columnKey.length; ++j) {
                    nameCell = nameRow.createCell(j);
                    nameCell.setCellValue(jsonObject.get((Object)columnKey[j]) == null ? null : jsonObject.get((Object)columnKey[j]).toString());
                    nameCell.setCellStyle((CellStyle)cellStyle);
                }
            }
        }
        fileName = StringUtils.isBlank((CharSequence)fileName) ? System.currentTimeMillis() + ".xls" : fileName + ".xls";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return url;
    }

    public static HSSFDataValidation getDataValidation(int firstRow, int lastRow, int firstCol, int lastCol, String tip, String[] dvConstraintArr, int type) {
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DVConstraint dvConstraint = null;
        switch (type) {
            case 1: {
                dvConstraint = DVConstraint.createNumericConstraint((int)1, (int)0, (String)"-1000000", (String)"1000000000");
                break;
            }
            case 7: {
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])dvConstraintArr);
                break;
            }
            default: {
                dvConstraint = DVConstraint.createCustomFormulaConstraint((String)"BB1");
            }
        }
        HSSFDataValidation dataValidation = new HSSFDataValidation(addressList, (DataValidationConstraint)dvConstraint);
        dataValidation.createErrorBox(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a", (String)"StrategicAgreementExcelImportFormPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f93\u5165\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"StrategicAgreementExcelImportFormPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        dataValidation.setSuppressDropDownArrow(false);
        if (tip != null) {
            dataValidation.createPromptBox(ResManager.loadKDString((String)"\u8f93\u5165\u63d0\u793a", (String)"StrategicAgreementExcelImportFormPlugin_18", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), tip);
        }
        dataValidation.setShowPromptBox(true);
        return dataValidation;
    }
}

