/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.argeement;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.SerializeHelper;
import kd.pmgt.pmbs.common.enums.AgreementAdapteScopeEnum;
import kd.pmgt.pmbs.common.enums.AgreementStatusEnum;
import kd.pmgt.pmct.formplugin.base.AbstractPmctListPlugin;

public class StrategicAgreementF7ListPlugin
extends AbstractPmctListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String openStyle = (String)formShowParameter.getCustomParam("openstyle");
        if (StringUtils.equals((CharSequence)openStyle, (CharSequence)"F7")) {
            return;
        }
        long orgId = RequestContext.get().getOrgId();
        CommonFilterColumn orgColumn = (CommonFilterColumn)args.getFilterColumn("org.name");
        orgColumn.setDefaultValue(String.valueOf(orgId));
        super.filterContainerInit(args);
    }

    public void setFilter(SetFilterEvent e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String openStyle = (String)formShowParameter.getCustomParam("openstyle");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (StringUtils.equals((CharSequence)openStyle, (CharSequence)"F7")) {
            boolean isShowAll = (Boolean)this.getModel().getValue("isshowall");
            if (isShowAll) {
                List qFilters = e.getQFilters();
                for (QFilter qFilter : qFilters) {
                    String cp = qFilter.getCP();
                    if (!StringUtils.equals((CharSequence)cp, (CharSequence)"ftlike")) continue;
                    return;
                }
                String allTypeFilterStr = this.getPageCache().get("allTypeFilter");
                QFilter allTypeFilter = (QFilter)SerializeHelper.unserialize((String)allTypeFilterStr);
                qFilterList.add(allTypeFilter);
                e.setCustomQFilters(qFilterList);
                qFilters.clear();
            } else {
                List qFilters = e.getQFilters();
                for (QFilter qFilter : qFilters) {
                    String cp = qFilter.getCP();
                    if (!StringUtils.equals((CharSequence)cp, (CharSequence)"ftlike")) continue;
                    return;
                }
                String defaultFilterStr = (String)formShowParameter.getCustomParam("defaultFilter");
                QFilter defaultFilter = (QFilter)SerializeHelper.unserialize((String)defaultFilterStr);
                qFilterList.add(defaultFilter);
                e.setCustomQFilters(qFilterList);
                qFilters.clear();
            }
            return;
        }
        String agreementIdList = (String)formShowParameter.getCustomParam("agreementhistory");
        if (StringUtils.isNotEmpty((CharSequence)agreementIdList)) {
            ArrayList<Long> idList = new ArrayList<Long>(10);
            if (agreementIdList.contains(",")) {
                String[] agreementIds;
                for (String agreementId : agreementIds = agreementIdList.split(",")) {
                    idList.add(Long.parseLong(agreementId));
                }
            } else {
                idList.add(Long.parseLong(agreementIdList));
            }
            QFilter idFilter = new QFilter("id", "in", idList);
            qFilterList.add(idFilter);
            e.setCustomQFilters(qFilterList);
            e.setMainOrgQFilter(null);
            return;
        }
        long orgId = RequestContext.get().getOrgId();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        qFilterList.add(orgFilter);
        e.setCustomQFilters(qFilterList);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newdata = changeData.getNewValue();
        String field = e.getProperty().getName();
        if ("isshowall".equals(field)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            boolean isShowAll = (Boolean)newdata;
            if (!isShowAll) {
                this.getPageCache().remove("allTypeFilter");
            } else {
                this.setAllTypeFilter();
            }
            billList.bindData((BindingContext)null);
        }
    }

    public void setAllTypeFilter() {
        DynamicObject[] wholeAgreements;
        DynamicObject[] specialAgreements;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Long orgPk = Long.parseLong(customParams.get("org").toString());
        Long projectPk = Long.parseLong(customParams.get("project").toString());
        HashSet<Long> allAgreeIdSet = new HashSet<Long>(16);
        QFilter specialFilter = new QFilter("agreementstate", "=", (Object)AgreementStatusEnum.EFFECTING.getValue()).and("billstatus", "=", (Object)"C").and("islatest", "=", (Object)"1").and("adaptescope", "=", (Object)AgreementAdapteScopeEnum.SPECIFY.getValue());
        for (DynamicObject agreementObj : specialAgreements = BusinessDataServiceHelper.load((String)"pmct_strategicagreement", (String)"orgscopeentry,orgscopeentry.scopeorg,projectscopeentry,projectscopeentry.project", (QFilter[])specialFilter.toArray())) {
            DynamicObjectCollection orgScopeEntry = agreementObj.getDynamicObjectCollection("orgscopeentry");
            if (null == orgPk || null == orgScopeEntry) continue;
            for (int i = 0; i < orgScopeEntry.size(); ++i) {
                Long scopeOrgPkValue = (Long)((DynamicObject)orgScopeEntry.get(i)).getDynamicObject("scopeorg").getPkValue();
                if (null == scopeOrgPkValue) continue;
                if (orgPk.compareTo(scopeOrgPkValue) == 0 && projectPk != 0L) {
                    DynamicObjectCollection subProjectScopeEntry = ((DynamicObject)orgScopeEntry.get(i)).getDynamicObjectCollection("projectscopeentry");
                    for (DynamicObject row : subProjectScopeEntry) {
                        Long scopeProject = (Long)row.getDynamicObject("project").getPkValue();
                        if (projectPk.compareTo(scopeProject) != 0) continue;
                        allAgreeIdSet.add((Long)agreementObj.getPkValue());
                    }
                    continue;
                }
                if (orgPk.compareTo(scopeOrgPkValue) != 0 || projectPk != 0L) continue;
                allAgreeIdSet.add((Long)agreementObj.getPkValue());
            }
        }
        QFilter wholeFilter = new QFilter("agreementstate", "=", (Object)AgreementStatusEnum.EFFECTING.getValue()).and("islatest", "=", (Object)"1").and("billstatus", "=", (Object)"C").and("adaptescope", "=", (Object)AgreementAdapteScopeEnum.WHOLE.getValue());
        for (DynamicObject row : wholeAgreements = BusinessDataServiceHelper.load((String)"pmct_strategicagreement", (String)"", (QFilter[])wholeFilter.toArray())) {
            allAgreeIdSet.add((Long)row.getPkValue());
        }
        QFilter wholeAgreeIdFilter = new QFilter("id", "in", allAgreeIdSet);
        this.getPageCache().put("allTypeFilter", SerializeHelper.serialize((Object)wholeAgreeIdFilter));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object budgetId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        String fieldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)fieldName)) {
            args.setCancel(true);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(budgetId);
            showParameter.setFormId("pmct_strategicagreement");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

