/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.base;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.business.helper.InvoiceHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;
import org.apache.commons.lang3.StringUtils;

public class AbstractPmctInvoicePlugin
extends AbstractPmctBillPlugin
implements UploadListener,
BeforeF7SelectListener {
    protected static final String PROPERTY_RECEIVER = "receiver";
    protected static final String PROPERTY_RECEIVE_DATE = "receivedate";
    protected static final String PROPERTY_IS_RECEIVED = "isreceived";
    protected static final String ENTRY_FILE_NAME = "filename";
    protected static final String ENTRY_UPLOAD_DATE = "uploaddate";
    protected static final String ENTRY_IMAGE_URL = "imageurl";
    protected static final String ENTRY_ENTITY_PICTURE = "pictureentry";
    protected static final String CONTROL_IMAGE_LIST = "imagelistap";

    public void computeEntry(String propertyName, int rowIndex) {
        if (null != propertyName) {
            DynamicObject taxRateObject = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            BigDecimal taxRate = BigDecimal.ZERO;
            if (taxRateObject != null) {
                taxRate = taxRateObject.getBigDecimal("taxrate").divide(BigDecimal.valueOf(100L));
            }
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
            BigDecimal ofTaxPrice = (BigDecimal)this.getModel().getValue("oftaxprice", rowIndex);
            BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
            BigDecimal ofTaxAmount = (BigDecimal)this.getModel().getValue("oftaxamount", rowIndex);
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
            switch (propertyName) {
                case "qty": 
                case "oftaxprice": 
                case "taxrate": {
                    ofTaxAmount = ofTaxPrice.multiply(qty);
                    price = ofTaxPrice.divide(BigDecimal.ONE.add(taxRate), 6, 4);
                    amount = price.multiply(qty);
                    break;
                }
                case "price": {
                    if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0) break;
                    amount = price.multiply(qty);
                    ofTaxAmount = amount.multiply(BigDecimal.ONE.add(taxRate));
                    ofTaxPrice = ofTaxAmount.divide(qty, 6, 4);
                    break;
                }
                case "oftaxamount": {
                    if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0) break;
                    amount = ofTaxAmount.divide(BigDecimal.ONE.add(taxRate), 6, 4);
                    ofTaxPrice = ofTaxAmount.divide(qty, 6, 4);
                    price = amount.divide(qty, 6, 4);
                    break;
                }
            }
            BigDecimal tax = ofTaxAmount.subtract(amount);
            this.getModel().beginInit();
            this.getModel().setValue("oftaxprice", (Object)ofTaxPrice, rowIndex);
            this.getModel().setValue("oftaxamount", (Object)ofTaxAmount, rowIndex);
            this.getModel().setValue("amount", (Object)amount, rowIndex);
            this.getModel().setValue("tax", (Object)tax, rowIndex);
            this.getModel().setValue("price", (Object)price, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ImageList imageList = (ImageList)this.getControl(CONTROL_IMAGE_LIST);
        imageList.addUploadListener((UploadListener)this);
        BasedataEdit contract = (BasedataEdit)this.getControl("contract");
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void upload(UploadEvent evt) {
        Object[] urlObjects = evt.getUrls();
        Object[] nameObjects = evt.getNames();
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)CONTROL_IMAGE_LIST)) {
            Date currentDate = new Date();
            for (int i = 0; i < nameObjects.length && i < urlObjects.length; ++i) {
                int index = this.getModel().createNewEntryRow(ENTRY_ENTITY_PICTURE);
                this.getModel().setValue(ENTRY_FILE_NAME, nameObjects[i], index);
                this.getModel().setValue(ENTRY_UPLOAD_DATE, (Object)currentDate, index);
                this.getModel().setValue(ENTRY_IMAGE_URL, (Object)urlObjects[i].toString(), index);
            }
        }
    }

    public void remove(UploadEvent evt) {
        Object[] indexs = evt.getIndexes();
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)CONTROL_IMAGE_LIST)) {
            for (Object index : indexs) {
                IDataModel operate = this.getModel();
                operate.deleteEntryRow(ENTRY_ENTITY_PICTURE, ((Integer)index).intValue());
            }
        }
    }

    public void afterBindData(EventObject e) {
        int rowCount;
        String billStatus;
        super.afterBindData(e);
        ImageList imageList = (ImageList)this.getView().getControl(CONTROL_IMAGE_LIST);
        DynamicObjectCollection images = this.getModel().getEntryEntity(ENTRY_ENTITY_PICTURE);
        if (images != null && images.size() > 0) {
            String[] urls = new String[images.size()];
            int index = 0;
            for (DynamicObject image : images) {
                String imageUrl = image.getString(ENTRY_IMAGE_URL);
                urls[index] = InvoiceHelper.getDownloadUrl((String)imageUrl);
                ++index;
            }
            imageList.setImageUrls(urls);
        }
        if (StringUtils.equals((CharSequence)(billStatus = (String)this.getModel().getValue("billstatus")), (CharSequence)StatusEnum.CHECKED.getValue()) || StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.UNCHECKED.getValue())) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("uploadImg", Boolean.FALSE);
            this.getView().updateControlMetadata(CONTROL_IMAGE_LIST, map);
        }
        if ((rowCount = this.getModel().getEntryRowCount("entryentity")) > 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"totalamount", "totaloftaxamount", "totaltax"});
        }
    }

    protected void computeTotal() {
        DynamicObjectCollection items = this.getModel().getEntryEntity("entryentity");
        if (items != null && items.size() > 0) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTax = BigDecimal.ZERO;
            BigDecimal totalOfTaxAmount = BigDecimal.ZERO;
            for (DynamicObject item : items) {
                totalAmount = totalAmount.add(item.getBigDecimal("amount"));
                totalTax = totalTax.add(item.getBigDecimal("tax"));
                totalOfTaxAmount = totalOfTaxAmount.add(item.getBigDecimal("oftaxamount"));
            }
            this.getModel().beginInit();
            this.getModel().setValue("totalamount", (Object)totalAmount);
            this.getModel().setValue("totaltax", (Object)totalTax);
            this.getModel().setValue("totaloftaxamount", (Object)totalOfTaxAmount);
            this.getModel().endInit();
            this.getView().updateView("totalamount");
            this.getView().updateView("totaltax");
            this.getView().updateView("totaloftaxamount");
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("totalamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("totaltax", (Object)BigDecimal.ZERO);
            this.getModel().setValue("totaloftaxamount", (Object)BigDecimal.ZERO);
            this.getModel().endInit();
            this.getView().updateView("totalamount");
            this.getView().updateView("totaltax");
            this.getView().updateView("totaloftaxamount");
        }
        BigDecimal totalOfTaxAmount = (BigDecimal)this.getModel().getValue("totaloftaxamount");
        if (this.getView().getEntityId().equals("pmct_ininvoice")) {
            BigDecimal totalUseAmt = (BigDecimal)this.getModel().getValue("totaluseamt");
            this.getModel().setValue("availableamt", (Object)totalOfTaxAmount.subtract(totalUseAmt));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if ("new".equals(key)) {
            ImageList imageList = (ImageList)this.getView().getControl(CONTROL_IMAGE_LIST);
            imageList.setImageUrls(new String[0]);
            this.getView().updateView(CONTROL_IMAGE_LIST);
        } else if ("newentry".equals(key)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"totalamount", "totaloftaxamount", "totaltax"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        HashMap<String, Boolean> map;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key) || StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
            map = new HashMap<String, Boolean>();
            map.put("uploadImg", Boolean.FALSE);
            this.getView().updateControlMetadata(CONTROL_IMAGE_LIST, map);
        }
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue())) {
            map = new HashMap();
            map.put("uploadImg", Boolean.TRUE);
            this.getView().updateControlMetadata(CONTROL_IMAGE_LIST, map);
        }
        if ("deleteentry".equals(key)) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            if (rowCount == 0) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"totalamount", "totaloftaxamount", "totaltax"});
            }
            this.computeTotal();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
    }
}

