/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.contclaim;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmct.formplugin.base.AbstractPmctListPlugin;

public class ClaimBillListPlugin
extends AbstractPmctListPlugin {
    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        if (billFormId.equals("pmct_inclaimbill")) {
            event.getQFilters().add(new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue()));
        } else if (billFormId.equals("pmct_outclaimbill")) {
            event.getQFilters().add(new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue()));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)args.getHyperLinkClickEvent().getFieldName(), (CharSequence)"billno")) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
            if (listParameter.isLookUp()) {
                args.setCancel(true);
                String billFormId = ((ListView)this.getView()).getBillFormId();
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(billFormId);
                parameter.setPkId(billList.getCurrentSelectedRowInfo().getPrimaryKeyValue());
                StyleCss css = new StyleCss();
                css.setHeight("640px");
                css.setWidth("1064px");
                parameter.getOpenStyle().setInlineStyleCss(css);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
        if ("submit".equals(operateKey) || "audit".equals(operateKey) || "unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) {
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ClaimBillListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)operateKey)) {
                DynamicObject claimObject = BusinessDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"pmct_claimbilltpl");
                claimObject = BusinessDataServiceHelper.loadSingle((Object)claimObject.getPkValue(), (String)"pmct_inclaimbill");
                DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)claimObject.getDynamicObject("contract").getPkValue(), (String)"pmct_contracttpl");
                DynamicObject contStatus = contract.getDynamicObject("contractstatus");
                List statusNums = Stream.of(ContractStatusEnum.CLOSED.getValue()).collect(Collectors.toList());
                if (statusNums.contains(contStatus.getString("number"))) {
                    String tip = String.format(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a%s\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ClaimBillListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contStatus.getString("name"));
                    this.getView().showTipNotification(tip);
                    args.setCancel(true);
                }
            }
        }
    }
}

