/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.contclaim;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.enums.contractlist.ContractListClaimTypeEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.business.service.ProjectBudgetItemService;
import kd.pmgt.pmct.common.utils.ContractSupplierHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class OutContractClaimBillPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener {
    public static final String CALCULATE_RATIO = "calculateratio";
    public static final String CALCULATE_AMOUNT = "calculateamount";
    public static final String DELETEPAYPLAN = "deletepayplan";
    public static final String VIEWCOMPARE = "viewcompare";
    public static final String SAVE = "save";
    public static final String SUBMIT = "submit";
    private static final String UNSUBMIT = "unsubmit";
    private static final String UNAUDIT = "unaudit";
    public static final String PARAMETER_SOURCE_ID = "sourceid";
    public static final String PARAMETER_CONTRACT_ID = "contractid";
    public static final String PARAMETER_CHANGE_TYPE = "changetype";
    public static final String PARAMETER_FORM_ID = "formId";
    public static final String PARAMETER_CUSTOM_ENTRY_DATA = "entrydata";
    protected static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    protected static final String CLAIM_PAY_PLAN = "claimpayplan";
    private static final String IS_CLOSEDCALLBACK_CONTRACT = "isContractClosedCallBack";
    private static final String CTRL_ADDPAYPLAN = "addpayplan";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("budgetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit listingBudgetItem = (BasedataEdit)this.getView().getControl("listingbudgetitem");
        listingBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit nodeSettingEdit = (BasedataEdit)this.getControl("nodesetting");
        nodeSettingEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        nodeSettingEdit.addBeforeF7ViewDetailListener(evt -> {
            DynamicObject nodeSetting;
            evt.setCancel(true);
            Object pkId = evt.getPkId();
            if (null != pkId && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)pkId) && !(nodeSetting = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)NodeSettingSourceEnum.PMBS_TASK.getValue())).getBoolean("islatest")) {
                DynamicObject sourceTask = nodeSetting.getDynamicObject("sourcetask");
                nodeSetting = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)String.join((CharSequence)",", new CharSequence[0]), (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue()), new QFilter("islatest", "=", (Object)true)});
                pkId = nodeSetting.getPkValue();
            }
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (String)"id", (Object)pkId));
        });
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        if (supplier != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Date date = new Date();
        this.getModel().setValue("reqdate", (Object)date);
        this.getModel().setValue("replydate", (Object)date);
        DynamicObject payItem = BusinessDataServiceHelper.loadSingle((Object)849909148731577344L, (String)"pmct_payitem");
        this.getModel().setValue("contpayitem", (Object)payItem);
        DynamicObject period = EcPeriodUtils.getCurrentPeriod();
        if (period != null) {
            this.getModel().setValue("period", period.getPkValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateBudgetViewByProject();
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        ContractHelper.showPayPlanEntry((IFormView)this.getView(), (DynamicObject)contract, (String)CLAIM_PAY_PLAN, (String)"claimpayplanentry");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "addpayplan": {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("claimpayplanentry");
                int rowIndex = entrys.size() - 1;
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                if (contract != null) {
                    contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                    this.getModel().setValue("supplier", (Object)contract.getDynamicObject("partb"), rowIndex);
                    boolean bl = contract.getBoolean("ismulticontract");
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                ContractPayItemHelper.setBillNameInPayPlanEntry((IDataModel)this.getModel());
                break;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection payPlanEntrys = this.getModel().getEntryEntity("claimpayplanentry");
        Map completeMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])((DynamicObject[])payPlanEntrys.toArray((Object[])new DynamicObject[payPlanEntrys.size()])));
        Map mapData = (Map)completeMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject payPlanEntry : payPlanEntrys) {
            DynamicObject nodeSetting = payPlanEntry.getDynamicObject("nodesetting");
            if (null == nodeSetting || !QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) continue;
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
            payPlanEntry.set("taskcompletestate", mapData.get(nodeSetting.getLong("id")));
            Long payItemId = payPlanEntry.getLong("conplanitemid");
            if (0L == payItemId || QueryServiceHelper.exists((String)"pmbs_contractpayitem", (Object)payItemId)) continue;
            payPlanEntry.set("conplanitemid", null);
        }
    }

    private void onChangeContract() {
        this.getModel().setValue("claimoftaxamount", null);
        this.getModel().setValue("taxamount", null);
        this.getModel().setValue("claimamount", null);
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract == null) {
            this.getModel().setValue("taxrate", null);
            this.getModel().setValue("avgtaxrate", null);
            this.getModel().setValue("budgetitem", null);
            return;
        }
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        DynamicObject project = contract.getDynamicObject("project");
        DynamicObject budgetitem = contract.getDynamicObject("budgetitem");
        if (project != null && budgetitem != null) {
            this.getModel().setValue("budgetitem", contract.getDynamicObject("budgetitem").getPkValue());
        }
        this.getModel().setValue("org", contract.getDynamicObject("org").getPkValue(), 0);
        this.getModel().beginInit();
        if (project != null) {
            this.getModel().setValue("project", project.getPkValue(), 0);
        } else {
            this.getModel().setValue("project", null);
        }
        this.getModel().endInit();
        this.getView().updateView("project");
        boolean isMultiRate = contract.getBoolean("ismultirate");
        this.getModel().setValue("ismultirate", (Object)isMultiRate);
        if (contract.getBoolean("ismultirate")) {
            BigDecimal lstAvgTaxRate = contract.getBigDecimal("lstavgtaxrate");
            if (lstAvgTaxRate != null && lstAvgTaxRate.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("avgtaxrate", (Object)lstAvgTaxRate);
            } else {
                this.getModel().setValue("avgtaxrate", (Object)contract.getBigDecimal("avgtaxrate"));
            }
            this.getModel().setValue("taxrate", null);
        } else {
            this.getModel().setValue("avgtaxrate", null);
            DynamicObject taxRate = contract.getDynamicObject("lsttaxrate");
            if (taxRate != null) {
                this.getModel().setValue("taxrate", taxRate.getPkValue());
            } else {
                taxRate = contract.getDynamicObject("taxrate");
                if (taxRate != null) {
                    this.getModel().setValue("taxrate", taxRate.getPkValue());
                }
            }
        }
        DynamicObjectCollection payPlanEntry = this.getModel().getEntryEntity("claimpayplanentry");
        for (int i = 0; i < payPlanEntry.size(); ++i) {
            DynamicObject entryEntity = (DynamicObject)payPlanEntry.get(i);
            if (null != entryEntity.get("nodesetting")) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"ctrlstrategy"});
        }
    }

    protected void updateBudgetViewByProject() {
        boolean isNew;
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null && (isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue())))) {
            return;
        }
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        FieldEdit budgetItem = (FieldEdit)this.getControl("budgetitem");
        FieldEdit listingBudgetItem = (FieldEdit)this.getControl("listingbudgetitem");
        if (project != null && contract != null) {
            QFilter proFilter = new QFilter("pro", "=", project.getPkValue());
            DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{proFilter});
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean needProjectCostControl = projectApproval != null && projectApproval.getBoolean("projectcostcontrol");
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            boolean isOpenedContract = contract.getBoolean("openedcontract");
            if (needProjectCostControl && !multiPartSettlement && !isOpenedContract) {
                boolean isBasedOnList = contract.getBoolean("isonlist");
                budgetItem.setMustInput(!isBasedOnList);
                listingBudgetItem.setMustInput(isBasedOnList);
            } else {
                budgetItem.setMustInput(false);
                listingBudgetItem.setMustInput(false);
            }
        } else {
            budgetItem.setMustInput(false);
            listingBudgetItem.setMustInput(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object propNewValue = e.getChangeSet()[0].getNewValue();
        Object propOldValue = e.getChangeSet()[0].getOldValue();
        switch (propName) {
            case "project": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                if (contract != null && propNewValue != null && !propNewValue.equals(contract.getDynamicObject("project"))) {
                    this.getModel().setValue("contract", null);
                }
                this.getModel().setValue("budgetitem", null);
                this.updateBudgetViewByProject();
                break;
            }
            case "contract": {
                if (!this.checkContractMutex(e)) {
                    return;
                }
                this.updateBudgetViewByProject();
                ContractHelper.showContractList((IFormView)this.getView());
                ContractHelper.initListCardEntry((IFormView)this.getView(), (String)"kapianentry", (DynamicObject)((DynamicObject)propNewValue));
                ContractHelper.loadPayPlanEntry((IFormView)this.getView(), (DynamicObject)((DynamicObject)propNewValue), (String)CLAIM_PAY_PLAN);
                this.onChangeContract();
                break;
            }
            case "paypercent": {
                this.changePayPercent(rowIndex);
                break;
            }
            case "payamountoftax": {
                this.changePayAmountOfTax(rowIndex);
                break;
            }
            case "isneedsettle": {
                this.changeIsNeedSettle();
                break;
            }
            case "subclaimtype": {
                this.changeSubClaimType(rowIndex);
                break;
            }
            case "nodesetting": {
                this.changeNodeSetting(rowIndex, propNewValue, propOldValue);
                break;
            }
            case "ctrlstrategy": {
                this.ctrlStrategyChange(rowIndex, propNewValue, propOldValue);
                break;
            }
        }
    }

    protected void changeNodeSetting(int rowIndex, Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("claimpayplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conplanitemid");
        DynamicObject payItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractpayitem");
        String payItemName = null == payItem ? null : payItem.getString("name");
        Long payItemNodeId = null;
        if (null != payItem && null != payItem.getDynamicObject("nodesetting")) {
            payItemNodeId = payItem.getDynamicObject("nodesetting").getLong("id");
        }
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && null != payItemNodeId && ((DynamicObject)oldValue).getLong("id") == payItemNodeId.longValue()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u6536\u6b3e\u8282\u70b9\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractClaimBillPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("nodesetting", (IFormPlugin)this));
            String nodeSettingOldId = oldValue != null ? ((DynamicObject)oldValue).getString("id") : null;
            this.getPageCache().put("oldValue", nodeSettingOldId);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("ctrlstrategy", null, rowIndex);
            this.getModel().setValue("taskcompletestate", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"ctrlstrategy"});
        DynamicObject nodeSetting = (DynamicObject)newValue;
        if (null == nodeSetting.getDynamicObjectType().getProperty("completionstatus") && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
        }
        String completionStatus = nodeSetting.getString("completionstatus");
        String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
        this.getModel().setValue("taskcompletestate", (Object)status, rowIndex);
    }

    private void ctrlStrategyChange(int rowIndex, Object newValue, Object oldValue) {
        String payItemStrategy;
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("claimpayplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conplanitemid");
        DynamicObject payItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractpayitem");
        String payItemName = null == payItem ? null : payItem.getString("name");
        String string = payItemStrategy = null == payItem ? null : payItem.getString("ctrlstrategy");
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && StringUtils.equals((CharSequence)payItemStrategy, (CharSequence)oldValue.toString())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u63a7\u5236\u7b56\u7565\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractClaimBillPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ctrlstrategy", (IFormPlugin)this));
            String ctrlStrategyOldValue = oldValue.toString();
            this.getPageCache().put("oldValue", ctrlStrategyOldValue);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("taskcompletestate", null, rowIndex);
        }
    }

    private void changeSubClaimType(int rowIndex) {
        String subClaimType = this.getModel().getValue("subclaimtype", rowIndex).toString();
        DynamicObject budgetItem = (DynamicObject)this.getModel().getValue("budgetitem");
        if (ContractListClaimTypeEnum.NEW_DETAIL_LIST.getValue().equals(subClaimType) || ContractListClaimTypeEnum.NEW_NON_DETAIL_LIST.getValue().equals(subClaimType)) {
            this.getModel().setValue("listingbudgetitem", (Object)budgetItem, rowIndex);
        } else {
            this.getModel().setValue("listingbudgetitem", null, rowIndex);
        }
    }

    private void changeIsNeedSettle() {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        ContractHelper.showPayPlanEntry((IFormView)this.getView(), (DynamicObject)contract, (String)CLAIM_PAY_PLAN, (String)"claimpayplanentry");
        ContractHelper.loadPayPlanEntry((IFormView)this.getView(), (DynamicObject)contract, (String)CLAIM_PAY_PLAN);
        ContractHelper.initListCardEntry((IFormView)this.getView(), (String)"kapianentry", (DynamicObject)contract);
        this.getModel().setValue("claimoftaxamount", null);
        this.getModel().setValue("taxamount", null);
        this.getModel().setValue("claimamount", null);
    }

    private void changePayAmountOfTax(int rowIndex) {
        this.getModel().beginInit();
        BigDecimal payAmountOfTax = (BigDecimal)this.getModel().getValue("payamountoftax", rowIndex);
        BigDecimal afterOfTaxAmount = (BigDecimal)this.getModel().getValue("afteroftaxamount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        int amtPrecision = currency == null ? 2 : currency.getInt("amtprecision");
        this.getModel().setValue("paypercent", (Object)payAmountOfTax.multiply(ONE_HUNDRED).divide(afterOfTaxAmount, amtPrecision, 4));
        this.getModel().endInit();
        this.getView().updateView("claimpayplanentry");
    }

    private void changePayPercent(int rowIndex) {
        this.getModel().beginInit();
        BigDecimal payPercent = ((BigDecimal)this.getModel().getValue("paypercent", rowIndex)).divide(ONE_HUNDRED);
        BigDecimal afterOfTaxAmount = (BigDecimal)this.getModel().getValue("afteroftaxamount");
        this.getModel().setValue("payamountoftax", (Object)afterOfTaxAmount.multiply(payPercent));
        this.getModel().endInit();
        this.getView().updateView("claimpayplanentry");
    }

    protected void doCalculateRatio() {
        BigDecimal afterOfTaxAmount;
        DynamicObjectCollection claimPayPlanEntry = this.getModel().getEntryEntity("claimpayplanentry");
        if (!claimPayPlanEntry.isEmpty() && (afterOfTaxAmount = (BigDecimal)this.getModel().getValue("afteroftaxamount")) != null && afterOfTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
            for (DynamicObject claimPayPlanEntryObj : claimPayPlanEntry) {
                BigDecimal payAmountOfTax = claimPayPlanEntryObj.getBigDecimal("payamountoftax");
                BigDecimal ratio = payAmountOfTax.divide(afterOfTaxAmount, 4, 4).multiply(BigDecimal.valueOf(100L));
                claimPayPlanEntryObj.set("paypercent", (Object)ratio);
                int index = claimPayPlanEntry.indexOf((Object)claimPayPlanEntryObj);
                this.getView().updateView("paypercent", index);
            }
        }
    }

    private boolean checkContractMutex(PropertyChangedArgs e) {
        DynamicObject newContract = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newContract == null) {
            return true;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)"C");
        QFilter isNeedSettleFilter = new QFilter("isneedsettle", "=", (Object)Boolean.TRUE);
        QFilter contractFilter = new QFilter("contract", "=", newContract.getPkValue());
        QFilter unContainFilter = new QFilter("id", "!=", (Object)Long.parseLong(dataEntity.getPkValue().toString()));
        DynamicObject[] outClaims = BusinessDataServiceHelper.load((String)"pmct_outclaimbill", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, isNeedSettleFilter, contractFilter, unContainFilter});
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, contractFilter, unContainFilter});
        DynamicObject[] outContractRevisions = BusinessDataServiceHelper.load((String)"pmct_outcontractrevision", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, contractFilter, unContainFilter});
        DynamicObject[] outContAddAgreements = BusinessDataServiceHelper.load((String)"pmct_outaddagreement", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, contractFilter, unContainFilter});
        if (outClaims.length > 0) {
            DynamicObject inClaim = outClaims[0];
            this.getPageCache().put("outClaimId", inClaim.getPkValue().toString());
            this.getModel().setValue("contract", null);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7d22\u8d54\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u7d22\u8d54\u5355\u3002\u662f\u5426\u8df3\u8f6c\u5230\u672a\u5ba1\u6838\u7684\u7d22\u8d54\u5355\u8fdb\u884c\u5904\u7406\uff1f", (String)"OutContractClaimBillPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(IS_CLOSEDCALLBACK_CONTRACT, (IFormPlugin)this));
            return false;
        }
        if (contractRevisions.length > 0) {
            this.getModel().setValue("contract", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u7d22\u8d54\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4fee\u8ba2\u5355\uff0c\u8bf7\u5f85\u4fee\u8ba2\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"OutContractClaimBillPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (outContractRevisions.length > 0) {
            this.getModel().setValue("contract", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u7d22\u8d54\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u53d8\u66f4\u5355\uff0c\u8bf7\u5f85\u53d8\u66f4\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"OutContractClaimBillPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (outContAddAgreements.length > 0) {
            this.getModel().setValue("contract", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u7d22\u8d54\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u8865\u5145\u534f\u8bae\uff0c\u8bf7\u5f85\u8865\u5145\u534f\u8bae\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"OutContractClaimBillPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "showclaimrecords": {
                DynamicObject obj = (DynamicObject)this.getModel().getValue("contract");
                if (obj == null) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"OutContractClaimBillPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String billFormId = this.getView().getFormShowParameter().getFormId();
                ListShowParameter parameter = new ListShowParameter();
                parameter.getListFilterParameter().setFilter(new QFilter("contract.id", "=", obj.get("id")));
                parameter.getListFilterParameter().setFilter(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
                parameter.setLookUp(true);
                parameter.setMultiSelect(false);
                parameter.setFormId("bos_listf7");
                parameter.setBillFormId(billFormId);
                StyleCss css = new StyleCss();
                css.setWidth("1068");
                css.setHeight("648");
                parameter.getOpenStyle().setInlineStyleCss(css);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setShowTitle(false);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "calculateratio": {
                this.doCalculateRatio();
                break;
            }
            case "calculateamount": {
                this.doCalculateAmount();
                break;
            }
            case "deletepayplan": {
                this.checkDeletePayPlan(args);
                break;
            }
            case "viewcompare": {
                this.viewCompare();
                break;
            }
            case "submit": {
                ContractEditHelper.setCheckParameter((BeforeDoOperationEventArgs)args, (String)"pmct_outclaimbill", (String)CLAIM_PAY_PLAN);
                break;
            }
            case "addpayplan": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                if (contract != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"OutContractClaimBillPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private void viewCompare() {
        if (this.getModel().getValue("contract") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"OutContractClaimBillPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(PARAMETER_SOURCE_ID, this.getModel().getDataEntity().getPkValue());
        param.put(PARAMETER_CONTRACT_ID, ((DynamicObject)this.getModel().getValue("contract")).getPkValue());
        param.put(PARAMETER_CHANGE_TYPE, PayPlanSourceEnum.CLAIM.getValue());
        param.put(PARAMETER_FORM_ID, "pmct_outclaimbill");
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outclaimbill")).getDynamicObjectCollection("claimpayplanentry").getDynamicObjectType();
        DynamicObjectCollection claimPayPlanEntry = this.getModel().getEntryEntity("claimpayplanentry");
        param.put(PARAMETER_CUSTOM_ENTRY_DATA, DynamicObjectSerializeUtil.serialize((Object[])claimPayPlanEntry.toArray(), (DynamicObjectType)dt));
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmct_fundplanchange");
        showParameter.setCustomParams(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void checkDeletePayPlan(BeforeDoOperationEventArgs args) {
        EntryGrid claimPayPlanEntry = (EntryGrid)this.getControl("claimpayplanentry");
        int[] selectRows = claimPayPlanEntry.getSelectRows();
        for (int index = 0; index < selectRows.length; ++index) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("claimpayplanentry", selectRows[index]);
            String conPayItemId = entryRowEntity.getString("conplanitemid");
            if (!StringUtils.isNotBlank((CharSequence)conPayItemId)) continue;
            DynamicObject conPayItemObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(conPayItemId), (String)"pmbs_contractpayitem");
            BigDecimal reimbursedComAmt = conPayItemObj.getBigDecimal("reimbursedcomamt");
            BigDecimal paidComAmt = conPayItemObj.getBigDecimal("paidcomamt");
            if (reimbursedComAmt == null || reimbursedComAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u62a5\u9500\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"OutContractClaimBillPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (paidComAmt == null || paidComAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u4ed8\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"OutContractClaimBillPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String payItemName = conPayItemObj.getString("name");
            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractpayitembook", (Long[])new Long[]{conPayItemObj.getLong("id")});
            if (!targetBillIds.isEmpty()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"OutContractClaimBillPlugin_18", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName));
                args.setCancel(true);
                return;
            }
            BigDecimal appliedComAmt = conPayItemObj.getBigDecimal("appliedcomamt");
            if (NumberHelper.isNullZero((BigDecimal)appliedComAmt)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u4ed8\u6b3e\u7533\u8bf7\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"OutContractClaimBillPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    protected void doCalculateAmount() {
        DynamicObjectCollection claimPayPlanEntry = this.getModel().getEntryEntity("claimpayplanentry");
        if (!claimPayPlanEntry.isEmpty()) {
            BigDecimal afterOfTaxAmount = (BigDecimal)this.getModel().getValue("afteroftaxamount");
            for (DynamicObject claimPayPlanEntryObj : claimPayPlanEntry) {
                BigDecimal payPercent = claimPayPlanEntryObj.getBigDecimal("paypercent");
                BigDecimal payAmountOfTax = afterOfTaxAmount.multiply(payPercent.divide(BigDecimal.valueOf(100L)));
                claimPayPlanEntryObj.set("payamountoftax", (Object)payAmountOfTax);
                int index = claimPayPlanEntry.indexOf((Object)claimPayPlanEntryObj);
                this.getView().updateView("payamountoftax", index);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "contract": {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ContractHelper.getContractByStatus((String)"pmct_outclaimbill", (ListShowParameter)showParameter, (String)PayDirectionEnum.OUT.getValue());
                break;
            }
            case "budgetitem": 
            case "listingbudgetitem": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                QFilter idFilter = new ProjectBudgetItemService().getBudgetItemFilter(contract);
                if (idFilter == null) {
                    return;
                }
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "nodesetting": {
                this.beforeSelectNodeSetting(beforeF7SelectEvent);
                break;
            }
            case "supplier": {
                this.beforeSelectPlanEntrySupplier(beforeF7SelectEvent);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        int rowIndex;
        String oldValue;
        super.confirmCallBack(e);
        String callId = e.getCallBackId();
        if (IS_CLOSEDCALLBACK_CONTRACT.equals(callId)) {
            if (MessageBoxResult.Yes == e.getResult()) {
                String inClaimId = this.getPageCache().get("outClaimId");
                this.getPageCache().remove("outClaimId");
                if (!inClaimId.isEmpty()) {
                    BillShowParameter billShowParameter = new BillShowParameter();
                    billShowParameter.setPkId((Object)Long.parseLong(inClaimId));
                    billShowParameter.setFormId("pmct_outclaimbill");
                    billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)billShowParameter);
                }
            } else {
                this.getPageCache().remove("outClaimId");
            }
        }
        int result = e.getResult().getValue();
        if ("nodesetting".equals(callId) && result == MessageBoxResult.Cancel.getValue()) {
            oldValue = null != this.getPageCache().get("oldValue") ? Long.valueOf(Long.parseLong(this.getPageCache().get("oldValue"))) : null;
            rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
            this.getModel().setValue("nodesetting", (Object)oldValue, rowIndex);
        }
        if ("ctrlstrategy".equals(callId) && result == MessageBoxResult.Cancel.getValue()) {
            oldValue = this.getPageCache().get("oldValue");
            rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
            this.getModel().setValue("ctrlstrategy", (Object)oldValue, rowIndex);
        }
    }

    private void beforeSelectPlanEntrySupplier(BeforeF7SelectEvent evt) {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract != null) {
            DynamicObject partB = contract.getDynamicObject("partb");
            DynamicObjectCollection otherParts = contract.getDynamicObjectCollection("otherpart");
            QFilter supplierIdFilter = ContractSupplierHelper.getContractSupplierFilter((DynamicObject)partB, (DynamicObjectCollection)otherParts);
            evt.addCustomQFilter(supplierIdFilter);
        }
    }

    protected void beforeSelectNodeSetting(BeforeF7SelectEvent evt) {
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        param.setFormId("bos_listf7");
        QFilter qFilter = new QFilter("project", "=", null != project ? project.getPkValue() : null);
        param.getListFilterParameter().getQFilters().add(qFilter);
        QFilter txTypeFilter = new QFilter("number", "=", (Object)"004");
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)"pmpt_transactiontype", (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        qFilter = new QFilter(String.join((CharSequence)".", "transactiontype", "fbasedataid_id"), "in", txType.getPkValue());
        param.getListFilterParameter().getQFilters().add(qFilter);
        qFilter = new QFilter("islatest", "=", (Object)true);
        param.getListFilterParameter().getQFilters().add(qFilter);
    }
}

