/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.contpref;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmct.business.helper.PerformHelper;
import kd.pmgt.pmct.common.enums.DirectionEnum;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class InContractPerformBillPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject project;
        DynamicObject contract;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        Object propValue = valueSet[0].getNewValue();
        boolean amtChangeFlag = false;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal noTaxAmount = BigDecimal.ZERO;
        if (StringUtils.equals((CharSequence)key, (CharSequence)"contract")) {
            this.getModel().deleteEntryData("entryentity");
            contract = (DynamicObject)this.getModel().getValue("contract");
            if (Objects.nonNull(contract)) {
                DynamicObject singleContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
                if (singleContract.getDynamicObject("project") != null) {
                    this.getModel().setValue("project", singleContract.getDynamicObject("project").getPkValue());
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"budgetitem"});
                } else {
                    this.getModel().setValue("project", null);
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"budgetitem"});
                }
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"isneedsettle")) {
            boolean isNeedSettle = (Boolean)this.getModel().getValue("isneedsettle");
            if (isNeedSettle) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"contpayitem"});
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"budgetitem"});
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"contpayitem"});
                this.getModel().setValue("contpayitem", null, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"budgetitem"});
                this.getModel().setValue("budgetitem", null, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"amount")) {
            amtChangeFlag = true;
            amount = (BigDecimal)propValue;
            tax = (BigDecimal)this.getModel().getValue("tax", rowIndex);
            noTaxAmount = amount.subtract(tax);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"notaxamount")) {
            amtChangeFlag = true;
            noTaxAmount = (BigDecimal)propValue;
            tax = (BigDecimal)this.getModel().getValue("tax", rowIndex);
            amount = noTaxAmount.add(tax);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"tax")) {
            amtChangeFlag = true;
            tax = (BigDecimal)propValue;
            noTaxAmount = (BigDecimal)this.getModel().getValue("notaxamount", rowIndex);
            amount = tax.add(noTaxAmount);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"project") && (contract = (DynamicObject)this.getModel().getValue("contract")) != null && ((project = contract.getDynamicObject("project")) == null || propValue == null || !((DynamicObject)propValue).getPkValue().equals(project.getPkValue()))) {
            this.getModel().setValue("contract", null);
        }
        if (amtChangeFlag) {
            this.getModel().beginInit();
            this.getModel().setValue("amount", (Object)amount, rowIndex);
            this.getModel().setValue("notaxamount", (Object)noTaxAmount, rowIndex);
            this.getModel().setValue("tax", (Object)tax, rowIndex);
            boolean ismulticurrency = (Boolean)this.getModel().getValue("ismulticurrency");
            if (ismulticurrency) {
                BigDecimal exchangerate = (BigDecimal)this.getModel().getValue("exchangerate");
                BigDecimal stdamount = amount.multiply(exchangerate);
                BigDecimal stdnoTaxAmount = noTaxAmount.multiply(exchangerate);
                BigDecimal stdtax = tax.multiply(exchangerate);
                this.getModel().setValue("stdamount", (Object)stdamount, rowIndex);
                this.getModel().setValue("stdnotaxamount", (Object)stdnoTaxAmount, rowIndex);
                this.getModel().setValue("stdtax", (Object)stdtax, rowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("amount", rowIndex);
            this.getView().updateView("notaxamount", rowIndex);
            this.getView().updateView("tax", rowIndex);
            if (ismulticurrency) {
                this.getView().updateView("stdamount", rowIndex);
                this.getView().updateView("stdnotaxamount", rowIndex);
                this.getView().updateView("stdtax", rowIndex);
            }
        }
        IFormView view = this.getView();
        PerformHelper.setTotalData((IFormView)view);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contpayitem = (BasedataEdit)this.getControl("contpayitem");
        contpayitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contract = (BasedataEdit)this.getControl("contract");
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_incontract", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("budgetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        budgetItem.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmas_projectbudget", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String propertyName = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpayitem")) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"InContractPerformBillPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            DynamicObject contracttype = contract.getDynamicObject("contracttype");
            if (null != contracttype) {
                QFilter filter4 = this.getContTypeIdQFilter(contracttype);
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter4);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contract")) {
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            ContractHelper.getContractByStatus((String)"pmct_inperformrecords", (ListShowParameter)parameter, (String)PayDirectionEnum.IN.getValue());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"budgetitem", (CharSequence)propertyName)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            String sourceTypeIn = "IN";
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("project");
            if (Objects.nonNull(dynamicObject)) {
                QFilter contStatusFilter = new QFilter("project", "=", dynamicObject.getPkValue());
                QFilter typeFilter = new QFilter("sourcetype", "=", (Object)sourceTypeIn);
                contStatusFilter.and(typeFilter);
                showParameter.getListFilterParameter().getQFilters().add(contStatusFilter);
            }
        }
    }

    protected QFilter getContTypeIdQFilter(DynamicObject contracttype) {
        QFilter ispreitem = new QFilter("ispreitem", "!=", (Object)Boolean.TRUE);
        QFilter direction = new QFilter("direction", "!=", (Object)DirectionEnum.NON.getValue());
        QFilter iscompute = new QFilter("iscompute", "!=", (Object)Boolean.TRUE);
        QFilter filter1 = ispreitem.and(direction).and(iscompute);
        QFilter filter3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter typeQFilter = new QFilter("contracttype.fbasedataid", "in", Collections.singletonList(contracttype.getPkValue())).or("contracttype.fbasedataid", "=", null);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"pmct_payitem", (String)"id", (QFilter[])new QFilter[]{typeQFilter, filter1, filter3});
        return new QFilter("id", "in", collection.stream().map(obj -> obj.get("id")).collect(Collectors.toSet()));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.getModel().getValue("bizdate") == null) {
            this.getModel().setValue("bizdate", (Object)new Date());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (Objects.nonNull(contract)) {
            DynamicObject singleContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
            this.getView().setVisible(Boolean.valueOf(singleContract.getDynamicObject("project") != null), new String[]{"budgetitem"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"budgetitem"});
        }
        IFormView view = this.getView();
        PerformHelper.setTotalData((IFormView)view);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (StringUtils.equals((CharSequence)"newentry", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"insertentry", (CharSequence)operateKey)) {
            if (contract == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"InContractPerformBillPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            if (Objects.nonNull(contract)) {
                for (int i = 0; i < rowCount; ++i) {
                    boolean isneedsettle = (Boolean)this.getModel().getValue("isneedsettle", i);
                    DynamicObject contpayitem = (DynamicObject)this.getModel().getValue("contpayitem", i);
                    if (!isneedsettle || contpayitem != null) continue;
                    String msg = String.format(ResManager.loadKDStringExt((String)"\u4e8b\u52a1\u8bb0\u5f55\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff0c\u5df2\u52fe\u9009\u201c\u9700\u8981\u72ec\u7acb\u7ed3\u7b97\u201d\uff0c\u8bf7\u9009\u62e9\u5408\u540c\u652f\u4ed8\u9879\u3002", (String)"InContractPerformBillPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), i + 1);
                    this.getView().showErrorNotification(msg);
                    args.setCancel(true);
                    return;
                }
            }
        }
    }
}

