/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.contsettle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.TreeSubEntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.business.utils.ContractTypeUtils;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class OutFinalSettleBillPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.getModel().getValue("bizdate") == null) {
            this.getModel().setValue("bizdate", (Object)new Date());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
        } else {
            QFilter filter = new QFilter("contract", "=", contract.getPkValue());
            DynamicObject[] contBudgetInfo = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter});
            if (contBudgetInfo.length <= 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            }
            DynamicObject singleContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean isLastRate = true;
            if (!singleContract.getBoolean("ismultirate")) {
                BigDecimal settleRate;
                BigDecimal contractRate;
                DynamicObject contractRateDyn = singleContract.getDynamicObject("lsttaxrate");
                DynamicObject settleRateDyn = this.getModel().getDataEntity().getDynamicObject("taxrate");
                if (contractRateDyn != null && settleRateDyn != null && (contractRate = contractRateDyn.getBigDecimal("taxrate")).compareTo(settleRate = settleRateDyn.getBigDecimal("taxrate")) != 0) {
                    this.getModel().setValue("taxrate", (Object)contractRateDyn);
                    isLastRate = false;
                    SaveServiceHelper.update((DynamicObject)this.getModel().getDataEntity());
                }
            } else {
                BigDecimal contractAvgRate = singleContract.getBigDecimal("lstavgtaxrate");
                BigDecimal settleAvgRate = this.getModel().getDataEntity().getBigDecimal("avgtaxrate");
                if (contractAvgRate != null && settleAvgRate != null && contractAvgRate.compareTo(settleAvgRate) != 0) {
                    this.getModel().setValue("avgtaxrate", (Object)contractAvgRate);
                    isLastRate = false;
                    SaveServiceHelper.update((DynamicObject)this.getModel().getDataEntity());
                }
            }
            if (!isLastRate) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7a0e\u7387\u5df2\u66f4\u65b0\u4e3a\u5408\u540c\u6700\u65b0\u7a0e\u7387\u3002", (String)"OutFinalSettleBillPlugin_18", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object propValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"contract")) {
            this.contractChange();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"project")) {
            this.projectChanged(propValue);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"listfinalsettle") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"listfinalsettletax") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"sublistfinalsettle") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"listfinalsettlesub")) {
            BigDecimal oldVal;
            BigDecimal bigDecimal = oldVal = oldValue == null ? BigDecimal.ZERO : (BigDecimal)oldValue;
            if (propValue == null) {
                return;
            }
            this.sumToParent(key, (BigDecimal)propValue, oldVal, rowIndex);
            int size = this.getModel().getEntryRowCount("cardentry");
            for (int i = 0; i < size; ++i) {
                this.sumListModelEntry(i);
            }
            this.sumHeadAmount();
        }
    }

    protected void projectChanged(Object newValue) {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract != null) {
            if (newValue != null && !newValue.equals(contract.getDynamicObject("project"))) {
                this.getModel().setValue("contract", null);
            } else if (newValue == null) {
                this.getModel().setValue("contract", null);
            }
        }
    }

    public void contractChange() {
        IDataModel model = this.getModel();
        this.cleandata();
        DynamicObject contract = (DynamicObject)model.getValue("contract");
        if (contract == null) {
            model.setValue("ismultirate", (Object)Boolean.FALSE);
            model.setValue("ismulticurrency", (Object)Boolean.FALSE);
            model.setValue("isonlist", (Object)Boolean.FALSE);
            model.setValue("contattr", null);
            model.setValue("taxrate", null);
            model.setValue("cbudgetitem", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
        } else {
            QFilter filter = new QFilter("contract", "=", contract.getPkValue());
            DynamicObject[] existedBills = BusinessDataServiceHelper.load((String)"pmct_outfinalsettle", (String)"billno", (QFilter[])new QFilter[]{filter});
            DynamicObject dataEntity = model.getDataEntity();
            if (existedBills.length > 0 && !existedBills[0].getString("id").equals(dataEntity.getString("id"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u652f\u51fa\u5408\u540c\u51b3\u7b97\u5355%s\uff0c\u65e0\u6cd5\u521b\u5efa\u65b0\u7684\u51b3\u7b97\u5355\u3002", (String)"OutFinalSettleBillPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), existedBills[0].getString("billno")));
            }
            DynamicObject singleContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean existBill = this.checkContBill(singleContract);
            if (existBill) {
                model.setValue("contract", null);
                return;
            }
            if (!singleContract.getBoolean("ismultirate")) {
                model.setValue("taxrate", (Object)singleContract.getDynamicObject("lsttaxrate"));
                model.setValue("avgtaxrate", null);
            } else {
                model.setValue("taxrate", null);
                model.setValue("avgtaxrate", (Object)singleContract.getBigDecimal("lstavgtaxrate"));
            }
            this.autoFetchAmountPerform((Long)contract.get("id"));
            model.setValue("ismulticurrency", (Object)contract.getBoolean("ismulticurrency"));
            model.setValue("ismultirate", (Object)contract.getBoolean("ismultirate"));
            model.setValue("isonlist", (Object)contract.getBoolean("isonlist"));
            if (singleContract.getDynamicObject("project") != null) {
                model.setValue("project", singleContract.getDynamicObject("project").getPkValue());
            } else {
                model.setValue("project", null);
            }
            model.setValue("cbudgetitem", (Object)contract.getDynamicObject("budgetitem"));
            this.loadContractListing(singleContract);
            this.sumHeadAmount();
        }
    }

    private boolean checkContBill(DynamicObject contract) {
        boolean existBill = false;
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        filter.and(new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue()));
        DynamicObject[] reviseBill = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"billno", (QFilter[])new QFilter[]{filter});
        DynamicObject[] changeBill = BusinessDataServiceHelper.load((String)"pmct_outcontractrevision", (String)"billno", (QFilter[])new QFilter[]{filter});
        DynamicObject[] claimBill = BusinessDataServiceHelper.load((String)"pmct_outclaimbill", (String)"billno", (QFilter[])new QFilter[]{filter});
        DynamicObject[] performBill = BusinessDataServiceHelper.load((String)"pmct_outperformrecords", (String)"billno", (QFilter[])new QFilter[]{filter});
        DynamicObject[] settleBill = BusinessDataServiceHelper.load((String)"pmct_outcontract_settle", (String)"billno", (QFilter[])new QFilter[]{filter});
        if (reviseBill.length > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c%1$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5408\u540c\u4fee\u8ba2\u5355\uff0c\u5355\u636e\u7f16\u53f7\u662f%2$s\uff0c\u8bf7\u7b49\u5f85\u5355\u636e\u5ba1\u6838\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OutFinalSettleBillPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contract.getString("billname"), reviseBill[0].getString("billno")));
            existBill = true;
        } else if (changeBill.length > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c%1$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5408\u540c\u53d8\u66f4\u5355\uff0c\u5355\u636e\u7f16\u53f7\u662f%2$s\uff0c\u8bf7\u7b49\u5f85\u5355\u636e\u5ba1\u6838\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OutFinalSettleBillPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contract.getString("billname"), changeBill[0].getString("billno")));
            existBill = true;
        } else if (claimBill.length > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c%1$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5408\u540c\u7d22\u8d54\u5355\uff0c\u5355\u636e\u7f16\u53f7\u662f%2$s\uff0c\u8bf7\u7b49\u5f85\u5355\u636e\u5ba1\u6838\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OutFinalSettleBillPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contract.getString("billname"), claimBill[0].getString("billno")));
            existBill = true;
        } else if (performBill.length > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c%1$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5c65\u7ea6\u4e8b\u52a1\u767b\u8bb0\u5355\uff0c\u5355\u636e\u7f16\u53f7\u662f%2$s\uff0c\u8bf7\u7b49\u5f85\u5355\u636e\u5ba1\u6838\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OutFinalSettleBillPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contract.getString("billname"), performBill[0].getString("billno")));
            existBill = true;
        } else if (settleBill.length > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c%1$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5408\u540c\u7ed3\u7b97\u5355\uff0c\u5355\u636e\u7f16\u53f7\u662f%2$s\uff0c\u8bf7\u7b49\u5f85\u5355\u636e\u5ba1\u6838\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OutFinalSettleBillPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contract.getString("billname"), settleBill[0].getString("billno")));
            existBill = true;
        }
        return existBill;
    }

    private void cleandata() {
        this.getModel().setValue("initamount", null);
        this.getModel().setValue("inittax", null);
        this.getModel().setValue("inittaxamount", null);
        this.getModel().setValue("changeamount", null);
        this.getModel().setValue("changetaxamount", null);
        this.getModel().setValue("amount", null);
        this.getModel().setValue("tax", null);
        this.getModel().setValue("taxamount", null);
        this.getModel().setValue("settleamount", null);
        this.getModel().setValue("settletax", null);
        this.getModel().setValue("settletaxamount", null);
        this.getModel().setValue("invoicetaxamount", null);
        this.getModel().setValue("invoicetax", null);
        this.getModel().setValue("paytaxamount", null);
        this.getModel().setValue("remaintaxamount", null);
        this.getModel().setValue("performtaxamount", null);
        this.getModel().setValue("appamount", null);
        this.getModel().setValue("apptaxamount", null);
        this.getModel().setValue("apptax", null);
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData("treesubentryentity");
        this.getModel().deleteEntryData("cardentry");
    }

    private void autoFetchAmountPerform(Long id) {
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmct_outcontract");
        IDataModel model = this.getModel();
        model.setValue("initamount", contract.get("originalamount"));
        model.setValue("inittax", contract.get("taxamount"));
        model.setValue("inittaxamount", contract.get("originaloftaxamount"));
        BigDecimal totalchangeamount = contract.getBigDecimal("totalclaimamount").add(contract.getBigDecimal("totalrevisionamount")).add(contract.getBigDecimal("totaladditionamount"));
        model.setValue("changeamount", (Object)totalchangeamount);
        BigDecimal totalchangeoftaxamount = contract.getBigDecimal("totalrevisionoftaxamount").add(contract.getBigDecimal("totalclaimoftaxamount")).add(contract.getBigDecimal("totaladditionoftaxamt"));
        model.setValue("changetaxamount", (Object)totalchangeoftaxamount);
        model.setValue("amount", (Object)contract.getBigDecimal("totalamount"));
        model.setValue("tax", (Object)contract.getBigDecimal("totaloftaxamount").subtract(contract.getBigDecimal("totalamount")));
        model.setValue("taxamount", contract.get("totaloftaxamount"));
        model.setValue("settleamount", contract.get("totalsettleamount"));
        model.setValue("settletax", (Object)contract.getBigDecimal("totalsettleoftaxamount").subtract(contract.getBigDecimal("totalsettleamount")));
        model.setValue("settletaxamount", contract.get("totalsettleoftaxamount"));
        model.setValue("invoicetaxamount", contract.get("totalinvoiceoftaxamount"));
        BigDecimal totalInvoiceAmount = contract.getBigDecimal("totalinvoiceamount");
        model.setValue("invoicetax", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalInvoiceAmount));
        model.setValue("paytaxamount", contract.get("totalrealoftaxamount"));
        model.setValue("remaintaxamount", (Object)contract.getBigDecimal("totaloftaxamount").subtract(contract.getBigDecimal("totalsettleoftaxamount")));
        model.setValue("performtaxamount", contract.get("performtaxamount"));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)"contract", (CharSequence)key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ContractHelper.getContractByStatus((String)"pmct_outfinalsettle", (ListShowParameter)showParameter, (String)PayDirectionEnum.OUT.getValue());
        }
    }

    private void loadContractListing(DynamicObject contract) {
        this.getModel().deleteEntryData("cardentry");
        DynamicObjectCollection listConfigs = ContractTypeUtils.getListConfigs((DynamicObject)contract.getDynamicObject("contracttype"));
        if (listConfigs == null || listConfigs.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("contractid", "=", (Object)String.valueOf(contract.getPkValue()));
        DynamicObjectCollection contractList = QueryServiceHelper.query((String)"pmct_contractlist", (String)"listingmodel", (QFilter[])new QFilter[]{qFilter});
        Set listModelIds = contractList.stream().map(obj -> obj.getLong("listingmodel")).collect(Collectors.toSet());
        for (DynamicObject listConfig : listConfigs) {
            if (!listModelIds.contains(listConfig.getPkValue())) continue;
            String tabName = listConfig.getString("tabname");
            String cmpRule = listConfig.getString("computerule");
            int rowIndex = this.getModel().createNewEntryRow("cardentry");
            this.getModel().setValue("modelname", (Object)tabName, rowIndex);
            this.getModel().setValue("listmodelid", listConfig.getPkValue(), rowIndex);
            if ("00".equals(cmpRule)) {
                this.getModel().setValue("cmptype", (Object)"(+)", rowIndex);
                continue;
            }
            if ("01".equals(cmpRule)) {
                this.getModel().setValue("cmptype", (Object)"(-)", rowIndex);
                continue;
            }
            if (!"02".equals(cmpRule)) continue;
            this.getModel().setValue("cmptype", (Object)"(0)", rowIndex);
        }
        Boolean isOnList = (Boolean)this.getModel().getValue("isonlist");
        DynamicObjectCollection listModelEntry = this.getModel().getEntryEntity("cardentry");
        if (listModelEntry.size() > 0 && isOnList.booleanValue()) {
            DynamicObjectType sublistDy = this.getModel().getEntryEntity("treesubentryentity").getDynamicObjectType();
            for (DynamicObject listModel : listModelEntry) {
                DynamicObjectCollection sublistEntries = new DynamicObjectCollection(sublistDy, (Object)listModel);
                String listModelId = listModel.getString("listmodelid");
                String allProperty = "modifier, createtime, modifytime, number, name, status, creator, enable, masterid, level, longnumber, fullname, isleaf, parent, sysnumber, measureunit, qty, taxprice, taxrate, rateobj, amount, price, tax, oftax, desc, lstsettleqty, lstsettleoftaxamount, changeqty, chgeffectqty, chgoftaxamount, totalqty, curtaxprice, lstoftaxamount, avgtaxprice, ischanged, isaddnew, material, sequence, entryid, currency, listparentid, listingmodel, contractid, paydirection,listingbudgetitem,latestamount";
                QFilter contFilter = new QFilter("contractid", "=", (Object)contract.getString("id")).and("listingmodel", "=", (Object)listModelId);
                DynamicObject[] listEntries = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)allProperty, (QFilter[])new QFilter[]{contFilter}, (String)"sysnumber desc");
                if (null == listEntries || listEntries.length <= 0) continue;
                HashMap<Long, Long> idToOldIdMap = new HashMap<Long, Long>(listEntries.length);
                sublistEntries.clear();
                BigDecimal rowOfTax = BigDecimal.ZERO;
                BigDecimal rowTax = BigDecimal.ZERO;
                long[] ids = DB.genLongIds((String)"t_pmct_settle_treelist", (int)listEntries.length);
                for (int i = listEntries.length - 1; i >= 0; --i) {
                    DynamicObject listEntry = listEntries[i];
                    DynamicObject item = sublistEntries.addNew();
                    Long oldId = listEntry.getLong("id");
                    idToOldIdMap.put(oldId, ids[i]);
                    item.set("id", (Object)ids[i]);
                    item.set("listnumber", (Object)listEntry.getString("number"));
                    item.set("listname", (Object)listEntry.getString("name"));
                    item.set("measureunit", (Object)listEntry.getDynamicObject("measureunit"));
                    item.set("qty", (Object)listEntry.getBigDecimal("totalqty"));
                    item.set("taxprice", (Object)listEntry.getBigDecimal("curtaxprice"));
                    BigDecimal lstOfTaxAmount = listEntry.getBigDecimal("lstoftaxamount");
                    item.set("oftax", (Object)lstOfTaxAmount);
                    item.set("rateobj", (Object)listEntry.getDynamicObject("rateobj"));
                    item.set("isleaf", (Object)listEntry.getBoolean("isleaf"));
                    item.set("rateobj", (Object)listEntry.getDynamicObject("rateobj"));
                    String pidStr = listEntry.getString("listparentid");
                    if (StringUtils.isNotEmpty((CharSequence)pidStr)) {
                        item.set("pid", (Object)Long.parseLong(pidStr));
                    }
                    item.set("seq", (Object)listEntry.getInt("sequence"));
                    item.set("listingbudgetitem", (Object)listEntry.getDynamicObject("listingbudgetitem"));
                    item.set("lstsettleqty", (Object)listEntry.getBigDecimal("lstsettleqty"));
                    item.set("lstsettleoftaxamount", (Object)listEntry.getBigDecimal("lstsettleoftaxamount"));
                    item.set("listfinalsettle", (Object)listEntry.getBigDecimal("lstsettleoftaxamount"));
                    BigDecimal lstSettleOfTaxAmt = listEntry.getBigDecimal("lstsettleoftaxamount");
                    BigDecimal tax = BigDecimal.ZERO;
                    BigDecimal ofTaxAmount = lstSettleOfTaxAmt;
                    BigDecimal taxRate = BigDecimal.ZERO;
                    Iterator rateObj = listEntry.getDynamicObject("rateobj");
                    if (rateObj != null) {
                        taxRate = rateObj.getBigDecimal("taxrate");
                    }
                    if (taxRate != null && (taxRate = taxRate.divide(BigDecimal.valueOf(100L))).compareTo(BigDecimal.ZERO) != 0) {
                        tax = lstSettleOfTaxAmt.multiply(taxRate);
                        ofTaxAmount = lstSettleOfTaxAmt.subtract(tax);
                    }
                    item.set("listfinalsettletax", (Object)tax);
                    item.set("sublistfinalsettle", (Object)ofTaxAmount);
                    if (item.getBoolean("isleaf")) {
                        item.set("listfinalsettlesub", (Object)listEntry.getBigDecimal("lstsettleoftaxamount").subtract(lstOfTaxAmount));
                    }
                    rowOfTax = rowOfTax.add(lstSettleOfTaxAmt);
                    rowTax = rowTax.add(tax);
                }
                for (DynamicObject entry : sublistEntries) {
                    long oldPid = entry.getLong("pid");
                    if (oldPid == 0L) continue;
                    Long newPid = idToOldIdMap.getOrDefault(oldPid, 0L);
                    entry.set("pid", (Object)newPid);
                }
                block4: for (DynamicObject entry : sublistEntries) {
                    boolean isLeaf = entry.getBoolean("isleaf");
                    BigDecimal childFinalSettle = entry.getBigDecimal("listfinalsettle");
                    BigDecimal childFinalSettleTax = entry.getBigDecimal("listfinalsettletax");
                    BigDecimal childSubListFinalSettle = entry.getBigDecimal("sublistfinalsettle");
                    BigDecimal childListFinalSettleSub = entry.getBigDecimal("listfinalsettlesub");
                    if (!isLeaf) continue;
                    long pid = entry.getLong("pid");
                    while (pid != 0L) {
                        DynamicObject father = null;
                        for (DynamicObject findFather : sublistEntries) {
                            long id = findFather.getLong("id");
                            if (id != pid) continue;
                            father = findFather;
                            break;
                        }
                        if (father == null) continue block4;
                        BigDecimal fatherFinalSettle = father.getBigDecimal("listfinalsettle");
                        BigDecimal fatherFinalSettleTax = father.getBigDecimal("listfinalsettletax");
                        BigDecimal fatherSublistFinalSettle = father.getBigDecimal("sublistfinalsettle");
                        BigDecimal fatherListFinalSettleSub = father.getBigDecimal("listfinalsettlesub");
                        father.set("listfinalsettle", (Object)fatherFinalSettle.add(childFinalSettle));
                        father.set("listfinalsettletax", (Object)fatherFinalSettleTax.add(childFinalSettleTax));
                        father.set("sublistfinalsettle", (Object)fatherSublistFinalSettle.add(childSubListFinalSettle));
                        father.set("listfinalsettlesub", (Object)childListFinalSettleSub.add(fatherListFinalSettleSub));
                        pid = father.getLong("pid");
                    }
                }
                listModel.set("treesubentryentity", (Object)sublistEntries);
                listModel.set("totaloftaxamount", (Object)rowOfTax);
                listModel.set("totaltax", (Object)rowTax);
                listModel.set("totalamount", (Object)rowOfTax.subtract(rowTax));
            }
        }
        this.getView().updateView("treesubentryentity");
        this.getView().updateView("cardentry");
        this.getView().updateView("apptaxamount");
        this.getView().updateView("apptax");
        this.getView().updateView("appamount");
        TreeSubEntryGrid entryGrid = (TreeSubEntryGrid)this.getView().getControl("treesubentryentity");
        entryGrid.setCollapse(false);
        CardEntry cardEntry = (CardEntry)this.getControl("cardentry");
        cardEntry.selectRows(0);
        cardEntry.entryRowClick(Integer.valueOf(0));
    }

    private void sumToParent(String propName, BigDecimal newAmount, BigDecimal oldAmount, int index) {
        DynamicObjectCollection treeEntries = (DynamicObjectCollection)this.getModel().getValue("treesubentryentity");
        DynamicObject treeEntry = (DynamicObject)treeEntries.get(index);
        String parentId = treeEntry.getString("pid");
        if (StringUtils.isEmpty((CharSequence)parentId) || "0".equals(parentId)) {
            return;
        }
        for (int i = index - 1; i >= 0; --i) {
            String curRowId = this.getModel().getEntryRowEntity("treesubentryentity", i).getString("id");
            if (!parentId.equals(curRowId)) continue;
            BigDecimal curAmount = (BigDecimal)this.getModel().getValue(propName, i);
            this.getModel().setValue(propName, (Object)newAmount.add(curAmount).subtract(oldAmount), i);
            break;
        }
    }

    private void sumListModelEntry(int rowIndex) {
        DynamicObject modelEntry = this.getModel().getEntryRowEntity("cardentry", rowIndex);
        DynamicObjectCollection subListEntries = modelEntry.getDynamicObjectCollection("treesubentryentity");
        BigDecimal oftax = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        for (DynamicObject subListEntry : subListEntries) {
            boolean isTreeLeaf = subListEntry.getBoolean("isleaf");
            if (!isTreeLeaf) continue;
            BigDecimal rowOftax = subListEntry.getBigDecimal("listfinalsettle");
            if (rowOftax == null) {
                rowOftax = BigDecimal.ZERO;
            }
            oftax = oftax.add(rowOftax);
            BigDecimal rowAmount = subListEntry.getBigDecimal("listfinalsettletax");
            if (rowAmount == null) {
                rowAmount = BigDecimal.ZERO;
            }
            tax = tax.add(rowAmount);
        }
        BigDecimal amount = oftax.subtract(tax);
        this.getModel().setValue("totalamount", (Object)amount, rowIndex);
        this.getModel().setValue("totaltax", (Object)tax, rowIndex);
        this.getModel().setValue("totaloftaxamount", (Object)oftax, rowIndex);
    }

    private void sumHeadAmount() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("cardentry");
        BigDecimal originalOftaxAmount = BigDecimal.ZERO;
        BigDecimal originalAmount = BigDecimal.ZERO;
        BigDecimal avgTaxrate = BigDecimal.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            String cmpType = (String)model.getValue("cmptype", i);
            BigDecimal coefficient = BigDecimal.ONE;
            if ("(0)".equals(cmpType)) continue;
            if ("(-)".equals(cmpType)) {
                coefficient = BigDecimal.valueOf(-1L);
            }
            BigDecimal rowOftax = (BigDecimal)model.getValue("totaloftaxamount", i);
            rowOftax = rowOftax.multiply(coefficient);
            originalOftaxAmount = originalOftaxAmount.add(rowOftax);
            BigDecimal rowAmount = (BigDecimal)model.getValue("totalamount", i);
            rowAmount = rowAmount.multiply(coefficient);
            originalAmount = originalAmount.add(rowAmount);
            BigDecimal rowTax = (BigDecimal)model.getValue("totaltax", i);
            rowTax = rowTax.multiply(coefficient);
            avgTaxrate = avgTaxrate.add(rowTax);
        }
        boolean isOnList = (Boolean)model.getValue("isonlist");
        if (!isOnList) {
            originalOftaxAmount = (BigDecimal)model.getValue("settletaxamount");
            originalAmount = (BigDecimal)model.getValue("settleamount");
            avgTaxrate = (BigDecimal)model.getValue("settletax");
        }
        model.beginInit();
        model.setValue("apptaxamount", (Object)originalOftaxAmount);
        model.setValue("appamount", (Object)originalAmount);
        model.setValue("apptax", (Object)avgTaxrate);
        model.endInit();
        this.getView().updateView("apptaxamount");
        this.getView().updateView("appamount");
        this.getView().updateView("apptax");
    }
}

