/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.convert;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.common.utils.InComeUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctConvertPlugin;

public class PaymentApplyToPaymentRegisterConvertPlugin
extends AbstractPmctConvertPlugin {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        super.afterConvert(e);
        ExtendedDataEntitySet extendedDataEntitySet = e.getTargetExtDataEntitySet();
        String tgtTypeName = this.getTgtMainType().getName();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = extendedDataEntitySet.FindByEntityKey(tgtTypeName)) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject org = dataEntity.getDynamicObject("org");
            DynamicObject period = dataEntity.getDynamicObject("period");
            DynamicObjectCollection contractEntries = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : contractEntries) {
                BigDecimal totalPayApplyOfTaxAmount;
                BigDecimal totalRealOfTaxAmount;
                BigDecimal totalSettleOfTaxAmount;
                DynamicObject contract = entry.getDynamicObject("entrycontract");
                DynamicObject entryContPro = entry.getDynamicObject("contpro");
                DynamicObject supplier = entry.getDynamicObject("contpartb");
                BigDecimal thisPaymentOfTaxAmount = entry.getBigDecimal("thispaymentoftaxamount");
                MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                String multiPayType = contract.getString("multipaytype");
                if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                    totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryContPro, contract, period, supplier);
                    totalRealOfTaxAmount = multiSettleAmtService.getMultiPayAmount(org, entryContPro, contract, period, supplier);
                    totalPayApplyOfTaxAmount = multiSettleAmtService.getMultiPayApplyAmount(org, entryContPro, contract, period, supplier);
                } else {
                    InComeUtils inComeUtils = new InComeUtils();
                    totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, supplier);
                    totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, supplier);
                    totalPayApplyOfTaxAmount = inComeUtils.totalApplyOfTaxAmount(contract, period, supplier);
                }
                entry.set("preapplyoftaxamtsum", (Object)totalPayApplyOfTaxAmount);
                if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal startPaymentRate = totalRealOfTaxAmount.divide(totalSettleOfTaxAmount, 10, 5).multiply(BigDecimal.valueOf(100L));
                    BigDecimal endPaymentRate = thisPaymentOfTaxAmount.add(totalRealOfTaxAmount).divide(totalSettleOfTaxAmount, 10, 5).multiply(BigDecimal.valueOf(100L));
                    entry.set("startpaymentrate", (Object)startPaymentRate);
                    entry.set("endpaymentrate", (Object)endPaymentRate);
                }
                entry.set("thispaymentamount", (Object)entry.getBigDecimal("thispaymentoftaxamount").subtract(entry.getBigDecimal("thispaymenttaxamount")));
            }
        }
    }
}

