/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.doc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.helper.WebOfficeBrowserHelper;
import kd.bos.mvc.form.helper.WebOfficeBrowserParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.pmgt.pmbs.business.utils.ContractTypeUtils;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmct.common.enums.ContTemplateTypeEnum;
import org.jetbrains.annotations.NotNull;

public class ContractDocBillEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
UploadListener {
    private static final Log log = LogFactory.getLog(ContractDocBillEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit conttemp = (BasedataEdit)this.getControl("conttemp");
        conttemp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object contractId = customParams.get("contractid");
        Object basetype = customParams.get("basetype");
        if (basetype != null) {
            this.getModel().setValue("basetype", basetype);
        }
        if (contractId != null) {
            this.getModel().setValue("contract", contractId);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String basetype = (String)this.getModel().getValue("basetype");
        ItemClassEdit billEdit = (ItemClassEdit)this.getView().getControl("contract");
        if (StringUtils.equals((CharSequence)basetype, (CharSequence)"pmct_addagreementf7")) {
            billEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8865\u5145\u534f\u8bae", (String)"ContractDocBillEditPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])));
        } else if (StringUtils.equals((CharSequence)basetype, (CharSequence)"pmct_strategicagreementf7")) {
            billEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6218\u7565\u534f\u8bae", (String)"ContractDocBillEditPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])));
        }
        DynamicObject conttemp = (DynamicObject)this.getModel().getValue("conttemp");
        if (conttemp != null) {
            this.getPageCache().put("oriconttempid", conttemp.getPkValue().toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject contractDoc;
        DynamicObject oldContTemp;
        boolean fromDatabase;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"contbilldoc", (CharSequence)operateKey)) {
            boolean fromDatabase2 = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!fromDatabase2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u4fe1\u606f\u3002", (String)"ContractDocBillEditPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractDocBillEditPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String billno = (String)this.getModel().getValue("billno");
            if (StringUtils.isEmpty((CharSequence)billno)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractDocBillEditPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject contTemp = (DynamicObject)this.getModel().getValue("conttemp");
            if (contTemp == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u6587\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractDocBillEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String oriconttempid = this.getPageCache().get("oriconttempid");
            if (StringUtils.isNotEmpty((CharSequence)oriconttempid) && !StringUtils.equals((CharSequence)oriconttempid, (CharSequence)contTemp.getString("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u6587\u6a21\u677f\u53d8\u5316\uff0c\u8bf7\u5148\u4fdd\u5b58\u518d\u7f16\u8f91\u3002", (String)"ContractDocBillEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!this.validDocTemp(contTemp.getLong("id"))) {
                args.setCancel(true);
                return;
            }
            WebOfficeBrowserParam param = new WebOfficeBrowserParam("pmct_contbilldesign");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("conttempid", this.getModel().getValue("conttemp_id"));
            paramMap.put("contract", this.getModel().getValue("contract_id"));
            paramMap.put("contdocbillid", this.getModel().getValue("id"));
            param.setParams(paramMap);
            String url = WebOfficeBrowserHelper.buildUrl((WebOfficeBrowserParam)param);
            this.getView().openUrl(url);
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) && (fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) && (oldContTemp = (contractDoc = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"pmct_contdocbill")).getDynamicObject("conttemp")) != null) {
            Long curContTempId = (Long)this.getModel().getValue("conttemp_id");
            if (curContTempId == null || curContTempId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u6587\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractDocBillEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!this.validDocTemp(curContTempId)) {
                args.setCancel(true);
                return;
            }
            if (!oldContTemp.get("id").equals(curContTempId)) {
                this.getPageCache().put("oriconttempid", curContTempId.toString());
                this.getModel().setValue("billdocurl", (Object)"");
            }
        }
    }

    private boolean validDocTemp(Long curDocTempId) {
        String basetype = (String)this.getModel().getValue("basetype");
        String payDirection = "";
        DynamicObject contTemp = BusinessDataServiceHelper.loadSingle((String)"pmct_conttemplate", (String)"conttemplatetype,group,effective", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curDocTempId)});
        boolean effective = contTemp.getBoolean("effective");
        DynamicObject billObj = (DynamicObject)this.getModel().getValue("contract");
        if (StringUtils.equals((CharSequence)basetype, (CharSequence)"pmct_contractf7")) {
            billObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contracttpl", (String)"contracttype,paydirection", (QFilter[])new QFilter[]{new QFilter("id", "=", billObj.getPkValue())});
            payDirection = billObj.getString("paydirection");
        }
        String templateType = contTemp.getString("conttemplatetype");
        String billDocTemplateType = this.getTemplateType(basetype, payDirection);
        if (!effective || !StringUtils.equals((CharSequence)billDocTemplateType, (CharSequence)templateType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6b63\u6587\u6a21\u677f\u3002", (String)"ContractDocBillEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        if ("conttemp".equals(key)) {
            String basetype = (String)this.getModel().getValue("basetype");
            DynamicObject billObj = (DynamicObject)this.getModel().getValue("contract");
            if (billObj != null) {
                DynamicObject contType;
                String payDirection = "";
                if (StringUtils.equals((CharSequence)basetype, (CharSequence)"pmct_addagreementf7")) {
                    billObj = BusinessDataServiceHelper.loadSingle((String)"pmct_addagreementtpl", (String)"contract", (QFilter[])new QFilter[]{new QFilter("id", "=", billObj.getPkValue())});
                    DynamicObject contract = billObj.getDynamicObject("contract");
                    contract = BusinessDataServiceHelper.loadSingle((String)"pmct_contracttpl", (String)"contracttype,paydirection", (QFilter[])new QFilter[]{new QFilter("id", "=", contract.getPkValue())});
                    payDirection = contract.getString("paydirection");
                    contType = contract.getDynamicObject("contracttype");
                    if (contType == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8865\u5145\u534f\u8bae\u8bf7\u5148\u586b\u5199\u201c\u5408\u540c\u201d\u3002", (String)"ContractDocBillEditPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    }
                } else if (StringUtils.equals((CharSequence)basetype, (CharSequence)"pmct_strategicagreementf7")) {
                    contType = (billObj = BusinessDataServiceHelper.loadSingle((String)"pmct_strategicagreement", (String)"agreementtype", (QFilter[])new QFilter[]{new QFilter("id", "=", billObj.getPkValue())})).getDynamicObject("agreementtype");
                    if (contType == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u534f\u8bae\uff08\u5408\u540c\uff09\u7c7b\u578b\u3002", (String)"ContractDocBillEditPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    billObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contracttpl", (String)"contracttype,paydirection", (QFilter[])new QFilter[]{new QFilter("id", "=", billObj.getPkValue())});
                    contType = billObj.getDynamicObject("contracttype");
                    payDirection = billObj.getString("paydirection");
                    if (contType == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5408\u540c\u7c7b\u578b\u3002", (String)"ContractDocBillEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    }
                }
                QFilter effectiveFilter = new QFilter("effective", "=", (Object)Boolean.TRUE);
                String contTemplateType = this.getTemplateType(basetype, payDirection);
                QFilter payFilter = new QFilter("conttemplatetype", "=", (Object)contTemplateType);
                Set contTypeTplIdSet = ContractTypeUtils.getContTplList((Object)contType.getPkValue(), (QFilter)new QFilter("conttemplatetype", "=", (Object)ContTemplateTypeEnum.OUT.getValue()));
                QFilter contTypeFilter = new QFilter("id", "in", (Object)contTypeTplIdSet).or("group", "=", (Object)0);
                param.getListFilterParameter().getQFilters().add(contTypeFilter.and(effectiveFilter).and(payFilter));
                return;
            }
            QFilter effectiveFilter = new QFilter("effective", "=", (Object)Boolean.TRUE);
            param.getListFilterParameter().getQFilters().add(effectiveFilter);
        }
    }

    @NotNull
    private String getTemplateType(String basetype, String payDirection) {
        String templateType = StringUtils.equals((CharSequence)basetype, (CharSequence)"pmct_addagreementf7") ? (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) ? "OUTADDAGREEMENT" : "INADDAGREEMENT") : (StringUtils.equals((CharSequence)basetype, (CharSequence)"pmct_strategicagreementf7") ? "STRATEGICAGREEMENT" : (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) ? "OUT" : "IN"));
        return templateType;
    }

    public void afterRemove(UploadEvent evt) {
        Object[] urls;
        for (Object attachObj : urls = evt.getUrls()) {
            if (!(attachObj instanceof LinkedHashMap)) continue;
            LinkedHashMap attachMap = (LinkedHashMap)attachObj;
            String status = (String)attachMap.get("status");
            DynamicObject billObj = (DynamicObject)this.getModel().getValue("contract");
            if (!StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"success") || billObj == null) continue;
            String url = (String)attachMap.get("url");
            String attachmentPrefixUrl = UrlService.getAttachmentPrefixUrl((String)url);
            String decodeUrl = null;
            try {
                decodeUrl = URLDecoder.decode(url, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
            if (decodeUrl != null) {
                decodeUrl = decodeUrl.substring(attachmentPrefixUrl.length());
            }
            QFilter fInterIdFilter = new QFilter("FInterID", "=", (Object)billObj.getString("id"));
            QFilter fUrlFilter = new QFilter("FFileId", "=", (Object)decodeUrl);
            DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{fInterIdFilter, fUrlFilter});
            boolean hasContText = false;
            Object curBillId = this.getModel().getDataEntity().getPkValue();
            fInterIdFilter = new QFilter("FInterID", "=", (Object)curBillId.toString());
            DynamicObject[] attachments = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"FFileId", (QFilter[])new QFilter[]{fInterIdFilter});
            if (attachments.length > 0) {
                DynamicObject[] conFields;
                List fFileIds = Arrays.stream(attachments).map(o -> o.getString("FFileId")).collect(Collectors.toList());
                fInterIdFilter = new QFilter("FInterID", "=", (Object)billObj.getString("id"));
                for (DynamicObject conField : conFields = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"FFileId", (QFilter[])new QFilter[]{fInterIdFilter})) {
                    String fFileId = conField.getString("FFileId");
                    if (!fFileIds.contains(fFileId)) continue;
                    hasContText = true;
                    break;
                }
            }
            if (hasContText || !QueryServiceHelper.exists((String)"pmct_contracttpl", (Object)billObj.getString("id")) || (billObj = BusinessDataServiceHelper.loadSingle((Object)billObj.getString("id"), (String)"pmct_contracttpl")) == null) continue;
            billObj.set("hasconttext", (Object)"0");
            SaveServiceHelper.update((DynamicObject)billObj);
        }
    }
}

