/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.doc;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkCheckEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkValueEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeCheckboxEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeDocChangeEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeIsFieldReviseEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeOpenStatusEvent;
import kd.bos.form.control.model.WebOfficeFileType;
import kd.bos.form.control.model.WebOfficeTrackingType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmct.common.utils.ContractOfficeUtil;
import kd.pmgt.pmct.formplugin.base.AbstractPmctFormPlugin;
import kd.pmgt.pmct.formplugin.doc.ContractDocBillDesignPlugin;

public class ContractTemplateDesignPlugin
extends AbstractPmctFormPlugin
implements WebOfficeDataListener,
UploadListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(ContractDocBillDesignPlugin.class);
    private static final String WEBOFFICEAP = "webofficeap";
    private static final String TEMPDOCURL = "tempdocurl";
    private static final String TEMPDOCNAME = "tempdocname";
    private static final String CONTTEMPID = "conttempid";
    private static final String FILENAME = "filename";
    private static final String FILEPATH = "filepath";
    private static final String URL = "url";
    private static final String FILE_SIZE = "fileSize";
    private static final String FORMID_CONTTEMPLATE = "pmct_conttemplate";
    private static final String FINTERID = "finterid";
    private static final String FATTACHMENTPANEL = "fattachmentpanel";
    private static final String BOS_ATTACHMENT = "bos_attachment";
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    private static final String CHANGE_NOT_SAVE = "cahngeNotSave";

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        int rowIndex = evt.getRow();
        if (rowIndex == -1) {
            return;
        }
        if (StringUtils.equals((CharSequence)"bookmarkentry", (CharSequence)entryKey)) {
            WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
            String bookMarkKey = (String)this.getModel().getValue("bookmarkkey", rowIndex);
            webOffice.locateMark(bookMarkKey);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        IFormView view = this.getView();
        Object onlyView = paramMap.get("onlyView");
        this.getModel().setValue("onlyview", onlyView);
        Object contTempId = paramMap.get(CONTTEMPID);
        if (StringUtils.isBlank(contTempId)) {
            logger.error("{}\u754c\u9762({})\u83b7\u53d6\u4f20\u9012\u7684\u53c2\u6570\u5408\u540c\u6a21\u677fID\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5f02\u5e38\u3002", (Object)EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId()).getDisplayName(), (Object)this.getView().getEntityId());
            return;
        }
        this.getModel().setValue(CONTTEMPID, contTempId);
        DynamicObject contTemplate = BusinessDataServiceHelper.loadSingle(contTempId, (String)FORMID_CONTTEMPLATE);
        this.getModel().setValue(TEMPDOCURL, contTemplate.get(TEMPDOCURL));
        this.getModel().setValue(TEMPDOCNAME, (Object)String.format("%s.doc", contTemplate.getString("number")));
        String contTempType = contTemplate.getString("conttemplatetype");
        ContractOfficeUtil.loadTempBookMarkEntry((IFormView)view, (DynamicObject)contTemplate);
        if (StringUtils.equals((CharSequence)"IN", (CharSequence)contTempType)) {
            ContractOfficeUtil.generateField((IFormView)view, (String)"pmct_incontract");
        } else if (StringUtils.equals((CharSequence)"OUT", (CharSequence)contTempType)) {
            ContractOfficeUtil.generateField((IFormView)view, (String)"pmct_outcontract");
        } else if (StringUtils.equals((CharSequence)"OUTADDAGREEMENT", (CharSequence)contTempType)) {
            ContractOfficeUtil.generateField((IFormView)view, (String)"pmct_outaddagreement");
        } else if (StringUtils.equals((CharSequence)"INADDAGREEMENT", (CharSequence)contTempType)) {
            ContractOfficeUtil.generateField((IFormView)view, (String)"pmct_inaddagreement");
        } else if (StringUtils.equals((CharSequence)"STRATEGICAGREEMENT", (CharSequence)contTempType)) {
            ContractOfficeUtil.generateField((IFormView)view, (String)"pmct_strategicagreement");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String effective = (String)this.getView().getFormShowParameter().getCustomParam("effective");
        if (StringUtils.isNotEmpty((CharSequence)effective)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save"});
        }
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        Object tempDocUrl = this.getModel().getValue(TEMPDOCURL);
        if (StringUtils.isBlank((Object)tempDocUrl)) {
            webOffice.openNew(WebOfficeFileType.word);
        } else {
            Object contTempId = this.getModel().getValue(CONTTEMPID);
            DynamicObject contTemplate = BusinessDataServiceHelper.loadSingle((Object)contTempId, (String)FORMID_CONTTEMPLATE);
            String tempName = contTemplate.getString(TEMPDOCNAME);
            String newDocUrl = UrlService.getAttachmentFullUrl((String)tempDocUrl.toString());
            if (StringUtils.isEmpty((CharSequence)newDocUrl)) {
                return;
            }
            String encode = "";
            try {
                encode = URLEncoder.encode(tempName, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Throwable)ex);
            }
            newDocUrl = newDocUrl.replace(tempName, encode);
            webOffice.open(newDocUrl);
        }
        boolean onlyView = this.getModel().getDataEntity().getBoolean("onlyview");
        if (onlyView) {
            webOffice.limitDoc(this.getPassword());
        }
    }

    protected String getPassword() {
        Object systemParameter = SystemParamHelper.getSystemParameter((String)"textpassword", (String)"pmct");
        if (StringUtils.isBlank((Object)systemParameter)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u5728\u7cfb\u7edf\u53c2\u6570\u4e2d\u8bbe\u7f6e\u6b63\u6587\u5bc6\u7801\u3002", (String)"ContractTemplateDesignPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
        return systemParameter.toString();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IFormView view = this.getView();
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        if (StringUtils.equals((CharSequence)"savedoc", (CharSequence)operateKey)) {
            webOffice.getAllBookmarks();
            String userName = RequestContext.get().getUserName();
            webOffice.setTrackingMode(userName, WebOfficeTrackingType.TRACKING_EDIT);
            String tempName = (String)this.getModel().getValue(TEMPDOCNAME);
            webOffice.save(tempName);
            this.getPageCache().put(CHANGE_NOT_SAVE, Boolean.FALSE.toString());
        } else if (StringUtils.equals((CharSequence)"selectfield", (CharSequence)operateKey)) {
            ContractOfficeUtil.selectField((IFormView)view, (WebOffice)webOffice);
            this.getPageCache().put(CHANGE_NOT_SAVE, Boolean.TRUE.toString());
        } else if (StringUtils.equals((CharSequence)"deletebookmark", (CharSequence)operateKey)) {
            ContractOfficeUtil.delectField((IFormView)view, (WebOffice)webOffice);
            this.getPageCache().put(CHANGE_NOT_SAVE, Boolean.TRUE.toString());
        } else if (StringUtils.equals((CharSequence)"setbookmark", (CharSequence)operateKey)) {
            ContractOfficeUtil.addBookMarkForSelection((IFormView)view, (WebOffice)webOffice);
            this.getPageCache().put(CHANGE_NOT_SAVE, Boolean.TRUE.toString());
        } else if (StringUtils.equals((CharSequence)"doclose", (CharSequence)operateKey)) {
            webOffice.isDocChanged();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"canedit", (CharSequence)key)) {
            this.getPageCache().put(CHANGE_NOT_SAVE, Boolean.TRUE.toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)CHANGE_NOT_SAVE, (CharSequence)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().invokeOperation("close");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar uploadDocButton = (Toolbar)this.getControl("toolbarap");
        uploadDocButton.addUploadListener((UploadListener)this);
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.addUploadListener((UploadListener)this);
        webOffice.addDataListener((WebOfficeDataListener)this);
        EntryGrid bookMarkEntry = (EntryGrid)this.getControl("bookmarkentry");
        bookMarkEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        String tempDocUrl = (String)this.getModel().getValue(TEMPDOCURL);
        String tempDocName = (String)this.getModel().getValue(TEMPDOCNAME);
        Object[] urls = evt.getUrls();
        String callbackKey = evt.getCallbackKey();
        Map<String, String> urlMap = ContractTemplateDesignPlugin.handleFileUrl(urls, tempDocName);
        String filePath = urlMap.get(FILEPATH);
        String fileName = urlMap.get(FILENAME);
        String url = urlMap.get(URL);
        Map<String, String> uploadDataMap = ContractTemplateDesignPlugin.uploadTempFile(url, tempDocUrl, filePath, fileName);
        fileName = uploadDataMap.get(FILENAME);
        url = uploadDataMap.get(URL);
        if (StringUtils.equals((CharSequence)"bar_uploaddoc", (CharSequence)callbackKey)) {
            WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
            ContractTemplateDesignPlugin.openWebOfficeFile(webOffice, url, fileName);
        } else if (StringUtils.equals((CharSequence)WEBOFFICEAP, (CharSequence)callbackKey)) {
            this.getModel().setValue(TEMPDOCURL, (Object)url);
            this.getModel().setValue(TEMPDOCNAME, (Object)fileName);
            Object contTempId = this.getModel().getValue(CONTTEMPID);
            DynamicObject contTemplate = BusinessDataServiceHelper.loadSingle((Object)contTempId, (String)FORMID_CONTTEMPLATE);
            contTemplate.set(TEMPDOCURL, (Object)url);
            contTemplate.set(TEMPDOCNAME, (Object)fileName);
            DynamicObjectCollection bookMarkEntryCol = contTemplate.getDynamicObjectCollection("bookmarkentry");
            bookMarkEntryCol.clear();
            DynamicObjectType bookEntryDt = bookMarkEntryCol.getDynamicObjectType();
            DynamicObjectCollection designBookMarkEntryCol = this.getModel().getEntryEntity("bookmarkentry");
            for (DynamicObject dynamicObject : designBookMarkEntryCol) {
                DynamicObject bookEntry = new DynamicObject(bookEntryDt);
                bookEntry.set("bookmarkkey", dynamicObject.get("bookmarkkey"));
                bookEntry.set("bookmarktype", dynamicObject.get("bookmarktype"));
                bookEntry.set("bookmarkprop", dynamicObject.get("bookmarkprop"));
                bookEntry.set("bookmarkvalue", dynamicObject.get("bookmarkvalue"));
                bookEntry.set("canedit", dynamicObject.get("canedit"));
                bookMarkEntryCol.add((Object)bookEntry);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contTemplate});
            QFilter fInterIdFilter = new QFilter(FINTERID, "=", (Object)String.valueOf(contTemplate.getPkValue()));
            QFilter fattachmentPanelFilter = new QFilter(FATTACHMENTPANEL, "=", (Object)ATTACHMENT_PANEL);
            DeleteServiceHelper.delete((String)BOS_ATTACHMENT, (QFilter[])new QFilter[]{fInterIdFilter, fattachmentPanelFilter});
            FileAttachmentHelper.setFileInAttachmentPanel((Object)contTemplate.getPkValue(), (String)FORMID_CONTTEMPLATE, (String)fileName, (String)fileName, (String)url, (int)Integer.parseInt(uploadDataMap.get(FILE_SIZE)), (String)ATTACHMENT_PANEL);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ContractTemplateDesignPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
    }

    public static void openWebOfficeFile(WebOffice webOffice, String url, String fileName) {
        String tUrl = UrlService.getAttachmentFullUrl((String)url);
        String urlName = tUrl.substring(tUrl.lastIndexOf(47));
        String[] files = urlName.split("\\.");
        String tFileName = files.length == 2 ? files[0] : UUID.randomUUID().toString();
        try {
            tFileName = URLEncoder.encode(tFileName, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
        }
        String tExtend = files.length == 2 ? files[1] : "doc";
        fileName = tFileName + '.' + tExtend;
        tUrl = tUrl.substring(0, tUrl.lastIndexOf(47));
        tUrl = tUrl + fileName;
        webOffice.openAll(tUrl, fileName);
    }

    public static Map<String, String> handleFileUrl(Object[] urls, String tempDocName) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Object urlData = urls[0];
        String filePath = "";
        String fileName = "";
        String url = "";
        if (urlData instanceof String) {
            filePath = urlData.toString();
            fileName = filePath.substring(filePath.lastIndexOf(47));
            String[] files = fileName.split("\\.");
            String tFileName = files.length == 2 ? files[0] : UUID.randomUUID().toString();
            try {
                tFileName = URLEncoder.encode(tFileName, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
            }
            String tExtend = files.length == 2 ? files[1] : "doc";
            fileName = tFileName + '.' + tExtend;
            url = filePath;
        } else if (urlData instanceof Map) {
            filePath = ((Map)urlData).get(URL).toString();
            if (StringUtils.isBlank((CharSequence)tempDocName)) {
                String name;
                fileName = name = ((Map)urlData).get("name").toString();
                if (StringUtils.isBlank((CharSequence)name)) {
                    fileName = "NONAMEDOC";
                }
            } else {
                fileName = tempDocName;
            }
            url = filePath;
        }
        dataMap.put(FILENAME, fileName);
        dataMap.put(FILEPATH, filePath);
        dataMap.put(URL, url);
        return dataMap;
    }

    public static Map<String, String> uploadTempFile(String url, String docurl, String filePath, String fileName) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String turl = "";
        int fileSize = 0;
        if (url.contains("tempfile")) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            FileService service = FileServiceFactory.getAttachmentFileService();
            FileItem fileItem = null;
            if (StringUtils.isNotBlank((CharSequence)docurl)) {
                docurl = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(docurl);
                fileItem = new FileItem(fileName, docurl, in);
                fileItem.setCreateNewFileWhenExists(false);
            } else {
                String path = ContractOfficeUtil.generateTplPath((String)fileName);
                String utf8FileName = fileName;
                try {
                    utf8FileName = URLEncoder.encode(utf8FileName, StandardCharsets.UTF_8.toString());
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Throwable)e);
                }
                fileItem = new FileItem(utf8FileName, path, in);
                fileItem.setCreateNewFileWhenExists(true);
            }
            try {
                fileSize = fileItem.getInputStream().available();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            turl = service.upload(fileItem);
            cache.remove(url);
            url = turl;
        }
        dataMap.put(FILENAME, fileName);
        dataMap.put(FILEPATH, filePath);
        dataMap.put(URL, url);
        dataMap.put(FILE_SIZE, String.valueOf(fileSize));
        return dataMap;
    }

    public void onGetAllBookmarks(WebOfficeBookmarkEvent paramWebOfficeBookmarkEvent) {
        List bookmarks = paramWebOfficeBookmarkEvent.getBookmarks();
        DynamicObjectCollection bookMarkEntryCol = this.getModel().getEntryEntity("bookmarkentry");
        List collect = bookMarkEntryCol.stream().filter(a -> bookmarks.contains(a.getString("bookmarkkey"))).collect(Collectors.toList());
        bookMarkEntryCol.clear();
        bookMarkEntryCol.addAll(collect);
        this.getModel().updateEntryCache(bookMarkEntryCol);
        this.getView().updateView("bookmarkentry");
    }

    public void onGetBookmarkCheckResult(WebOfficeBookmarkCheckEvent paramWebOfficeBookmarkCheckEvent) {
    }

    public void onGetDocChangeCheckResult(WebOfficeDocChangeEvent paramWebOfficeDocChangeEvent) {
        String changeNotSave;
        if (paramWebOfficeDocChangeEvent.isChanged()) {
            this.getPageCache().put(CHANGE_NOT_SAVE, Boolean.TRUE.toString());
        }
        if ((changeNotSave = this.getView().getPageCache().get(CHANGE_NOT_SAVE)) != null && Boolean.parseBoolean(changeNotSave)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ContractTemplateDesignPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_NOT_SAVE));
        } else {
            this.getView().invokeOperation("close");
        }
    }

    public void onGetTextByBookmark(WebOfficeBookmarkValueEvent paramWebOfficeBookmarkValueEvent) {
    }

    public void onGetAllCheckBoxes(WebOfficeCheckboxEvent paramWebOfficeCheckboxEvent) {
    }

    public void onIsFieldRevise(WebOfficeIsFieldReviseEvent paramWebOfficeIsFieldReviseEvent) {
    }

    public void onSendOpenStatus(WebOfficeOpenStatusEvent paramWebOfficeOpenStatusEvent) {
    }
}

