/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.invoice;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctInvoicePlugin;

public class OutInvoiceEditPlugin
extends AbstractPmctInvoicePlugin {
    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getControl("contract");
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit reverseInvoice = (BasedataEdit)this.getControl("reverseinvoice");
        reverseInvoice.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_incontract", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit seller = (BasedataEdit)this.getControl("seller");
        seller.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propertyName = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        BigDecimal totaltax = this.getModel().getDataEntity().getBigDecimal("totaltax");
        BigDecimal totalamount = this.getModel().getDataEntity().getBigDecimal("totalamount");
        BigDecimal totaloftaxamount = this.getModel().getDataEntity().getBigDecimal("totaloftaxamount");
        switch (propertyName) {
            case "contract": {
                this.onChangeContract();
                break;
            }
            case "taxrate": {
                DynamicObject taxRate = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
                if (taxRate != null) {
                    this.getModel().setValue("taxvalue", taxRate.get("taxrate"), rowIndex);
                } else {
                    this.getModel().setValue("taxvalue", null);
                }
            }
            case "qty": 
            case "oftaxprice": 
            case "price": 
            case "oftaxamount": {
                this.computeEntry(propertyName, rowIndex);
                this.computeTotal();
                break;
            }
            case "tax": 
            case "amount": {
                this.computeTotal();
                break;
            }
            case "totalamount": 
            case "totaltax": {
                this.getModel().beginInit();
                this.getModel().setValue("totaloftaxamount", (Object)NumberHelper.add((Object)totalamount, (Object)totaltax));
                this.getModel().endInit();
                this.getView().updateView("totaloftaxamount");
                break;
            }
            case "totaloftaxamount": {
                this.getModel().beginInit();
                if (totaltax.compareTo(BigDecimal.ZERO) != 0 && totalamount.compareTo(BigDecimal.ZERO) != 0) {
                    return;
                }
                if (totaltax.compareTo(BigDecimal.ZERO) != 0 && totalamount.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("totalamount", (Object)totaloftaxamount.subtract(totaltax));
                } else if (totaltax.compareTo(BigDecimal.ZERO) == 0 && totalamount.compareTo(BigDecimal.ZERO) != 0) {
                    this.getModel().setValue("totaltax", (Object)totaloftaxamount.subtract(totalamount));
                }
                this.getModel().endInit();
                this.getView().updateView("totalamount");
                this.getView().updateView("totaltax");
                break;
            }
        }
    }

    private void onChangeContract() {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        this.getModel().setValue("isclaimed", (Object)(contract != null ? 1 : 0));
        this.getModel().beginInit();
        if (contract == null) {
            return;
        }
        DynamicObject singleContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
        DynamicObject project = singleContract.getDynamicObject("project");
        if (project == null) {
            this.getModel().setValue("project", null);
            this.getView().updateView("project");
            return;
        }
        this.getModel().setValue("project", project.getPkValue(), 0);
        this.getModel().endInit();
        this.getView().updateView("project");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String key = event.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)"contract", (CharSequence)key)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ContractHelper.getContractByStatus((String)"pmct_outinvoice", (ListShowParameter)showParameter, (String)PayDirectionEnum.IN.getValue());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"reverseinvoice", (CharSequence)key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            QFilter OrgFilter = new QFilter("org", "=", (Object)Long.parseLong(org.getPkValue().toString()));
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmct_outinvoice", (String)"reverseinvoice", (QFilter[])new QFilter[]{OrgFilter, billStatusFilter});
            Set<Object> reverseInvoiceIds = new HashSet();
            if (bills != null && bills.length > 0) {
                reverseInvoiceIds = Arrays.stream(bills).filter(bill -> bill.getDynamicObjectCollection("reverseinvoice") != null && bill.getDynamicObjectCollection("reverseinvoice").size() > 0).map(bill -> Long.parseLong(bill.getPkValue().toString())).collect(Collectors.toSet());
            }
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter filter = new QFilter("billstatus", "=", (Object)"C");
            filter.and(new QFilter("source", "=", (Object)"00"));
            filter.and(OrgFilter);
            if (reverseInvoiceIds.size() > 0) {
                filter.and(new QFilter("reverseinvoice", "not in", reverseInvoiceIds));
            }
            showParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (StringUtils.equals((CharSequence)"seller", (CharSequence)key)) {
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            List hashPermOrgUnits = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(RequestContext.get().getCurrUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac");
            if (hashPermOrgUnits.size() == 0) {
                enableFilter.and(new QFilter("id", "=", (Object)0L));
            } else {
                enableFilter.and(new QFilter("id", "in", (Object)hashPermOrgUnits));
            }
            parameter.getListFilterParameter().getQFilters().add(enableFilter);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection pictureEntry;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ((StringUtils.equals((CharSequence)operateKey, (CharSequence)OperationEnum.SAVE.getValue()) || StringUtils.equals((CharSequence)operateKey, (CharSequence)OperationEnum.SUBMIT.getValue())) && (pictureEntry = this.getModel().getEntryEntity("pictureentry")) != null && pictureEntry.size() > 0) {
            for (DynamicObject picture : pictureEntry) {
                String filename = picture.getString("filename");
                if (!StringUtils.isNotBlank((CharSequence)filename) || filename.length() <= 200) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5f71\u50cf\u6587\u4ef6\u540d\u79f0\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc7200\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u56fe\u7247\u540d\u79f0\u3002", (String)"OutInvoiceEditPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }
}

